/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.func.column;

import com.easy.query.core.basic.api.select.Query;
import com.easy.query.core.expression.parser.core.SQLTableOwner;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.segment.SQLSegment;
import com.easy.query.core.func.SQLFunc;
import com.easy.query.core.func.SQLFunction;
import com.easy.query.core.func.column.ColumnExpression;
import com.easy.query.core.func.column.ColumnFuncSelector;
import com.easy.query.core.func.column.impl.ColumSQLExpressionImpl;
import com.easy.query.core.func.column.impl.ColumnFuncExpressionImpl;
import com.easy.query.core.func.column.impl.ColumnFuncFormatExpressionImpl;
import com.easy.query.core.func.column.impl.ColumnFuncValueExpressionImpl;
import com.easy.query.core.func.column.impl.ColumnFunctionExpressionImpl;
import com.easy.query.core.func.column.impl.ColumnKeepStyleExpressionImpl;
import com.easy.query.core.func.column.impl.ColumnLazyFunctionExpressionImpl;
import com.easy.query.core.func.column.impl.ColumnMultiValueExpressionImpl;
import com.easy.query.core.func.column.impl.ColumnSubQueryExpressionImpl;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

public class ColumnFuncSelectorImpl
implements ColumnFuncSelector {
    private final List<ColumnExpression> concatExpressions;

    public ColumnFuncSelectorImpl(List<ColumnExpression> concatExpressions) {
        this.concatExpressions = concatExpressions;
    }

    @Override
    public ColumnFuncSelector column(String property) {
        this.concatExpressions.add(new ColumnFuncExpressionImpl(null, property));
        return this;
    }

    @Override
    public ColumnFuncSelector column(SQLTableOwner tableOwner, String property) {
        if (tableOwner != null) {
            return this.column(tableOwner.getTable(), property);
        }
        return this.column(property);
    }

    @Override
    public ColumnFuncSelector column(TableAvailable table, String property) {
        this.concatExpressions.add(new ColumnFuncExpressionImpl(table, property));
        return this;
    }

    @Override
    public ColumnFuncSelector value(Object val) {
        this.concatExpressions.add(new ColumnFuncValueExpressionImpl(val));
        return this;
    }

    @Override
    public ColumnFuncSelector keepStyle() {
        this.concatExpressions.add(ColumnKeepStyleExpressionImpl.DEFAULT);
        return this;
    }

    @Override
    public <T> ColumnFuncSelector collection(Collection<T> collections) {
        this.concatExpressions.add(new ColumnMultiValueExpressionImpl(collections));
        return this;
    }

    @Override
    public ColumnFuncSelector sqlFuncExpression(TableAvailable table, Function<SQLFunc, SQLFunction> sqlFunctionCreator) {
        this.concatExpressions.add(new ColumnLazyFunctionExpressionImpl(table, sqlFunctionCreator));
        return this;
    }

    @Override
    public ColumnFuncSelector format(Object valFormat) {
        this.concatExpressions.add(new ColumnFuncFormatExpressionImpl(valFormat));
        return this;
    }

    @Override
    public ColumnFuncSelector sql(SQLSegment sqlSegment) {
        this.concatExpressions.add(new ColumSQLExpressionImpl(sqlSegment));
        return this;
    }

    @Override
    public ColumnFuncSelector sqlFunc(TableAvailable table, SQLFunction sqlFunction) {
        this.concatExpressions.add(new ColumnFunctionExpressionImpl(table, sqlFunction));
        return this;
    }

    @Override
    public ColumnFuncSelector subQuery(Query<?> subQuery) {
        this.concatExpressions.add(new ColumnSubQueryExpressionImpl(subQuery));
        return this;
    }
}

