/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.func.def;

import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.func.SQLFunction;
import com.easy.query.core.func.column.ColumnExpression;
import com.easy.query.core.func.column.impl.ColumnFuncValueExpressionImpl;
import com.easy.query.core.func.column.impl.ColumnFunctionExpressionImpl;
import com.easy.query.core.func.def.AbstractExpressionSQLFunction;
import com.easy.query.core.func.def.DistinctDefaultSQLFunction;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractWithValueOrDefaultExpressionSQLFunction
extends AbstractExpressionSQLFunction
implements DistinctDefaultSQLFunction {
    protected final List<ColumnExpression> columnExpressions;
    protected boolean distinct = false;
    protected boolean hasDefaultValue;

    public AbstractWithValueOrDefaultExpressionSQLFunction(List<ColumnExpression> columnExpressions) {
        this.columnExpressions = columnExpressions;
    }

    @Override
    public int paramMarks() {
        return this.columnExpressions.size();
    }

    @Override
    protected List<ColumnExpression> getColumnExpressions() {
        return this.columnExpressions;
    }

    @Override
    public DistinctDefaultSQLFunction distinct(boolean dist) {
        this.distinct = dist;
        return this;
    }

    @Override
    public DistinctDefaultSQLFunction nullDefault(Object value) {
        if (this.hasDefaultValue) {
            throw new EasyQueryInvalidOperationException("can not repeat value or default");
        }
        if (value != null) {
            this.hasDefaultValue = true;
            ArrayList<ColumnExpression> columnCopyExpressions = new ArrayList<ColumnExpression>(this.columnExpressions);
            columnCopyExpressions.add(new ColumnFuncValueExpressionImpl(value));
            SQLFunction valueOrDefaultSQLFunction = this.createValueOrDefaultSQLFunction(columnCopyExpressions);
            ColumnFunctionExpressionImpl columnFunctionExpression = new ColumnFunctionExpressionImpl(null, valueOrDefaultSQLFunction);
            this.columnExpressions.clear();
            this.columnExpressions.add(columnFunctionExpression);
        }
        return this;
    }

    protected abstract SQLFunction createValueOrDefaultSQLFunction(List<ColumnExpression> var1);
}

