/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.func.def.impl;

import com.easy.query.core.basic.jdbc.parameter.ToSQLContext;
import com.easy.query.core.common.tuple.Tuple2;
import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.expression.builder.Filter;
import com.easy.query.core.expression.builder.core.AnyValueFilter;
import com.easy.query.core.expression.builder.impl.FilterImpl;
import com.easy.query.core.expression.lambda.SQLExpression1;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.segment.condition.AndPredicateSegment;
import com.easy.query.core.expression.segment.impl.DefaultSQLSegment;
import com.easy.query.core.expression.segment.scec.expression.ParamExpression;
import com.easy.query.core.expression.sql.builder.ExpressionContext;
import com.easy.query.core.func.column.ColumnExpression;
import com.easy.query.core.func.column.impl.ColumSQLExpressionImpl;
import com.easy.query.core.func.def.AbstractExpressionSQLFunction;
import com.easy.query.core.util.EasySQLExpressionUtil;
import java.util.ArrayList;
import java.util.List;

public class CaseWhenSQLFunction
extends AbstractExpressionSQLFunction {
    private final QueryRuntimeContext runtimeContext;
    private final ExpressionContext expressionContext;
    private final List<Tuple2<SQLExpression1<Filter>, ParamExpression>> whens;
    private final ParamExpression elseValue;
    private final List<ColumnExpression> columnExpressions = new ArrayList<ColumnExpression>();
    private final StringBuilder sql = new StringBuilder();

    public CaseWhenSQLFunction(QueryRuntimeContext runtimeContext, ExpressionContext expressionContext, List<Tuple2<SQLExpression1<Filter>, ParamExpression>> whens, ParamExpression elseValue) {
        this.runtimeContext = runtimeContext;
        this.expressionContext = expressionContext;
        this.whens = whens;
        this.elseValue = elseValue;
        this.initCaseWhen();
    }

    private void initCaseWhen() {
        int i = 0;
        this.sql.append("(CASE ");
        for (Tuple2<SQLExpression1<Filter>, ParamExpression> when : this.whens) {
            SQLExpression1<Filter> filterExpression = when.t();
            ParamExpression paramExpression = when.t1();
            AndPredicateSegment resolve = this.resolve(this.runtimeContext, this.expressionContext, filterExpression);
            ColumSQLExpressionImpl columSQLExpressionPredicate = new ColumSQLExpressionImpl(new DefaultSQLSegment(toSQLContext -> resolve.toSQL((ToSQLContext)toSQLContext)));
            this.columnExpressions.add(columSQLExpressionPredicate);
            this.sql.append("WHEN ");
            this.sql.append("{").append(i++).append("}");
            ColumSQLExpressionImpl columSQLExpressionValue = new ColumSQLExpressionImpl(new DefaultSQLSegment(toSQLContext -> EasySQLExpressionUtil.parseParamExpression(this.expressionContext, paramExpression, toSQLContext).toString()));
            this.columnExpressions.add(columSQLExpressionValue);
            this.sql.append(" THEN ");
            this.sql.append("{").append(i++).append("}").append(" ");
        }
        ColumSQLExpressionImpl columSQLExpressionElseValue = new ColumSQLExpressionImpl(new DefaultSQLSegment(toSQLContext -> EasySQLExpressionUtil.parseParamExpression(this.expressionContext, this.elseValue, toSQLContext).toString()));
        this.columnExpressions.add(columSQLExpressionElseValue);
        this.sql.append("ELSE ").append("{").append(i++).append("}").append(" END)");
    }

    public AndPredicateSegment resolve(QueryRuntimeContext runtimeContext, ExpressionContext expressionContext, SQLExpression1<Filter> filterExpression) {
        AndPredicateSegment andPredicateSegment = new AndPredicateSegment(true);
        FilterImpl filter = new FilterImpl(runtimeContext, expressionContext, andPredicateSegment, false, AnyValueFilter.DEFAULT);
        filterExpression.apply(filter);
        return andPredicateSegment;
    }

    @Override
    public String sqlSegment(TableAvailable defaultTable) {
        return this.sql.toString();
    }

    @Override
    public int paramMarks() {
        return this.columnExpressions.size();
    }

    @Override
    protected List<ColumnExpression> getColumnExpressions() {
        return this.columnExpressions;
    }
}

