/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.func.def.impl;

import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.func.column.ColumnExpression;
import com.easy.query.core.func.def.AbstractExpressionSQLFunction;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateTimeFormatSQLFunction
extends AbstractExpressionSQLFunction {
    private final List<ColumnExpression> columnExpressions;
    private final String javaFormat;

    public DateTimeFormatSQLFunction(List<ColumnExpression> columnExpressions, String javaFormat) {
        this.columnExpressions = columnExpressions;
        this.javaFormat = javaFormat;
    }

    @Override
    public String sqlSegment(TableAvailable defaultTable) {
        return this.getSQLSegment();
    }

    @Override
    public int paramMarks() {
        return this.columnExpressions.size();
    }

    public String getSQLSegment() {
        if (this.javaFormat != null) {
            String format;
            switch (format = this.javaFormat) {
                case "yyyy-MM-dd HH:mm:ss": {
                    return "DATE_FORMAT({0},'%Y-%m-%d %H:%i:%s')";
                }
                case "yyyy-MM-dd HH:mm": {
                    return "DATE_FORMAT({0},'%Y-%m-%d %H:%i')";
                }
                case "yyyy-MM-dd HH": {
                    return "DATE_FORMAT({0},'%Y-%m-%d %H')";
                }
                case "yyyy-MM-dd": {
                    return "DATE_FORMAT({0},'%Y-%m-%d')";
                }
                case "yyyy-MM": {
                    return "DATE_FORMAT({0},'%Y-%m')";
                }
                case "yyyyMMddHHmmss": {
                    return "DATE_FORMAT({0},'%Y%m%d%H%i%s')";
                }
                case "yyyyMMddHHmm": {
                    return "DATE_FORMAT({0},'%Y%m%d%H%i')";
                }
                case "yyyyMMddHH": {
                    return "DATE_FORMAT({0},'%Y%m%d%H')";
                }
                case "yyyyMMdd": {
                    return "DATE_FORMAT({0},'%Y%m%d')";
                }
                case "yyyyMM": {
                    return "DATE_FORMAT({0},'%Y%m')";
                }
                case "yyyy": {
                    return "DATE_FORMAT({0},'%Y')";
                }
                case "HH:mm:ss": {
                    return "DATE_FORMAT({0},'%H:%i:%s')";
                }
            }
            format = this.replaceFormat(format);
            String[] argsFinds = new String[]{"%Y", "%y", "%_a1", "%c", "%d", "%e", "%H", "%k", "%h", "%l", "%i", "%_a2", "%p"};
            String[] argsSpts = format.split("(m|s|t)");
            block38: for (int a2 = 0; a2 < argsSpts.length; ++a2) {
                switch (argsSpts[a2]) {
                    case "m": {
                        argsSpts[a2] = "CASE WHEN SUBSTR(DATE_FORMAT({0},'%i'),1,1) = '0' THEN SUBSTR(DATE_FORMAT({0},'%i'),2,1) ELSE DATE_FORMAT({0},'%i') END";
                        continue block38;
                    }
                    case "s": {
                        argsSpts[a2] = "CASE WHEN SUBSTR(DATE_FORMAT({0},'%s'),1,1) = '0' THEN SUBSTR(DATE_FORMAT({0},'%s'),2,1) ELSE DATE_FORMAT({0},'%s') END";
                        continue block38;
                    }
                    case "t": {
                        argsSpts[a2] = "TRIM(TRAILING 'M' FROM DATE_FORMAT({0},'%p'))";
                        continue block38;
                    }
                    default: {
                        String argsSptsA = argsSpts[a2];
                        if (argsSptsA.startsWith("'")) {
                            argsSptsA = argsSptsA.substring(1);
                        }
                        if (argsSptsA.endsWith("'")) {
                            argsSptsA = argsSptsA.substring(0, argsSptsA.length() - 1);
                        }
                        argsSpts[a2] = Arrays.stream(argsFinds).anyMatch(argsSptsA::contains) ? "DATE_FORMAT({0},'" + argsSptsA + "')" : "'" + argsSptsA + "'";
                    }
                }
            }
            if (argsSpts.length == 1) {
                format = argsSpts[0];
            } else if (argsSpts.length > 1) {
                format = "CONCAT(" + String.join((CharSequence)", ", (CharSequence[])Arrays.stream(argsSpts).filter(a -> !a.equals("''")).toArray(String[]::new)) + ")";
            }
            return format.replace("%_a1", "%m").replace("%_a2", "%s");
        }
        return "DATE_FORMAT({0},'%Y-%m-%d %H:%i:%s.%f')";
    }

    protected String replaceFormat(String format) {
        String pattern = "(yyyy|yy|MM|M|dd|d|HH|H|hh|h|mm|ss|tt)";
        Pattern r = Pattern.compile(pattern);
        Matcher matcher = r.matcher(format);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String match;
            switch (match = matcher.group(1)) {
                case "yyyy": {
                    matcher.appendReplacement(result, "%Y");
                    break;
                }
                case "yy": {
                    matcher.appendReplacement(result, "%y");
                    break;
                }
                case "MM": {
                    matcher.appendReplacement(result, "%_a1");
                    break;
                }
                case "M": {
                    matcher.appendReplacement(result, "%c");
                    break;
                }
                case "dd": {
                    matcher.appendReplacement(result, "%d");
                    break;
                }
                case "d": {
                    matcher.appendReplacement(result, "%e");
                    break;
                }
                case "HH": {
                    matcher.appendReplacement(result, "%H");
                    break;
                }
                case "H": {
                    matcher.appendReplacement(result, "%k");
                    break;
                }
                case "hh": {
                    matcher.appendReplacement(result, "%h");
                    break;
                }
                case "h": {
                    matcher.appendReplacement(result, "%l");
                    break;
                }
                case "mm": {
                    matcher.appendReplacement(result, "%i");
                    break;
                }
                case "ss": {
                    matcher.appendReplacement(result, "%_a2");
                    break;
                }
                case "tt": {
                    matcher.appendReplacement(result, "%p");
                }
            }
        }
        matcher.appendTail(result);
        return result.toString();
    }

    @Override
    protected List<ColumnExpression> getColumnExpressions() {
        return this.columnExpressions;
    }
}

