/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.func.def.impl;

import com.easy.query.core.enums.SQLLikeEnum;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.func.column.ColumnExpression;
import com.easy.query.core.func.column.ColumnFuncValueExpression;
import com.easy.query.core.func.def.AbstractExpressionSQLFunction;
import java.util.List;

public class LikeSQLFunction
extends AbstractExpressionSQLFunction {
    private final List<ColumnExpression> columnExpressions;
    private final SQLLikeEnum sqlLikeEnum;

    public LikeSQLFunction(List<ColumnExpression> columnExpressions, SQLLikeEnum sqlLikeEnum) {
        this.columnExpressions = columnExpressions;
        this.sqlLikeEnum = sqlLikeEnum;
    }

    @Override
    public String sqlSegment(TableAvailable defaultTable) {
        String valueString;
        ColumnFuncValueExpression columnFuncValueExpression;
        Object value;
        if (this.columnExpressions.size() != 2) {
            throw new IllegalArgumentException("bank arguments != 1");
        }
        ColumnExpression columnExpression = this.columnExpressions.get(1);
        if (columnExpression instanceof ColumnFuncValueExpression && (value = (columnFuncValueExpression = (ColumnFuncValueExpression)columnExpression).getValue()) != null && (valueString = value.toString()).contains("%")) {
            if (this.sqlLikeEnum == SQLLikeEnum.LIKE_PERCENT_RIGHT) {
                return "LOCATE({1},{0}) = 1";
            }
            if (this.sqlLikeEnum == SQLLikeEnum.LIKE_PERCENT_LEFT) {
                return "LOCATE({1},{0}) = CHAR_LENGTH({0})";
            }
            return "LOCATE({1},{0}) > 0";
        }
        if (this.sqlLikeEnum == SQLLikeEnum.LIKE_PERCENT_RIGHT) {
            return "{0} LIKE CONCAT({1},'%')";
        }
        if (this.sqlLikeEnum == SQLLikeEnum.LIKE_PERCENT_LEFT) {
            return "{0} LIKE CONCAT('%',{1})";
        }
        return "{0} LIKE CONCAT('%',{1},'%')";
    }

    @Override
    public int paramMarks() {
        return this.columnExpressions.size();
    }

    @Override
    protected List<ColumnExpression> getColumnExpressions() {
        return this.columnExpressions;
    }
}

