/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.inject;

import com.easy.query.core.exception.EasyQueryInjectCurrentlyInCreationException;
import com.easy.query.core.inject.ServiceDescriptor;
import com.easy.query.core.util.EasyClassUtil;
import java.util.HashMap;
import java.util.Map;

public class BeanCurrentlyInjectMarker {
    private final ThreadLocal<Map<Class<?>, Long>> THREAD_BEAN_CREATED_MARKER = ThreadLocal.withInitial(HashMap::new);

    public void beanCreateMark(ServiceDescriptor serviceDescriptor) {
        long currentThreadId = Thread.currentThread().getId();
        Map<Class<?>, Long> beanMarker = this.THREAD_BEAN_CREATED_MARKER.get();
        Long o = beanMarker.putIfAbsent(serviceDescriptor.getServiceType(), currentThreadId);
        if (o != null) {
            throw new EasyQueryInjectCurrentlyInCreationException("bean currently creation:" + EasyClassUtil.getSimpleName(serviceDescriptor.getServiceType()));
        }
    }

    public void beanCreated(ServiceDescriptor serviceDescriptor) {
        Map<Class<?>, Long> beanMarker = this.THREAD_BEAN_CREATED_MARKER.get();
        beanMarker.remove(serviceDescriptor.getServiceType());
    }
}

