/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.inject;

import com.easy.query.core.inject.ServiceProvider;
import com.easy.query.core.util.EasyClassUtil;
import java.util.function.Function;

public class ServiceDescriptor {
    private final Class<?> serviceType;
    private final Class<?> implementationType;
    private final Object implementationInstance;
    private final Function<ServiceProvider, Object> implementationFactory;

    public ServiceDescriptor(Class<?> serviceType, Class<?> implementationType) {
        if (serviceType == null) {
            throw new IllegalArgumentException(EasyClassUtil.getSimpleName(serviceType));
        }
        this.serviceType = serviceType;
        if (implementationType == null) {
            throw new IllegalArgumentException(EasyClassUtil.getSimpleName(implementationType));
        }
        this.implementationType = implementationType;
        this.implementationInstance = null;
        this.implementationFactory = null;
    }

    public ServiceDescriptor(Class<?> serviceType, Object implementationInstance) {
        if (serviceType == null) {
            throw new IllegalArgumentException(EasyClassUtil.getSimpleName(serviceType));
        }
        this.serviceType = serviceType;
        if (implementationInstance == null) {
            throw new IllegalArgumentException(EasyClassUtil.getInstanceSimpleName(implementationInstance));
        }
        this.implementationInstance = implementationInstance;
        this.implementationType = null;
        this.implementationFactory = null;
    }

    public ServiceDescriptor(Class<?> serviceType, Function<ServiceProvider, Object> implementationFactory) {
        if (serviceType == null) {
            throw new IllegalArgumentException(EasyClassUtil.getSimpleName(serviceType));
        }
        this.serviceType = serviceType;
        if (implementationFactory == null) {
            throw new IllegalArgumentException(EasyClassUtil.getInstanceSimpleName(implementationFactory));
        }
        this.implementationFactory = implementationFactory;
        this.implementationType = null;
        this.implementationInstance = null;
    }

    public Class<?> getServiceType() {
        return this.serviceType;
    }

    public Class<?> getImplementationType() {
        return this.implementationType;
    }

    public Object getImplementationInstance() {
        return this.implementationInstance;
    }

    public Function<ServiceProvider, Object> getImplementationFactory() {
        return this.implementationFactory;
    }
}

