/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.job;

import com.easy.query.core.basic.thread.EasyQueryThreadFactory;
import com.easy.query.core.configuration.EasyQueryOption;
import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.inject.ServiceProvider;
import com.easy.query.core.job.EasyTimeJobManager;
import com.easy.query.core.job.TimeJob;
import com.easy.query.core.job.TimeJobEntry;
import com.easy.query.core.logging.Log;
import com.easy.query.core.logging.LogFactory;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class DefaultEasyTimeJobManager
implements EasyTimeJobManager {
    private static final Log log = LogFactory.getLog(DefaultEasyTimeJobManager.class);
    private final CopyOnWriteArrayList<TimeJobEntry> jobs = new CopyOnWriteArrayList();
    private final ScheduledExecutorService scheduledExecutorService;
    private final ServiceProvider serviceProvider;
    private final boolean logDebug;

    public DefaultEasyTimeJobManager(EasyQueryOption easyQueryOption, ServiceProvider serviceProvider) {
        this.serviceProvider = serviceProvider;
        this.logDebug = log.isDebugEnabled();
        if (easyQueryOption.isStartTimeJob()) {
            this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new EasyQueryThreadFactory("TimeJobScheduledThread"));
            this.scheduledExecutorService.scheduleAtFixedRate(() -> {
                try {
                    long now = System.currentTimeMillis();
                    for (TimeJobEntry job : this.jobs) {
                        if (now <= job.getNextTime()) continue;
                        try {
                            if (this.logDebug) {
                                log.debug("job:" + job.jobName() + " execute.");
                            }
                            job.execute(serviceProvider);
                        }
                        catch (Exception ex) {
                            log.error("job:" + job.jobName() + " error.", ex);
                        }
                        finally {
                            job.calcNextTime();
                        }
                    }
                }
                catch (Throwable e) {
                    log.error("schedule time job error.", e);
                }
            }, 5000L, 60000L, TimeUnit.MILLISECONDS);
        } else {
            this.scheduledExecutorService = null;
        }
    }

    @Override
    public void add(TimeJob job) {
        if (this.scheduledExecutorService == null) {
            throw new EasyQueryInvalidOperationException("not config start time job");
        }
        this.jobs.add(new TimeJobEntry(job));
    }

    @Override
    public void shutdown() {
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdown();
        }
    }
}

