/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.metadata;

import com.easy.query.core.annotation.Nullable;
import com.easy.query.core.basic.extension.complex.ComplexPropType;
import com.easy.query.core.basic.extension.conversion.ColumnValueSQLConverter;
import com.easy.query.core.basic.extension.conversion.ValueConverter;
import com.easy.query.core.basic.extension.encryption.EncryptionStrategy;
import com.easy.query.core.basic.extension.generated.GeneratedKeySQLColumnGenerator;
import com.easy.query.core.basic.extension.generated.PrimaryKeyGenerator;
import com.easy.query.core.basic.jdbc.types.handler.JdbcTypeHandler;
import com.easy.query.core.expression.lambda.Property;
import com.easy.query.core.expression.lambda.PropertySetterCaller;
import com.easy.query.core.metadata.ColumnOption;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.util.EasyClassUtil;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;

public class ColumnMetadata {
    private final EntityMetadata entityMetadata;
    private final String name;
    private final PropertyDescriptor property;
    private final Class<?> propertyType;
    private final String propertyName;
    private final boolean primary;
    private final boolean generatedKey;
    private final boolean version;
    private final boolean insertIgnore;
    private final boolean updateIgnore;
    private final boolean updateSetInTrackDiff;
    private final EncryptionStrategy encryptionStrategy;
    private final boolean supportQueryLike;
    private final boolean large;
    private final boolean autoSelect;
    private final boolean primitive;
    private final ValueConverter<?, ?> valueConverter;
    private final ColumnValueSQLConverter columnValueSQLConverter;
    private final GeneratedKeySQLColumnGenerator generatedSQLColumnGenerator;
    private final PrimaryKeyGenerator primaryKeyGenerator;
    private final PropertySetterCaller<Object> setterCaller;
    private final Property<Object, ?> getterCaller;
    private final JdbcTypeHandler jdbcTypeHandler;
    private final ComplexPropType complexPropType;
    private final boolean valueObject;
    private final List<ColumnMetadata> valueObjectColumnMetadataList;
    private final Supplier<Object> beanConstructorCreator;

    public ColumnMetadata(ColumnOption columnOption) {
        this.entityMetadata = columnOption.getEntityMetadata();
        this.name = columnOption.getName();
        this.property = columnOption.getProperty();
        PropertyDescriptor propertyDescriptor = columnOption.getProperty();
        if (propertyDescriptor != null) {
            this.propertyType = propertyDescriptor.getPropertyType();
            this.primitive = this.propertyType.isPrimitive();
        } else {
            this.propertyType = Object.class;
            this.primitive = false;
        }
        this.propertyName = columnOption.getFullPropertyName();
        this.primary = columnOption.isPrimary();
        this.generatedKey = columnOption.isGeneratedKey();
        this.version = columnOption.isVersion();
        this.insertIgnore = columnOption.isInsertIgnore();
        this.updateIgnore = columnOption.isUpdateIgnore();
        this.updateSetInTrackDiff = columnOption.isUpdateSetInTrackDiff();
        this.encryptionStrategy = columnOption.getEncryptionStrategy();
        this.supportQueryLike = columnOption.isSupportQueryLike();
        this.large = columnOption.isLarge();
        this.autoSelect = columnOption.isAutoSelect();
        this.valueConverter = columnOption.getValueConverter();
        this.columnValueSQLConverter = columnOption.getColumnValueSQLConverter();
        this.generatedSQLColumnGenerator = columnOption.getGeneratedKeySQLColumnGenerator();
        this.primaryKeyGenerator = columnOption.getPrimaryKeyGenerator();
        if (columnOption.getGetterCaller() == null) {
            throw new IllegalArgumentException("not found " + EasyClassUtil.getSimpleName(columnOption.getEntityMetadata().getEntityClass()) + "." + this.propertyName + " getter caller");
        }
        if (columnOption.getSetterCaller() == null) {
            throw new IllegalArgumentException("not found " + EasyClassUtil.getSimpleName(columnOption.getEntityMetadata().getEntityClass()) + "." + this.propertyName + " setter caller");
        }
        this.getterCaller = columnOption.getGetterCaller();
        this.setterCaller = columnOption.getSetterCaller();
        this.jdbcTypeHandler = columnOption.getJdbcTypeHandler();
        this.complexPropType = columnOption.getComplexPropType();
        this.valueObject = columnOption.isValueObject();
        this.beanConstructorCreator = columnOption.getBeanConstructorCreator();
        this.valueObjectColumnMetadataList = this.valueObject ? new ArrayList<ColumnMetadata>(columnOption.getValueObjectColumnOptions().size()) : Collections.emptyList();
    }

    public EntityMetadata getEntityMetadata() {
        return this.entityMetadata;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public boolean isGeneratedKey() {
        return this.generatedKey;
    }

    public boolean isVersion() {
        return this.version;
    }

    public boolean isInsertIgnore() {
        return this.insertIgnore;
    }

    public boolean isUpdateIgnore() {
        return this.updateIgnore;
    }

    public boolean isUpdateSetInTrackDiff() {
        return this.updateSetInTrackDiff;
    }

    public PropertyDescriptor getProperty() {
        return this.property;
    }

    public boolean isEncryption() {
        return this.encryptionStrategy != null;
    }

    public EncryptionStrategy getEncryptionStrategy() {
        return this.encryptionStrategy;
    }

    public boolean isSupportQueryLike() {
        return this.supportQueryLike;
    }

    public boolean isLarge() {
        return this.large;
    }

    public boolean isAutoSelect() {
        return this.autoSelect;
    }

    public ValueConverter<?, ?> getValueConverter() {
        return this.valueConverter;
    }

    public Class<?> getPropertyType() {
        return this.propertyType;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public PropertySetterCaller<Object> getSetterCaller() {
        return this.setterCaller;
    }

    public Property<Object, ?> getGetterCaller() {
        return this.getterCaller;
    }

    public JdbcTypeHandler getJdbcTypeHandler() {
        return this.jdbcTypeHandler;
    }

    public ColumnValueSQLConverter getColumnValueSQLConverter() {
        return this.columnValueSQLConverter;
    }

    public GeneratedKeySQLColumnGenerator getGeneratedSQLColumnGenerator() {
        return this.generatedSQLColumnGenerator;
    }

    @Nullable
    public PrimaryKeyGenerator getPrimaryKeyGenerator() {
        return this.primaryKeyGenerator;
    }

    public ComplexPropType getComplexPropType() {
        return this.complexPropType;
    }

    public boolean isValueObject() {
        return this.valueObject;
    }

    public List<ColumnMetadata> getValueObjectColumnMetadataList() {
        return this.valueObjectColumnMetadataList;
    }

    public Supplier<Object> getBeanConstructorCreatorOrNull() {
        return this.beanConstructorCreator;
    }
}

