/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.metadata;

import com.easy.query.core.annotation.Column;
import com.easy.query.core.annotation.ColumnIgnore;
import com.easy.query.core.annotation.EasyAssertMessage;
import com.easy.query.core.annotation.Encryption;
import com.easy.query.core.annotation.InsertIgnore;
import com.easy.query.core.annotation.LogicDelete;
import com.easy.query.core.annotation.Navigate;
import com.easy.query.core.annotation.NavigateFlat;
import com.easy.query.core.annotation.NavigateJoin;
import com.easy.query.core.annotation.NotNull;
import com.easy.query.core.annotation.ShardingDataSourceKey;
import com.easy.query.core.annotation.ShardingExtraDataSourceKey;
import com.easy.query.core.annotation.ShardingExtraTableKey;
import com.easy.query.core.annotation.ShardingTableKey;
import com.easy.query.core.annotation.Table;
import com.easy.query.core.annotation.UpdateIgnore;
import com.easy.query.core.annotation.ValueObject;
import com.easy.query.core.annotation.Version;
import com.easy.query.core.basic.extension.complex.ComplexPropType;
import com.easy.query.core.basic.extension.complex.DefaultComplexPropType;
import com.easy.query.core.basic.extension.conversion.ColumnValueSQLConverter;
import com.easy.query.core.basic.extension.conversion.DefaultColumnValueSQLConverter;
import com.easy.query.core.basic.extension.conversion.DefaultValueConverter;
import com.easy.query.core.basic.extension.conversion.EnumValueAutoConverter;
import com.easy.query.core.basic.extension.conversion.ValueConverter;
import com.easy.query.core.basic.extension.encryption.EncryptionStrategy;
import com.easy.query.core.basic.extension.generated.DefaultGeneratedKeySQLColumnGenerator;
import com.easy.query.core.basic.extension.generated.GeneratedKeySQLColumnGenerator;
import com.easy.query.core.basic.extension.generated.PrimaryKeyGenerator;
import com.easy.query.core.basic.extension.generated.UnsupportPrimaryKeyGenerator;
import com.easy.query.core.basic.extension.interceptor.EntityInterceptor;
import com.easy.query.core.basic.extension.interceptor.Interceptor;
import com.easy.query.core.basic.extension.interceptor.PredicateFilterInterceptor;
import com.easy.query.core.basic.extension.interceptor.UpdateSetInterceptor;
import com.easy.query.core.basic.extension.logicdel.LogicDeleteBuilder;
import com.easy.query.core.basic.extension.logicdel.LogicDeleteStrategy;
import com.easy.query.core.basic.extension.logicdel.LogicDeleteStrategyEnum;
import com.easy.query.core.basic.extension.navigate.DefaultNavigateExtraFilterStrategy;
import com.easy.query.core.basic.extension.navigate.NavigateBuilder;
import com.easy.query.core.basic.extension.navigate.NavigateExtraFilterStrategy;
import com.easy.query.core.basic.extension.version.VersionStrategy;
import com.easy.query.core.basic.jdbc.executor.impl.def.EntityResultColumnMetadata;
import com.easy.query.core.basic.jdbc.executor.internal.reader.BeanDataReader;
import com.easy.query.core.basic.jdbc.executor.internal.reader.DataReader;
import com.easy.query.core.basic.jdbc.executor.internal.reader.EmptyDataReader;
import com.easy.query.core.basic.jdbc.executor.internal.reader.PropertyDataReader;
import com.easy.query.core.basic.jdbc.types.JdbcTypeHandlerManager;
import com.easy.query.core.basic.jdbc.types.handler.JdbcTypeHandler;
import com.easy.query.core.basic.jdbc.types.handler.UnKnownTypeHandler;
import com.easy.query.core.common.bean.FastBean;
import com.easy.query.core.common.bean.FastBeanProperty;
import com.easy.query.core.configuration.EasyQueryOption;
import com.easy.query.core.configuration.QueryConfiguration;
import com.easy.query.core.configuration.nameconversion.NameConversion;
import com.easy.query.core.enums.EntityMetadataTypeEnum;
import com.easy.query.core.enums.RelationMappingTypeEnum;
import com.easy.query.core.enums.RelationTypeEnum;
import com.easy.query.core.exception.EasyQueryException;
import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.expression.lambda.Property;
import com.easy.query.core.expression.lambda.PropertySetterCaller;
import com.easy.query.core.expression.lambda.SQLExpression1;
import com.easy.query.core.expression.parser.core.available.MappingPath;
import com.easy.query.core.expression.parser.core.base.WherePredicate;
import com.easy.query.core.inject.ServiceProvider;
import com.easy.query.core.logging.Log;
import com.easy.query.core.logging.LogFactory;
import com.easy.query.core.logging.nologging.NoLoggingImpl;
import com.easy.query.core.metadata.ActualTable;
import com.easy.query.core.metadata.ColumnAllIndex;
import com.easy.query.core.metadata.ColumnMetadata;
import com.easy.query.core.metadata.ColumnOption;
import com.easy.query.core.metadata.ErrorMessage;
import com.easy.query.core.metadata.LogicDeleteMetadata;
import com.easy.query.core.metadata.NavigateFlatMetadata;
import com.easy.query.core.metadata.NavigateJoinMetadata;
import com.easy.query.core.metadata.NavigateMetadata;
import com.easy.query.core.metadata.NavigateOption;
import com.easy.query.core.metadata.PropertyDescriptorFinder;
import com.easy.query.core.metadata.ShardingInitConfig;
import com.easy.query.core.metadata.ShardingSequenceConfig;
import com.easy.query.core.metadata.VersionMetadata;
import com.easy.query.core.sharding.initializer.ShardingEntityBuilder;
import com.easy.query.core.sharding.initializer.ShardingInitOption;
import com.easy.query.core.sharding.initializer.ShardingInitializer;
import com.easy.query.core.sharding.router.table.TableUnit;
import com.easy.query.core.util.EasyBeanUtil;
import com.easy.query.core.util.EasyClassUtil;
import com.easy.query.core.util.EasyCollectionUtil;
import com.easy.query.core.util.EasyObjectUtil;
import com.easy.query.core.util.EasyStringUtil;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class EntityMetadata {
    private static final Log log = LogFactory.getLog(EntityMetadata.class);
    private final Class<?> entityClass;
    private String tableName;
    private String schema;
    private ErrorMessage errorMessage;
    private LogicDeleteMetadata logicDeleteMetadata;
    private VersionMetadata versionMetadata;
    private String shardingDataSourcePropertyName;
    private final Set<String> shardingDataSourcePropertyNames = new LinkedHashSet<String>();
    private String shardingTablePropertyName;
    private final Set<String> shardingTablePropertyNames = new LinkedHashSet<String>();
    private ShardingInitConfig shardingInitConfig;
    private boolean hasValueObject;
    private boolean aliasQuery;
    private boolean hasPrimaryKeyGenerator = false;
    private final List<PredicateFilterInterceptor> predicateFilterInterceptors = new ArrayList<PredicateFilterInterceptor>();
    private final List<EntityInterceptor> entityInterceptors = new ArrayList<EntityInterceptor>();
    private final List<UpdateSetInterceptor> updateSetInterceptors = new ArrayList<UpdateSetInterceptor>();
    private final Map<String, ColumnMetadata> property2ColumnMap = new LinkedHashMap<String, ColumnMetadata>();
    private final Map<String, NavigateMetadata> property2NavigateMap = new LinkedHashMap<String, NavigateMetadata>();
    private final Map<String, NavigateFlatMetadata> property2NavigateFlatMap = new LinkedHashMap<String, NavigateFlatMetadata>();
    private final Map<String, NavigateJoinMetadata> property2NavigateJoinMap = new LinkedHashMap<String, NavigateJoinMetadata>();
    private final Map<String, String> keyPropertiesMap = new LinkedHashMap<String, String>();
    private final List<String> generatedKeyColumns = new ArrayList<String>(4);
    private final Map<String, ColumnMetadata> column2PropertyMap = new HashMap<String, ColumnMetadata>();
    private final Set<ActualTable> actualTables = new CopyOnWriteArraySet<ActualTable>();
    private final Set<String> dataSources = new CopyOnWriteArraySet<String>();
    protected EntityMetadataTypeEnum entityMetadataType = EntityMetadataTypeEnum.BEAN;
    private Supplier<Object> beanConstructorCreator;
    private DataReader dataReader;

    public boolean isMultiTableMapping() {
        return this.shardingTablePropertyName != null;
    }

    public boolean isMultiDataSourceMapping() {
        return this.shardingDataSourcePropertyName != null;
    }

    public EntityMetadata(Class<?> entityClass) {
        this.entityClass = entityClass;
    }

    public void init(ServiceProvider serviceProvider) {
        EasyAssertMessage easyAssertMessage;
        if (EasyClassUtil.isBasicType(this.entityClass)) {
            this.entityMetadataType = EntityMetadataTypeEnum.BASIC_TYPE;
            return;
        }
        if (EasyClassUtil.isEnumType(this.entityClass)) {
            this.entityMetadataType = EntityMetadataTypeEnum.BASIC_TYPE;
            return;
        }
        QueryConfiguration configuration = serviceProvider.getService(QueryConfiguration.class);
        JdbcTypeHandlerManager jdbcTypeHandlerManager = serviceProvider.getService(JdbcTypeHandlerManager.class);
        NameConversion nameConversion = configuration.getNameConversion();
        Table table = EasyClassUtil.getAnnotation(this.entityClass, Table.class);
        if (table != null) {
            EasyQueryOption easyQueryOption;
            boolean hasDefaultSchema;
            this.tableName = EasyStringUtil.defaultIfBank(table.value(), nameConversion.convert(EasyClassUtil.getSimpleName(this.entityClass)));
            this.schema = table.schema();
            if (EasyStringUtil.isBlank(this.schema) && (hasDefaultSchema = EasyStringUtil.isNotBlank((easyQueryOption = configuration.getEasyQueryOption()).getDefaultSchema()))) {
                this.schema = easyQueryOption.getDefaultSchema();
            }
        }
        this.errorMessage = (easyAssertMessage = EasyClassUtil.getAnnotation(this.entityClass, EasyAssertMessage.class)) != null ? new ErrorMessage(easyAssertMessage.value()) : new ErrorMessage("query no element in result set.");
        HashSet<String> ignoreProperties = table != null ? new HashSet<String>(Arrays.asList(table.ignoreProperties())) : new HashSet();
        HashMap<String, Field> staticFields = new HashMap<String, Field>();
        Collection<Field> allFields = EasyClassUtil.getAllFields(this.entityClass, staticFields);
        PropertyDescriptor[] ps = EasyClassUtil.propertyDescriptors(this.entityClass);
        PropertyDescriptorFinder propertyDescriptorFinder = new PropertyDescriptorFinder(ps);
        FastBean fastBean = EasyBeanUtil.getFastBean(this.entityClass);
        this.beanConstructorCreator = fastBean.getBeanConstructorCreator();
        boolean tableEntity = EasyStringUtil.isNotBlank(this.tableName);
        this.dataReader = tableEntity ? EmptyDataReader.EMPTY : null;
        ColumnAllIndex columnAllIndex = new ColumnAllIndex();
        for (Field field : allFields) {
            String property = EasyStringUtil.toLowerCaseFirstOne(field.getName());
            if (Modifier.isStatic(field.getModifiers()) || ignoreProperties.contains(property)) continue;
            PropertyDescriptor propertyDescriptor = propertyDescriptorFinder.find(property);
            if (propertyDescriptor == null) {
                propertyDescriptor = propertyDescriptorFinder.findIgnoreCase(property);
                if (propertyDescriptor == null) continue;
                String warningMessage = EasyClassUtil.getSimpleName(this.entityClass) + " filed:" + field.getName() + ",compare name:" + property + ",property name:" + propertyDescriptor.getName();
                if (log instanceof NoLoggingImpl) {
                    System.out.println("NoLogging:" + warningMessage);
                    continue;
                }
                log.warn(warningMessage);
                continue;
            }
            Type genericType = field.getGenericType();
            FastBeanProperty fastBeanProperty = new FastBeanProperty(EntityMetadata.isGenericType(genericType), propertyDescriptor);
            ColumnIgnore columnIgnore = field.getAnnotation(ColumnIgnore.class);
            if (columnIgnore != null) continue;
            Navigate navigate = field.getAnnotation(Navigate.class);
            if (navigate != null) {
                this.createNavigateMetadata(tableEntity, navigate, field, fastBean, fastBeanProperty, property, configuration);
                continue;
            }
            ValueObject valueObject = field.getAnnotation(ValueObject.class);
            if (valueObject != null) {
                this.hasValueObject = true;
                ColumnOption columnOption = this.createColumnOption(field, propertyDescriptor, tableEntity, fastBeanProperty, configuration, fastBean, jdbcTypeHandlerManager, true);
                FastBean valueObjectFastBean = EasyBeanUtil.getFastBean(propertyDescriptor.getPropertyType());
                columnOption.setValueObject(true);
                columnOption.setBeanConstructorCreator(valueObjectFastBean.getBeanConstructorCreator());
                this.parseValueObject(columnOption, configuration, jdbcTypeHandlerManager);
                this.acceptColumnOption(null, columnOption, columnAllIndex);
                continue;
            }
            if (!tableEntity) {
                NavigateFlat navigateFlat = field.getAnnotation(NavigateFlat.class);
                if (navigateFlat != null) {
                    this.createNavigateFlatMappingMetadata(navigateFlat, staticFields, field, fastBean, fastBeanProperty, property);
                    continue;
                }
                NavigateJoin navigateJoin = field.getAnnotation(NavigateJoin.class);
                if (navigateJoin != null) {
                    this.createNavigateJoinMappingMetadata(navigateJoin, staticFields, property);
                }
            }
            ColumnOption columnOption = this.createColumnOption(field, propertyDescriptor, tableEntity, fastBeanProperty, configuration, fastBean, jdbcTypeHandlerManager, true);
            this.acceptColumnOption(null, columnOption, columnAllIndex);
        }
        if (EasyCollectionUtil.isEmpty(this.property2ColumnMap.keySet())) {
            if (log instanceof NoLoggingImpl) {
                System.out.println("NoLogging:" + EasyClassUtil.getSimpleName(this.entityClass) + " not found property bean, plz add get set method");
            } else {
                log.warn(EasyClassUtil.getSimpleName(this.entityClass) + " not found property, plz add bean get set method");
            }
        }
        this.entityGlobalInterceptorConfigurationInit(configuration);
        if (table != null && this.isSharding()) {
            Class<? extends ShardingInitializer> initializer = table.shardingInitializer();
            this.initSharding(configuration, initializer);
        }
    }

    private void createNavigateMetadata(boolean tableEntity, Navigate navigate, Field field, FastBean fastBean, FastBeanProperty fastBeanProperty, String property, QueryConfiguration configuration) {
        String selfProperty = tableEntity ? navigate.selfProperty() : null;
        String targetProperty = tableEntity ? navigate.targetProperty() : null;
        RelationTypeEnum relationType = navigate.value();
        boolean toMany = relationType.equals((Object)RelationTypeEnum.OneToMany) || relationType.equals((Object)RelationTypeEnum.ManyToMany);
        Class<?> navigateType = this.getNavigateType(toMany, field, fastBeanProperty);
        if (navigateType == null) {
            throw new EasyQueryInvalidOperationException("not found navigate type, property:[" + property + "]");
        }
        Property<Object, ?> beanGetter = fastBean.getBeanGetter(fastBeanProperty);
        PropertySetterCaller<Object> beanSetter = fastBean.getBeanSetter(fastBeanProperty);
        NavigateOption navigateOption = new NavigateOption(this, property, fastBeanProperty.getPropertyType(), navigateType, relationType, selfProperty, targetProperty);
        if (tableEntity) {
            Class<? extends NavigateExtraFilterStrategy> extraFilterStrategyClass = navigate.extraFilter();
            if (!Objects.equals(DefaultNavigateExtraFilterStrategy.class, extraFilterStrategyClass)) {
                NavigateExtraFilterStrategy navigateExtraFilterStrategy = configuration.getNavigateExtraFilterStrategy(extraFilterStrategyClass);
                if (navigateExtraFilterStrategy == null) {
                    throw new EasyQueryInvalidOperationException("not found navigate extra filter strategy:[" + EasyClassUtil.getSimpleName(extraFilterStrategyClass) + "]");
                }
                SQLExpression1<WherePredicate<?>> predicateFilterExpression = navigateExtraFilterStrategy.getPredicateFilterExpression(new NavigateBuilder(navigateOption));
                if (predicateFilterExpression != null) {
                    navigateOption.setPredicateFilterExpression(predicateFilterExpression);
                }
            }
            if (RelationTypeEnum.ManyToMany == relationType) {
                if (Objects.equals(Object.class, navigate.mappingClass())) {
                    throw new IllegalArgumentException("relation type many to many map class not default");
                }
                if (EasyStringUtil.isBlank(navigate.selfMappingProperty())) {
                    throw new IllegalArgumentException("relation type many to many self mapping property is empty");
                }
                if (EasyStringUtil.isBlank(navigate.targetMappingProperty())) {
                    throw new IllegalArgumentException("relation type many to many target mapping property is empty");
                }
                navigateOption.setMappingClass(navigate.mappingClass());
                navigateOption.setSelfMappingProperty(navigate.selfMappingProperty());
                navigateOption.setTargetMappingProperty(navigate.targetMappingProperty());
            }
        }
        NavigateMetadata navigateMetadata = new NavigateMetadata(navigateOption, beanGetter, beanSetter);
        this.property2NavigateMap.put(property, navigateMetadata);
    }

    private String[] getFlatMappingPath(NavigateFlat navigateFlat, Map<String, Field> staticFields) {
        if (navigateFlat.mappingPath().length == 0) {
            return this.getMappingPath(navigateFlat.pathAlias(), staticFields, navigateFlat.mappingPath());
        }
        return navigateFlat.mappingPath();
    }

    private String[] getJoinMappingPath(NavigateJoin navigateJoin, Map<String, Field> staticFields) {
        if (navigateJoin.mappingPath().length == 0) {
            return this.getMappingPath(navigateJoin.pathAlias(), staticFields, navigateJoin.mappingPath());
        }
        return navigateJoin.mappingPath();
    }

    private String[] getMappingPath(String mapping, Map<String, Field> staticFields, String[] def) {
        MappingPath mappingPath;
        String mappingPathValue;
        Object mappingPathObject;
        Field field;
        if (EasyStringUtil.isNotBlank(mapping) && (field = staticFields.get(mapping)) != null && (mappingPathObject = EasyClassUtil.getStaticFieldValue(field)) instanceof MappingPath && EasyStringUtil.isNotBlank(mappingPathValue = (mappingPath = (MappingPath)mappingPathObject).__getMappingPath())) {
            return mappingPathValue.split("\\.");
        }
        return def;
    }

    private void createNavigateFlatMappingMetadata(NavigateFlat navigateFlat, Map<String, Field> staticFields, Field field, FastBean fastBean, FastBeanProperty fastBeanProperty, String property) {
        boolean toMany;
        Class<?> navigateType;
        String[] mappingPath = this.getFlatMappingPath(navigateFlat, staticFields);
        if (mappingPath.length <= 1) {
            throw new EasyQueryInvalidOperationException("navigate flat, mappingPath at least two path");
        }
        RelationMappingTypeEnum relationMappingType = navigateFlat.value();
        if (relationMappingType == RelationMappingTypeEnum.AUTO) {
            Class<?> propertyType = fastBeanProperty.getPropertyType();
            relationMappingType = Collection.class.isAssignableFrom(propertyType) ? RelationMappingTypeEnum.ToMany : RelationMappingTypeEnum.ToOne;
        }
        if ((navigateType = this.getNavigateType(toMany = relationMappingType.equals((Object)RelationMappingTypeEnum.ToMany), field, fastBeanProperty)) == null) {
            throw new EasyQueryInvalidOperationException("not found navigate flat type, property:[" + property + "]");
        }
        PropertySetterCaller<Object> beanSetter = fastBean.getBeanSetter(fastBeanProperty);
        NavigateFlatMetadata navigateFlatMetadata = new NavigateFlatMetadata(this, relationMappingType, mappingPath, navigateType, EasyClassUtil.isBasicTypeOrEnum(navigateType), beanSetter, property);
        this.property2NavigateFlatMap.put(property, navigateFlatMetadata);
    }

    private void createNavigateJoinMappingMetadata(NavigateJoin navigateJoin, Map<String, Field> staticFields, String property) {
        String[] mappingPath = this.getJoinMappingPath(navigateJoin, staticFields);
        if (mappingPath.length <= 1) {
            throw new EasyQueryInvalidOperationException("navigate join, mappingPath at least two path");
        }
        NavigateJoinMetadata navigateJoinMetadata = new NavigateJoinMetadata(this, mappingPath, property);
        this.property2NavigateJoinMap.put(property, navigateJoinMetadata);
    }

    private ColumnMetadata acceptColumnOption(String parentPropertyName, ColumnOption columnOption, ColumnAllIndex columnAllIndex) {
        String propertyName = parentPropertyName == null ? columnOption.getProperty().getName() : parentPropertyName + "." + columnOption.getProperty().getName();
        columnOption.setFullPropertyName(propertyName);
        ColumnMetadata columnMetadata = new ColumnMetadata(columnOption);
        ColumnMetadata oldValue = this.property2ColumnMap.put(columnMetadata.getPropertyName(), columnMetadata);
        if (oldValue != null) {
            throw new EasyQueryInvalidOperationException("propertyName:" + propertyName + ", repeat.");
        }
        if (columnOption.isValueObject()) {
            for (ColumnOption valueObjectColumnOption : columnOption.getValueObjectColumnOptions()) {
                ColumnMetadata valueObjectColumnMetadata = this.acceptColumnOption(propertyName, valueObjectColumnOption, columnAllIndex);
                columnMetadata.getValueObjectColumnMetadataList().add(valueObjectColumnMetadata);
            }
        } else {
            ColumnMetadata oldColumnName = this.column2PropertyMap.put(columnOption.getName(), columnMetadata);
            if (oldColumnName != null) {
                throw new EasyQueryInvalidOperationException("columnName:" + columnOption.getName() + ", repeat.");
            }
            if (columnOption.isTableEntity() && columnOption.isAutoSelect()) {
                this.dataReader = new BeanDataReader(this.dataReader, new PropertyDataReader(new EntityResultColumnMetadata(columnAllIndex.incrementAndGet(), this, columnMetadata)));
            }
        }
        return columnMetadata;
    }

    private void processEnumValueConverter(ColumnOption columnOption, Class<?> propertyType, QueryConfiguration configuration) {
        if (Enum.class.isAssignableFrom(propertyType)) {
            List<EnumValueAutoConverter<?, ?>> enumValueAutoConverters = configuration.getEnumValueAutoConverters();
            for (EnumValueAutoConverter<?, ?> enumValueAutoConverter : enumValueAutoConverters) {
                if (!enumValueAutoConverter.apply(this.entityClass, (Class)EasyObjectUtil.typeCastNullable(propertyType))) continue;
                columnOption.setValueConverter(enumValueAutoConverter);
                break;
            }
        }
    }

    private ColumnOption createColumnOption(Field field, PropertyDescriptor propertyDescriptor, boolean tableEntity, FastBeanProperty fastBeanProperty, QueryConfiguration configuration, FastBean fastBean, JdbcTypeHandlerManager jdbcTypeHandlerManager, boolean defaultAutoSelect) {
        NameConversion nameConversion = configuration.getNameConversion();
        String property = field.getName();
        Column column = field.getAnnotation(Column.class);
        boolean hasColumnName = column != null && EasyStringUtil.isNotBlank(column.value());
        boolean autoSelect = column == null ? defaultAutoSelect : column.autoSelect();
        String columnName = hasColumnName ? column.value() : nameConversion.convert(property);
        ColumnOption columnOption = new ColumnOption(tableEntity, this, columnName);
        columnOption.setProperty(propertyDescriptor);
        columnOption.setAutoSelect(autoSelect);
        Encryption encryption = field.getAnnotation(Encryption.class);
        if (encryption != null) {
            Class<? extends EncryptionStrategy> strategy = encryption.strategy();
            EncryptionStrategy easyEncryptionStrategy = configuration.getEasyEncryptionStrategy(strategy);
            if (easyEncryptionStrategy == null) {
                throw new EasyQueryException(EasyClassUtil.getSimpleName(this.entityClass) + "." + property + " Encryption strategy unknown");
            }
            columnOption.setEncryptionStrategy(easyEncryptionStrategy);
            columnOption.setSupportQueryLike(encryption.supportQueryLike());
        }
        if (column != null) {
            ComplexPropType complexPropType;
            Class<? extends ValueConverter<?, ?>> conversionClass = column.conversion();
            if (!Objects.equals(DefaultValueConverter.class, conversionClass)) {
                ValueConverter<?, ?> valueConverter = configuration.getValueConverter(conversionClass);
                if (valueConverter == null) {
                    throw new EasyQueryException(EasyClassUtil.getSimpleName(this.entityClass) + "." + property + " conversion unknown");
                }
                columnOption.setValueConverter(valueConverter);
            } else {
                this.processEnumValueConverter(columnOption, propertyDescriptor.getPropertyType(), configuration);
            }
            Class<? extends ComplexPropType> complexPropTypeClass = column.complexPropType();
            if (Objects.equals(DefaultComplexPropType.class, complexPropTypeClass)) {
                complexPropType = new DefaultComplexPropType(fastBeanProperty.getPropertyType());
                columnOption.setComplexPropType(complexPropType);
            } else {
                complexPropType = EasyClassUtil.newInstance(complexPropTypeClass);
                columnOption.setComplexPropType(complexPropType);
            }
            Class<? extends JdbcTypeHandler> typeHandlerClass = column.typeHandler();
            if (!Objects.equals(typeHandlerClass, UnKnownTypeHandler.class)) {
                JdbcTypeHandler handlerByHandlerClass = jdbcTypeHandlerManager.getHandlerByHandlerClass(typeHandlerClass);
                columnOption.setJdbcTypeHandler(handlerByHandlerClass);
            }
        } else {
            this.processEnumValueConverter(columnOption, propertyDescriptor.getPropertyType(), configuration);
        }
        if (tableEntity) {
            LogicDelete logicDelete;
            ShardingExtraTableKey shardingExtraTableKey;
            ShardingTableKey shardingTableKey;
            ShardingExtraDataSourceKey shardingExtraDataSourceKey;
            ShardingDataSourceKey shardingDataSourceKey;
            Version version;
            UpdateIgnore updateIgnore;
            InsertIgnore insertIgnore;
            if (column != null) {
                Class<? extends PrimaryKeyGenerator> primaryKeyGeneratorClass;
                if (column.primaryKey()) {
                    this.keyPropertiesMap.put(property, columnName);
                }
                columnOption.setPrimary(column.primaryKey());
                boolean generatedKey = column.generatedKey();
                if (generatedKey) {
                    this.generatedKeyColumns.add(columnName);
                    Class<? extends GeneratedKeySQLColumnGenerator> generatedKeySQLColumnGeneratorClass = column.generatedSQLColumnGenerator();
                    if (!Objects.equals(DefaultGeneratedKeySQLColumnGenerator.class, generatedKeySQLColumnGeneratorClass)) {
                        GeneratedKeySQLColumnGenerator generatedKeySQLColumnGenerator = configuration.getGeneratedKeySQLColumnGenerator(generatedKeySQLColumnGeneratorClass);
                        if (generatedKeySQLColumnGenerator == null) {
                            throw new EasyQueryException(EasyClassUtil.getSimpleName(this.entityClass) + "." + property + " generated key sql column generator unknown");
                        }
                        columnOption.setGeneratedKeySQLColumnGenerator(generatedKeySQLColumnGenerator);
                    }
                } else if (column.primaryKey() && !Objects.equals(UnsupportPrimaryKeyGenerator.class, primaryKeyGeneratorClass = column.primaryKeyGenerator())) {
                    PrimaryKeyGenerator primaryKeyGenerator = configuration.getPrimaryKeyGenerator(primaryKeyGeneratorClass);
                    if (primaryKeyGenerator == null) {
                        throw new EasyQueryException(EasyClassUtil.getSimpleName(this.entityClass) + "." + property + " primary key generator unknown");
                    }
                    columnOption.setPrimaryKeyGenerator(primaryKeyGenerator);
                    this.hasPrimaryKeyGenerator = true;
                }
                columnOption.setGeneratedKey(generatedKey);
                columnOption.setLarge(column.large());
                Class<? extends ColumnValueSQLConverter> columnValueSQLConverterClass = column.sqlConversion();
                if (!Objects.equals(DefaultColumnValueSQLConverter.class, columnValueSQLConverterClass)) {
                    ColumnValueSQLConverter columnValueSQLConverter = configuration.getColumnValueSQLConverter(columnValueSQLConverterClass);
                    if (columnValueSQLConverter == null) {
                        throw new EasyQueryException(EasyClassUtil.getSimpleName(this.entityClass) + "." + property + " column value sql converter unknown");
                    }
                    columnOption.setColumnValueSQLConverter(columnValueSQLConverter);
                    if (columnValueSQLConverter.isMergeSubQuery()) {
                        this.aliasQuery = true;
                    }
                }
            }
            if ((insertIgnore = field.getAnnotation(InsertIgnore.class)) != null) {
                columnOption.setInsertIgnore(true);
            }
            if ((updateIgnore = field.getAnnotation(UpdateIgnore.class)) != null) {
                columnOption.setUpdateIgnore(true);
                columnOption.setUpdateSetInTrackDiff(updateIgnore.updateSetInTrackDiff());
            }
            if ((version = field.getAnnotation(Version.class)) != null) {
                Class<? extends VersionStrategy> strategy = version.strategy();
                VersionStrategy easyVersionStrategy = configuration.getEasyVersionStrategyOrNull(strategy);
                if (easyVersionStrategy == null) {
                    throw new EasyQueryException(EasyClassUtil.getSimpleName(this.entityClass) + "." + property + " Version strategy unknown");
                }
                columnOption.setVersion(true);
                if (this.versionMetadata == null) {
                    this.versionMetadata = new VersionMetadata(property, easyVersionStrategy);
                } else {
                    throw new EasyQueryException("multi version not support");
                }
            }
            if ((shardingDataSourceKey = field.getAnnotation(ShardingDataSourceKey.class)) != null) {
                this.setShardingDataSourcePropertyName(property);
            }
            if ((shardingExtraDataSourceKey = field.getAnnotation(ShardingExtraDataSourceKey.class)) != null) {
                this.addExtraShardingDataSourcePropertyName(property);
            }
            if ((shardingTableKey = field.getAnnotation(ShardingTableKey.class)) != null) {
                this.setShardingTablePropertyName(property);
            }
            if ((shardingExtraTableKey = field.getAnnotation(ShardingExtraTableKey.class)) != null) {
                this.addExtraShardingTablePropertyName(property);
            }
            if ((logicDelete = field.getAnnotation(LogicDelete.class)) != null) {
                if (this.logicDeleteMetadata != null) {
                    throw new EasyQueryException("multi logic delete not support");
                }
                LogicDeleteStrategyEnum strategy = logicDelete.strategy();
                if (Objects.equals((Object)LogicDeleteStrategyEnum.CUSTOM, (Object)strategy)) {
                    String strategyName = logicDelete.strategyName();
                    if (EasyStringUtil.isBlank(strategyName)) {
                        throw new EasyQueryException(EasyClassUtil.getSimpleName(this.entityClass) + "." + property + " logic delete strategy is empty");
                    }
                    LogicDeleteStrategy globalLogicDeleteStrategy = configuration.getLogicDeleteStrategyNotNull(strategyName);
                    LogicDeleteBuilder logicDeleteBuilder = new LogicDeleteBuilder(this.entityClass, property, field.getType());
                    this.logicDeleteMetadata = globalLogicDeleteStrategy.configureBuild(logicDeleteBuilder);
                } else {
                    LogicDeleteStrategy sysGlobalLogicDeleteStrategy = configuration.getSysLogicDeleteStrategyNotNull(strategy);
                    LogicDeleteBuilder logicDeleteBuilder = new LogicDeleteBuilder(this.entityClass, property, field.getType());
                    this.logicDeleteMetadata = sysGlobalLogicDeleteStrategy.configureBuild(logicDeleteBuilder);
                }
            }
        }
        Property<Object, ?> beanGetter = fastBean.getBeanGetter(fastBeanProperty);
        columnOption.setGetterCaller(beanGetter);
        PropertySetterCaller<Object> beanSetter = fastBean.getBeanSetter(fastBeanProperty);
        columnOption.setSetterCaller(beanSetter);
        if (columnOption.getJdbcTypeHandler() == null) {
            JdbcTypeHandler jdbcTypeHandler = jdbcTypeHandlerManager.getHandler(columnOption.getProperty().getPropertyType());
            columnOption.setJdbcTypeHandler(jdbcTypeHandler);
        }
        return columnOption;
    }

    private void parseValueObject(ColumnOption parentColumnOption, QueryConfiguration configuration, JdbcTypeHandlerManager jdbcTypeHandlerManager) {
        PropertyDescriptor parentProperty = parentColumnOption.getProperty();
        Class<?> valueObjectClass = parentProperty.getPropertyType();
        Collection<Field> allFields = EasyClassUtil.getAllFields(valueObjectClass);
        PropertyDescriptor[] ps = EasyClassUtil.propertyDescriptors(valueObjectClass);
        PropertyDescriptorFinder propertyDescriptorFinder = new PropertyDescriptorFinder(ps);
        FastBean fastBean = EasyBeanUtil.getFastBean(valueObjectClass);
        for (Field field : allFields) {
            PropertyDescriptor propertyDescriptor;
            String property = EasyStringUtil.toLowerCaseFirstOne(field.getName());
            if (Modifier.isStatic(field.getModifiers()) || (propertyDescriptor = propertyDescriptorFinder.find(property)) == null) continue;
            Type genericType = field.getGenericType();
            FastBeanProperty fastBeanProperty = new FastBeanProperty(EntityMetadata.isGenericType(genericType), propertyDescriptor);
            ColumnIgnore columnIgnore = field.getAnnotation(ColumnIgnore.class);
            if (columnIgnore != null) continue;
            Navigate navigate = field.getAnnotation(Navigate.class);
            if (navigate != null) {
                this.createNavigateMetadata(true, navigate, field, fastBean, fastBeanProperty, property, configuration);
                continue;
            }
            ValueObject valueObject = field.getAnnotation(ValueObject.class);
            if (valueObject != null) {
                ColumnOption columnOption = this.createColumnOption(field, propertyDescriptor, true, fastBeanProperty, configuration, fastBean, jdbcTypeHandlerManager, parentColumnOption.isAutoSelect());
                FastBean valueObjectFastBean = EasyBeanUtil.getFastBean(propertyDescriptor.getPropertyType());
                columnOption.setValueObject(true);
                columnOption.setBeanConstructorCreator(valueObjectFastBean.getBeanConstructorCreator());
                parentColumnOption.getValueObjectColumnOptions().add(columnOption);
                this.parseValueObject(columnOption, configuration, jdbcTypeHandlerManager);
                continue;
            }
            ColumnOption columnOption = this.createColumnOption(field, propertyDescriptor, true, fastBeanProperty, configuration, fastBean, jdbcTypeHandlerManager, parentColumnOption.isAutoSelect());
            parentColumnOption.getValueObjectColumnOptions().add(columnOption);
        }
    }

    private static boolean isGenericType(Type type) {
        Class clazz;
        if (type instanceof TypeVariable) {
            return true;
        }
        return type instanceof Class && (clazz = (Class)type).getTypeParameters().length > 0;
    }

    private Class<?> getNavigateType(boolean toMany, Field field, FastBeanProperty fastBeanProperty) {
        if (toMany) {
            Type elementType;
            ParameterizedType parameterizedType;
            Type[] typeArguments;
            Type genericType = field.getGenericType();
            if (genericType instanceof ParameterizedType && (typeArguments = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments()).length > 0 && (elementType = typeArguments[0]) instanceof Class) {
                return (Class)elementType;
            }
            return null;
        }
        return fastBeanProperty.getPropertyType();
    }

    private void initSharding(QueryConfiguration configuration, Class<? extends ShardingInitializer> initializer) {
        ShardingInitializer easyShardingInitializer = configuration.getEasyShardingInitializerOrNull(initializer);
        if (easyShardingInitializer == null) {
            throw new EasyQueryInvalidOperationException("not found sharding initializer:" + EasyClassUtil.getSimpleName(initializer));
        }
        ShardingEntityBuilder shardingInitializerBuilder = new ShardingEntityBuilder(this, configuration.getEasyQueryOption());
        easyShardingInitializer.initialize(shardingInitializerBuilder);
        ShardingInitOption shardingInitOption = shardingInitializerBuilder.build();
        Map<String, Collection<String>> initializeTables = shardingInitOption.getActualTableNames();
        if (initializeTables != null && !initializeTables.isEmpty()) {
            Set<String> dataSources = initializeTables.keySet();
            for (String dataSource : dataSources) {
                Collection<String> tableNames = initializeTables.get(dataSource);
                if (EasyCollectionUtil.isNotEmpty(tableNames)) {
                    for (String name : tableNames) {
                        this.addActualTableWithDataSource(dataSource, name);
                    }
                    continue;
                }
                this.addActualTableWithDataSource(dataSource, this.tableName);
            }
        }
        ShardingSequenceConfig shardingSequenceConfig = null;
        Comparator<TableUnit> defaultTableNameComparator = shardingInitOption.getDefaultTableNameComparator();
        if (defaultTableNameComparator != null) {
            shardingSequenceConfig = new ShardingSequenceConfig(defaultTableNameComparator, shardingInitOption.getSequenceProperties(), shardingInitOption.getMaxShardingQueryLimit(), shardingInitOption.getSequenceCompareMethods(), shardingInitOption.getSequenceCompareAscMethods(), shardingInitOption.getSequenceLimitMethods(), shardingInitOption.getSequenceConnectionModeMethods(), shardingInitOption.getConnectionMode());
        }
        this.shardingInitConfig = new ShardingInitConfig(shardingInitOption.getReverseFactor(), shardingInitOption.getMinReverseTotal(), shardingSequenceConfig);
    }

    protected void entityGlobalInterceptorConfigurationInit(QueryConfiguration configuration) {
        if (EasyStringUtil.isNotBlank(this.tableName)) {
            List globalInterceptors = configuration.getEasyInterceptors().stream().sorted(Comparator.comparingInt(Interceptor::order)).collect(Collectors.toList());
            for (Interceptor globalInterceptor : globalInterceptors) {
                if (!globalInterceptor.apply(this.entityClass)) continue;
                if (globalInterceptor instanceof PredicateFilterInterceptor) {
                    this.predicateFilterInterceptors.add((PredicateFilterInterceptor)globalInterceptor);
                }
                if (globalInterceptor instanceof EntityInterceptor) {
                    this.entityInterceptors.add((EntityInterceptor)globalInterceptor);
                }
                if (!(globalInterceptor instanceof UpdateSetInterceptor)) continue;
                this.updateSetInterceptors.add((UpdateSetInterceptor)globalInterceptor);
            }
        }
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSchemaOrNull() {
        return this.schema;
    }

    public String getColumnName(String propertyName) {
        ColumnMetadata columnMetadata = this.property2ColumnMap.get(propertyName);
        if (columnMetadata == null) {
            throw new EasyQueryException(String.format("%s not found property:[%s] mapping column", EasyClassUtil.getSimpleName(this.entityClass), propertyName));
        }
        return columnMetadata.getName();
    }

    public String getPropertyNameOrNull(String columnName) {
        return this.getPropertyNameOrNull(columnName, null);
    }

    public String getPropertyNameNotNull(String columnName) {
        String propertyName = this.getPropertyNameOrNull(columnName, null);
        if (propertyName == null) {
            throw new EasyQueryException(String.format("not found column:[%s] mapping property", columnName));
        }
        return propertyName;
    }

    public String getPropertyNameOrNull(String columnName, String def) {
        ColumnMetadata columnMetadata = this.getColumnMetadataOrNull(columnName);
        if (columnMetadata == null) {
            return def;
        }
        return columnMetadata.getPropertyName();
    }

    public ColumnMetadata getColumnMetadataOrNull(String columnName) {
        ColumnMetadata columnMetadata = null;
        columnMetadata = this.column2PropertyMap.get(columnName);
        if (null == columnMetadata) {
            columnMetadata = this.column2PropertyMap.get(columnName.toLowerCase(Locale.ENGLISH));
        }
        return columnMetadata;
    }

    public Collection<ColumnMetadata> getColumns() {
        return this.property2ColumnMap.values();
    }

    public Collection<String> getProperties() {
        return this.property2ColumnMap.keySet();
    }

    public Map<String, ColumnMetadata> getProperty2ColumnMap() {
        return this.property2ColumnMap;
    }

    public Map<String, NavigateMetadata> getProperty2NavigateMap() {
        return this.property2NavigateMap;
    }

    public Collection<String> getKeyProperties() {
        return this.keyPropertiesMap.keySet();
    }

    public boolean isKeyProperty(String propertyName) {
        if (propertyName == null) {
            return false;
        }
        return this.keyPropertiesMap.containsKey(propertyName);
    }

    public NavigateMetadata getNavigateNotNull(String propertyName) {
        NavigateMetadata navigateMetadata = this.getNavigateOrNull(propertyName);
        if (navigateMetadata == null) {
            throw new EasyQueryException(String.format(EasyClassUtil.getSimpleName(this.entityClass) + " not found property:[%s] mapping navigate", propertyName));
        }
        return navigateMetadata;
    }

    public NavigateFlatMetadata getNavigateFlatNotNull(String propertyName) {
        NavigateFlatMetadata navigateFlatMetadata = this.getNavigateFlatOrNull(propertyName);
        if (navigateFlatMetadata == null) {
            throw new EasyQueryException(String.format(EasyClassUtil.getSimpleName(this.entityClass) + " not found property:[%s] mapping navigate flat", propertyName));
        }
        return navigateFlatMetadata;
    }

    public NavigateMetadata getNavigateOrNull(String propertyName) {
        return this.property2NavigateMap.get(propertyName);
    }

    public NavigateFlatMetadata getNavigateFlatOrNull(String propertyName) {
        return this.property2NavigateFlatMap.get(propertyName);
    }

    public Collection<NavigateMetadata> getNavigateMetadatas() {
        return this.property2NavigateMap.values();
    }

    public Collection<NavigateFlatMetadata> getNavigateFlatMetadatas() {
        return this.property2NavigateFlatMap.values();
    }

    public NavigateJoinMetadata getNavigateJoinOrNull(String propertyName) {
        return this.property2NavigateJoinMap.get(propertyName);
    }

    public Collection<NavigateJoinMetadata> getNavigateJoinMetadatas() {
        return this.property2NavigateJoinMap.values();
    }

    public ColumnMetadata getColumnNotNull(String propertyName) {
        ColumnMetadata columnMetadata = this.getColumnOrNull(propertyName);
        if (columnMetadata == null) {
            throw new EasyQueryException(String.format("%s not found property:[%s] mapping column name", EasyClassUtil.getSimpleName(this.entityClass), propertyName));
        }
        return columnMetadata;
    }

    public ColumnMetadata getColumnOrNull(String propertyName) {
        return this.property2ColumnMap.get(propertyName);
    }

    public void checkTable() {
        if (this.entityMetadataType != EntityMetadataTypeEnum.MAP && EasyStringUtil.isEmpty(this.tableName)) {
            throw new EasyQueryException("current entity not mapping table name," + EasyClassUtil.getSimpleName(this.entityClass));
        }
    }

    public void setLogicDeleteMetadata(LogicDeleteMetadata logicDeleteMetadata) {
        this.logicDeleteMetadata = logicDeleteMetadata;
    }

    public LogicDeleteMetadata getLogicDeleteMetadata() {
        return this.logicDeleteMetadata;
    }

    public boolean enableLogicDelete() {
        return this.logicDeleteMetadata != null;
    }

    public List<PredicateFilterInterceptor> getPredicateFilterInterceptors() {
        return this.predicateFilterInterceptors;
    }

    public List<EntityInterceptor> getEntityInterceptors() {
        return this.entityInterceptors;
    }

    public List<UpdateSetInterceptor> getUpdateSetInterceptors() {
        return this.updateSetInterceptors;
    }

    public List<String> getGeneratedKeyColumns() {
        return this.generatedKeyColumns;
    }

    public boolean hasVersionColumn() {
        return this.versionMetadata != null;
    }

    public VersionMetadata getVersionMetadata() {
        return this.versionMetadata;
    }

    public boolean isSharding() {
        return this.isMultiTableMapping() || this.isMultiDataSourceMapping();
    }

    public String getShardingDataSourcePropertyName() {
        return this.shardingDataSourcePropertyName;
    }

    public void setShardingDataSourcePropertyName(String shardingDataSourcePropertyName) {
        if (this.shardingDataSourcePropertyNames.contains(shardingDataSourcePropertyName)) {
            throw new EasyQueryInvalidOperationException("same sharding data source property name:[" + shardingDataSourcePropertyName + "]");
        }
        this.shardingDataSourcePropertyName = shardingDataSourcePropertyName;
        this.shardingDataSourcePropertyNames.add(shardingDataSourcePropertyName);
    }

    public void addExtraShardingDataSourcePropertyName(String shardingExtraDataSourcePropertyName) {
        if (this.shardingDataSourcePropertyNames.contains(shardingExtraDataSourcePropertyName)) {
            throw new EasyQueryInvalidOperationException("same sharding data source property name:[" + shardingExtraDataSourcePropertyName + "]");
        }
        this.shardingDataSourcePropertyNames.add(shardingExtraDataSourcePropertyName);
    }

    public String getShardingTablePropertyName() {
        return this.shardingTablePropertyName;
    }

    public void setShardingTablePropertyName(String shardingTablePropertyName) {
        if (this.shardingTablePropertyNames.contains(shardingTablePropertyName)) {
            throw new EasyQueryInvalidOperationException("same sharding table property name:[" + shardingTablePropertyName + "]");
        }
        this.shardingTablePropertyName = shardingTablePropertyName;
        this.shardingTablePropertyNames.add(shardingTablePropertyName);
    }

    public void addExtraShardingTablePropertyName(String shardingExtraTablePropertyName) {
        if (this.shardingTablePropertyNames.contains(shardingExtraTablePropertyName)) {
            throw new EasyQueryInvalidOperationException("same sharding table property name:[" + shardingExtraTablePropertyName + "]");
        }
        this.shardingTablePropertyNames.add(shardingExtraTablePropertyName);
    }

    public Collection<ActualTable> getActualTables() {
        return Collections.unmodifiableCollection(this.actualTables);
    }

    public void addActualTableWithDataSource(String dataSource, String actualTableName) {
        if (EasyStringUtil.isBlank(dataSource)) {
            throw new IllegalArgumentException("data source");
        }
        if (EasyStringUtil.isBlank(actualTableName)) {
            throw new IllegalArgumentException("actual table name");
        }
        this.dataSources.add(dataSource);
        this.actualTables.add(new ActualTable(dataSource, actualTableName));
    }

    public Collection<String> getDataSources() {
        return Collections.unmodifiableCollection(this.dataSources);
    }

    public Set<String> getShardingDataSourcePropertyNames() {
        return this.shardingDataSourcePropertyNames;
    }

    public Set<String> getShardingTablePropertyNames() {
        return this.shardingTablePropertyNames;
    }

    public ShardingInitConfig getShardingInitConfig() {
        return this.shardingInitConfig;
    }

    public Supplier<Object> getBeanConstructorCreator() {
        return this.beanConstructorCreator;
    }

    public EntityMetadataTypeEnum getEntityMetadataType() {
        return this.entityMetadataType;
    }

    public String getSingleKeyProperty() {
        Collection<String> keyProperties = this.getKeyProperties();
        if (EasyCollectionUtil.isNotSingle(keyProperties)) {
            throw new EasyQueryInvalidOperationException("entity :" + EasyClassUtil.getSimpleName(this.entityClass) + " not single key size :" + keyProperties.size());
        }
        return EasyCollectionUtil.first(keyProperties);
    }

    public DataReader getDataReader() {
        return this.dataReader;
    }

    public boolean isHasValueObject() {
        return this.hasValueObject;
    }

    public boolean isAliasQuery() {
        return this.aliasQuery;
    }

    @NotNull
    public ErrorMessage getErrorMessage() {
        return this.errorMessage;
    }

    public boolean isHasPrimaryKeyGenerator() {
        return this.hasPrimaryKeyGenerator;
    }
}

