/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.metadata;

import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.enums.RelationTypeEnum;
import com.easy.query.core.expression.lambda.Property;
import com.easy.query.core.expression.lambda.PropertySetterCaller;
import com.easy.query.core.expression.lambda.SQLExpression1;
import com.easy.query.core.expression.parser.core.base.WherePredicate;
import com.easy.query.core.metadata.ColumnMetadata;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.metadata.NavigateOption;
import com.easy.query.core.util.EasyStringUtil;

public class NavigateMetadata {
    private final EntityMetadata entityMetadata;
    private final String propertyName;
    private final Class<?> navigateOriginalPropertyType;
    private final Class<?> navigatePropertyType;
    private final RelationTypeEnum relationType;
    private final boolean basicType;
    private final String selfProperty;
    private final String targetProperty;
    private final Property<Object, ?> getter;
    private final PropertySetterCaller<Object> setter;
    private final Class<?> mappingClass;
    private final String selfMappingProperty;
    private final String targetMappingProperty;
    private final SQLExpression1<WherePredicate<?>> predicateFilterExpression;

    public NavigateMetadata(NavigateOption navigateOption, Property<Object, ?> getter, PropertySetterCaller<Object> setter) {
        this.entityMetadata = navigateOption.getEntityMetadata();
        this.propertyName = navigateOption.getPropertyName();
        this.navigateOriginalPropertyType = navigateOption.getNavigateOriginalPropertyType();
        this.navigatePropertyType = navigateOption.getNavigatePropertyType();
        this.relationType = navigateOption.getRelationType();
        this.selfProperty = navigateOption.getSelfProperty();
        this.targetProperty = navigateOption.getTargetProperty();
        this.mappingClass = navigateOption.getMappingClass();
        this.selfMappingProperty = navigateOption.getSelfMappingProperty();
        this.targetMappingProperty = navigateOption.getTargetMappingProperty();
        this.predicateFilterExpression = navigateOption.getPredicateFilterExpression();
        this.basicType = navigateOption.isBasicType();
        this.getter = getter;
        this.setter = setter;
    }

    public EntityMetadata getEntityMetadata() {
        return this.entityMetadata;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Class<?> getNavigatePropertyType() {
        return this.navigatePropertyType;
    }

    public Class<?> getNavigateOriginalPropertyType() {
        return this.navigateOriginalPropertyType;
    }

    public RelationTypeEnum getRelationType() {
        return this.relationType;
    }

    public String getSelfProperty() {
        return this.selfProperty;
    }

    public String getSelfPropertyOrPrimary() {
        if (EasyStringUtil.isNotBlank(this.selfProperty)) {
            return this.selfProperty;
        }
        return this.entityMetadata.getSingleKeyProperty();
    }

    public String getTargetProperty() {
        return this.targetProperty;
    }

    public String getTargetPropertyOrPrimary(QueryRuntimeContext runtimeContext) {
        if (EasyStringUtil.isNotBlank(this.targetProperty)) {
            return this.targetProperty;
        }
        EntityMetadata targetEntityMetadata = runtimeContext.getEntityMetadataManager().getEntityMetadata(this.navigatePropertyType);
        return targetEntityMetadata.getSingleKeyProperty();
    }

    public Class<?> getMappingClass() {
        return this.mappingClass;
    }

    public String getSelfMappingProperty() {
        return this.selfMappingProperty;
    }

    public String getTargetMappingProperty() {
        return this.targetMappingProperty;
    }

    public Property<Object, ?> getGetter() {
        return this.getter;
    }

    public PropertySetterCaller<Object> getSetter() {
        return this.setter;
    }

    public ColumnMetadata getSelfRelationColumn() {
        String selfPropertyName = this.getSelfPropertyOrPrimary();
        return this.entityMetadata.getColumnNotNull(selfPropertyName);
    }

    public SQLExpression1<WherePredicate<?>> getPredicateFilterExpression() {
        return this.predicateFilterExpression;
    }

    public boolean hasPredicateFilterExpression() {
        return this.predicateFilterExpression != null;
    }

    public void predicateFilterApply(WherePredicate<?> wherePredicate) {
        if (this.predicateFilterExpression != null) {
            this.predicateFilterExpression.apply(wherePredicate);
        }
    }

    public boolean isBasicType() {
        return this.basicType;
    }
}

