/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.metadata;

import com.easy.query.core.enums.RelationTypeEnum;
import com.easy.query.core.expression.lambda.SQLExpression1;
import com.easy.query.core.expression.parser.core.base.WherePredicate;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.util.EasyClassUtil;

public class NavigateOption {
    private final EntityMetadata entityMetadata;
    private final String propertyName;
    private final Class<?> navigateOriginalPropertyType;
    private final Class<?> navigatePropertyType;
    private final RelationTypeEnum relationType;
    private final String selfProperty;
    private final String targetProperty;
    private final boolean basicType;
    private Class<?> mappingClass;
    private String selfMappingProperty;
    private String targetMappingProperty;
    private SQLExpression1<WherePredicate<?>> predicateFilterExpression;

    public NavigateOption(EntityMetadata entityMetadata, String propertyName, Class<?> navigateOriginalPropertyType, Class<?> navigatePropertyType, RelationTypeEnum relationType, String selfProperty, String targetProperty) {
        this.entityMetadata = entityMetadata;
        this.propertyName = propertyName;
        this.navigateOriginalPropertyType = navigateOriginalPropertyType;
        this.navigatePropertyType = navigatePropertyType;
        this.relationType = relationType;
        this.selfProperty = selfProperty;
        this.targetProperty = targetProperty;
        this.basicType = EasyClassUtil.isBasicType(navigatePropertyType);
    }

    public EntityMetadata getEntityMetadata() {
        return this.entityMetadata;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Class<?> getNavigateOriginalPropertyType() {
        return this.navigateOriginalPropertyType;
    }

    public Class<?> getNavigatePropertyType() {
        return this.navigatePropertyType;
    }

    public RelationTypeEnum getRelationType() {
        return this.relationType;
    }

    public String getSelfProperty() {
        return this.selfProperty;
    }

    public String getTargetProperty() {
        return this.targetProperty;
    }

    public Class<?> getMappingClass() {
        return this.mappingClass;
    }

    public void setMappingClass(Class<?> mappingClass) {
        this.mappingClass = mappingClass;
    }

    public String getSelfMappingProperty() {
        return this.selfMappingProperty;
    }

    public void setSelfMappingProperty(String selfMappingProperty) {
        this.selfMappingProperty = selfMappingProperty;
    }

    public String getTargetMappingProperty() {
        return this.targetMappingProperty;
    }

    public void setTargetMappingProperty(String targetMappingProperty) {
        this.targetMappingProperty = targetMappingProperty;
    }

    public SQLExpression1<WherePredicate<?>> getPredicateFilterExpression() {
        return this.predicateFilterExpression;
    }

    public void setPredicateFilterExpression(SQLExpression1<WherePredicate<?>> predicateFilterExpression) {
        this.predicateFilterExpression = predicateFilterExpression;
    }

    public boolean isBasicType() {
        return this.basicType;
    }
}

