/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.sharding.api.initializer.time;

import com.easy.query.core.sharding.api.initializer.time.AbstractShardingTimeInitializer;
import com.easy.query.core.util.EasyUtil;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

public abstract class AbstractShardingMonthInitializer<T>
extends AbstractShardingTimeInitializer<T> {
    @Override
    protected LocalDateTime getBeginTimeToStart(LocalDateTime beginTime) {
        return EasyUtil.getMonthStart(beginTime);
    }

    @Override
    protected LocalDateTime getNextTime(LocalDateTime currentTime) {
        return currentTime.plusMonths(1L);
    }

    @Override
    protected String formatTail(LocalDateTime time) {
        return time.format(DateTimeFormatter.ofPattern("yyyyMM"));
    }

    @Override
    public long calcNextTime() {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime monthStart = EasyUtil.getMonthStart(now.plusMonths(1L));
        return monthStart.toEpochSecond(ZoneOffset.ofHours(8)) * 1000L;
    }
}

