/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.sharding.api.initializer.time;

import com.easy.query.core.sharding.api.initializer.time.AbstractShardingTimeInitializer;
import com.easy.query.core.util.EasyUtil;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

public abstract class AbstractShardingQuarterInitializer<T>
extends AbstractShardingTimeInitializer<T> {
    @Override
    protected LocalDateTime getBeginTimeToStart(LocalDateTime beginTime) {
        return EasyUtil.getQuarterStart(beginTime);
    }

    @Override
    protected LocalDateTime getNextTime(LocalDateTime currentTime) {
        return EasyUtil.getQuarterStart(currentTime).plusMonths(3L);
    }

    @Override
    protected String formatTail(LocalDateTime time) {
        return EasyUtil.getQuarterStart(time).format(DateTimeFormatter.ofPattern("'Q'Q"));
    }

    @Override
    public long calcNextTime() {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime monthStart = EasyUtil.getQuarterStart(now.plusMonths(3L));
        return monthStart.toEpochSecond(ZoneOffset.ofHours(8)) * 1000L;
    }
}

