/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.sharding.api.initializer.time;

import com.easy.query.core.sharding.api.initializer.time.AbstractShardingTimeInitializer;
import com.easy.query.core.util.EasyUtil;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

public abstract class AbstractShardingYearInitializer<T>
extends AbstractShardingTimeInitializer<T> {
    @Override
    protected LocalDateTime getBeginTimeToStart(LocalDateTime beginTime) {
        return EasyUtil.getYearStart(beginTime);
    }

    @Override
    protected LocalDateTime getNextTime(LocalDateTime currentTime) {
        return currentTime.plusYears(1L);
    }

    @Override
    protected String formatTail(LocalDateTime time) {
        return time.format(DateTimeFormatter.ofPattern("yyyy"));
    }

    @Override
    public long calcNextTime() {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime yearStart = EasyUtil.getYearStart(now.plusYears(1L));
        return yearStart.toEpochSecond(ZoneOffset.ofHours(8)) * 1000L;
    }
}

