/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.sharding.api.route.time;

import com.easy.query.core.sharding.api.route.time.AbstractTimeTableRoute;
import com.easy.query.core.util.EasyUtil;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public abstract class AbstractQuarterTableRoute<TEntity>
extends AbstractTimeTableRoute<TEntity> {
    @Override
    protected String formatShardingValue(LocalDateTime time) {
        return EasyUtil.getQuarterStart(time).format(DateTimeFormatter.ofPattern("'Q'Q"));
    }

    @Override
    public boolean lessThanTimeStart(LocalDateTime shardingValue) {
        LocalDateTime quarterFirstDay = EasyUtil.getQuarterStart(shardingValue);
        return shardingValue.isEqual(quarterFirstDay);
    }
}

