/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.sharding.api.route.time;

import com.easy.query.core.enums.sharding.ShardingOperatorEnum;
import com.easy.query.core.expression.lambda.RouteFunction;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.metadata.ActualTable;
import com.easy.query.core.sharding.common.IgnoreCaseStringComparator;
import com.easy.query.core.sharding.route.table.abstraction.AbstractTableRoute;
import java.time.LocalDateTime;
import java.util.Comparator;

public abstract class AbstractTimeTableRoute<TEntity>
extends AbstractTableRoute<TEntity> {
    protected abstract LocalDateTime convertLocalDateTime(Object var1);

    protected Comparator<String> getTailComparator() {
        return IgnoreCaseStringComparator.DEFAULT;
    }

    protected abstract String formatShardingValue(LocalDateTime var1);

    @Override
    protected RouteFunction<ActualTable> getRouteFilter(TableAvailable table, Object shardingValue, ShardingOperatorEnum shardingOperator, boolean withEntity) {
        LocalDateTime shardingTime = this.convertLocalDateTime(shardingValue);
        String tail = this.formatShardingValue(shardingTime);
        String tableName = table.getTableName() + this.tableSeparator() + tail;
        switch (shardingOperator) {
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: {
                return t -> this.getTailComparator().compare(tableName, t.getActualTableName()) <= 0;
            }
            case LESS_THAN: {
                if (this.lessThanTimeStart(shardingTime)) {
                    return t -> this.getTailComparator().compare(tableName, t.getActualTableName()) > 0;
                }
                return t -> this.getTailComparator().compare(tableName, t.getActualTableName()) >= 0;
            }
            case LESS_THAN_OR_EQUAL: {
                return t -> this.getTailComparator().compare(tableName, t.getActualTableName()) >= 0;
            }
            case EQUAL: {
                return t -> this.getTailComparator().compare(tableName, t.getActualTableName()) == 0;
            }
        }
        return t -> true;
    }

    public abstract boolean lessThanTimeStart(LocalDateTime var1);
}

