/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.sharding.initializer;

import com.easy.query.core.enums.ExecuteMethodEnum;
import com.easy.query.core.enums.sharding.ConnectionModeEnum;
import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.sharding.initializer.ShardingEntityBuilder;
import com.easy.query.core.sharding.initializer.ShardingInitOptionBuilder;
import com.easy.query.core.util.EasyBitwiseUtil;

public class ShardingSequenceBuilder<T> {
    private final ShardingEntityBuilder<T> baseBuilder;
    private final ShardingInitOptionBuilder shardingInitOptionBuilder;
    private final EntityMetadata entityMetadata;

    public ShardingSequenceBuilder(ShardingEntityBuilder<T> baseBuilder, ShardingInitOptionBuilder shardingInitOptionBuilder, EntityMetadata entityMetadata) {
        this.baseBuilder = baseBuilder;
        this.shardingInitOptionBuilder = shardingInitOptionBuilder;
        this.entityMetadata = entityMetadata;
    }

    public ShardingSequenceBuilder<T> addPropertyDefaultUseAsc(String propertyName) {
        if (this.entityMetadata.getColumnOrNull(propertyName) == null) {
            throw new EasyQueryInvalidOperationException("sharding initializer add asc unknown property:" + propertyName);
        }
        this.shardingInitOptionBuilder.getSequenceProperties().put(propertyName, true);
        return this;
    }

    public ShardingSequenceBuilder<T> addPropertyDefaultUseDesc(String propertyName) {
        if (this.entityMetadata.getColumnOrNull(propertyName) == null) {
            throw new EasyQueryInvalidOperationException("sharding initializer add desc unknown property:" + propertyName);
        }
        this.shardingInitOptionBuilder.getSequenceProperties().put(propertyName, false);
        return this;
    }

    public ShardingSequenceBuilder<T> defaultAffectedMethod(boolean asc, ExecuteMethodEnum ... executeMethods) {
        int sequenceCompareMethods = ExecuteMethodEnum.UNKNOWN.getCode();
        int sequenceCompareAscMethods = ExecuteMethodEnum.UNKNOWN.getCode();
        for (ExecuteMethodEnum executeMethod : executeMethods) {
            int executeMethodCode = executeMethod.getCode();
            sequenceCompareAscMethods = EasyBitwiseUtil.removeBit(sequenceCompareAscMethods, executeMethodCode);
            sequenceCompareMethods = EasyBitwiseUtil.addBit(sequenceCompareMethods, executeMethodCode);
            if (!asc) continue;
            sequenceCompareAscMethods = EasyBitwiseUtil.addBit(sequenceCompareAscMethods, executeMethodCode);
        }
        this.shardingInitOptionBuilder.setSequenceCompareMethods(sequenceCompareMethods);
        this.shardingInitOptionBuilder.setSequenceCompareAscMethods(sequenceCompareAscMethods);
        return this;
    }

    public ShardingSequenceBuilder<T> useMaxShardingQueryLimit(int maxShardingQueryLimit, ExecuteMethodEnum firstMethod, ExecuteMethodEnum ... executeMethods) {
        this.shardingInitOptionBuilder.setMaxShardingQueryLimit(maxShardingQueryLimit);
        int sequenceLimitMethods = ExecuteMethodEnum.UNKNOWN.getCode();
        int firstMethodCode = firstMethod.getCode();
        sequenceLimitMethods = EasyBitwiseUtil.addBit(sequenceLimitMethods, firstMethodCode);
        for (ExecuteMethodEnum executeMethod : executeMethods) {
            int executeMethodCode = executeMethod.getCode();
            sequenceLimitMethods = EasyBitwiseUtil.addBit(sequenceLimitMethods, executeMethodCode);
        }
        this.shardingInitOptionBuilder.setSequenceLimitMethods(sequenceLimitMethods);
        return this;
    }

    public ShardingSequenceBuilder<T> useConnectionMode(ConnectionModeEnum connectionMode, ExecuteMethodEnum ... executeMethods) {
        this.shardingInitOptionBuilder.setConnectionMode(connectionMode);
        int sequenceConnectionModeMethods = ExecuteMethodEnum.UNKNOWN.getCode();
        for (ExecuteMethodEnum executeMethod : executeMethods) {
            int executeMethodCode = executeMethod.getCode();
            sequenceConnectionModeMethods = EasyBitwiseUtil.addBit(sequenceConnectionModeMethods, executeMethodCode);
        }
        this.shardingInitOptionBuilder.setSequenceConnectionModeMethods(sequenceConnectionModeMethods);
        return this;
    }

    public ShardingEntityBuilder<T> and() {
        return this.baseBuilder;
    }
}

