/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.sharding.manager;

import com.easy.query.core.exception.EasyQueryException;
import com.easy.query.core.exception.EasyQuerySQLCommandException;
import com.easy.query.core.sharding.manager.QueryCountContext;
import com.easy.query.core.sharding.manager.SequenceCountLine;
import com.easy.query.core.sharding.manager.ShardingQueryCountManager;
import java.util.List;

public class DefaultShardingQueryCountManager
implements ShardingQueryCountManager {
    private final ThreadLocal<QueryCountContext> context = ThreadLocal.withInitial(() -> null);

    @Override
    public void begin() {
        if (this.context.get() != null) {
            throw new EasyQuerySQLCommandException("repeat begin sharding query count");
        }
        QueryCountContext queryCountContext = new QueryCountContext();
        this.context.set(queryCountContext);
    }

    @Override
    public boolean isBegin() {
        return this.context.get() != null;
    }

    private QueryCountContext getQueryCountContextNotNull() {
        QueryCountContext queryCountContext = this.context.get();
        if (queryCountContext == null) {
            throw new EasyQueryException("cant get query count context");
        }
        return queryCountContext;
    }

    @Override
    public void addCountResult(long total, boolean init) {
        QueryCountContext queryCountContext = this.getQueryCountContextNotNull();
        queryCountContext.addCountResult(total, init);
    }

    @Override
    public List<Long> getCountResult() {
        QueryCountContext queryCountContext = this.getQueryCountContextNotNull();
        return queryCountContext.getCountResult();
    }

    @Override
    public SequenceCountLine getSequenceCountLine() {
        QueryCountContext queryCountContext = this.getQueryCountContextNotNull();
        return queryCountContext.getSequenceCountLine();
    }

    @Override
    public void clear() {
        this.context.remove();
    }
}

