/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.sharding.rewrite;

import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.enums.ExecuteMethodEnum;
import com.easy.query.core.enums.MergeBehaviorEnum;
import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.expression.executor.parser.PrepareParseResult;
import com.easy.query.core.expression.executor.parser.QueryPrepareParseResult;
import com.easy.query.core.expression.executor.parser.SequenceParseResult;
import com.easy.query.core.expression.func.AggregationType;
import com.easy.query.core.expression.func.ColumnFunctionFactory;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.segment.ColumnSegment;
import com.easy.query.core.expression.segment.FuncColumnSegment;
import com.easy.query.core.expression.segment.GroupByColumnSegment;
import com.easy.query.core.expression.segment.OrderBySegment;
import com.easy.query.core.expression.segment.SQLSegment;
import com.easy.query.core.expression.segment.builder.ProjectSQLBuilderSegment;
import com.easy.query.core.expression.segment.factory.SQLSegmentFactory;
import com.easy.query.core.expression.sql.builder.ExpressionContext;
import com.easy.query.core.expression.sql.expression.EntityQuerySQLExpression;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.metadata.ShardingInitConfig;
import com.easy.query.core.metadata.ShardingSequenceConfig;
import com.easy.query.core.sharding.manager.ShardingQueryCountManager;
import com.easy.query.core.sharding.rewrite.DefaultRewriteRouteUnit;
import com.easy.query.core.sharding.rewrite.GroupAvgBehaviorEnum;
import com.easy.query.core.sharding.rewrite.GroupRewriteStatus;
import com.easy.query.core.sharding.rewrite.ReversePaginationRewriteRouteUnit;
import com.easy.query.core.sharding.rewrite.RewriteContext;
import com.easy.query.core.sharding.rewrite.RewriteContextFactory;
import com.easy.query.core.sharding.rewrite.RewriteRouteUnit;
import com.easy.query.core.sharding.router.RouteContext;
import com.easy.query.core.sharding.router.RouteUnit;
import com.easy.query.core.sharding.router.ShardingRouteResult;
import com.easy.query.core.util.EasyBitwiseUtil;
import com.easy.query.core.util.EasyClassUtil;
import com.easy.query.core.util.EasyCollectionUtil;
import com.easy.query.core.util.EasyMapUtil;
import com.easy.query.core.util.EasySQLSegmentUtil;
import com.easy.query.core.util.EasyShardingUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DefaultRewriteContextFactory
implements RewriteContextFactory {
    private final SQLSegmentFactory sqlSegmentFactory;

    public DefaultRewriteContextFactory(SQLSegmentFactory sqlSegmentFactory) {
        this.sqlSegmentFactory = sqlSegmentFactory;
    }

    @Override
    public RewriteContext rewriteShardingExpression(PrepareParseResult prepareParseResult, RouteContext routeContext) {
        if (prepareParseResult instanceof QueryPrepareParseResult) {
            return this.rewriteShardingQueryExpression((QueryPrepareParseResult)prepareParseResult, routeContext);
        }
        return this.createDefaultRewriteContext(prepareParseResult, routeContext);
    }

    public RewriteContext rewriteShardingQueryExpression(QueryPrepareParseResult queryPrepareParseResult, RouteContext routeContext) {
        int mergeBehavior;
        ProjectSQLBuilderSegment projects;
        ColumnSegment columnSegment;
        SequenceParseResult sequenceParseResult;
        EntityQuerySQLExpression easyEntityPredicateSQLExpression = queryPrepareParseResult.getEntityPredicateSQLExpression();
        QueryRuntimeContext runtimeContext = easyEntityPredicateSQLExpression.getRuntimeContext();
        ExpressionContext expressionContext = easyEntityPredicateSQLExpression.getExpressionMetadata().getExpressionContext();
        if (EasySQLSegmentUtil.isEmpty(easyEntityPredicateSQLExpression.getOrder()) && (ExecuteMethodEnum.LIST == queryPrepareParseResult.getExecutorContext().getExecuteMethod() || ExecuteMethodEnum.FIRST == queryPrepareParseResult.getExecutorContext().getExecuteMethod() || ExecuteMethodEnum.SINGLE == queryPrepareParseResult.getExecutorContext().getExecuteMethod()) && (sequenceParseResult = queryPrepareParseResult.getSequenceParseResult()) != null) {
            Object entityMetadata;
            ShardingInitConfig shardingInitConfig;
            ShardingSequenceConfig shardingSequenceConfig;
            TableAvailable table = sequenceParseResult.getTable();
            if (EasyCollectionUtil.any(easyEntityPredicateSQLExpression.getTables(), t -> Objects.equals(t.getEntityTable(), table)) && (shardingSequenceConfig = (shardingInitConfig = ((EntityMetadata)(entityMetadata = table.getEntityMetadata())).getShardingInitConfig()).getShardingSequenceConfig()) != null) {
                boolean reverse = sequenceParseResult.isReverse();
                String firstSequenceProperty = shardingSequenceConfig.getFirstSequencePropertyOrNull();
                if (firstSequenceProperty != null) {
                    OrderBySegment orderByColumnSegment = this.sqlSegmentFactory.createOrderByColumnSegment(table, firstSequenceProperty, expressionContext, !reverse);
                    easyEntityPredicateSQLExpression.getOrder().append(orderByColumnSegment);
                    if (!easyEntityPredicateSQLExpression.getProjects().containsOnce(((EntityMetadata)entityMetadata).getEntityClass(), firstSequenceProperty)) {
                        columnSegment = this.sqlSegmentFactory.createColumnSegment(table, firstSequenceProperty, expressionContext, null);
                        easyEntityPredicateSQLExpression.getProjects().append(columnSegment);
                    }
                }
            }
        }
        if (EasySQLSegmentUtil.isNotEmpty(easyEntityPredicateSQLExpression.getGroup())) {
            int groupBySize;
            int orderBySize;
            boolean hasAvg = false;
            LinkedHashMap groupRewriteStatusMap = new LinkedHashMap(easyEntityPredicateSQLExpression.getProjects().getSQLSegments().size());
            for (SQLSegment groupSQLSegment : easyEntityPredicateSQLExpression.getGroup().getSQLSegments()) {
                if (!(groupSQLSegment instanceof ColumnSegment)) {
                    throw new UnsupportedOperationException("sharding rewrite group not implement ColumnSegment:" + EasyClassUtil.getInstanceSimpleName(groupSQLSegment));
                }
                ColumnSegment groupColumnSegment = (ColumnSegment)groupSQLSegment;
                boolean addToProjection = true;
                for (SQLSegment sqlSegment : easyEntityPredicateSQLExpression.getProjects().getSQLSegments()) {
                    if (sqlSegment instanceof FuncColumnSegment) {
                        FuncColumnSegment aggregationColumnSegment = (FuncColumnSegment)sqlSegment;
                        if (!hasAvg) {
                            hasAvg = Objects.equals((Object)AggregationType.AVG, (Object)aggregationColumnSegment.getAggregationType());
                        }
                        GroupRewriteStatus groupRewriteStatusKey = new GroupRewriteStatus(aggregationColumnSegment.getTable(), aggregationColumnSegment.getPropertyName());
                        GroupRewriteStatus groupRewriteStatus = EasyMapUtil.computeIfAbsent(groupRewriteStatusMap, groupRewriteStatusKey, k -> groupRewriteStatusKey);
                        GroupAvgBehaviorEnum groupAvgBehavior = GroupAvgBehaviorEnum.getGroupAvgBehavior(aggregationColumnSegment.getAggregationType());
                        if (groupAvgBehavior == null) continue;
                        groupRewriteStatus.removeBehavior(groupAvgBehavior);
                        continue;
                    }
                    if (!(sqlSegment instanceof ColumnSegment)) {
                        throw new UnsupportedOperationException("sharding rewrite projection not implement ColumnSegment:" + EasyClassUtil.getInstanceSimpleName(sqlSegment));
                    }
                    columnSegment = (ColumnSegment)sqlSegment;
                    if (!Objects.equals(groupColumnSegment.getTable(), columnSegment.getTable()) || !Objects.equals(groupColumnSegment.getPropertyName(), columnSegment.getPropertyName()) || !addToProjection) continue;
                    addToProjection = false;
                }
                if (!addToProjection) continue;
                easyEntityPredicateSQLExpression.getProjects().append(groupColumnSegment.cloneSQLColumnSegment());
            }
            List<SQLSegment> groupSQLSegments = easyEntityPredicateSQLExpression.getGroup().getSQLSegments();
            List<SQLSegment> orderSQLSegments = easyEntityPredicateSQLExpression.getOrder().getSQLSegments();
            boolean startsWithGroupByAndOrderBy = EasyShardingUtil.isGroupByAndOrderByStartsWith(groupSQLSegments, orderSQLSegments);
            queryPrepareParseResult.setStartsWithGroupByInOrderBy(startsWithGroupByAndOrderBy);
            if (startsWithGroupByAndOrderBy && (orderBySize = orderSQLSegments.size()) < (groupBySize = groupSQLSegments.size())) {
                for (int i = orderBySize; i < groupBySize; ++i) {
                    GroupByColumnSegment groupByColumnSegment = (GroupByColumnSegment)groupSQLSegments.get(i);
                    if (groupByColumnSegment.getTable() == null || groupByColumnSegment.getPropertyName() == null) {
                        throw new EasyQueryInvalidOperationException("not found group column table or property");
                    }
                    easyEntityPredicateSQLExpression.getOrder().append(groupByColumnSegment.createOrderByColumnSegment(true));
                }
            }
            if (hasAvg) {
                for (Map.Entry groupRewriteStatusKv : groupRewriteStatusMap.entrySet()) {
                    FuncColumnSegment funcColumnSegment;
                    SQLSegmentFactory sqlSegmentFactory;
                    ColumnFunctionFactory columnFunctionFactory;
                    GroupRewriteStatus rewriteStatusKvKey = (GroupRewriteStatus)groupRewriteStatusKv.getKey();
                    if (rewriteStatusKvKey.hasBehavior(GroupAvgBehaviorEnum.AVG)) continue;
                    if (rewriteStatusKvKey.hasBehavior(GroupAvgBehaviorEnum.COUNT)) {
                        columnFunctionFactory = runtimeContext.getColumnFunctionFactory();
                        sqlSegmentFactory = runtimeContext.getSQLSegmentFactory();
                        funcColumnSegment = sqlSegmentFactory.createFuncColumnSegment(rewriteStatusKvKey.getTable(), rewriteStatusKvKey.getPropertyName(), expressionContext, columnFunctionFactory.createCountFunction(false), rewriteStatusKvKey.getPropertyName() + "RewriteCount");
                        easyEntityPredicateSQLExpression.getProjects().append(funcColumnSegment);
                    }
                    if (!rewriteStatusKvKey.hasBehavior(GroupAvgBehaviorEnum.SUM)) continue;
                    columnFunctionFactory = runtimeContext.getColumnFunctionFactory();
                    sqlSegmentFactory = runtimeContext.getSQLSegmentFactory();
                    funcColumnSegment = sqlSegmentFactory.createFuncColumnSegment(rewriteStatusKvKey.getTable(), rewriteStatusKvKey.getPropertyName(), expressionContext, columnFunctionFactory.createSumFunction(false), rewriteStatusKvKey.getPropertyName() + "RewriteSum");
                    easyEntityPredicateSQLExpression.getProjects().append(funcColumnSegment);
                }
            }
        } else if (easyEntityPredicateSQLExpression.isDistinct() && !(projects = (ProjectSQLBuilderSegment)easyEntityPredicateSQLExpression.getProjects()).hasAggregateColumns()) {
            for (SQLSegment sqlSegment : easyEntityPredicateSQLExpression.getProjects().getSQLSegments()) {
                if (!(sqlSegment instanceof ColumnSegment)) continue;
                easyEntityPredicateSQLExpression.getGroup().append(sqlSegment);
            }
        }
        if (EasyBitwiseUtil.hasBit(mergeBehavior = EasyShardingUtil.parseMergeBehavior(queryPrepareParseResult, easyEntityPredicateSQLExpression, routeContext), MergeBehaviorEnum.PAGINATION.getCode())) {
            return this.createPaginationRewriteContext(mergeBehavior, queryPrepareParseResult, easyEntityPredicateSQLExpression, routeContext);
        }
        if (EasyBitwiseUtil.hasBit(mergeBehavior, MergeBehaviorEnum.SEQUENCE_COUNT.getCode())) {
            ShardingQueryCountManager shardingQueryCountManager = runtimeContext.getShardingQueryCountManager();
            List<Long> countResult = shardingQueryCountManager.getCountResult();
            List<RewriteRouteUnit> sequenceCountRewriteRouteUnits = EasyShardingUtil.getSequenceCountRewriteRouteUnits(queryPrepareParseResult, routeContext, countResult);
            ShardingRouteResult shardingRouteResult = routeContext.getShardingRouteResult();
            return new RewriteContext(mergeBehavior, queryPrepareParseResult, sequenceCountRewriteRouteUnits, shardingRouteResult.isCrossDataSource(), shardingRouteResult.isCrossTable(), shardingRouteResult.isSequenceQuery(), false);
        }
        return this.createDefaultRewriteContext(mergeBehavior, queryPrepareParseResult, routeContext);
    }

    private RewriteContext createDefaultRewriteContext(int mergeBehavior, PrepareParseResult prepareParseResult, RouteContext routeContext) {
        ShardingRouteResult shardingRouteResult = routeContext.getShardingRouteResult();
        List<RewriteRouteUnit> rewriteRouteUnits = this.createDefaultRewriteRouteUnit(routeContext);
        return new RewriteContext(mergeBehavior, prepareParseResult, rewriteRouteUnits, shardingRouteResult.isCrossDataSource(), shardingRouteResult.isCrossTable(), shardingRouteResult.isSequenceQuery(), false);
    }

    private RewriteContext createDefaultRewriteContext(PrepareParseResult prepareParseResult, RouteContext routeContext) {
        return this.createDefaultRewriteContext(MergeBehaviorEnum.DEFAULT.getCode(), prepareParseResult, routeContext);
    }

    private List<RewriteRouteUnit> createDefaultRewriteRouteUnit(RouteContext routeContext) {
        ShardingRouteResult shardingRouteResult = routeContext.getShardingRouteResult();
        List<RouteUnit> routeUnits = shardingRouteResult.getRouteUnits();
        ArrayList<RewriteRouteUnit> rewriteRouteUnits = new ArrayList<RewriteRouteUnit>(routeUnits.size());
        for (RouteUnit routeUnit : routeUnits) {
            rewriteRouteUnits.add(new DefaultRewriteRouteUnit(routeUnit));
        }
        return rewriteRouteUnits;
    }

    private RewriteContext createPaginationRewriteContext(int mergeBehavior, QueryPrepareParseResult queryPrepareParseResult, EntityQuerySQLExpression easyQuerySQLExpression, RouteContext routeContext) {
        List<RewriteRouteUnit> rewriteRouteUnits = this.getPaginationRewriteRouteUnitsAndRewriteQuerySQLExpression(mergeBehavior, queryPrepareParseResult, easyQuerySQLExpression, routeContext);
        ShardingRouteResult shardingRouteResult = routeContext.getShardingRouteResult();
        boolean reverseMerge = !EasyBitwiseUtil.hasBit(mergeBehavior, MergeBehaviorEnum.SEQUENCE_PAGINATION.getCode()) && EasyBitwiseUtil.hasBit(mergeBehavior, MergeBehaviorEnum.REVERSE_PAGINATION.getCode());
        return new RewriteContext(mergeBehavior, queryPrepareParseResult, rewriteRouteUnits, shardingRouteResult.isCrossDataSource(), shardingRouteResult.isCrossTable(), shardingRouteResult.isSequenceQuery(), reverseMerge);
    }

    private List<RewriteRouteUnit> getPaginationRewriteRouteUnitsAndRewriteQuerySQLExpression(int mergeBehavior, QueryPrepareParseResult queryPrepareParseResult, EntityQuerySQLExpression easyQuerySQLExpression, RouteContext routeContext) {
        QueryRuntimeContext runtimeContext = queryPrepareParseResult.getExecutorContext().getRuntimeContext();
        if (EasyBitwiseUtil.hasBit(mergeBehavior, MergeBehaviorEnum.SEQUENCE_PAGINATION.getCode())) {
            ShardingQueryCountManager shardingQueryCountManager = runtimeContext.getShardingQueryCountManager();
            List<Long> countResult = shardingQueryCountManager.getCountResult();
            List<RewriteRouteUnit> rewriteRouteUnits = EasyShardingUtil.getSequencePaginationRewriteRouteUnits(queryPrepareParseResult, routeContext, countResult);
            this.rewritePagination(easyQuerySQLExpression);
            return rewriteRouteUnits;
        }
        if (EasyBitwiseUtil.hasBit(mergeBehavior, MergeBehaviorEnum.REVERSE_PAGINATION.getCode())) {
            ShardingQueryCountManager shardingQueryCountManager = runtimeContext.getShardingQueryCountManager();
            List<Long> countResult = shardingQueryCountManager.getCountResult();
            long total = EasyCollectionUtil.sumLong(countResult, o -> o);
            long originalOffset = queryPrepareParseResult.getOriginalOffset();
            long originalRows = queryPrepareParseResult.getOriginalRows();
            long realOffset = total - originalOffset - originalRows;
            long realRows = realOffset + originalRows;
            ShardingRouteResult shardingRouteResult = routeContext.getShardingRouteResult();
            List<RouteUnit> routeUnits = shardingRouteResult.getRouteUnits();
            ArrayList<RewriteRouteUnit> rewriteRouteUnits = new ArrayList<RewriteRouteUnit>(routeUnits.size());
            for (RouteUnit routeUnit : routeUnits) {
                rewriteRouteUnits.add(new ReversePaginationRewriteRouteUnit(0L, realRows, routeUnit));
            }
            this.rewriteReversePagination(easyQuerySQLExpression, realOffset);
            return rewriteRouteUnits;
        }
        this.rewritePagination(easyQuerySQLExpression);
        return this.createDefaultRewriteRouteUnit(routeContext);
    }

    private void rewritePagination(EntityQuerySQLExpression easyQuerySQLExpression) {
        if (easyQuerySQLExpression.hasLimit()) {
            long rows = easyQuerySQLExpression.getRows();
            long offset = easyQuerySQLExpression.getOffset();
            if (offset > 0L) {
                easyQuerySQLExpression.setOffset(0L);
            }
            easyQuerySQLExpression.setRows(offset + rows);
        }
    }

    private void rewriteReversePagination(EntityQuerySQLExpression easyQuerySQLExpression, long realOffset) {
        if (easyQuerySQLExpression.hasLimit()) {
            long rows = easyQuerySQLExpression.getRows();
            long offset = easyQuerySQLExpression.getOffset();
            if (offset > 0L) {
                easyQuerySQLExpression.setOffset(0L);
            }
            easyQuerySQLExpression.setRows(realOffset + rows);
        }
    }
}

