/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.sharding.router;

import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.expression.executor.parser.EntityPrepareParseResult;
import com.easy.query.core.expression.executor.parser.PredicatePrepareParseResult;
import com.easy.query.core.expression.executor.parser.PrepareParseResult;
import com.easy.query.core.expression.executor.parser.QueryPrepareParseResult;
import com.easy.query.core.expression.executor.parser.SequenceParseResult;
import com.easy.query.core.expression.executor.parser.descriptor.TableEntityParseDescriptor;
import com.easy.query.core.expression.executor.parser.descriptor.TableParseDescriptor;
import com.easy.query.core.expression.executor.parser.descriptor.impl.TableEntityParseDescriptorImpl;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.sharding.router.RouteContext;
import com.easy.query.core.sharding.router.RouteContextFactory;
import com.easy.query.core.sharding.router.RouteUnit;
import com.easy.query.core.sharding.router.ShardingRouteResult;
import com.easy.query.core.sharding.router.datasource.engine.DataSourceRouteEngine;
import com.easy.query.core.sharding.router.datasource.engine.DataSourceRouteResult;
import com.easy.query.core.sharding.router.table.EasyEntityTableRouteUnit;
import com.easy.query.core.sharding.router.table.TableRouteUnit;
import com.easy.query.core.sharding.router.table.engine.TableRouteContext;
import com.easy.query.core.sharding.router.table.engine.TableRouteEngine;
import com.easy.query.core.util.EasyClassUtil;
import com.easy.query.core.util.EasyCollectionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class DefaultRouteContextFactory
implements RouteContextFactory {
    private final DataSourceRouteEngine dataSourceRouteEngine;
    private final TableRouteEngine tableRouteEngine;

    public DefaultRouteContextFactory(DataSourceRouteEngine dataSourceRouteEngine, TableRouteEngine tableRouteEngine) {
        this.dataSourceRouteEngine = dataSourceRouteEngine;
        this.tableRouteEngine = tableRouteEngine;
    }

    @Override
    public RouteContext createRouteContext(PrepareParseResult prepareParseResult) {
        if (prepareParseResult instanceof PredicatePrepareParseResult) {
            PredicatePrepareParseResult predicatePrepareParseResult = (PredicatePrepareParseResult)prepareParseResult;
            SequenceParseResult sequenceParseResult = predicatePrepareParseResult instanceof QueryPrepareParseResult ? ((QueryPrepareParseResult)predicatePrepareParseResult).getSequenceParseResult() : null;
            return this.createRouteContextByPredicate(predicatePrepareParseResult.getTableParseDescriptor(), sequenceParseResult);
        }
        if (prepareParseResult instanceof EntityPrepareParseResult) {
            EntityPrepareParseResult entityPrepareParseResult = (EntityPrepareParseResult)prepareParseResult;
            return this.createRouteContextByEntity(entityPrepareParseResult.getTableParseDescriptor());
        }
        throw new UnsupportedOperationException(EasyClassUtil.getInstanceSimpleName(prepareParseResult));
    }

    private RouteContext createRouteContextByPredicate(TableParseDescriptor tableParseDescriptor, SequenceParseResult sequenceParseResult) {
        return this.doCreateRouteContext(tableParseDescriptor, sequenceParseResult);
    }

    private RouteContext createRouteContextByEntity(TableEntityParseDescriptor tableEntityParseDescriptor) {
        TableAvailable table = EasyCollectionUtil.first(tableEntityParseDescriptor.getTables());
        List<Object> entities = tableEntityParseDescriptor.getEntitiesNotNull(table);
        ArrayList<RouteUnit> entityRouteUnits = new ArrayList<RouteUnit>(entities.size());
        String dataSource = null;
        String tableName = null;
        boolean isCrossDataSource = false;
        boolean isCrossTable = false;
        for (Object entity : entities) {
            TableEntityParseDescriptorImpl entityParseDescriptor = new TableEntityParseDescriptorImpl(table, Collections.singletonList(entity));
            RouteContext routeContext = this.doCreateRouteContext(entityParseDescriptor, null);
            List<RouteUnit> routeUnits = routeContext.getShardingRouteResult().getRouteUnits();
            if (EasyCollectionUtil.isNotSingle(routeUnits)) {
                throw new EasyQueryInvalidOperationException("entity route route unit more or empty:" + routeUnits.size() + "\uff0c" + entity);
            }
            RouteUnit routeUnit = routeUnits.get(0);
            List<TableRouteUnit> tableRouteUnits = routeUnit.getTableRouteUnits();
            if (EasyCollectionUtil.isNotSingle(tableRouteUnits)) {
                throw new EasyQueryInvalidOperationException("entity route table route unit more or empty:" + tableRouteUnits.size() + "\uff0c" + entity);
            }
            TableRouteUnit tableRouteUnit = tableRouteUnits.get(0);
            if (EasyCollectionUtil.isEmpty(entityRouteUnits)) {
                dataSource = routeUnit.getDataSource();
                tableName = routeUnit.getTableRouteUnits().get(0).getActualTableName();
            }
            String currentDataSource = routeUnit.getDataSource();
            String currentTableName = tableRouteUnit.getActualTableName();
            if (!isCrossDataSource) {
                boolean bl = isCrossDataSource = !Objects.equals(dataSource, currentDataSource);
            }
            if (!isCrossTable) {
                isCrossTable = !Objects.equals(tableName, currentTableName);
            }
            EasyEntityTableRouteUnit easyEntityTableRouteUnit = new EasyEntityTableRouteUnit(tableRouteUnit, entity);
            RouteUnit entityRouteUint = new RouteUnit(currentDataSource, Collections.singletonList(easyEntityTableRouteUnit));
            entityRouteUnits.add(entityRouteUint);
        }
        ShardingRouteResult shardingRouteResult = new ShardingRouteResult(entityRouteUnits, isCrossDataSource, isCrossTable, false);
        return new RouteContext(shardingRouteResult);
    }

    private RouteContext doCreateRouteContext(TableParseDescriptor tableParseDescriptor, SequenceParseResult sequenceParseResult) {
        DataSourceRouteResult dataSourceRouteResult = this.dataSourceRouteEngine.route(tableParseDescriptor);
        ShardingRouteResult shardingRouteResult = this.tableRouteEngine.route(new TableRouteContext(dataSourceRouteResult, tableParseDescriptor, sequenceParseResult));
        return new RouteContext(shardingRouteResult);
    }
}

