/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.sharding.router.datasource.engine;

import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.expression.executor.parser.descriptor.TableParseDescriptor;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.sharding.EasyQueryDataSource;
import com.easy.query.core.sharding.router.datasource.engine.DataSourceRouteEngine;
import com.easy.query.core.sharding.router.datasource.engine.DataSourceRouteResult;
import com.easy.query.core.sharding.router.descriptor.RouteDescriptor;
import com.easy.query.core.sharding.router.descriptor.RouteDescriptorFactory;
import com.easy.query.core.sharding.router.manager.DataSourceRouteManager;
import com.easy.query.core.util.EasyCollectionUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class DefaultDataSourceRouteEngine
implements DataSourceRouteEngine {
    private final EasyQueryDataSource easyDataSource;
    private final DataSourceRouteManager dataSourceRouteManager;
    private final RouteDescriptorFactory routeDescriptorFactory;

    public DefaultDataSourceRouteEngine(EasyQueryDataSource easyDataSource, DataSourceRouteManager dataSourceRouteManager, RouteDescriptorFactory routeDescriptorFactory) {
        this.easyDataSource = easyDataSource;
        this.dataSourceRouteManager = dataSourceRouteManager;
        this.routeDescriptorFactory = routeDescriptorFactory;
    }

    @Override
    public DataSourceRouteResult route(TableParseDescriptor tableParseDescriptor) {
        HashMap dataSourceMaps = new HashMap();
        Set<TableAvailable> tables = tableParseDescriptor.getTables();
        for (TableAvailable shardingTable : tables) {
            EntityMetadata entityMetadata = shardingTable.getEntityMetadata();
            if (!entityMetadata.isMultiDataSourceMapping()) {
                HashSet<String> defDataSource = new HashSet<String>();
                defDataSource.add(this.easyDataSource.getDefaultDataSourceName());
                dataSourceMaps.put(shardingTable, defDataSource);
            }
            RouteDescriptor routeDescriptor = this.routeDescriptorFactory.createRouteDescriptor(shardingTable, tableParseDescriptor);
            Collection<String> dataSources = this.dataSourceRouteManager.routeTo(routeDescriptor);
            Set entityDataSources = (Set)dataSourceMaps.get(shardingTable);
            if (entityDataSources == null) {
                dataSourceMaps.put(shardingTable, new HashSet<String>(dataSources));
                continue;
            }
            entityDataSources.addAll(dataSources);
        }
        if (dataSourceMaps.isEmpty()) {
            throw new EasyQueryInvalidOperationException("data source route mot match:");
        }
        if (dataSourceMaps.size() == 1) {
            Set firstDataSources = (Set)dataSourceMaps.values().iterator().next();
            return new DataSourceRouteResult(firstDataSources);
        }
        Set<String> intersectDataSources = EasyCollectionUtil.getIntersection(dataSourceMaps.values());
        return new DataSourceRouteResult(intersectDataSources);
    }
}

