/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.sharding.router.table;

import com.easy.query.core.expression.lambda.RouteFunction;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.metadata.ActualTable;
import com.easy.query.core.sharding.route.table.TableRoute;
import com.easy.query.core.sharding.router.RoutePredicateExpression;
import com.easy.query.core.sharding.router.datasource.engine.DataSourceRouteResult;
import com.easy.query.core.sharding.router.descriptor.RouteDescriptor;
import com.easy.query.core.sharding.router.table.BaseTableRouteUnit;
import com.easy.query.core.sharding.router.table.TableRouteUnit;
import com.easy.query.core.sharding.router.table.abstraction.AbstractTableRouter;
import com.easy.query.core.util.EasyShardingUtil;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ShardingTableRouter
extends AbstractTableRouter {
    @Override
    public <T> Collection<TableRouteUnit> route0(TableRoute<T> tableRoute, DataSourceRouteResult dataSourceRouteResult, Collection<ActualTable> beforeTableNames, RouteDescriptor routeDescriptor) {
        RoutePredicateExpression<ActualTable> routePredicateExpression = EasyShardingUtil.getRoutePredicateExpression(routeDescriptor, tableRoute, true);
        RouteFunction<ActualTable> routePredicate = routePredicateExpression.getRoutePredicate();
        TableAvailable table = routeDescriptor.getTable();
        return this.filterTableNameWithDataSourceResult(dataSourceRouteResult, beforeTableNames).filter(routePredicate::apply).map(o -> this.parseRouteWithTableName(table, (ActualTable)o)).collect(Collectors.toList());
    }

    protected Stream<ActualTable> filterTableNameWithDataSourceResult(DataSourceRouteResult dataSourceRouteResult, Collection<ActualTable> beforeActualTables) {
        return beforeActualTables.stream().filter(actualTable -> dataSourceRouteResult.getIntersectDataSources().contains(actualTable.getDataSourceName()));
    }

    protected TableRouteUnit parseRouteWithTableName(TableAvailable table, ActualTable actualTable) {
        return new BaseTableRouteUnit(actualTable.getDataSourceName(), actualTable.getActualTableName(), table);
    }
}

