/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.sharding.router.table.engine;

import com.easy.query.core.expression.executor.parser.SequenceParseResult;
import com.easy.query.core.expression.executor.parser.descriptor.TableParseDescriptor;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.sharding.router.RouteUnit;
import com.easy.query.core.sharding.router.ShardingRouteResult;
import com.easy.query.core.sharding.router.datasource.engine.DataSourceRouteResult;
import com.easy.query.core.sharding.router.descriptor.RouteDescriptor;
import com.easy.query.core.sharding.router.descriptor.RouteDescriptorFactory;
import com.easy.query.core.sharding.router.manager.TableRouteManager;
import com.easy.query.core.sharding.router.table.BaseTableRouteUnit;
import com.easy.query.core.sharding.router.table.TableRouteUnit;
import com.easy.query.core.sharding.router.table.TableUnit;
import com.easy.query.core.sharding.router.table.engine.TableRouteContext;
import com.easy.query.core.sharding.router.table.engine.TableRouteEngine;
import com.easy.query.core.sharding.router.table.engine.TableRouteResult;
import com.easy.query.core.util.EasyCollectionUtil;
import com.easy.query.core.util.EasyMapUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class DefaultTableRouteEngine
implements TableRouteEngine {
    private final TableRouteManager tableRouteManager;
    private final RouteDescriptorFactory routeDescriptorFactory;

    public DefaultTableRouteEngine(TableRouteManager tableRouteManager, RouteDescriptorFactory routeDescriptorFactory) {
        this.tableRouteManager = tableRouteManager;
        this.routeDescriptorFactory = routeDescriptorFactory;
    }

    @Override
    public ShardingRouteResult route(TableRouteContext tableRouteContext) {
        HashMap routeMaps = new HashMap();
        TableParseDescriptor tableParseDescriptor = tableRouteContext.getTableParseDescriptor();
        Set<TableAvailable> shardingTables = tableParseDescriptor.getTables();
        int tableRouteUnitSize = 0;
        boolean onlyShardingDataSource = true;
        for (TableAvailable shardingTable : shardingTables) {
            EntityMetadata entityMetadata = shardingTable.getEntityMetadata();
            if (!entityMetadata.isMultiTableMapping()) continue;
            onlyShardingDataSource = false;
            RouteDescriptor routeDescriptor = this.routeDescriptorFactory.createRouteDescriptor(shardingTable, tableParseDescriptor);
            Collection<TableRouteUnit> shardingRouteUnits = this.getEntityRouteUnit(tableRouteContext.getDataSourceRouteResult(), routeDescriptor);
            for (TableRouteUnit shardingRouteUnit : shardingRouteUnits) {
                String dataSource = shardingRouteUnit.getDataSourceName();
                Map tableNamMaps = EasyMapUtil.computeIfAbsent(routeMaps, dataSource, o -> new HashMap());
                Set tableRouteUnits = EasyMapUtil.computeIfAbsent(tableNamMaps, shardingTable, o -> new HashSet());
                tableRouteUnits.add(shardingRouteUnit);
                ++tableRouteUnitSize;
            }
        }
        ArrayList<RouteUnit> routeUnits = new ArrayList<RouteUnit>(tableRouteUnitSize);
        int dataSourceCount = 0;
        boolean isCrossTable = false;
        for (String dataSourceName : tableRouteContext.getDataSourceRouteResult().getIntersectDataSources()) {
            Map routeMap = (Map)routeMaps.get(dataSourceName);
            if (routeMap != null) {
                Collection cartesian = EasyCollectionUtil.getCartesian(routeMap.values());
                List tableRouteResults = cartesian.stream().map(o -> new TableRouteResult(new ArrayList<TableRouteUnit>((Collection<TableRouteUnit>)o))).filter(o -> !o.isEmpty()).collect(Collectors.toList());
                if (!EasyCollectionUtil.isNotEmpty(tableRouteResults)) continue;
                ++dataSourceCount;
                if (tableRouteResults.size() > 1) {
                    isCrossTable = true;
                }
                for (TableRouteResult tableRouteResult : tableRouteResults) {
                    if (tableRouteResult.getReplaceTables().size() > 1) {
                        isCrossTable = true;
                    }
                    routeUnits.add(new RouteUnit(dataSourceName, tableRouteResult.getReplaceTables()));
                }
                continue;
            }
            if (!onlyShardingDataSource) continue;
            ArrayList<TableRouteUnit> tableRouteUnits = new ArrayList<TableRouteUnit>(shardingTables.size());
            for (TableAvailable shardingTable : shardingTables) {
                BaseTableRouteUnit baseTableRouteUnit = new BaseTableRouteUnit(dataSourceName, shardingTable.getTableName(), shardingTable);
                tableRouteUnits.add(baseTableRouteUnit);
            }
            RouteUnit routeUnit = new RouteUnit(dataSourceName, tableRouteUnits);
            routeUnits.add(routeUnit);
        }
        boolean sequenceQuery = false;
        SequenceParseResult sequenceOrderPrepareParseResult = tableRouteContext.getSequenceParseResult();
        if (sequenceOrderPrepareParseResult != null) {
            RouteUnit first;
            int i;
            TableAvailable table = sequenceOrderPrepareParseResult.getTable();
            if (EasyCollectionUtil.isNotEmpty(routeUnits) && (i = this.getCompareRouteUnitIndex(first = (RouteUnit)EasyCollectionUtil.first(routeUnits), table)) >= 0) {
                Comparator<TableUnit> tableComparator = sequenceOrderPrepareParseResult.getTableComparator();
                int compareFactor = sequenceOrderPrepareParseResult.isReverse() ? -1 : 1;
                routeUnits.sort((c1, c2) -> {
                    TableRouteUnit tableRouteUnit1 = c1.getTableRouteUnits().get(i);
                    TableRouteUnit tableRouteUnit2 = c2.getTableRouteUnits().get(i);
                    return compareFactor * tableComparator.compare(tableRouteUnit1, tableRouteUnit2);
                });
                sequenceQuery = true;
            }
        }
        return new ShardingRouteResult(routeUnits, dataSourceCount > 1, isCrossTable, sequenceQuery);
    }

    private int getCompareRouteUnitIndex(RouteUnit routeUnit, TableAvailable table) {
        int i = -1;
        for (TableRouteUnit tableRouteUnit : routeUnit.getTableRouteUnits()) {
            ++i;
            if (!Objects.equals(tableRouteUnit.getTable(), table)) continue;
            return i;
        }
        return -1;
    }

    private Collection<TableRouteUnit> getEntityRouteUnit(DataSourceRouteResult dataSourceRouteResult, RouteDescriptor routeDescriptor) {
        return this.tableRouteManager.routeTo(dataSourceRouteResult, routeDescriptor);
    }
}

