/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.util;

import java.util.Arrays;
import java.util.function.Predicate;

public class EasyArrayUtil {
    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    public static <T> boolean isNotEmpty(T[] array) {
        return !EasyArrayUtil.isEmpty(array);
    }

    public static <T> T[] concat(T[] first, T[] second) {
        if (first == null && second == null) {
            throw new IllegalArgumentException("not allow first and second are null.");
        }
        if (EasyArrayUtil.isEmpty(first) && second != null) {
            return second;
        }
        if (EasyArrayUtil.isEmpty(second)) {
            return first;
        }
        T[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static <TSource> boolean any(TSource[] sources, Predicate<TSource> predicate) {
        if (EasyArrayUtil.isEmpty(sources)) {
            return false;
        }
        for (TSource source : sources) {
            if (!predicate.test(source)) continue;
            return true;
        }
        return false;
    }
}

