/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.util;

import com.easy.query.core.common.bean.DefaultFastBean;
import com.easy.query.core.common.bean.FastBean;
import com.easy.query.core.expression.lambda.Property;
import com.easy.query.core.expression.lambda.PropertySetterCaller;
import com.easy.query.core.metadata.ColumnMetadata;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.metadata.EntityMetadataManager;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

public class EasyBeanUtil {
    public static Function<Class<?>, FastBean> FAST_BEAN_FUNCTION = DefaultFastBean::new;

    public static Set<String> getBeanMatchProperties(EntityMetadataManager entityMetadataManager, Object entity, Predicate<Object> propertyPredicate) {
        Class<?> entityClass = entity.getClass();
        EntityMetadata entityMetadata = entityMetadataManager.getEntityMetadata(entityClass);
        Collection<String> properties = entityMetadata.getProperties();
        LinkedHashSet<String> matchProperties = new LinkedHashSet<String>(properties.size());
        for (String propertyName : properties) {
            Object value = EasyBeanUtil.getPropertyValue(entity, entityMetadata, propertyName);
            if (!propertyPredicate.test(value)) continue;
            matchProperties.add(propertyName);
        }
        return matchProperties;
    }

    public static Object getPropertyValue(Object entity, EntityMetadata entityMetadata, String propertyName) {
        ColumnMetadata columnMetadata = entityMetadata.getColumnNotNull(propertyName);
        return EasyBeanUtil.getPropertyValue(entity, entityMetadata, columnMetadata);
    }

    public static Object getPropertyValue(Object entity, EntityMetadata entityMetadata, ColumnMetadata columnMetadata) {
        String propertyName = columnMetadata.getPropertyName();
        if (entityMetadata.isHasValueObject() && propertyName.contains(".")) {
            Object valueObject = EasyBeanUtil.getParentPropertyValue(entity, entityMetadata, columnMetadata.getPropertyName(), false);
            if (valueObject == null) {
                return null;
            }
            return EasyBeanUtil.getCurrentPropertyValue(valueObject, columnMetadata);
        }
        return EasyBeanUtil.getCurrentPropertyValue(entity, columnMetadata);
    }

    public static Object getCurrentPropertyValue(Object entity, ColumnMetadata columnMetadata) {
        Property<Object, ?> propertyGetter = columnMetadata.getGetterCaller();
        return propertyGetter.apply(entity);
    }

    private static Object getParentPropertyValue(Object entity, EntityMetadata entityMetadata, String propertyName, boolean withParents) {
        Object parent = entity;
        if (entityMetadata.isHasValueObject() && propertyName.contains(".")) {
            Object parentValue;
            int fromIndex = 0;
            do {
                String parentPropertyName;
                ColumnMetadata parentColumnMetadata;
                if ((parentValue = EasyBeanUtil.getCurrentPropertyValue(parent, parentColumnMetadata = entityMetadata.getColumnNotNull(parentPropertyName = propertyName.substring(0, fromIndex = propertyName.indexOf(".", fromIndex))))) != null || !withParents) continue;
                parentValue = parentColumnMetadata.getBeanConstructorCreatorOrNull().get();
                EasyBeanUtil.setCurrentPropertyValue(parent, parentColumnMetadata, parentValue);
            } while ((parent = parentValue) != null && propertyName.indexOf(".", ++fromIndex) > -1);
        }
        return parent;
    }

    public static void setPropertyValue(Object entity, EntityMetadata entityMetadata, ColumnMetadata columnMetadata, Object value, boolean withParents) {
        Object parent = entity;
        if (entityMetadata.isHasValueObject() && columnMetadata.getPropertyName().contains(".")) {
            parent = EasyBeanUtil.getParentPropertyValue(entity, entityMetadata, columnMetadata.getPropertyName(), withParents);
        }
        EasyBeanUtil.setCurrentPropertyValue(parent, columnMetadata, value);
    }

    public static void setCurrentPropertyValue(Object entity, ColumnMetadata columnMetadata, Object value) {
        PropertySetterCaller<Object> setterCaller = columnMetadata.getSetterCaller();
        setterCaller.call(entity, value);
    }

    public static FastBean getFastBean(Class<?> entityClass) {
        return FAST_BEAN_FUNCTION.apply(entityClass);
    }
}

