/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.util;

import com.easy.query.core.common.LinkedCaseInsensitiveMap;
import com.easy.query.core.common.bean.FastBeanProperty;
import com.easy.query.core.exception.EasyQueryException;
import com.easy.query.core.logging.Log;
import com.easy.query.core.logging.LogFactory;
import com.easy.query.core.util.EasyNumberUtil;
import com.easy.query.core.util.EasyStringUtil;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class EasyClassUtil {
    private static final Log log = LogFactory.getLog(EasyClassUtil.class);

    private EasyClassUtil() {
    }

    public static Class<?> getClassForName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getInstanceSimpleName(Object obj) {
        if (obj == null) {
            return "";
        }
        return EasyClassUtil.getSimpleName(obj.getClass());
    }

    public static String getSimpleName(Class<?> clazz) {
        if (clazz == null) {
            return "";
        }
        return clazz.getSimpleName();
    }

    public static String getFullName(Class<?> clazz) {
        if (clazz == null) {
            return "";
        }
        return clazz.getName();
    }

    private static PropertyDescriptor find(PropertyDescriptor[] pd, String name) {
        for (PropertyDescriptor p : pd) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    public static Method getWriteMethodNotNull(FastBeanProperty prop, Class<?> type) {
        Method writeMethod = EasyClassUtil.getWriteMethodOrNull(prop, type);
        if (writeMethod == null) {
            throw new EasyQueryException(EasyClassUtil.getSimpleName(type) + "." + prop.getName() + " cant get write method.");
        }
        return writeMethod;
    }

    public static Method getWriteMethodOrNull(FastBeanProperty prop, Class<?> type) {
        Method writeMethod = prop.getWriteMethod();
        if (writeMethod == null && !"class".equals(prop.getName())) {
            String propName = prop.getName();
            String setMethodName = "set" + (propName.length() > 1 && propName.charAt(1) >= 'A' && propName.charAt(1) <= 'Z' ? propName : EasyStringUtil.toUpperCaseFirstOne(propName));
            try {
                writeMethod = type.getMethod(setMethodName, prop.getPropertyType());
            }
            catch (Exception e) {
                log.error("get write method error:" + prop.getName(), e);
                return null;
            }
        }
        return writeMethod;
    }

    public static boolean isNumberType(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        return Number.class.isAssignableFrom(clazz);
    }

    public static boolean isBasicType(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        if (clazz.getName().startsWith("java.")) {
            return clazz == String.class || clazz == Integer.class || clazz == Byte.class || clazz == Long.class || clazz == Double.class || clazz == Float.class || clazz == Character.class || clazz == Short.class || clazz == BigDecimal.class || clazz == BigInteger.class || clazz == Boolean.class || clazz == java.util.Date.class || clazz == Date.class || clazz == Timestamp.class || clazz == LocalDateTime.class || clazz == LocalDate.class || clazz == LocalTime.class || clazz == UUID.class;
        }
        return false;
    }

    public static boolean isBasicTypeOrEnum(Class<?> clazz) {
        return EasyClassUtil.isBasicType(clazz) || EasyClassUtil.isEnumType(clazz);
    }

    public static Class<?> getObjectTypeWhenPrimitive(Class<?> propertyType) {
        if (propertyType.isPrimitive()) {
            if (propertyType == Boolean.TYPE) {
                return Boolean.class;
            }
            if (propertyType == Byte.TYPE) {
                return Byte.class;
            }
            if (propertyType == Short.TYPE) {
                return Short.class;
            }
            if (propertyType == Integer.TYPE) {
                return Integer.class;
            }
            if (propertyType == Long.TYPE) {
                return Long.class;
            }
            if (propertyType == Float.TYPE) {
                return Float.class;
            }
            if (propertyType == Double.TYPE) {
                return Double.class;
            }
            if (propertyType == Character.TYPE) {
                return Character.class;
            }
        }
        return propertyType;
    }

    public static boolean isEnumType(Class<?> clazz) {
        return clazz.isEnum();
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new EasyQueryException(e);
        }
        catch (IllegalAccessException e) {
            throw new EasyQueryException(e);
        }
    }

    public static Object getStaticFieldValue(Field field) {
        try {
            field.setAccessible(true);
            Object object = field.get(null);
            return object;
        }
        catch (IllegalAccessException e) {
            throw new EasyQueryException("cant get static field value.", e);
        }
        finally {
            field.setAccessible(false);
        }
    }

    public static Map newMapInstanceOrNull(Class<?> clazz) {
        if (Map.class.equals(clazz)) {
            return new LinkedCaseInsensitiveMap();
        }
        try {
            return (Map)clazz.newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static PropertyDescriptor[] propertyDescriptors(Class<?> c) {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(c, Object.class);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        return beanInfo.getPropertyDescriptors();
    }

    public static PropertyDescriptor[] propertyDescriptorsRuntime(Class<?> c) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(c, Object.class);
            return beanInfo.getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
    }

    public static Collection<Field> getAllFields(Class<?> clazz) {
        LinkedHashMap<String, Field> fields = EasyClassUtil.getAllFields0(clazz);
        return fields.values();
    }

    private static LinkedHashMap<String, Field> getAllFields0(Class<?> clazz) {
        LinkedHashMap<String, Field> fields = new LinkedHashMap<String, Field>();
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            LinkedHashMap<String, Field> allFields0 = EasyClassUtil.getAllFields0(superClass);
            fields.putAll(allFields0);
        }
        for (Field declaredField : clazz.getDeclaredFields()) {
            fields.put(declaredField.getName(), declaredField);
        }
        return fields;
    }

    public static Collection<Field> getAllFields(Class<?> clazz, Map<String, Field> staticFields) {
        LinkedHashMap<String, Field> fields = EasyClassUtil.getAllFields0(clazz, staticFields);
        return fields.values();
    }

    private static LinkedHashMap<String, Field> getAllFields0(Class<?> clazz, Map<String, Field> staticFields) {
        LinkedHashMap<String, Field> fields = new LinkedHashMap<String, Field>();
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            LinkedHashMap<String, Field> allFields0 = EasyClassUtil.getAllFields0(superClass, staticFields);
            fields.putAll(allFields0);
        }
        for (Field declaredField : clazz.getDeclaredFields()) {
            if (Modifier.isStatic(declaredField.getModifiers())) {
                staticFields.put(declaredField.getName(), declaredField);
                continue;
            }
            fields.put(declaredField.getName(), declaredField);
        }
        return fields;
    }

    public static Class[] getClasses(String packageName) throws ClassNotFoundException, IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        assert (classLoader != null);
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            dirs.add(new File(resource.getFile()));
        }
        ArrayList<Class> classes = new ArrayList<Class>();
        for (File directory : dirs) {
            classes.addAll(EasyClassUtil.findClasses(directory, packageName));
        }
        return classes.toArray(new Class[classes.size()]);
    }

    private static List<Class> findClasses(File directory, String packageName) throws ClassNotFoundException {
        File[] files;
        ArrayList<Class> classes = new ArrayList<Class>();
        if (!directory.exists()) {
            return classes;
        }
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                assert (!file.getName().contains("."));
                classes.addAll(EasyClassUtil.findClasses(file, packageName + "." + file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            classes.add(Class.forName(packageName + '.' + file.getName().substring(0, file.getName().length() - 6)));
        }
        return classes;
    }

    public static <T extends Annotation> T getAnnotation(Class c, Class<T> expect) {
        do {
            T an;
            if ((an = c.getAnnotation(expect)) == null) continue;
            return an;
        } while ((c = c.getSuperclass()) != null && c != Object.class);
        return null;
    }

    public static <T extends Annotation> T getAnnotation(Class c, String property, Method getter, Class<T> annotationClass) {
        if (getter == null) {
            throw new NullPointerException("\u671f\u671bPOJO\u7c7b\u7b26\u5408javabean\u89c4\u8303\uff0c" + c + " \u6ca1\u6709getter\u65b9\u6cd5");
        }
        T t = getter.getAnnotation(annotationClass);
        if (t != null) {
            return t;
        }
        try {
            while (c != null) {
                Field[] fs;
                for (Field f : fs = c.getDeclaredFields()) {
                    if (!f.getName().equals(property)) continue;
                    t = f.getAnnotation(annotationClass);
                    return t;
                }
                c = c.getSuperclass();
            }
            return t;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object convertValueToRequiredType(Object result, Class<?> requiredType) {
        if (result == null) {
            return null;
        }
        Class<?> type = result.getClass();
        if (type == result) {
            return result;
        }
        if (String.class == requiredType) {
            return result.toString();
        }
        if (Number.class.isAssignableFrom(requiredType)) {
            if (result instanceof Number) {
                return EasyNumberUtil.convertNumberToTargetClass((Number)result, requiredType);
            }
            return EasyNumberUtil.parseNumber(result.toString(), requiredType);
        }
        if (requiredType.isPrimitive() && result instanceof Number) {
            return EasyNumberUtil.convertNumberToTargetClass((Number)result, requiredType);
        }
        throw new IllegalArgumentException("\u65e0\u6cd5\u8f6c\u5316\u6210\u671f\u671b\u7c7b\u578b:" + requiredType);
    }

    public static boolean canInstance(int mod) {
        return !Modifier.isAbstract(mod) || !Modifier.isInterface(mod);
    }

    public static Class<? extends Collection> getCollectionImplType(Class<?> type) {
        if (EasyClassUtil.canInstance(type.getModifiers())) {
            return type;
        }
        if (List.class.isAssignableFrom(type)) {
            return ArrayList.class;
        }
        if (Set.class.isAssignableFrom(type)) {
            return HashSet.class;
        }
        throw new IllegalStateException("navigate not support type:" + EasyClassUtil.getSimpleName(type));
    }
}

