/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.util;

import com.easy.query.core.annotation.Nullable;
import com.easy.query.core.basic.extension.conversion.ValueConverter;
import com.easy.query.core.basic.extension.encryption.EncryptionStrategy;
import com.easy.query.core.basic.extension.formater.SQLParameterPrintFormat;
import com.easy.query.core.basic.extension.listener.JdbcExecuteAfterArg;
import com.easy.query.core.basic.extension.listener.JdbcExecuteBeforeArg;
import com.easy.query.core.basic.extension.listener.JdbcExecutorListener;
import com.easy.query.core.basic.extension.track.TrackManager;
import com.easy.query.core.basic.jdbc.conn.EasyConnection;
import com.easy.query.core.basic.jdbc.executor.ExecutorContext;
import com.easy.query.core.basic.jdbc.executor.ResultColumnMetadata;
import com.easy.query.core.basic.jdbc.executor.internal.merge.result.StreamResultSet;
import com.easy.query.core.basic.jdbc.executor.internal.merge.result.impl.EasyShardingStreamResultSet;
import com.easy.query.core.basic.jdbc.executor.internal.merge.result.impl.EasyStreamResultSet;
import com.easy.query.core.basic.jdbc.parameter.BeanSQLParameter;
import com.easy.query.core.basic.jdbc.parameter.ConstSQLParameter;
import com.easy.query.core.basic.jdbc.parameter.EasyConstSQLParameter;
import com.easy.query.core.basic.jdbc.parameter.SQLLikeParameter;
import com.easy.query.core.basic.jdbc.parameter.SQLParameter;
import com.easy.query.core.basic.jdbc.parameter.SQLRawParameter;
import com.easy.query.core.basic.jdbc.types.EasyParameter;
import com.easy.query.core.basic.jdbc.types.JdbcTypeHandlerManager;
import com.easy.query.core.basic.jdbc.types.handler.JdbcTypeHandler;
import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.enums.EasyBehaviorEnum;
import com.easy.query.core.exception.EasyQueryException;
import com.easy.query.core.exception.EasyQuerySQLStatementException;
import com.easy.query.core.expression.lambda.PropertySetterCaller;
import com.easy.query.core.expression.lambda.SQLConsumer;
import com.easy.query.core.logging.Log;
import com.easy.query.core.logging.LogFactory;
import com.easy.query.core.metadata.ColumnMetadata;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.util.EasyClassUtil;
import com.easy.query.core.util.EasyCollectionUtil;
import com.easy.query.core.util.EasyObjectUtil;
import com.easy.query.core.util.EasyStringUtil;
import com.easy.query.core.util.EasyTrackUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class EasyJdbcExecutorUtil {
    private static final int BATCH_GROUP_COUNT = 1000;
    private static final int EXECUTE_DEFAULT_EFFECT = 0;
    private static final Log log = LogFactory.getLog(EasyJdbcExecutorUtil.class);

    private static void printShardingSQLFormat(StringBuilder printSQL, EasyConnection easyConnection) {
        printSQL.append(Thread.currentThread().getName());
        printSQL.append(", name:");
        printSQL.append(easyConnection.getDataSourceName());
        printSQL.append(", ");
    }

    private static void printReplicaSQLFormat(StringBuilder printSQL, EasyConnection easyConnection) {
        printSQL.append("strategy:");
        printSQL.append(easyConnection.getConnectionStrategy().getName());
        printSQL.append(", ");
    }

    private static void logSQL(boolean printSql, String sql, EasyConnection easyConnection, boolean shardingPrint, boolean replicaPrint) {
        if (printSql) {
            StringBuilder printSQL = new StringBuilder();
            printSQL.append("==> ");
            if (shardingPrint) {
                EasyJdbcExecutorUtil.printShardingSQLFormat(printSQL, easyConnection);
            }
            if (replicaPrint) {
                EasyJdbcExecutorUtil.printReplicaSQLFormat(printSQL, easyConnection);
            }
            printSQL.append("Preparing: ");
            printSQL.append(sql);
            log.info(printSQL.toString());
        }
    }

    private static void logParameter(boolean printSql, SQLParameterPrintFormat sqlParameterPrintFormat, List<SQLParameter> parameters, EasyConnection easyConnection, boolean shardingPrint, boolean replicaPrint) {
        if (printSql) {
            StringBuilder printSQL = new StringBuilder();
            printSQL.append("==> ");
            if (shardingPrint) {
                EasyJdbcExecutorUtil.printShardingSQLFormat(printSQL, easyConnection);
            }
            if (replicaPrint) {
                EasyJdbcExecutorUtil.printReplicaSQLFormat(printSQL, easyConnection);
            }
            printSQL.append("Parameters: ");
            printSQL.append(sqlParameterPrintFormat.format(parameters));
            log.info(printSQL.toString());
        }
    }

    private static void logResult(boolean printSql, long total, EasyConnection easyConnection, boolean shardingPrint, boolean replicaPrint) {
        if (printSql) {
            StringBuilder printSQL = new StringBuilder();
            printSQL.append("<== ");
            if (shardingPrint) {
                EasyJdbcExecutorUtil.printShardingSQLFormat(printSQL, easyConnection);
            }
            if (replicaPrint) {
                EasyJdbcExecutorUtil.printReplicaSQLFormat(printSQL, easyConnection);
            }
            printSQL.append("Total: ");
            printSQL.append(total);
            log.info(printSQL.toString());
        }
    }

    private static void logResult(boolean printSql, int total, EasyConnection easyConnection, boolean shardingPrint, boolean replicaPrint) {
        if (printSql) {
            EasyJdbcExecutorUtil.logResult(true, (long)total, easyConnection, shardingPrint, replicaPrint);
        }
    }

    private static void logUse(boolean printSql, long start, long end, EasyConnection easyConnection, boolean shardingPrint, boolean replicaPrint) {
        if (printSql) {
            StringBuilder printSQL = new StringBuilder();
            printSQL.append("<== ");
            if (shardingPrint) {
                EasyJdbcExecutorUtil.printShardingSQLFormat(printSQL, easyConnection);
            }
            if (replicaPrint) {
                EasyJdbcExecutorUtil.printReplicaSQLFormat(printSQL, easyConnection);
            }
            printSQL.append("Time Elapsed: ");
            printSQL.append(end - start);
            printSQL.append("(ms)");
            log.info(printSQL.toString());
        }
    }

    public static <T> List<SQLParameter> extractParameters(T entity, List<SQLParameter> sqlParameters, boolean printSql, SQLParameterPrintFormat sqlParameterPrintFormat, EasyConnection easyConnection, boolean shardingPrint, boolean replicaPrint) {
        if (EasyCollectionUtil.isNotEmpty(sqlParameters)) {
            ArrayList<SQLParameter> params = new ArrayList<SQLParameter>(sqlParameters.size());
            for (SQLParameter sqlParameter : sqlParameters) {
                if (sqlParameter instanceof ConstSQLParameter) {
                    Object value = EasyJdbcExecutorUtil.toValue(sqlParameter, sqlParameter.getValue());
                    params.add(new EasyConstSQLParameter(sqlParameter.getTableOrNull(), sqlParameter.getPropertyNameOrNull(), value));
                    continue;
                }
                if (sqlParameter instanceof BeanSQLParameter) {
                    BeanSQLParameter beanSQLParameter = (BeanSQLParameter)sqlParameter;
                    beanSQLParameter.setBean(entity);
                    Object value = EasyJdbcExecutorUtil.toValue(beanSQLParameter, beanSQLParameter.getValue());
                    params.add(new EasyConstSQLParameter(beanSQLParameter.getTableOrNull(), beanSQLParameter.getPropertyNameOrNull(), value));
                    continue;
                }
                throw new EasyQueryException("current sql parameter:[" + EasyClassUtil.getSimpleName(sqlParameter.getClass()) + "],property name:[" + sqlParameter.getPropertyNameOrNull() + "] is not implements BeanSQLParameter or ConstSQLParameter");
            }
            if (printSql) {
                EasyJdbcExecutorUtil.logParameter(true, sqlParameterPrintFormat, params, easyConnection, shardingPrint, replicaPrint);
            }
            return params;
        }
        return Collections.emptyList();
    }

    public static StreamResultSet query(ExecutorContext executorContext, EasyConnection easyConnection, String sql, List<SQLParameter> sqlParameters) throws SQLException {
        return EasyJdbcExecutorUtil.query(executorContext, easyConnection, sql, sqlParameters, false, false);
    }

    public static StreamResultSet query(ExecutorContext executorContext, EasyConnection easyConnection, String sql, List<SQLParameter> sqlParameters, boolean shardingPrint, boolean replicaPrint) throws SQLException {
        QueryRuntimeContext runtimeContext = executorContext.getRuntimeContext();
        JdbcExecutorListener jdbcExecutorListener = runtimeContext.getJdbcExecutorListener();
        JdbcTypeHandlerManager easyJdbcTypeHandler = runtimeContext.getJdbcTypeHandlerManager();
        SQLParameterPrintFormat sqlParameterPrintFormat = runtimeContext.getSQLParameterPrintFormat();
        boolean printSql = executorContext.getEasyQueryOption().isPrintSql();
        EasyJdbcExecutorUtil.logSQL(printSql, sql, easyConnection, shardingPrint, replicaPrint);
        boolean listen = jdbcExecutorListener.enable() && executorContext.getExpressionContext().getBehavior().hasBehavior(EasyBehaviorEnum.JDBC_LISTEN);
        SQLConsumer<Statement> configurer = executorContext.getConfigurer(shardingPrint);
        PreparedStatement ps = null;
        ResultSet rs = null;
        List<SQLParameter> parameters = EasyJdbcExecutorUtil.extractParameters(null, sqlParameters, printSql, sqlParameterPrintFormat, easyConnection, shardingPrint, replicaPrint);
        JdbcExecuteBeforeArg jdbcListenBeforeArg = null;
        StreamResultSet sr = null;
        Exception exception = null;
        try {
            long end;
            long start;
            if (listen) {
                String traceId = jdbcExecutorListener.createTraceId();
                jdbcListenBeforeArg = new JdbcExecuteBeforeArg(traceId, sql, Collections.singletonList(parameters));
                jdbcExecutorListener.onExecuteBefore(jdbcListenBeforeArg);
            }
            ps = EasyJdbcExecutorUtil.createPreparedStatement(easyConnection.getConnection(), sql, parameters, easyJdbcTypeHandler);
            long l = start = printSql ? System.currentTimeMillis() : 0L;
            if (configurer != null) {
                configurer.accept(ps);
            }
            rs = ps.executeQuery();
            long l2 = end = printSql ? System.currentTimeMillis() : 0L;
            if (printSql) {
                EasyJdbcExecutorUtil.logUse(true, start, end, easyConnection, shardingPrint, replicaPrint);
            }
            if (shardingPrint) {
                boolean next = rs.next();
                sr = new EasyShardingStreamResultSet(rs, ps, next);
            } else {
                sr = new EasyStreamResultSet(rs, ps);
            }
            if (listen) {
                jdbcExecutorListener.onExecuteAfter(new JdbcExecuteAfterArg(jdbcListenBeforeArg, 0, exception));
            }
        }
        catch (Exception e) {
            try {
                exception = e;
                log.error(sql, e);
                if (e instanceof SQLException) {
                    throw new EasyQuerySQLStatementException(sql, e);
                }
                throw e;
            }
            catch (Throwable throwable) {
                if (listen) {
                    jdbcExecutorListener.onExecuteAfter(new JdbcExecuteAfterArg(jdbcListenBeforeArg, 0, exception));
                }
                throw throwable;
            }
        }
        return sr;
    }

    public static <T> int insert(ExecutorContext executorContext, EasyConnection easyConnection, String sql, List<T> entities, List<SQLParameter> sqlParameters, boolean fillAutoIncrement, boolean shardingPrint, boolean replicaPrint) throws SQLException {
        QueryRuntimeContext runtimeContext = executorContext.getRuntimeContext();
        JdbcExecutorListener jdbcExecutorListener = runtimeContext.getJdbcExecutorListener();
        boolean listen = jdbcExecutorListener.enable() && executorContext.getExpressionContext().getBehavior().hasBehavior(EasyBehaviorEnum.JDBC_LISTEN);
        boolean printSql = executorContext.getEasyQueryOption().isPrintSql();
        EasyJdbcExecutorUtil.logSQL(printSql, sql, easyConnection, shardingPrint, replicaPrint);
        JdbcTypeHandlerManager easyJdbcTypeHandler = runtimeContext.getJdbcTypeHandlerManager();
        SQLParameterPrintFormat sqlParameterPrintFormat = runtimeContext.getSQLParameterPrintFormat();
        Class<?> entityClass = entities.get(0).getClass();
        EntityMetadata entityMetadata = runtimeContext.getEntityMetadataManager().getEntityMetadata(entityClass);
        List<String> generatedKeyColumns = fillAutoIncrement ? entityMetadata.getGeneratedKeyColumns() : null;
        PreparedStatement ps = null;
        Exception exception = null;
        JdbcExecuteBeforeArg jdbcListenBeforeArg = null;
        int r = 0;
        try {
            if (listen) {
                String traceId = jdbcExecutorListener.createTraceId();
                jdbcListenBeforeArg = new JdbcExecuteBeforeArg(traceId, sql, new ArrayList<List<SQLParameter>>(entities.size()));
                jdbcExecutorListener.onExecuteBefore(jdbcListenBeforeArg);
            }
            int batchSize = 0;
            for (T entity : entities) {
                ++batchSize;
                List<SQLParameter> parameters = EasyJdbcExecutorUtil.extractParameters(entity, sqlParameters, printSql, sqlParameterPrintFormat, easyConnection, shardingPrint, replicaPrint);
                if (listen) {
                    jdbcListenBeforeArg.getSqlParameters().add(parameters);
                }
                if (ps == null) {
                    ps = EasyJdbcExecutorUtil.createPreparedStatement(easyConnection.getConnection(), sql, parameters, easyJdbcTypeHandler, generatedKeyColumns);
                } else {
                    EasyJdbcExecutorUtil.setPreparedStatement(ps, parameters, easyJdbcTypeHandler);
                }
                r += EasyJdbcExecutorUtil.execute(entities.size() > 1, batchSize, ps, params -> EasyJdbcExecutorUtil.incrementBackFill(fillAutoIncrement, params.getAlreadyCommitSize(), generatedKeyColumns, params.getPs(), entities, entityMetadata));
            }
            EasyJdbcExecutorUtil.logResult(printSql, r += EasyJdbcExecutorUtil.executeEnd(entities.size() > 1, batchSize, ps, params -> EasyJdbcExecutorUtil.incrementBackFill(fillAutoIncrement, params.getAlreadyCommitSize(), generatedKeyColumns, params.getPs(), entities, entityMetadata)), easyConnection, shardingPrint, replicaPrint);
        }
        catch (Exception e) {
            try {
                exception = e;
                log.error(sql, e);
                if (e instanceof SQLException) {
                    throw new EasyQuerySQLStatementException(sql, e);
                }
                throw e;
            }
            catch (Throwable throwable) {
                EasyJdbcExecutorUtil.clear(ps);
                if (listen) {
                    jdbcExecutorListener.onExecuteAfter(new JdbcExecuteAfterArg(jdbcListenBeforeArg, r, exception));
                }
                throw throwable;
            }
        }
        EasyJdbcExecutorUtil.clear(ps);
        if (listen) {
            jdbcExecutorListener.onExecuteAfter(new JdbcExecuteAfterArg(jdbcListenBeforeArg, r, exception));
        }
        return r;
    }

    private static void clear(PreparedStatement ps) {
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static <T> int executeRows(ExecutorContext executorContext, EasyConnection easyConnection, String sql, List<T> entities, List<SQLParameter> sqlParameters, boolean shardingPrint, boolean replicaPrint) throws SQLException {
        TrackManager trackManager;
        boolean hasTracked;
        Class<?> entityClass;
        boolean trackBean;
        boolean printSql = executorContext.getEasyQueryOption().isPrintSql();
        EasyJdbcExecutorUtil.logSQL(printSql, sql, easyConnection, shardingPrint, replicaPrint);
        QueryRuntimeContext runtimeContext = executorContext.getRuntimeContext();
        JdbcExecutorListener jdbcExecutorListener = runtimeContext.getJdbcExecutorListener();
        boolean listen = jdbcExecutorListener.enable() && executorContext.getExpressionContext().getBehavior().hasBehavior(EasyBehaviorEnum.JDBC_LISTEN);
        JdbcTypeHandlerManager easyJdbcTypeHandlerManager = runtimeContext.getJdbcTypeHandlerManager();
        SQLParameterPrintFormat sqlParameterPrintFormat = runtimeContext.getSQLParameterPrintFormat();
        PreparedStatement ps = null;
        Exception exception = null;
        JdbcExecuteBeforeArg jdbcListenBeforeArg = null;
        int r = 0;
        try {
            if (listen) {
                String traceId = jdbcExecutorListener.createTraceId();
                jdbcListenBeforeArg = new JdbcExecuteBeforeArg(traceId, sql, new ArrayList<List<SQLParameter>>(entities.size()));
                jdbcExecutorListener.onExecuteBefore(jdbcListenBeforeArg);
            }
            int batchSize = 0;
            for (T entity : entities) {
                ++batchSize;
                List<SQLParameter> parameters = EasyJdbcExecutorUtil.extractParameters(entity, sqlParameters, printSql, sqlParameterPrintFormat, easyConnection, shardingPrint, replicaPrint);
                if (listen) {
                    jdbcListenBeforeArg.getSqlParameters().add(parameters);
                }
                if (ps == null) {
                    ps = EasyJdbcExecutorUtil.createPreparedStatement(easyConnection.getConnection(), sql, parameters, easyJdbcTypeHandlerManager);
                } else {
                    EasyJdbcExecutorUtil.setPreparedStatement(ps, parameters, easyJdbcTypeHandlerManager);
                }
                r += EasyJdbcExecutorUtil.execute(entities.size() > 1, batchSize, ps, null);
            }
            EasyJdbcExecutorUtil.logResult(printSql, r += EasyJdbcExecutorUtil.executeEnd(entities.size() > 1, batchSize, ps, null), easyConnection, shardingPrint, replicaPrint);
        }
        catch (Exception e) {
            try {
                exception = e;
                log.error(sql, e);
                if (e instanceof SQLException) {
                    throw new EasyQuerySQLStatementException(sql, e);
                }
                throw e;
            }
            catch (Throwable throwable) {
                TrackManager trackManager2;
                boolean hasTracked2;
                Class<?> entityClass2;
                boolean trackBean2;
                EasyJdbcExecutorUtil.clear(ps);
                if (listen) {
                    jdbcExecutorListener.onExecuteAfter(new JdbcExecuteAfterArg(jdbcListenBeforeArg, r, exception));
                }
                if (EasyCollectionUtil.isNotEmpty(entities) && (trackBean2 = EasyTrackUtil.trackBean(executorContext, entityClass2 = entities.get(0).getClass())) && (hasTracked2 = (trackManager2 = executorContext.getRuntimeContext().getTrackManager()).getCurrentTrackContext().hasTracked(entityClass2))) {
                    for (T entity : entities) {
                        trackManager2.getCurrentTrackContext().removeTracking(entity);
                    }
                }
                throw throwable;
            }
        }
        EasyJdbcExecutorUtil.clear(ps);
        if (listen) {
            jdbcExecutorListener.onExecuteAfter(new JdbcExecuteAfterArg(jdbcListenBeforeArg, r, exception));
        }
        if (EasyCollectionUtil.isNotEmpty(entities) && (trackBean = EasyTrackUtil.trackBean(executorContext, entityClass = entities.get(0).getClass())) && (hasTracked = (trackManager = executorContext.getRuntimeContext().getTrackManager()).getCurrentTrackContext().hasTracked(entityClass))) {
            for (T entity : entities) {
                trackManager.getCurrentTrackContext().removeTracking(entity);
            }
        }
        return r;
    }

    public static <T> int executeRows(ExecutorContext executorContext, EasyConnection easyConnection, String sql, List<SQLParameter> sqlParameters, boolean shardingPrint, boolean replicaPrint) throws SQLException {
        boolean printSql = executorContext.getEasyQueryOption().isPrintSql();
        EasyJdbcExecutorUtil.logSQL(printSql, sql, easyConnection, shardingPrint, replicaPrint);
        QueryRuntimeContext runtimeContext = executorContext.getRuntimeContext();
        JdbcTypeHandlerManager easyJdbcTypeHandlerManager = runtimeContext.getJdbcTypeHandlerManager();
        SQLParameterPrintFormat sqlParameterPrintFormat = runtimeContext.getSQLParameterPrintFormat();
        List<SQLParameter> parameters = EasyJdbcExecutorUtil.extractParameters(null, sqlParameters, printSql, sqlParameterPrintFormat, easyConnection, shardingPrint, replicaPrint);
        JdbcExecutorListener jdbcExecutorListener = runtimeContext.getJdbcExecutorListener();
        boolean listen = jdbcExecutorListener.enable() && executorContext.getExpressionContext().getBehavior().hasBehavior(EasyBehaviorEnum.JDBC_LISTEN);
        JdbcExecuteBeforeArg jdbcListenBeforeArg = null;
        PreparedStatement ps = null;
        Exception exception = null;
        int r = 0;
        try {
            if (listen) {
                String traceId = jdbcExecutorListener.createTraceId();
                jdbcListenBeforeArg = new JdbcExecuteBeforeArg(traceId, sql, Collections.singletonList(parameters));
                jdbcExecutorListener.onExecuteBefore(jdbcListenBeforeArg);
            }
            ps = EasyJdbcExecutorUtil.createPreparedStatement(easyConnection.getConnection(), sql, parameters, easyJdbcTypeHandlerManager);
            r = ps.executeUpdate();
            EasyJdbcExecutorUtil.logResult(printSql, r, easyConnection, shardingPrint, replicaPrint);
        }
        catch (Exception e) {
            try {
                exception = e;
                log.error(sql, e);
                if (e instanceof SQLException) {
                    throw new EasyQuerySQLStatementException(sql, e);
                }
                throw e;
            }
            catch (Throwable throwable) {
                EasyJdbcExecutorUtil.clear(ps);
                if (listen) {
                    jdbcExecutorListener.onExecuteAfter(new JdbcExecuteAfterArg(jdbcListenBeforeArg, r, exception));
                }
                throw throwable;
            }
        }
        EasyJdbcExecutorUtil.clear(ps);
        if (listen) {
            jdbcExecutorListener.onExecuteAfter(new JdbcExecuteAfterArg(jdbcListenBeforeArg, r, exception));
        }
        return r;
    }

    private static PreparedStatement createPreparedStatement(Connection connection, String sql, List<SQLParameter> sqlParameters, JdbcTypeHandlerManager easyJdbcTypeHandlerManager) throws SQLException {
        return EasyJdbcExecutorUtil.createPreparedStatement(connection, sql, sqlParameters, easyJdbcTypeHandlerManager, null);
    }

    private static PreparedStatement createPreparedStatement(Connection connection, String sql, List<SQLParameter> sqlParameters, JdbcTypeHandlerManager easyJdbcTypeHandlerManager, List<String> generatedKeyColumns) throws SQLException {
        PreparedStatement preparedStatement = EasyCollectionUtil.isEmpty(generatedKeyColumns) ? connection.prepareStatement(sql) : connection.prepareStatement(sql, generatedKeyColumns.toArray(new String[0]));
        return EasyJdbcExecutorUtil.setPreparedStatement(preparedStatement, sqlParameters, easyJdbcTypeHandlerManager);
    }

    private static PreparedStatement setPreparedStatement(PreparedStatement preparedStatement, List<SQLParameter> sqlParameters, JdbcTypeHandlerManager easyJdbcTypeHandlerManager) throws SQLException {
        if (EasyCollectionUtil.isNotEmpty(sqlParameters)) {
            EasyParameter easyParameter = new EasyParameter(preparedStatement, sqlParameters);
            int paramSize = sqlParameters.size();
            for (int i = 0; i < paramSize; ++i) {
                easyParameter.setIndex(i);
                JdbcTypeHandler handler = easyJdbcTypeHandlerManager.getHandler(easyParameter.getValueType());
                handler.setParameter(easyParameter);
            }
        }
        return preparedStatement;
    }

    public static Object fromValue(ResultColumnMetadata resultColumnMetadata, Object value) {
        Class<?> entityClass = resultColumnMetadata.getEntityClass();
        Object fromValue = EasyJdbcExecutorUtil.fromValue0(entityClass, resultColumnMetadata, value);
        return resultColumnMetadata.getValueConverter().deserialize(EasyObjectUtil.typeCast(fromValue), resultColumnMetadata.getColumnMetadata());
    }

    private static Object fromValue0(Class<?> entityClass, ResultColumnMetadata resultColumnMetadata, Object value) {
        if (resultColumnMetadata.isEncryption()) {
            EncryptionStrategy easyEncryptionStrategy = resultColumnMetadata.getEncryptionStrategy();
            return easyEncryptionStrategy.decrypt(entityClass, resultColumnMetadata.getPropertyName(), value);
        }
        return value;
    }

    public static Object toValue(SQLParameter sqlParameter, Object value) {
        if (value instanceof SQLRawParameter) {
            return ((SQLRawParameter)value).getVal();
        }
        if (sqlParameter.getTableOrNull() != null) {
            EntityMetadata entityMetadata = sqlParameter.getTableOrNull().getEntityMetadata();
            String propertyName = sqlParameter.getPropertyNameOrNull();
            if (propertyName != null) {
                ColumnMetadata columnMetadata = entityMetadata.getColumnNotNull(propertyName);
                ValueConverter<?, ?> valueConverter = columnMetadata.getValueConverter();
                if (value != null) {
                    Object toValue = EasyJdbcExecutorUtil.toValue(columnMetadata, sqlParameter, value, entityMetadata.getEntityClass(), propertyName);
                    return valueConverter.serialize(EasyObjectUtil.typeCast(toValue), columnMetadata);
                }
                return valueConverter.serialize(null, columnMetadata);
            }
        }
        return value;
    }

    private static Object toValue(ColumnMetadata columnMetadata, SQLParameter sqlParameter, Object value, Class<?> entityClass, String propertyName) {
        if (columnMetadata.isEncryption()) {
            if (sqlParameter instanceof SQLLikeParameter) {
                if (columnMetadata.isSupportQueryLike()) {
                    EncryptionStrategy easyEncryptionStrategy = columnMetadata.getEncryptionStrategy();
                    String likeValue = value.toString();
                    String encryptValue = EasyStringUtil.endWithRemove(EasyStringUtil.startWithRemove(likeValue, "%"), "%");
                    return EasyStringUtil.startWithDefault(likeValue, "%", "") + easyEncryptionStrategy.encrypt(entityClass, propertyName, encryptValue) + EasyStringUtil.endWithDefault(likeValue, "%", "");
                }
            } else {
                EncryptionStrategy easyEncryptionStrategy = columnMetadata.getEncryptionStrategy();
                return easyEncryptionStrategy.encrypt(entityClass, propertyName, value);
            }
        }
        return value;
    }

    private static int execute(boolean batch, int batchSize, PreparedStatement ps, @Nullable SQLConsumer<InsertBackFillParams> consumer) throws SQLException {
        if (batch) {
            ps.addBatch();
            if (batchSize % 1000 == 0) {
                int[] ints = ps.executeBatch();
                ps.clearBatch();
                if (consumer != null) {
                    consumer.accept(new InsertBackFillParams(batchSize, ps));
                }
                return EasyCollectionUtil.sum(ints);
            }
            return 0;
        }
        return ps.executeUpdate();
    }

    private static int executeEnd(boolean batch, int batchSize, PreparedStatement ps, @Nullable SQLConsumer<InsertBackFillParams> consumer) throws SQLException {
        if (batch) {
            if (batchSize % 1000 != 0) {
                int[] ints = ps.executeBatch();
                ps.clearBatch();
                if (consumer != null) {
                    consumer.accept(new InsertBackFillParams(batchSize, ps));
                }
                return EasyCollectionUtil.sum(ints);
            }
        } else if (consumer != null) {
            consumer.accept(new InsertBackFillParams(1, ps));
        }
        return 0;
    }

    private static <T> void incrementBackFill(boolean fillAutoIncrement, int alreadyCommitSize, List<String> generatedKeyColumns, PreparedStatement ps, List<T> entities, EntityMetadata entityMetadata) throws SQLException {
        if (fillAutoIncrement && EasyCollectionUtil.isNotEmpty(generatedKeyColumns)) {
            assert (ps != null);
            ResultSet keysSet = ps.getGeneratedKeys();
            int unCommitSize = alreadyCommitSize % 1000;
            int index = unCommitSize == 0 ? alreadyCommitSize - 1000 : alreadyCommitSize - unCommitSize;
            ColumnMetadata[] columnMetadatas = new ColumnMetadata[generatedKeyColumns.size()];
            while (keysSet.next()) {
                T entity = entities.get(index);
                for (int i = 0; i < generatedKeyColumns.size(); ++i) {
                    ColumnMetadata columnMetadata = columnMetadatas[i];
                    if (columnMetadata == null) {
                        String columnName = generatedKeyColumns.get(i);
                        String propertyName = entityMetadata.getPropertyNameNotNull(columnName);
                        columnMetadatas[i] = columnMetadata = entityMetadata.getColumnNotNull(propertyName);
                    }
                    Object value = keysSet.getObject(i + 1);
                    Object newValue = EasyClassUtil.convertValueToRequiredType(value, columnMetadata.getPropertyType());
                    PropertySetterCaller<Object> beanSetter = columnMetadata.getSetterCaller();
                    beanSetter.call(entity, newValue);
                }
                ++index;
            }
        }
    }

    public static class InsertBackFillParams {
        private final int alreadyCommitSize;
        private final PreparedStatement ps;

        public InsertBackFillParams(int alreadyCommitSize, PreparedStatement ps) {
            this.alreadyCommitSize = alreadyCommitSize;
            this.ps = ps;
        }

        public int getAlreadyCommitSize() {
            return this.alreadyCommitSize;
        }

        public PreparedStatement getPs() {
            return this.ps;
        }
    }
}

