/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.util;

import com.easy.query.core.util.EasyCollectionUtil;
import java.util.ArrayList;
import java.util.List;

public class EasyStringUtil {
    public static final String EMPTY = "";

    public static String toLowerCaseFirstOne(String s) {
        if (Character.isLowerCase(s.charAt(0))) {
            return s;
        }
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    public static String toUpperCaseFirstOne(String s) {
        if (Character.isUpperCase(s.charAt(0))) {
            return s;
        }
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public static String toLowerUnderlined(String s) {
        char[] chars = s.toCharArray();
        StringBuilder temp = new StringBuilder();
        for (int i = 0; i < chars.length; ++i) {
            if (i != 0 && Character.isUpperCase(chars[i])) {
                temp.append("_");
            }
            temp.append(Character.toLowerCase(chars[i]));
        }
        return temp.toString();
    }

    public static String toUpperUnderlined(String s) {
        char[] chars = s.toCharArray();
        StringBuilder temp = new StringBuilder();
        for (int i = 0; i < chars.length; ++i) {
            if (i != 0 && Character.isUpperCase(chars[i])) {
                temp.append("_");
            }
            temp.append(Character.toUpperCase(chars[i]));
        }
        return temp.toString();
    }

    public static String fromLowerUnderlined(String str) {
        String[] splitArr = str.split("_");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < splitArr.length; ++i) {
            if (i == 0) {
                sb.append(splitArr[0].toLowerCase());
                continue;
            }
            sb.append(EasyStringUtil.toUpperCaseFirstOne(splitArr[i].toLowerCase()));
        }
        return sb.toString();
    }

    public static String trimAllWhitespace(String str) {
        if (str == null || str.length() <= 0) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        int index = 0;
        while (sb.length() > index) {
            if (Character.isWhitespace(sb.charAt(index))) {
                sb.deleteCharAt(index);
                continue;
            }
            ++index;
        }
        return sb.toString();
    }

    public static String defaultIfBank(String value, String def) {
        if (EasyStringUtil.isBlank(value)) {
            return def;
        }
        return value;
    }

    public static boolean isNotBlank(String str) {
        return !EasyStringUtil.isBlank(str);
    }

    public static boolean isBlank(String str) {
        if (EasyStringUtil.isEmpty(str)) {
            return true;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean endsWith(String str, String suffix, boolean ignoreCase) {
        if (str == null || suffix == null) {
            return str == null && suffix == null;
        }
        if (suffix.length() > str.length()) {
            return false;
        }
        int strOffset = str.length() - suffix.length();
        return str.regionMatches(ignoreCase, strOffset, suffix, 0, suffix.length());
    }

    public static boolean startsWith(String str, String prefix, boolean ignoreCase) {
        if (str == null || prefix == null) {
            return str == null && prefix == null;
        }
        if (prefix.length() > str.length()) {
            return false;
        }
        return str.regionMatches(ignoreCase, 0, prefix, 0, prefix.length());
    }

    public static boolean startsWith(String str, String prefix) {
        return str != null && prefix != null && str.startsWith(prefix);
    }

    public static boolean endsWith(String str, String suffix) {
        return str != null && suffix != null && str.endsWith(suffix);
    }

    public static String startWithRemove(String str, String prefix) {
        if (!EasyStringUtil.startsWith(str, prefix)) {
            return str;
        }
        return str.substring(prefix.length());
    }

    public static String endWithRemove(String str, String suffix) {
        if (!EasyStringUtil.endsWith(str, suffix)) {
            return str;
        }
        return str.substring(0, str.length() - suffix.length());
    }

    public static String startWithDefault(String str, String prefix, String def) {
        if (EasyStringUtil.startsWith(str, prefix)) {
            return prefix;
        }
        return def;
    }

    public static String endWithDefault(String str, String suffix, String def) {
        if (EasyStringUtil.endsWith(str, suffix)) {
            return suffix;
        }
        return def;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    private static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION;
    }

    public static boolean isChinese(String strName) {
        char[] ch = strName.toCharArray();
        for (int i = 0; i < ch.length; ++i) {
            char c = ch[i];
            if (!EasyStringUtil.isChinese(c)) continue;
            return true;
        }
        return false;
    }

    public static String[] safeSubstring(String input) {
        int[] codePoints = input.codePoints().toArray();
        String[] substrings = new String[codePoints.length];
        StringBuilder currentSubstring = new StringBuilder();
        int currentIndex = 0;
        for (int codePoint : codePoints) {
            if (Character.isHighSurrogate((char)codePoint)) {
                currentSubstring.setLength(0);
                currentSubstring.append((char)codePoint);
            } else {
                currentSubstring.appendCodePoint(codePoint);
            }
            if (currentSubstring.codePoints().count() != 1L) continue;
            substrings[currentIndex] = currentSubstring.toString();
            ++currentIndex;
            currentSubstring.setLength(0);
        }
        if (currentSubstring.length() > 0) {
            substrings[currentIndex] = currentSubstring.toString();
        }
        return substrings;
    }

    public static String safeSubstringFirst(String input) {
        int[] codePoints = input.codePoints().toArray();
        StringBuilder currentSubstring = new StringBuilder();
        if (codePoints.length == 0) {
            return EMPTY;
        }
        int codePoint = codePoints[0];
        if (Character.isHighSurrogate((char)codePoint)) {
            currentSubstring.setLength(0);
            currentSubstring.append((char)codePoint);
        } else {
            currentSubstring.appendCodePoint(codePoint);
        }
        if (currentSubstring.codePoints().count() == 1L) {
            return currentSubstring.toString();
        }
        if (currentSubstring.length() > 0) {
            return currentSubstring.toString();
        }
        return EMPTY;
    }

    public static List<String> getStringCharSegments(String str, int maxCharLen, int otherCharLength, int chineseCharLength) {
        ArrayList<String> segments = new ArrayList<String>(str.length());
        for (int i = 0; i < str.length(); ++i) {
            int j;
            char c;
            int len = 0;
            StringBuilder segmentBuilder = new StringBuilder();
            for (j = i; j < str.length() && len < maxCharLen; len += EasyStringUtil.isChinese(c = str.charAt(j)) ? chineseCharLength : otherCharLength, ++j) {
                segmentBuilder.append(c);
            }
            segments.add(segmentBuilder.toString());
            if (j == str.length() && len <= maxCharLen) break;
        }
        return segments;
    }

    public static List<String> getStringSafeCharSegments(String str, int maxCharLen, int otherCharLength, int chineseCharLength) {
        ArrayList<String> segments = new ArrayList<String>(str.length());
        String[] safeCharString = EasyStringUtil.safeSubstring(str);
        for (int i = 0; i < safeCharString.length; ++i) {
            int j;
            String c;
            int len = 0;
            StringBuilder segmentBuilder = new StringBuilder();
            for (j = i; j < safeCharString.length && len < maxCharLen; len += (c = safeCharString[j]).length() > 1 || EasyStringUtil.isChinese(c) ? chineseCharLength : otherCharLength, ++j) {
                segmentBuilder.append(c);
            }
            segments.add(segmentBuilder.toString());
            if (j == safeCharString.length && len <= maxCharLen) break;
        }
        return segments;
    }

    public static List<String> splitBase64ByGroupSize(String str, int groupSize) {
        if (str == null || str.length() == 0 || groupSize <= 0) {
            return EasyCollectionUtil.emptyList();
        }
        ArrayList<String> groups = new ArrayList<String>();
        int i = 0;
        while (i < str.length()) {
            int j;
            char c;
            int len = 0;
            for (j = i; j < str.length() && len < groupSize; len += (c = str.charAt(j)) < '\u0100' ? 1 : 2, ++j) {
            }
            groups.add(str.substring(i, j));
            i = j;
        }
        return groups;
    }

    public static String leftPad(String input, int totalWidth, char paddingChar) {
        if (input.length() >= totalWidth) {
            return input;
        }
        StringBuilder sb = new StringBuilder(totalWidth);
        for (int i = 0; i < totalWidth - input.length(); ++i) {
            sb.append(paddingChar);
        }
        sb.append(input);
        return sb.toString();
    }
}

