/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.datasource;

import com.anwen.mongo.annotation.SpelAnnotationHandler;
import com.anwen.mongo.annotation.datasource.MongoDs;
import com.anwen.mongo.cache.global.DataSourceNameCache;
import com.anwen.mongo.domain.MongoPlusException;
import com.anwen.mongo.handlers.DataSourceHandler;
import com.anwen.mongo.toolkit.ClassTypeUtil;
import com.anwen.mongo.toolkit.StringUtils;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.context.expression.MethodBasedEvaluationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.expression.EvaluationContext;

@Aspect
@Order(value=0)
public class MongoDataSourceAspect {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@within(com.anwen.mongo.annotation.datasource.MongoDs) || @annotation(com.anwen.mongo.annotation.datasource.MongoDs)")
    public Object manageDataSource(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        MongoDs mongoDs = this.getMongoDsAnnotation(method);
        String mongoDsValue = mongoDs.value();
        if (StringUtils.isNotBlank((String)mongoDsValue) && mongoDsValue.contains("#")) {
            MethodBasedEvaluationContext context = new MethodBasedEvaluationContext((Object)joinPoint, method, joinPoint.getArgs(), SpelAnnotationHandler.PARAMETER_NAME_DISCOVERER);
            mongoDsValue = (String)SpelAnnotationHandler.EXPRESSION_PARSER.parseExpression(mongoDsValue.replace("#", "")).getValue((EvaluationContext)context, String.class);
        }
        if (mongoDs.dsHandler() != Void.class) {
            DataSourceHandler dataSourceHandler = (DataSourceHandler)ClassTypeUtil.getInstanceByClass((Class)mongoDs.dsHandler());
            mongoDsValue = dataSourceHandler.getDataSource(mongoDsValue);
        }
        if (StringUtils.isBlank((String)mongoDsValue)) {
            throw new MongoPlusException("Data source not found");
        }
        DataSourceNameCache.setDataSource((String)mongoDsValue);
        try {
            Object object = joinPoint.proceed();
            return object;
        }
        finally {
            DataSourceNameCache.clear();
        }
    }

    private MongoDs getMongoDsAnnotation(Method method) {
        MongoDs mongoDs = (MongoDs)AnnotationUtils.findAnnotation((Method)method, MongoDs.class);
        if (mongoDs == null || StringUtils.isBlank((String)mongoDs.value())) {
            mongoDs = (MongoDs)AnnotationUtils.findAnnotation(method.getDeclaringClass(), MongoDs.class);
        }
        return mongoDs;
    }
}

