/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.property;

import com.anwen.mongo.domain.MongoPlusEncryptException;
import com.anwen.mongo.encryptor.AESExample;
import com.anwen.mongo.toolkit.StringUtils;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.env.OriginTrackedMapPropertySource;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;

public class EncryptionPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    private final String PREFIX = "${ENC:";
    private final String SUFFIX = "}";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        final String secretKey = environment.getProperty("mpw.key");
        if (StringUtils.isBlank((String)secretKey)) {
            return;
        }
        environment.getPropertySources().stream().filter(OriginTrackedMapPropertySource.class::isInstance).forEach(propertySource -> {
            String sourceName = propertySource.getName();
            PropertySource<Object> encryptedPropertySource = new PropertySource<Object>(sourceName){

                public Object getProperty(String name) {
                    String value;
                    Object property = propertySource.getProperty(name);
                    if (property != null && EncryptionPostProcessor.this.detected(value = property.toString())) {
                        try {
                            return AESExample.decrypt((String)EncryptionPostProcessor.this.unWrapper(value), (String)secretKey);
                        }
                        catch (Exception e) {
                            throw new MongoPlusEncryptException("Configuration decryption failed", (Throwable)e);
                        }
                    }
                    return property;
                }
            };
            environment.getPropertySources().replace(sourceName, (PropertySource)encryptedPropertySource);
        });
    }

    public int getOrder() {
        return 0;
    }

    public boolean detected(String property) {
        return property != null && property.startsWith("${ENC:") && property.endsWith("}");
    }

    public String wrapper(String property) {
        return "${ENC:" + property + "}";
    }

    public String unWrapper(String property) {
        return property.substring("${ENC:".length(), property.length() - "}".length());
    }
}

