/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.registrar;

import com.anwen.mongo.logging.Log;
import com.anwen.mongo.logging.LogFactory;
import com.anwen.mongo.registrar.MongoMapperFactoryBean;
import com.anwen.mongo.toolkit.CollUtil;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import org.springframework.aop.scope.ScopedProxyFactoryBean;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.lang.NonNull;

public class ClassPathMongoMapperScanner
extends ClassPathBeanDefinitionScanner {
    private final Log log = LogFactory.getLog(ClassPathMongoMapperScanner.class);
    private Class<? extends MongoMapperFactoryBean> factoryBean = MongoMapperFactoryBean.class;
    static final String FACTORY_BEAN_OBJECT_TYPE = "factoryBeanObjectType";

    public ClassPathMongoMapperScanner(BeanDefinitionRegistry registry) {
        super(registry, false);
    }

    public void setFactoryBean(Class<? extends MongoMapperFactoryBean> factoryBean) {
        this.factoryBean = factoryBean;
    }

    @NonNull
    protected Set<BeanDefinitionHolder> doScan(String ... basePackages) {
        Set beanDefinitionHolders = super.doScan(basePackages);
        if (CollUtil.isNotEmpty((Collection)beanDefinitionHolders)) {
            this.handleBeanDefinition(beanDefinitionHolders);
        }
        return beanDefinitionHolders;
    }

    public void handleBeanDefinition(Set<BeanDefinitionHolder> beanDefinitions) {
        BeanDefinitionRegistry registry = this.getRegistry();
        beanDefinitions.forEach(holder -> {
            String beanClassName;
            AbstractBeanDefinition definition = (AbstractBeanDefinition)holder.getBeanDefinition();
            boolean scopedProxy = false;
            if (ScopedProxyFactoryBean.class.getName().equals(definition.getBeanClassName())) {
                definition = (AbstractBeanDefinition)Optional.ofNullable(((RootBeanDefinition)definition).getDecoratedDefinition()).map(BeanDefinitionHolder::getBeanDefinition).orElseThrow(() -> new IllegalStateException("The target bean definition of scoped proxy bean not found. Root bean definition[" + holder + "]"));
                scopedProxy = true;
            }
            if ((beanClassName = definition.getBeanClassName()) != null) {
                definition.getConstructorArgumentValues().addGenericArgumentValue((Object)beanClassName);
            }
            try {
                definition.getPropertyValues().add("mapperInterface", Class.forName(beanClassName));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            definition.setBeanClass(this.factoryBean);
            definition.setAttribute(FACTORY_BEAN_OBJECT_TYPE, (Object)beanClassName);
            if (scopedProxy) {
                return;
            }
            if (!definition.isSingleton()) {
                BeanDefinitionHolder proxyHolder = ScopedProxyUtils.createScopedProxy((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)registry, (boolean)true);
                if (registry.containsBeanDefinition(proxyHolder.getBeanName())) {
                    registry.removeBeanDefinition(proxyHolder.getBeanName());
                }
                registry.registerBeanDefinition(proxyHolder.getBeanName(), proxyHolder.getBeanDefinition());
            }
        });
    }

    protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
        return beanDefinition.getMetadata().isInterface() && beanDefinition.getMetadata().isIndependent();
    }
}

