/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.transactional;

import com.anwen.mongo.annotation.transactional.MongoTransactional;
import com.anwen.mongo.cache.global.HandlerCache;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.core.annotation.Order;

@Aspect
@Order(value=1)
public class MongoTransactionalAspect {
    @Pointcut(value="@annotation(com.anwen.mongo.annotation.transactional.MongoTransactional)")
    protected void markMongoTransactional() {
    }

    @Around(value="markMongoTransactional() && @annotation(mongoTransactional)")
    public Object manageTransaction(ProceedingJoinPoint joinPoint, MongoTransactional mongoTransactional) throws Throwable {
        return HandlerCache.transactionHandler.transaction(() -> {
            try {
                return joinPoint.proceed();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }, mongoTransactional);
    }
}

