/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import com.google.common.collect.ImmutableMap;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.cp.api.WxCpMessageService;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.message.WxCpLinkedCorpMessage;
import me.chanjar.weixin.cp.bean.message.WxCpMessage;
import me.chanjar.weixin.cp.bean.message.WxCpMessageSendResult;
import me.chanjar.weixin.cp.bean.message.WxCpMessageSendStatistics;
import me.chanjar.weixin.cp.util.json.WxCpGsonBuilder;

public class WxCpMessageServiceImpl
implements WxCpMessageService {
    private final WxCpService cpService;

    @Override
    public WxCpMessageSendResult send(WxCpMessage message) throws WxErrorException {
        Integer agentId = message.getAgentId();
        if (null == agentId) {
            message.setAgentId(this.cpService.getWxCpConfigStorage().getAgentId());
        }
        return WxCpMessageSendResult.fromJson(this.cpService.post(this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/message/send"), message.toJson()));
    }

    @Override
    public WxCpMessageSendStatistics getStatistics(int timeType) throws WxErrorException {
        return WxCpMessageSendStatistics.fromJson(this.cpService.post(this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/message/get_statistics"), WxCpGsonBuilder.create().toJson((Object)ImmutableMap.of((Object)"time_type", (Object)timeType))));
    }

    @Override
    public WxCpMessageSendResult sendLinkedCorpMessage(WxCpLinkedCorpMessage message) throws WxErrorException {
        Integer agentId = message.getAgentId();
        if (null == agentId) {
            message.setAgentId(this.cpService.getWxCpConfigStorage().getAgentId());
        }
        return WxCpMessageSendResult.fromJson(this.cpService.post(this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/linkedcorp/message/send"), message.toJson()));
    }

    public WxCpMessageServiceImpl(WxCpService cpService) {
        this.cpService = cpService;
    }
}

