/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import lombok.NonNull;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.json.GsonHelper;
import me.chanjar.weixin.common.util.json.GsonParser;
import me.chanjar.weixin.cp.api.WxCpLivingService;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.living.WxCpLivingCreateRequest;
import me.chanjar.weixin.cp.bean.living.WxCpLivingInfo;
import me.chanjar.weixin.cp.bean.living.WxCpLivingModifyRequest;
import me.chanjar.weixin.cp.bean.living.WxCpLivingResult;
import me.chanjar.weixin.cp.bean.living.WxCpLivingShareInfo;
import me.chanjar.weixin.cp.bean.living.WxCpWatchStat;
import me.chanjar.weixin.cp.util.json.WxCpGsonBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxCpLivingServiceImpl
implements WxCpLivingService {
    private static final Logger log = LoggerFactory.getLogger(WxCpLivingServiceImpl.class);
    private final WxCpService cpService;

    @Override
    public String getLivingCode(String openId, String livingId) throws WxErrorException {
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/living/get_living_code");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("openid", openId);
        jsonObject.addProperty("livingid", livingId);
        String responseContent = this.cpService.post(apiUrl, jsonObject.toString());
        return GsonHelper.getString((JsonObject)GsonParser.parse((String)responseContent), (String)"living_code");
    }

    @Override
    public WxCpLivingInfo getLivingInfo(String livingId) throws WxErrorException {
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/living/get_living_info?livingid=") + livingId;
        String responseContent = this.cpService.get(apiUrl, null);
        return (WxCpLivingInfo)WxCpGsonBuilder.create().fromJson(GsonParser.parse((String)responseContent).get("living_info"), new TypeToken<WxCpLivingInfo>(){}.getType());
    }

    @Override
    public WxCpWatchStat getWatchStat(String livingId, Integer nextKey) throws WxErrorException {
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/living/get_watch_stat");
        JsonObject jsonObject = new JsonObject();
        if (nextKey != null) {
            jsonObject.addProperty("next_key", String.valueOf(nextKey));
        }
        jsonObject.addProperty("livingid", livingId);
        String responseContent = this.cpService.post(apiUrl, jsonObject.toString());
        return WxCpWatchStat.fromJson(responseContent);
    }

    @Override
    public WxCpLivingResult.LivingIdResult getUserAllLivingId(String userId, String cursor, Integer limit) throws WxErrorException {
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/living/get_user_all_livingid");
        JsonObject jsonObject = new JsonObject();
        if (cursor != null) {
            jsonObject.addProperty("cursor", cursor);
        }
        if (limit != null) {
            jsonObject.addProperty("limit", (Number)limit);
        }
        jsonObject.addProperty("userid", userId);
        String responseContent = this.cpService.post(apiUrl, jsonObject.toString());
        return WxCpLivingResult.LivingIdResult.fromJson(responseContent);
    }

    @Override
    public WxCpLivingShareInfo getLivingShareInfo(String wwShareCode) throws WxErrorException {
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/living/get_living_share_info");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("ww_share_code", wwShareCode);
        String responseContent = this.cpService.post(apiUrl, jsonObject.toString());
        return WxCpLivingShareInfo.fromJson(responseContent);
    }

    @Override
    public String livingCreate(WxCpLivingCreateRequest request) throws WxErrorException {
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/living/create");
        String responseContent = this.cpService.post(apiUrl, request.toJson());
        return GsonHelper.getString((JsonObject)GsonParser.parse((String)responseContent), (String)"livingid");
    }

    @Override
    public WxCpLivingResult livingModify(WxCpLivingModifyRequest request) throws WxErrorException {
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/living/modify");
        String responseContent = this.cpService.post(apiUrl, request.toJson());
        return WxCpLivingResult.fromJson(responseContent);
    }

    @Override
    public WxCpLivingResult livingCancel(@NonNull String livingId) throws WxErrorException {
        if (livingId == null) {
            throw new NullPointerException("livingId is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/living/cancel");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("livingid", livingId);
        String responseContent = this.cpService.post(apiUrl, jsonObject.toString());
        return WxCpLivingResult.fromJson(responseContent);
    }

    @Override
    public WxCpLivingResult deleteReplayData(@NonNull String livingId) throws WxErrorException {
        if (livingId == null) {
            throw new NullPointerException("livingId is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/living/delete_replay_data");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("livingid", livingId);
        String responseContent = this.cpService.post(apiUrl, jsonObject.toString());
        return WxCpLivingResult.fromJson(responseContent);
    }

    public WxCpLivingServiceImpl(WxCpService cpService) {
        this.cpService = cpService;
    }
}

