/*
 * Decompiled with CFR 0.152.
 */
package com.binarywang.spring.starter.wxjava.cp.storage;

import com.binarywang.spring.starter.wxjava.cp.properties.WxCpProperties;
import com.binarywang.spring.starter.wxjava.cp.properties.WxCpRedisProperties;
import com.binarywang.spring.starter.wxjava.cp.storage.AbstractWxCpConfigStorageConfiguration;
import me.chanjar.weixin.cp.config.WxCpConfigStorage;
import me.chanjar.weixin.cp.config.impl.WxCpDefaultConfigImpl;
import me.chanjar.weixin.cp.config.impl.WxCpRedissonConfigImpl;
import org.apache.commons.lang3.StringUtils;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.TransportMode;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="wx.cp.config-storage", name={"type"}, havingValue="redisson")
public class WxCpInRedissonConfigStorageConfiguration
extends AbstractWxCpConfigStorageConfiguration {
    private final WxCpProperties wxCpProperties;
    private final ApplicationContext applicationContext;

    @Bean
    @ConditionalOnMissingBean(value={WxCpConfigStorage.class})
    public WxCpConfigStorage wxCpConfigStorage() {
        WxCpRedissonConfigImpl config = this.getConfigStorage();
        return this.config((WxCpDefaultConfigImpl)config, this.wxCpProperties);
    }

    private WxCpRedissonConfigImpl getConfigStorage() {
        WxCpRedisProperties redisProperties = this.wxCpProperties.getConfigStorage().getRedis();
        RedissonClient redissonClient = redisProperties != null && StringUtils.isNotEmpty((CharSequence)redisProperties.getHost()) ? this.getRedissonClient() : (RedissonClient)this.applicationContext.getBean(RedissonClient.class);
        return new WxCpRedissonConfigImpl(redissonClient, this.wxCpProperties.getConfigStorage().getKeyPrefix());
    }

    private RedissonClient getRedissonClient() {
        WxCpProperties.ConfigStorage storage = this.wxCpProperties.getConfigStorage();
        WxCpRedisProperties redis = storage.getRedis();
        Config config = new Config();
        config.useSingleServer().setAddress("redis://" + redis.getHost() + ":" + redis.getPort()).setDatabase(redis.getDatabase()).setPassword(redis.getPassword());
        config.setTransportMode(TransportMode.NIO);
        return Redisson.create((Config)config);
    }

    public WxCpInRedissonConfigStorageConfiguration(WxCpProperties wxCpProperties, ApplicationContext applicationContext) {
        this.wxCpProperties = wxCpProperties;
        this.applicationContext = applicationContext;
    }
}

