/*
 * Decompiled with CFR 0.152.
 */
package com.github.miemiedev.mybatis.paginator.support;

import com.github.miemiedev.mybatis.paginator.dialect.Dialect;
import com.github.miemiedev.mybatis.paginator.support.DefaultParameterHandler;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLHelp {
    private static Logger logger = LoggerFactory.getLogger(SQLHelp.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCount(String sql, MappedStatement mappedStatement, Object parameterObject, BoundSql boundSql, Dialect dialect) throws SQLException {
        String count_sql = dialect.getCountString(sql);
        logger.debug("Total count SQL [{}] ", (Object)count_sql);
        logger.debug("Total count Parameters: {} ", parameterObject);
        Connection connection = null;
        PreparedStatement countStmt = null;
        ResultSet rs = null;
        try {
            connection = mappedStatement.getConfiguration().getEnvironment().getDataSource().getConnection();
            countStmt = connection.prepareStatement(count_sql);
            DefaultParameterHandler handler = new DefaultParameterHandler(mappedStatement, parameterObject, boundSql);
            handler.setParameters(countStmt);
            rs = countStmt.executeQuery();
            int count = 0;
            if (rs.next()) {
                count = rs.getInt(1);
            }
            logger.debug("Total count: {}", (Object)count);
            int n = count;
            return n;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            finally {
                try {
                    if (countStmt != null) {
                        countStmt.close();
                    }
                }
                finally {
                    if (connection != null && !connection.isClosed()) {
                        connection.close();
                    }
                }
            }
        }
    }
}

