/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.pool;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.List;

public class KeyAffinityExecutorStats {
    private final List<SingleThreadPoolStats> stats;

    public KeyAffinityExecutorStats(List<SingleThreadPoolStats> stats) {
        this.stats = stats;
    }

    public List<SingleThreadPoolStats> getThreadPoolStats() {
        return Collections.unmodifiableList(this.stats);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("stats", this.stats).toString();
    }

    public static class SingleThreadPoolStats {
        private final int parallelism;
        private final int activeThreadCount;
        private final int queueSize;
        private final int queueRemainingCapacity;

        public SingleThreadPoolStats(int parallelism, int activeThreadCount, int queueSize, int queueRemainingCapacity) {
            this.parallelism = parallelism;
            this.activeThreadCount = activeThreadCount;
            this.queueSize = queueSize;
            this.queueRemainingCapacity = queueRemainingCapacity;
        }

        public int getParallelism() {
            return this.parallelism;
        }

        public int getActiveThreadCount() {
            return this.activeThreadCount;
        }

        public int getQueueSize() {
            return this.queueSize;
        }

        public int getQueueRemainingCapacity() {
            return this.queueRemainingCapacity;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("parallelism", this.parallelism).add("activeThreadCount", this.activeThreadCount).add("queueSize", this.queueSize).add("queueRemainingCapacity", this.queueRemainingCapacity).toString();
        }
    }
}

