/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.pool.impl;

import com.github.phantomthief.pool.impl.KeyAffinityImpl;
import com.github.phantomthief.pool.impl.LazyKeyAffinity;
import com.github.phantomthief.util.ThrowableConsumer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.function.BooleanSupplier;
import java.util.function.IntPredicate;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
class KeyAffinityBuilder<V> {
    private Supplier<V> factory;
    private IntSupplier count;
    private ThrowableConsumer<V, Exception> depose;
    private IntPredicate usingRandom;
    private BooleanSupplier counterChecker;

    KeyAffinityBuilder() {
    }

    public <K> LazyKeyAffinity<K, V> build() {
        this.ensure();
        return new LazyKeyAffinity(this::buildInner);
    }

    <K> KeyAffinityImpl<K, V> buildInner() {
        return new KeyAffinityImpl(this.factory, this.count, this.depose, this.usingRandom, this.counterChecker);
    }

    void ensure() {
        if (this.count == null || this.count.getAsInt() <= 0) {
            throw new IllegalArgumentException("no count found.");
        }
        if (this.counterChecker == null) {
            this.counterChecker = () -> true;
        }
        if (this.depose == null) {
            this.depose = it -> {};
        }
        if (this.usingRandom == null) {
            this.usingRandom = it -> it > 20;
        }
    }

    @CheckReturnValue
    @Nonnull
    @VisibleForTesting
    <T extends KeyAffinityBuilder<V>> T counterChecker(@Nonnull BooleanSupplier value) {
        this.counterChecker = (BooleanSupplier)Preconditions.checkNotNull((Object)value);
        return (T)this;
    }

    @CheckReturnValue
    @Nonnull
    public <T extends KeyAffinityBuilder<V>> T factory(@Nonnull Supplier<V> value) {
        this.factory = (Supplier)Preconditions.checkNotNull(value);
        return (T)this;
    }

    @CheckReturnValue
    @Nonnull
    public <T extends KeyAffinityBuilder<V>> T usingRandom(boolean value) {
        return this.usingRandom(it -> value);
    }

    @CheckReturnValue
    @Nonnull
    public <T extends KeyAffinityBuilder<V>> T usingRandom(@Nonnull IntPredicate value) {
        this.usingRandom = (IntPredicate)Preconditions.checkNotNull((Object)value);
        return (T)this;
    }

    @CheckReturnValue
    @Nonnull
    public <T extends KeyAffinityBuilder<V>> T count(@Nonnegative int value) {
        Preconditions.checkArgument((value > 0 ? 1 : 0) != 0);
        this.count = () -> value;
        return (T)this;
    }

    @CheckReturnValue
    @Nonnull
    public <T extends KeyAffinityBuilder<V>> T count(@Nonnull IntSupplier value) {
        this.count = (IntSupplier)Preconditions.checkNotNull((Object)value);
        return (T)this;
    }

    @CheckReturnValue
    @Nonnull
    public <T extends KeyAffinityBuilder<V>> T depose(@Nonnegative ThrowableConsumer<V, Exception> value) {
        this.depose = (ThrowableConsumer)Preconditions.checkNotNull(value);
        return (T)this;
    }
}

