/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.pool.impl;

import com.github.phantomthief.pool.KeyAffinityExecutor;
import com.github.phantomthief.pool.KeyAffinityExecutorStats;
import com.github.phantomthief.pool.impl.KeyAffinityExecutorBuilder;
import com.github.phantomthief.pool.impl.KeyAffinityImpl;
import com.github.phantomthief.pool.impl.LazyKeyAffinity;
import com.github.phantomthief.pool.impl.ThreadListeningExecutorService;
import com.github.phantomthief.util.ThrowableRunnable;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class KeyAffinityExecutorImpl<K>
extends LazyKeyAffinity<K, ListeningExecutorService>
implements KeyAffinityExecutor<K> {
    KeyAffinityExecutorImpl(Supplier<KeyAffinityImpl<K, ListeningExecutorService>> factory) {
        super(factory);
    }

    @Override
    public void close() throws Exception {
        try {
            super.close();
        }
        finally {
            KeyAffinityExecutorBuilder.ALL_EXECUTORS.remove(this);
        }
    }

    @Override
    @Nullable
    public KeyAffinityExecutorStats stats() {
        ArrayList<KeyAffinityExecutorStats.SingleThreadPoolStats> list = new ArrayList<KeyAffinityExecutorStats.SingleThreadPoolStats>();
        for (ListeningExecutorService executor : this) {
            if (executor instanceof ThreadListeningExecutorService) {
                ThreadListeningExecutorService t1 = (ThreadListeningExecutorService)executor;
                list.add(new KeyAffinityExecutorStats.SingleThreadPoolStats(t1.getMaximumPoolSize(), t1.getActiveCount(), t1.getQueueSize(), t1.getQueueRemainingCapacity()));
                continue;
            }
            throw new IllegalStateException("cannot get stats for " + this);
        }
        return new KeyAffinityExecutorStats(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> ListenableFuture<T> submit(final K key, @Nonnull Callable<T> task) {
        Preconditions.checkNotNull(task);
        ListeningExecutorService service = (ListeningExecutorService)this.select(key);
        boolean addCallback = false;
        try {
            ListenableFuture future = service.submit(task);
            Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<Object>(){

                public void onSuccess(@Nullable Object result) {
                    KeyAffinityExecutorImpl.this.finishCall(key);
                }

                public void onFailure(Throwable t) {
                    KeyAffinityExecutorImpl.this.finishCall(key);
                }
            }, (Executor)MoreExecutors.directExecutor());
            addCallback = true;
            ListenableFuture listenableFuture = future;
            return listenableFuture;
        }
        finally {
            if (!addCallback) {
                this.finishCall(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeEx(K key, @Nonnull ThrowableRunnable<Exception> task) {
        Preconditions.checkNotNull(task);
        ListeningExecutorService service = (ListeningExecutorService)this.select(key);
        boolean addCallback = false;
        try {
            service.execute(() -> {
                try {
                    task.run();
                }
                catch (Throwable e) {
                    Throwables.throwIfUnchecked((Throwable)e);
                    throw new UncheckedExecutionException(e);
                }
                finally {
                    this.finishCall(key);
                }
            });
            addCallback = true;
        }
        finally {
            if (!addCallback) {
                this.finishCall(key);
            }
        }
    }
}

