/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.pool.impl;

import com.github.phantomthief.util.MoreSuppliers;
import java.util.Collection;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

class LazyBlockingQueue<E>
implements BlockingQueue<E> {
    private final Supplier<BlockingQueue<E>> factory;

    LazyBlockingQueue(@Nonnull Supplier<BlockingQueue<E>> factory) {
        this.factory = MoreSuppliers.lazy(factory);
    }

    @Override
    public boolean add(E e) {
        return this.factory.get().add(e);
    }

    @Override
    public boolean offer(E e) {
        return this.factory.get().offer(e);
    }

    @Override
    public E remove() {
        return this.factory.get().remove();
    }

    @Override
    public E poll() {
        return this.factory.get().poll();
    }

    @Override
    public E element() {
        return this.factory.get().element();
    }

    @Override
    public E peek() {
        return this.factory.get().peek();
    }

    @Override
    public void put(E e) throws InterruptedException {
        this.factory.get().put(e);
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        return this.factory.get().offer(e, timeout, unit);
    }

    @Override
    public E take() throws InterruptedException {
        return this.factory.get().take();
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.factory.get().poll(timeout, unit);
    }

    @Override
    public int remainingCapacity() {
        return this.factory.get().remainingCapacity();
    }

    @Override
    public boolean remove(Object o) {
        return this.factory.get().remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.factory.get().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.factory.get().addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.factory.get().removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.factory.get().retainAll(c);
    }

    @Override
    public void clear() {
        this.factory.get().clear();
    }

    @Override
    public int size() {
        return this.factory.get().size();
    }

    @Override
    public boolean isEmpty() {
        return this.factory.get().isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.factory.get().contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.factory.get().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.factory.get().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.factory.get().toArray(a);
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        return this.factory.get().drainTo(c);
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        return this.factory.get().drainTo(c, maxElements);
    }

    public String toString() {
        return this.factory.get().toString();
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        return this.factory.get().removeIf(filter);
    }

    @Override
    public Spliterator<E> spliterator() {
        return this.factory.get().spliterator();
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        this.factory.get().forEach(action);
    }
}

