/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.util;

import com.github.phantomthief.tuple.Tuple;
import com.github.phantomthief.tuple.TwoTuple;
import com.github.phantomthief.util.UnifiedNameService;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.reflect.Reflection;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.MethodUtils;

public class NameServiceUtils {
    private static final byte[] LOCAL_HOST = new byte[]{127, 0, 0, 1};

    private static <T, R> R doInvoke(Object object, String method, T it) throws UnknownHostException {
        try {
            return (R)MethodUtils.invokeMethod((Object)object, (boolean)true, (String)method, (Object[])new Object[]{it});
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof UnknownHostException) {
                throw (UnknownHostException)cause;
            }
            Throwables.throwIfUnchecked((Throwable)cause);
            throw new AssertionError((Object)cause);
        }
    }

    private static TwoTuple<Object, List<Object>> unwrapList(Object object) {
        if (object instanceof List) {
            List list = (List)object;
            Preconditions.checkState((!list.isEmpty() ? 1 : 0) != 0, (Object)"empty nameService in jdk8");
            Preconditions.checkState((list.size() == 1 ? 1 : 0) != 0, (Object)"multiple nameServices in jdk8");
            return Tuple.tuple(list.get(0), list);
        }
        throw new IllegalStateException("unknown jdk impl.");
    }

    private static <T> T adapterFromUnifiedNameService(UnifiedNameService unifiedNameService, Class<T> nameServiceInterface) {
        return (T)Reflection.newProxy(nameServiceInterface, (proxy, method, args) -> {
            String name = method.getName();
            if (name.equals("lookupAllHostAddr")) {
                return unifiedNameService.lookupAllHostAddr((String)args[0]);
            }
            if (name.equals("getHostByAddr")) {
                return unifiedNameService.getHostByAddr((byte[])args[0]);
            }
            return method.invoke((Object)unifiedNameService, args);
        });
    }

    private static void setNameServiceJdk8(UnifiedNameService unifiedNameService, Object originalNameService0) {
        TwoTuple<Object, List<Object>> tuple = NameServiceUtils.unwrapList(originalNameService0);
        Object originalNameService = tuple.getFirst();
        List<Object> list = tuple.getSecond();
        Class<?> nameServiceInterface = originalNameService.getClass().getInterfaces()[0];
        Object wrappedNameService = NameServiceUtils.adapterFromUnifiedNameService(unifiedNameService, nameServiceInterface);
        list.set(0, wrappedNameService);
    }

    private static void setNameServiceJdk9(UnifiedNameService unifiedNameService, Object originalNameService) throws IllegalAccessException {
        Class<?> nameServiceInterface = originalNameService.getClass().getInterfaces()[0];
        Object wrappedNameService = NameServiceUtils.adapterFromUnifiedNameService(unifiedNameService, nameServiceInterface);
        FieldUtils.writeStaticField(InetAddress.class, (String)"nameService", wrappedNameService, (boolean)true);
    }

    public static UnifiedNameService getCurrentNameService() {
        try {
            Object nameService9 = FieldUtils.readDeclaredStaticField(InetAddress.class, (String)"nameService", (boolean)true);
            if (nameService9 != null) {
                NameServiceUtils.checkJdk9(nameService9);
                return new UnifiedNameServiceAdapter(nameService9);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NullPointerException nameService9) {
            // empty catch block
        }
        try {
            Object nameServices8 = FieldUtils.readDeclaredStaticField(InetAddress.class, (String)"nameServices", (boolean)true);
            if (nameServices8 != null) {
                TwoTuple<Object, List<Object>> nameService8 = NameServiceUtils.unwrapList(nameServices8);
                NameServiceUtils.checkJdk8(nameService8.getFirst());
                return new UnifiedNameServiceAdapter(nameService8.getFirst());
            }
            throw new IllegalStateException("illegal jdk impl.");
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void checkJdk8(Object nameService8) {
        try {
            String string = (String)NameServiceUtils.doInvoke(nameService8, "getHostByAddr", LOCAL_HOST);
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    private static void checkJdk9(Object nameService9) {
        Preconditions.checkState((boolean)StringUtils.equals((CharSequence)"java.net.InetAddress$PlatformNameService", (CharSequence)nameService9.getClass().getName()), (Object)"unsupported jdk9+ impl.");
        try {
            String string = (String)NameServiceUtils.doInvoke(nameService9, "getHostByAddr", LOCAL_HOST);
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    public static void setNameService(UnifiedNameService unifiedNameService) {
        Object nameService2;
        try {
            nameService2 = FieldUtils.readDeclaredStaticField(InetAddress.class, (String)"nameService", (boolean)true);
            if (nameService2 != null) {
                NameServiceUtils.setNameServiceJdk9(unifiedNameService, nameService2);
                return;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NullPointerException nameService2) {
            // empty catch block
        }
        try {
            nameService2 = FieldUtils.readDeclaredStaticField(InetAddress.class, (String)"nameServices", (boolean)true);
            if (nameService2 != null) {
                NameServiceUtils.setNameServiceJdk8(unifiedNameService, nameService2);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    private static class UnifiedNameServiceAdapter
    implements UnifiedNameService {
        private final Object object;

        UnifiedNameServiceAdapter(@Nonnull Object obj) {
            this.object = obj;
        }

        @Override
        public InetAddress[] lookupAllHostAddr(String host) throws UnknownHostException {
            return (InetAddress[])NameServiceUtils.doInvoke(this.object, "lookupAllHostAddr", host);
        }

        @Override
        public String getHostByAddr(byte[] addr) throws UnknownHostException {
            return (String)NameServiceUtils.doInvoke(this.object, "getHostByAddr", addr);
        }
    }
}

