/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.util;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class SimpleRateLimiter {
    private final LongAdder skip = new LongAdder();
    private long allowTimesPerNanos;
    private volatile long lastAcquiredNanos;

    private SimpleRateLimiter(long allowTimesPerNanos) {
        Preconditions.checkState((allowTimesPerNanos > 0L ? 1 : 0) != 0);
        this.allowTimesPerNanos = allowTimesPerNanos;
    }

    public static SimpleRateLimiter createByPeriod(Duration periodPerTimes) {
        return new SimpleRateLimiter(((Duration)Preconditions.checkNotNull((Object)periodPerTimes)).toNanos());
    }

    public static SimpleRateLimiter create(double permitsPerSecond) {
        Preconditions.checkState((permitsPerSecond > 0.0 ? 1 : 0) != 0);
        long allowTimesPerNanos = (long)((double)TimeUnit.SECONDS.toNanos(1L) / permitsPerSecond);
        return new SimpleRateLimiter(allowTimesPerNanos);
    }

    public void setRate(double permitsPerSecond) {
        Preconditions.checkState((permitsPerSecond > 0.0 ? 1 : 0) != 0);
        long thisPeriod = (long)((double)TimeUnit.SECONDS.toNanos(1L) / permitsPerSecond);
        Preconditions.checkState((thisPeriod > 0L ? 1 : 0) != 0);
        this.allowTimesPerNanos = thisPeriod;
    }

    public void setPeriod(Duration periodPerTimes) {
        long thisPeriod = ((Duration)Preconditions.checkNotNull((Object)periodPerTimes)).toNanos();
        Preconditions.checkState((thisPeriod > 0L ? 1 : 0) != 0);
        this.allowTimesPerNanos = thisPeriod;
    }

    long getAllowTimesPerNanos() {
        return this.allowTimesPerNanos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryAcquire() {
        long nanoTime = System.nanoTime();
        if (nanoTime >= this.lastAcquiredNanos + this.allowTimesPerNanos || this.lastAcquiredNanos == 0L) {
            SimpleRateLimiter simpleRateLimiter = this;
            synchronized (simpleRateLimiter) {
                if (nanoTime >= this.lastAcquiredNanos + this.allowTimesPerNanos || this.lastAcquiredNanos == 0L) {
                    this.lastAcquiredNanos = nanoTime;
                    return true;
                }
            }
        }
        this.skip.increment();
        return false;
    }

    public long getSkipCountAndClear() {
        return this.skip.sumThenReset();
    }
}

