/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.util;

import com.github.phantomthief.util.StackTraceProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

class StackTraceProviderJdk8
implements StackTraceProvider {
    static final String[] REFLECTION_PREFIXES = new String[]{"sun.reflect.", "java.lang.reflect.", "jdk.internal.reflect."};

    StackTraceProviderJdk8() {
    }

    @Override
    @Nullable
    public StackTraceElement getCallerPlace(Predicate<String> locationAwareClassChecker, Predicate<String> ignore) {
        boolean afterSelf = false;
        boolean afterDeprecated = false;
        String deprecatedClass = null;
        for (StackTraceElement stack : new Exception().getStackTrace()) {
            String stackClassName = stack.getClassName();
            if (this.isReflection(stackClassName)) continue;
            if (locationAwareClassChecker.test(stackClassName)) {
                afterSelf = true;
                continue;
            }
            if (afterSelf && deprecatedClass == null) {
                deprecatedClass = stackClassName;
            }
            if (stackClassName.equals(deprecatedClass)) {
                afterDeprecated = true;
                continue;
            }
            if (!afterDeprecated || ignore.test(stackClassName)) continue;
            return stack;
        }
        return null;
    }

    private boolean isReflection(String stackClassName) {
        return StringUtils.startsWithAny((CharSequence)stackClassName, (CharSequence[])REFLECTION_PREFIXES);
    }

    private Set<String> toString(Class<?>[] locationAwareClasses) {
        int length = locationAwareClasses.length;
        if (length == 1) {
            return Collections.singleton(locationAwareClasses[0].getName());
        }
        HashSet<String> result = new HashSet<String>(length);
        for (Class<?> locationAwareClass : locationAwareClasses) {
            result.add(locationAwareClass.getName());
        }
        return result;
    }
}

