// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.calendar.v4.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.calendar.v4.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class EventLocation {
    /**
     * 地点名称
     * <p> 示例值：地点名称
     */
    @SerializedName("name")
    private String name;
    /**
     * 地点地址
     * <p> 示例值：地点地址
     */
    @SerializedName("address")
    private String address;
    /**
     * 地点坐标纬度信息，对于国内的地点，采用GCJ-02标准，海外地点采用WGS84标准
     * <p> 示例值：1.100000023841858
     */
    @SerializedName("latitude")
    private Double latitude;
    /**
     * 地点坐标经度信息，对于国内的地点，采用GCJ-02标准，海外地点采用WGS84标准
     * <p> 示例值：2.200000047683716
     */
    @SerializedName("longitude")
    private Double longitude;

    // builder 开始
    public EventLocation() {
    }

    public EventLocation(Builder builder) {
        /**
         * 地点名称
         * <p> 示例值：地点名称
         */
        this.name = builder.name;
        /**
         * 地点地址
         * <p> 示例值：地点地址
         */
        this.address = builder.address;
        /**
         * 地点坐标纬度信息，对于国内的地点，采用GCJ-02标准，海外地点采用WGS84标准
         * <p> 示例值：1.100000023841858
         */
        this.latitude = builder.latitude;
        /**
         * 地点坐标经度信息，对于国内的地点，采用GCJ-02标准，海外地点采用WGS84标准
         * <p> 示例值：2.200000047683716
         */
        this.longitude = builder.longitude;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    public static class Builder {
        /**
         * 地点名称
         * <p> 示例值：地点名称
         */
        private String name;
        /**
         * 地点地址
         * <p> 示例值：地点地址
         */
        private String address;
        /**
         * 地点坐标纬度信息，对于国内的地点，采用GCJ-02标准，海外地点采用WGS84标准
         * <p> 示例值：1.100000023841858
         */
        private Double latitude;
        /**
         * 地点坐标经度信息，对于国内的地点，采用GCJ-02标准，海外地点采用WGS84标准
         * <p> 示例值：2.200000047683716
         */
        private Double longitude;

        /**
         * 地点名称
         * <p> 示例值：地点名称
         *
         * @param name
         * @return
         */
        public Builder name(String name) {
            this.name = name;
            return this;
        }


        /**
         * 地点地址
         * <p> 示例值：地点地址
         *
         * @param address
         * @return
         */
        public Builder address(String address) {
            this.address = address;
            return this;
        }


        /**
         * 地点坐标纬度信息，对于国内的地点，采用GCJ-02标准，海外地点采用WGS84标准
         * <p> 示例值：1.100000023841858
         *
         * @param latitude
         * @return
         */
        public Builder latitude(Double latitude) {
            this.latitude = latitude;
            return this;
        }


        /**
         * 地点坐标经度信息，对于国内的地点，采用GCJ-02标准，海外地点采用WGS84标准
         * <p> 示例值：2.200000047683716
         *
         * @param longitude
         * @return
         */
        public Builder longitude(Double longitude) {
            this.longitude = longitude;
            return this;
        }


        public EventLocation build() {
            return new EventLocation(this);
        }
    }
}
