// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.corehr.v2.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.corehr.v2.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class SearchDepartmentReqBody {
    /**
     * 是否启用
     * <p> 示例值：true
     */
    @SerializedName("active")
    private Boolean active;
    /**
     * 当通过上级部门 ID 查询时，填写 true 返回所有子部门，填写 false 只返回直接下级部门
     * <p> 示例值：false
     */
    @SerializedName("get_all_children")
    private Boolean getAllChildren;
    /**
     * manager ID 列表;**字段权限要求：按照部门负责人搜索 (corehr:department.manager.search:read)**
     * <p> 示例值：
     */
    @SerializedName("manager_list")
    private String[] managerList;
    /**
     * 部门 ID 列表
     * <p> 示例值：
     */
    @SerializedName("department_id_list")
    private String[] departmentIdList;
    /**
     * 部门名称列表，需精确匹配
     * <p> 示例值：
     */
    @SerializedName("name_list")
    private String[] nameList;
    /**
     * 上级部门 ID ，可查询直接下级部门;**字段权限要求：按照上级部门搜索 (corehr:department.organize.search:read) **
     * <p> 示例值：7094136522860922222
     */
    @SerializedName("parent_department_id")
    private String parentDepartmentId;
    /**
     * 部门 code 列表
     * <p> 示例值：
     */
    @SerializedName("code_list")
    private String[] codeList;
    /**
     * 返回数据的字段列表
     * <p> 示例值：
     */
    @SerializedName("fields")
    private String[] fields;

    // builder 开始
    public SearchDepartmentReqBody() {
    }

    public SearchDepartmentReqBody(Builder builder) {
        /**
         * 是否启用
         * <p> 示例值：true
         */
        this.active = builder.active;
        /**
         * 当通过上级部门 ID 查询时，填写 true 返回所有子部门，填写 false 只返回直接下级部门
         * <p> 示例值：false
         */
        this.getAllChildren = builder.getAllChildren;
        /**
         * manager ID 列表;**字段权限要求：按照部门负责人搜索 (corehr:department.manager.search:read)**
         * <p> 示例值：
         */
        this.managerList = builder.managerList;
        /**
         * 部门 ID 列表
         * <p> 示例值：
         */
        this.departmentIdList = builder.departmentIdList;
        /**
         * 部门名称列表，需精确匹配
         * <p> 示例值：
         */
        this.nameList = builder.nameList;
        /**
         * 上级部门 ID ，可查询直接下级部门;**字段权限要求：按照上级部门搜索 (corehr:department.organize.search:read) **
         * <p> 示例值：7094136522860922222
         */
        this.parentDepartmentId = builder.parentDepartmentId;
        /**
         * 部门 code 列表
         * <p> 示例值：
         */
        this.codeList = builder.codeList;
        /**
         * 返回数据的字段列表
         * <p> 示例值：
         */
        this.fields = builder.fields;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public Boolean getGetAllChildren() {
        return this.getAllChildren;
    }

    public void setGetAllChildren(Boolean getAllChildren) {
        this.getAllChildren = getAllChildren;
    }

    public String[] getManagerList() {
        return this.managerList;
    }

    public void setManagerList(String[] managerList) {
        this.managerList = managerList;
    }

    public String[] getDepartmentIdList() {
        return this.departmentIdList;
    }

    public void setDepartmentIdList(String[] departmentIdList) {
        this.departmentIdList = departmentIdList;
    }

    public String[] getNameList() {
        return this.nameList;
    }

    public void setNameList(String[] nameList) {
        this.nameList = nameList;
    }

    public String getParentDepartmentId() {
        return this.parentDepartmentId;
    }

    public void setParentDepartmentId(String parentDepartmentId) {
        this.parentDepartmentId = parentDepartmentId;
    }

    public String[] getCodeList() {
        return this.codeList;
    }

    public void setCodeList(String[] codeList) {
        this.codeList = codeList;
    }

    public String[] getFields() {
        return this.fields;
    }

    public void setFields(String[] fields) {
        this.fields = fields;
    }

    public static class Builder {
        /**
         * 是否启用
         * <p> 示例值：true
         */
        private Boolean active;
        /**
         * 当通过上级部门 ID 查询时，填写 true 返回所有子部门，填写 false 只返回直接下级部门
         * <p> 示例值：false
         */
        private Boolean getAllChildren;
        /**
         * manager ID 列表;**字段权限要求：按照部门负责人搜索 (corehr:department.manager.search:read)**
         * <p> 示例值：
         */
        private String[] managerList;
        /**
         * 部门 ID 列表
         * <p> 示例值：
         */
        private String[] departmentIdList;
        /**
         * 部门名称列表，需精确匹配
         * <p> 示例值：
         */
        private String[] nameList;
        /**
         * 上级部门 ID ，可查询直接下级部门;**字段权限要求：按照上级部门搜索 (corehr:department.organize.search:read) **
         * <p> 示例值：7094136522860922222
         */
        private String parentDepartmentId;
        /**
         * 部门 code 列表
         * <p> 示例值：
         */
        private String[] codeList;
        /**
         * 返回数据的字段列表
         * <p> 示例值：
         */
        private String[] fields;

        /**
         * 是否启用
         * <p> 示例值：true
         *
         * @param active
         * @return
         */
        public Builder active(Boolean active) {
            this.active = active;
            return this;
        }


        /**
         * 当通过上级部门 ID 查询时，填写 true 返回所有子部门，填写 false 只返回直接下级部门
         * <p> 示例值：false
         *
         * @param getAllChildren
         * @return
         */
        public Builder getAllChildren(Boolean getAllChildren) {
            this.getAllChildren = getAllChildren;
            return this;
        }


        /**
         * manager ID 列表;**字段权限要求：按照部门负责人搜索 (corehr:department.manager.search:read)**
         * <p> 示例值：
         *
         * @param managerList
         * @return
         */
        public Builder managerList(String[] managerList) {
            this.managerList = managerList;
            return this;
        }


        /**
         * 部门 ID 列表
         * <p> 示例值：
         *
         * @param departmentIdList
         * @return
         */
        public Builder departmentIdList(String[] departmentIdList) {
            this.departmentIdList = departmentIdList;
            return this;
        }


        /**
         * 部门名称列表，需精确匹配
         * <p> 示例值：
         *
         * @param nameList
         * @return
         */
        public Builder nameList(String[] nameList) {
            this.nameList = nameList;
            return this;
        }


        /**
         * 上级部门 ID ，可查询直接下级部门;**字段权限要求：按照上级部门搜索 (corehr:department.organize.search:read) **
         * <p> 示例值：7094136522860922222
         *
         * @param parentDepartmentId
         * @return
         */
        public Builder parentDepartmentId(String parentDepartmentId) {
            this.parentDepartmentId = parentDepartmentId;
            return this;
        }


        /**
         * 部门 code 列表
         * <p> 示例值：
         *
         * @param codeList
         * @return
         */
        public Builder codeList(String[] codeList) {
            this.codeList = codeList;
            return this;
        }


        /**
         * 返回数据的字段列表
         * <p> 示例值：
         *
         * @param fields
         * @return
         */
        public Builder fields(String[] fields) {
            this.fields = fields;
            return this;
        }


        public SearchDepartmentReqBody build() {
            return new SearchDepartmentReqBody(this);
        }
    }
}
