// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.lingo.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.lingo.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class EntityCardData {
    /**
     * 根据请求的渲染类型进行渲染后的词条卡片数据
     * <p> 示例值：<view className="aslcard-baike-ultra-card larkw-aslCard-layout-flex aslcard-baike-container-outer without-copyperm-dom"   style='flex-direction: column; width: 100%; box-sizing: border-box; height: 100%; max-height: inherit; max-width: inherit;position: relative;'>   <style id="baike-card-external-ultra">     .aslcard-baike-container-outer {       min-width: 320px;     }      .abbreviation-cardItem_insearch .aslcard-baike-container-outer {       min-width: 100%;     }      .larkw-aslCard-card-container .larkw-aslCard-element-abbrnav-bar {       padding-top: 12px;     }      .larkw-aslCard-baikeCard .larkw-aslCard-showInLark {       display: none;     }      .larkw-aslCard-baikeCard-inLark .larkw-aslCard-showInLark {       display: block;     }      .larkw-aslCard-baikeCard-inLark .larkw-aslCard-footer-ignoreBtn {       display: none;     }      .list-item-avatar {       margin-right: 8px;       flex-shrink: 0;       overflow: hidden;       border-radius: 8px;     }      .list-item-avatar-bg {       background-color: @primary-pri-100;     }      .list-item-title {       overflow: hidden;       text-overflow: ellipsis;       white-space: nowrap;       color: @text-title;     }      .list-item-title.larkw-aslCard-text-link-button {       margin-left: -2px;     }      .larkw-aslCard-text-link-button {       padding: 0 4px;       transition: none;       border-radius: 6px;     }      .larkw-aslCard-text-link-button:hover {       color: @text-link-normal;     }      .larkw-aslCard-text-link-button:active {       color: @text-link-pressed;     }      .larkw-aslCard-baike-header {}      .larkw-aslCard-baikeCard-actions-icon .universe-icon {       font-size: 16px;     }      .baikeSectionHeader {       width: 100%;       box-sizing: border-box;       padding-left: 16px;     }      .baikeSectionHeaderInner {       padding: 8px 0;       flex-shrink: 0;       font-size: 12px;       margin-right: 4px;       line-height: 20px;       color: @text-caption;     }      .larkw-aslCard-ig .larkw-aslCard-element-abbrnav-bar {       padding: 18px 0 10px 0;       margin-left: -4px;     }      .abbreviation-cardItem_insearch .larkw-aslCard-showInLarkSearch {       display: block;     }      .abbreviation-cardItem_insearch .larkw-aslCard-hideInLarkSearch {       display: none;     }      .abbreviation-cardItem_insearch .larkw-aslCard-icon-mask.larkw-aslCard-baikeCard-actions-icon:not(:last-child),     .abbreviation-cardItem_insearch .larkw-aslCard-icon-mask:not(:last-child) {       display: none;     }      .baike-card-link-item .larkw-aslCard-element-image-fallback,     .baike-card-link-item .larkw-aslCard-element-plImage-placeholder {       background-color: @primary-pri-100;     }      .baike-card-link-item-default {       display: flex;       justify-content: center;       align-items: center;       background-color: @primary-pri-100;        color: @text-link-normal;     }      .larkw-aslCard-text-link-ig:hover {       color: @text-link-hover;     }      .larkw-aslCard-text-link-ig:active {       color: @text-link-pressed;     }      .larkw-aslCard-abbrClassify-tag .ud__tag__content {       max-width: 100px;       overflow: hidden;       text-overflow: ellipsis;       white-space: nowrap;     }      .larkw-aslCard-layout-block.larkw-abbreviation-content {       padding: 0;       box-sizing: inherit;     }      .larkw-abbreviation-content {       border-radius: 10px;     }      .list-item-avatar-user .ud__avatar {       height: 24px !important;       width: 24px !important;     }      .lux-ellipsis-line {       overflow: hidden;       text-overflow: ellipsis;       white-space: nowrap;       min-width: 50px;     }      .ud__menu-normal-item-title-content.ud__menu-normal-item-title-content-text-overflow {       white-space: nowrap;       overflow: hidden;       text-overflow: ellipsis;     }      .asl-section-description .larkw-aslCard-element-text {       white-space: pre-wrap;       word-break: break-word;     }      .abbreviation-cardItem_insearch .larkw-aslCard-element-image-set .image-cell {       width: 9.18vw;       height: 9.18vw;     }      .larkw-aslCard-element-rich-text .larkw-aslCard-element-link,      .larkw-aslCard-element-rich-text .larkw-aslCard-element-richlink {       margin: 0px !important;       padding: 3px 2px;       display: inline;     }      .larkw-aslCard-element-rich-text .larkw-aslCard-element-abbreviation {       display: inline;       cursor: pointer;       line-height: 20px;       position: relative;       border-bottom-style: solid;       border-width: 1px;       border-image-slice: 1;       border-image-source: repeating-linear-gradient(90deg, @N650 0, @N650 1px, transparent 0, transparent 3px);     }     .larkw-aslCard-element-rich-text .larkw-aslCard-element-abbreviation:hover,     .larkw-aslCard-element-rich-text .larkw-aslCard-element-abbreviation:active {       border-bottom-color: @B500;     }      .larkw-aslCard-element-rich-text .larkw-aslCard-element-abbreviation:hover {       color: @B500;       border-image-source: repeating-linear-gradient(90deg, @B500 0, @B500 1px, transparent 0, transparent 3px);     }      .larkw-aslCard-element-at {       color: @text-link-normal !important;     }      .main-key-content {       width: fit-content;       padding-bottom: 4px;     }      .main-key-tooltip {       cursor: pointer;     }      .main-key-tooltip:hover {       .larkw-aslCard-element-text {         color: @text-link-hover !important;       }     }      .larkw-aslCard-baikecard-feedback .panel {       display: flex;       flex-wrap: wrap;       grid-template-columns: unset;       grid-template-rows: unset;        .capsule {         min-width: 183px;          .capsule-text {           overflow: hidden;           text-overflow: ellipsis;         }       }     }   </style>    <style id="aslcard_theme_ultra">     .ai-popup-portal .ai-popup-wrapper {       border: none;       overflow: inherit;       box-shadow: @shadow-s4-down;     }      .larkw-aslCard-util-bg-ultra {       background-repeat: no-repeat;       background-position: 0 0;       background-size: 100% 143px;     }      .larkw-aslCard-card-theme-LIGHT .larkw-aslCard-util-bg-ultra {       background-image: url(https://lf-cdn-tos.bytescm.com/obj/static/asl-card/lm-min-ultra.png?time=202209222)     }      .larkw-aslCard-card-theme-DARK .larkw-aslCard-util-bg-ultra {       background-image: url(https://lf-cdn-tos.bytescm.com/obj/static/asl-card/dm-min-ultra.png?time=202209222)     }      .aslcard-ellipsis {       overflow: hidden;       text-overflow: ellipsis;       white-space: nowrap;     }      .aslcard-baike-section-ultra {       padding: 6px 0px;     }      .asl-baikeultra-section-title {       font-weight: 500;       font-size: 12px;        line-height: 22px;       display: flex;       align-items: center;       padding: 4px 20px;       color: @text-title;        .section-subTitle {         color: @text-caption;         font-weight: 400;         padding-left: 2px;       }     }      .asl-baikeultra-list-item {       padding: 6px 20px;       display: flex;       align-items: center;        .item-tag-md {         margin-left: 4px;       }     }      .aslcard-baike-btn {       display: flex;       align-items: center;       justify-content: center;       border-radius: 6px;       cursor: pointer;     }      .aslcard-baike-btn:hover {       background-color: @fill-hover;     }      .aslcard-baike-btn-extra-small {       height: 24px;       padding: 0 2px;     }      .aslcard-baike-btn-logo {}      .aslcard-baike-category-item {       margin: 4px 8px 4px 0px;       position: relative;       cursor: pointer;       line-height: 20px;       display: flex;        .category-tag-icon {         position: absolute;         right: 6px;         display: flex;         color: @udtoken-tag-text-blue;       }        .aslcard-baike-tag-md {         font-size: 12px;         font-weight: 400;         color: @udtoken-tag-text-blue;         background-color: @udtoken-tag-bg-blue;         cursor: pointer;         padding-right: 17px;       }     }      .aslcard-baike-category-item: hover {       .aslcard-baike-tag-md {         background-color: @udtoken-tag-bg-blue-hover;       }     }      .aslcard-baike-btn-bg-primary {       cursor: pointer;       background-color: @primary-pri-50;     }      .aslcard-baike-btn-bg-primary:hover {       background-color: @primary-pri-100;     }      .aslcard-baike-btn-bg-primary:active {       background-color: @primary-pri-200;     }      .aslcard-baike-divider {       height: 1px;       background-color: @line-divider-default;       transform: scaleY(0.5);     }      .aslcard-baike-navbar {       user-select: none;       box-sizing: border-box;       background-color: @bg-float;       border-radius: 10px 10px 0 0;       position: absolute;       width: 100%;       z-index: 3;       overflow: hidden;       height: 56px;       opacity: 0;       pointer-events: none;     }      .aslcard-baike-navbar-content {       width: 100%;       height: 22px;       display: flex;       align-items: center;       border-radius: 10px 10px 0 0;       overflow: hidden;     }      .aslcard-baike-navbar-noback {       box-sizing: border-box;       padding: 0px 20px;       height: 22px;     }      .aslcard-baike-navbar-withback {       justify-content: center;       display: none;     }      .larkw-aslCard-baikeCard-scrolled .aslcard-baike-navbar {       opacity: 1;       pointer-events: auto;       padding-top: 21px;       transition: opacity 0.15s;     }      .aslcard-baike-navbar-goback-btn {       display: none;       position: absolute;       top: 20px;       left: 16px;       z-index: 3;     }      .aslcard-baike-nav-placeloader {       display: none;       height: 28px;       width: 100%;     }      .larkw-aslCard-baikeCard-withgoback .aslcard-baike-navbar-goback-btn {       display: flex;     }      .larkw-aslCard-baikeCard-withgoback .aslcard-baike-navbar-noback {       display: none;     }      .larkw-aslCard-baikeCard-withgoback.larkw-aslCard-baikeCard-scrolled .aslcard-baike-navbar-withback {       display: flex;     }      .larkw-aslCard-baikeCard-withgoback .aslcard-baike-nav-placeloader {       display: block;     }      .larkw-aslCard-element-abbrmultidesc .abbrmultidesc-list {       max-height: 150px;       overflow: hidden auto;       margin-left: -8px;       margin-right: -8px;     }      .larkw-aslCard-element-abbrmultidesc .abbrmultidesc-item-content {       overflow: hidden;       text-overflow: ellipsis;       display: -webkit-box;       -webkit-line-clamp: 2;       -webkit-box-orient: vertical;     }      .abbreviation-cardItem_insearch {       border-radius: 8px;     }      .abbreviation-cardItem_insearch .larkw-aslCard-card-theme-LIGHT .larkw-aslCard-util-bg-ultra,     .abbreviation-cardItem_insearch .larkw-aslCard-card-theme-DARK .larkw-aslCard-util-bg-ultra {       background-image: none;     }      .larkw-aslCard-element-userlistV2 {       margin-left: -4px;     }      .aslcard-baike-logo-btn-img {       display: flex;       transition: background-image 0.15s;     }      .aslcard-baike-logo-btn-img-placeholder {       opacity: 0;     }      .aslcard-baike-logo-btn {       color: @icon-n3;              .repo_name {         color: @text-placeholder;         font-size: 12px;         padding-left: 0px;         overflow: hidden;         text-overflow: ellipsis;         white-space: nowrap;         font-weight: 600;       }     }      .aslcard-baike-logo-btn:hover {       color: @icon-n2;        .repo_name {         color: @text-title;       }     }      .aslcard-baike-logo-btn .aslcard-baike-logo-btn-img {       background-image: url(https://lf-cdn-tos.bytescm.com/obj/static/asl-card/baike-logo-gray-lm_zh-CN_v2.svg);     }      .aslcard-baike-logo-btn:hover .aslcard-baike-logo-btn-img {       background-image: url(https://lf-cdn-tos.bytescm.com/obj/static/asl-card/baike-logo-colorful-lm_zh-CN_v2.svg);     }      .larkw-aslCard-card-theme-DARK .aslcard-baike-logo-btn .aslcard-baike-logo-btn-img {       background-image: url(https://lf-cdn-tos.bytescm.com/obj/static/asl-card/baike-logo-gray-dm_zh-CN_v2.svg);     }      .larkw-aslCard-card-theme-DARK .aslcard-baike-logo-btn:hover .aslcard-baike-logo-btn-img {       background-image: url(https://lf-cdn-tos.bytescm.com/obj/static/asl-card/baike-logo-colorful-dm_zh-CN_v2.svg);     }      .larkw-aslCard-element-userlistV2-content .aslcard-barike-ultra-useritem:not(:last-child) {       margin-right: 4px;     }      .larkw-aslCard-element-userlistV2-hint .username {       overflow: hidden;       text-overflow: ellipsis;       white-space: nowrap;       max-width: 144px;     }      .aslcard-baike-ultra-card .larkw-aslCard-footer-dislike-button .universe-icon.larkw-aslCard-footer-like-icon {       color: @icon-n3;     }      .larkw-aslCard-element-abbrmultidesc .abbrmultidesc-list {       padding-bottom: 4px;       max-height: 144px;       overflow: hidden overlay;       margin-left: -5px;       margin-right: -5px;     }      .larkw-aslCard-element-abbrmultidesc .abbrmultidesc-item {       line-height: 18px;       padding: 7px 5px 7px 18px;     }      .larkw-aslCard-element-abbrmultidesc .abbrmultidesc-item-active {       color: @text-title;     }      .larkw-aslCard-element-abbrmultidesc .abbrmultidesc-item-visited {       color: @text-title;     }      .larkw-aslCard-element-abbrmultidesc .abbrmultidesc-item:before {       content: "";       position: absolute;       top: 13px;       border-radius: 50%;       left: 5px;       width: 6px;       height: 6px;       background-color: @icon-disabled;     }      .larkw-aslCard-element-abbrmultidesc .abbrmultidesc-item-active:before {       background-color: @B500;     }      .larkw-aslCard-element-abbrmultidesc div.abbrmultidesc-item {       padding: 7px 5px 7px 18px;     }      .larkw-aslCard-element-abbrmultidesc .abbrmultidesc-item .abbrmultidesc-item-content {       padding: 0;     }      .larkw-aslCard-element-abbrmultidesc .abbrmultidesc-item-pinItem {       margin-right: -5px;     }      .abbrmultidesc-list::-webkit-scrollbar-thumb:hover {       background-color: transparent !important;     }      .-container {       display: block;     }      .aslCard-baikeCard-alias-wrapper {       margin-top: 2px;       .aslCard-baikeCard-alias {         color: @text-caption;         font-size: 14px;         line-height: 22px;       }     }      .ellipsis-two-line {       overflow: hidden;       text-overflow: ellipsis;       display: -webkit-box;       -webkit-line-clamp: 2;       -webkit-box-orient: vertical;     }      .ellipsis-one-line {       overflow: hidden;       text-overflow: ellipsis;       display: -webkit-box;       -webkit-line-clamp: 1;       -webkit-box-orient: vertical;     }          .larkw-aslCard-element-abbrmultidescv2 .abbrmultidescv2-list-wrapper {       user-select: none;       max-height: 128px;     }      .larkw-aslCard-element-abbrmultidescv2 .abbrmultidescv2-list-unexpanded {       max-height: 0px !important;     }          .abbrmultidescv2-list.aslcard-baikecard-scrollarea::-webkit-scrollbar {       display: none;     }      .larkw-aslCard-section-title {       display: flex;       justify-content: space-between;       border-radius: 6px;       padding-right: -4px;        .title-right-btn {         margin-right: -4px;         display: flex;         flex-direction: row;         align-items: center;         cursor: pointer;         color: @text-caption;         font-size: 12px;         font-weight: 400;         height: 20px;         line-height: 20px;         padding: 0px 4px;         border-radius: 6px;       }        .title-right-btn.related-docs-title {           display: none;       }        .title-right-btn: hover{          background-color:  @fill-hover;       }     }      .larkw-aslCard-recommend-docs-entry-show {       .larkw-aslCard-section-title {         .title-right-btn.related-docs-title {           display: flex;         }       }     }       .larkw-aslCard-folder-container-normal-button {       padding: 4px 0px 4px 16px;        .folder-option {         padding: 0px 4px;       }     }      .larkw-aslCard-folder-container-link-button {       right: 0px;     }          .aslcard-baike-showEntry-section {       margin-left: 12px !important;       margin-right: 12px !important;        .aslcard-baike-relatedWords-showEntry:hover {         background-color: @bg-float-overlay;;         cursor: pointer;       }        .asl-baikeultra-section-title {         padding:4px 8px;       }        .larkw-aslCard-layout-block {         padding:0px 8px;          .larkw-aslCard-folder-container-normal-button {            padding-left: 0px;         }       }        .larkw-aslCard-folder-container-normal-button {         padding-left: 8px;       }     }      .larkw-aslCard-relatedWord-block {         width: 100%;         margin-bottom: 2px;                  .larkw-aslCard-relatedWord-block-title {           color: @text-caption;           font-size: 12px;           line-height: 20px;           display: flex;           align-items: center;           margin-bottom: 4px;         }          .larkw-aslCard-relatedWord-block-content{           display: flex;           flex-wrap: wrap;         }     }      .larkw-aslCard-relatedWord-block:last-child {         padding-bottom: 0px;     }      .like-kit {       display: flex;       flex-direction: row;     }      .larkw-aslCard-scrollbar::-webkit-scrollbar {       display: none;     }      .abbrmultidescv2-item-active .abbrmultidescv2-item-pinItem {       opacity: 1 !important;     }      .aslcard-baike-fotter-icon {       width: 24px;       height: 24px;       border-radius: 8px;       cursor: pointer;       align-items:center;        justify-content: center;       display: flex;       color: @icon-n3;       margin-left: 4px;     }      .aslcard-baike-fotter-icon:hover {       background-color: @udtoken-btn-text-bg-neutral-hover;;     }    </style>    <style id="aslcard_qa">     .aslcard-baike-relatedQASection {         .show-one-line {           height:          }          .relatedQA-page-entry: hover {            background-color:  @fill-hover;         }          .larkw-aslCard-QA-item {           display: flex;           flex-direction: row;           padding: 6px 8px;           border-radius: 6px;           cursor: pointer;            .QA_content {             width: 100%;                          .larkw-aslCard-element-rich-text {               white-space: nowrap;               overflow: hidden;               text-overflow: ellipsis;               display: inline-block;               width: calc(100% - 34px);               height: 22px;               pointer: cursor;                span {                 white-space: nowrap;               }             }              .Q_content,             .A_content {               height: 22px;               line-height:22px;               align-items: center;               display: flex;               flex-direction: row;               padding: 1px 0px;                .QA_icon {                 width: 20px;                 height: 20px;                 line-height: 20px;                 text-align: center;                 border-radius: 6px;                 margin-right:10px;                 font-size: 12px;               }                .Q_icon {                 background-color: @primary-pri-100;                 color: @primary-pri-500;               }                .A_icon {                 background-color: @function-warning-100;                 color: @function-warning-600;               }             }              .no_answer {               font-size: 14px;               line-height: 20px;               color: @text-caption;               display: flex;               align-items: center;                .to_answer {                 font-size: 14px;               }             }         }       }           .larkw-aslCard-QA-item: hover {           background-color:  @fill-hover;         }     }     .to_answer {       color: @text-link-normal;       border-radius: 6px;       padding: 0px 4px;       font-size: 12px;       line-height: 20px;       height: 20px;       cursor: pointer;     }      .to_answer:hover {       color: @text-link-normal;       background-color: @fill-active;     }      .to_answer:active {       color: @text-link-pressed;       background-color: @fill-active;     }      .to-answer-related-users,     .to-answer-contributors {       display: flex;       flex-direction: row;       font-size: 12px;       line-height: 20px;       color: @text-caption;       cursor: pointer;       width: fit-content;       flex-wrap: wrap;     }    </style>    <style id="aslcard-related-words">     .larkw-aslCard-relatedWords-wrapper {       padding: 0px 16px;       .larkw-aslCard-relatedWords-calssfication-item {         padding:4px 4px 0px 4px !important;         .title {           margin-bottom: 4px;           height: auto;            .title-text {             margin-bottom: 0px;             flex: 1;           }         }         .abbreviation-item {           margin: 0px 6px 6px 0px;         }       }        .larkw-aslCard-folder-container-normal-button {         padding-left: 0px !important;       }     }   </style>    <style id="abbrmulti-desc-v2">     .larkw-aslCard-element-abbrmultidescv2 {       .abbrmultidescv2-header-topline {         margin: 2px 0px;       }        .abbrmultidescv2-header {         padding: 4px 0px;       }        .abbrmultidescv2-item-content {          padding: 4px 0px;       }     }      .aslcard-baike-divider {       margin: 4px 0px;     }   </style>    <view className="aslcard-baike-navbar">     <view className="aslcard-baike-navbar-content aslcard-baike-navbar-noback" style="width: calc(100% - 64px);">       <text-highlight className="ellipsis-one-line" style="font-weight: 500;font-size: 14px;"  text="Ai"  highlightTerms='[]'/>     </view>     <view className="aslcard-baike-navbar-content aslcard-baike-navbar-withback">       <text style="font-weight: 500;font-size: 14px; max-width: 120px;" className="aslcard-ellipsis">Ai</text>     </view>     <view className="aslcard-baike-divider" style="position: absolute;bottom: 0;width: 100%;"></view>   </view>   <view className="aslcard-baike-navbar-goback-btn">     <tooltip title="返回">       <view className="larkw-aslCard-icon-mask" style="color: @icon-n1;" bind='{"onClick": {         "callbacks": [           {             "funcName": "back",             "params":{}           }         ]}       }'>         <image>           <svg width="16" height="16" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg">             <path               d="M12.2197 1.71967C12.5126 2.01256 12.5126 2.48744 12.2197 2.78033L6 9L12.2197 15.2197C12.5126 15.5126 12.5126 15.9874 12.2197 16.2803C11.9268 16.5732 11.4519 16.5732 11.159 16.2803L4.93934 10.0607C4.35355 9.47487 4.35355 8.52513 4.93934 7.93934L11.159 1.71967C11.4519 1.42678 11.9268 1.42678 12.2197 1.71967Z"               fill="currentColor" />           </svg>          </image>       </view>     </tooltip>   </view>   <view style="position: absolute;top: 20px;right: 16px;z-index: 3;">     <abbr-action-v2 data-tootip-more-title="更多">         <action shareModelTitle="分享到会话" showOut="true" type="share" text="分享" url="https://ai.feishu-boe.cn/lingo/detail/7233732879589572628?open_source&#x3D;im_share_card" tooltip=""           className="abbr_share_icon" subscribed=""           text-unsubscribe="取消订阅"           data-tooltip-subscribed-text="订阅后，将会通过订阅号推送词条下的新增文档"           data-tooltip-not-subscribed-text="取消订阅后，将不会再收到相关推送"           data-toast-subscribe="订阅成功，将会通过订阅号推送词条下的新增文档"           data-toast-unsubscribe="取消订阅后，将不会再收到相关推送"           data-ignore-success-toast="已关闭词条下划线提示"          />         <action shareModelTitle="" showOut="" type="abbr_home" text="查看词条详情" url="https://ai.feishu-boe.cn/lingo/detail/7233732879589572628?open_source&#x3D;card_entity_home" tooltip=""           className="abbr_detail_home_icon" subscribed=""           text-unsubscribe="取消订阅"           data-tooltip-subscribed-text="订阅后，将会通过订阅号推送词条下的新增文档"           data-tooltip-not-subscribed-text="取消订阅后，将不会再收到相关推送"           data-toast-subscribe="订阅成功，将会通过订阅号推送词条下的新增文档"           data-toast-unsubscribe="取消订阅后，将不会再收到相关推送"           data-ignore-success-toast="已关闭词条下划线提示"          />         <action shareModelTitle="" showOut="false" type="edit" text="编辑词条" url="https://ai.feishu-boe.cn/lingo/editor?locale&#x3D;zh-CN&amp;abbrId&#x3D;enterprise_7233732879589572628&amp;query&#x3D;Ai&amp;open_source&#x3D;card_entity_editor" tooltip=""           className="" subscribed=""           text-unsubscribe="取消订阅"           data-tooltip-subscribed-text="订阅后，将会通过订阅号推送词条下的新增文档"           data-tooltip-not-subscribed-text="取消订阅后，将不会再收到相关推送"           data-toast-subscribe="订阅成功，将会通过订阅号推送词条下的新增文档"           data-toast-unsubscribe="取消订阅后，将不会再收到相关推送"           data-ignore-success-toast="已关闭词条下划线提示"          />         <action shareModelTitle="" showOut="" type="ignore" text="关闭词条下划线" url="" tooltip=""           className="" subscribed=""           text-unsubscribe="取消订阅"           data-tooltip-subscribed-text="订阅后，将会通过订阅号推送词条下的新增文档"           data-tooltip-not-subscribed-text="取消订阅后，将不会再收到相关推送"           data-toast-subscribe="订阅成功，将会通过订阅号推送词条下的新增文档"           data-toast-unsubscribe="取消订阅后，将不会再收到相关推送"           data-ignore-success-toast="已关闭词条下划线提示"          />         <action shareModelTitle="" showOut="" type="divider" text="" url="" tooltip=""           className="" subscribed=""           text-unsubscribe="取消订阅"           data-tooltip-subscribed-text="订阅后，将会通过订阅号推送词条下的新增文档"           data-tooltip-not-subscribed-text="取消订阅后，将不会再收到相关推送"           data-toast-subscribe="订阅成功，将会通过订阅号推送词条下的新增文档"           data-toast-unsubscribe="取消订阅后，将不会再收到相关推送"           data-ignore-success-toast="已关闭词条下划线提示"          />         <action shareModelTitle="" showOut="" type="create" text="创建词条" url="https://ai.feishu-boe.cn/lingo/editor?action&#x3D;create&amp;abbrId&#x3D;enterprise_7233732879589572628&amp;locale&#x3D;zh-CN&amp;open_source&#x3D;card_entity_create" tooltip=""           className="" subscribed=""           text-unsubscribe="取消订阅"           data-tooltip-subscribed-text="订阅后，将会通过订阅号推送词条下的新增文档"           data-tooltip-not-subscribed-text="取消订阅后，将不会再收到相关推送"           data-toast-subscribe="订阅成功，将会通过订阅号推送词条下的新增文档"           data-toast-unsubscribe="取消订阅后，将不会再收到相关推送"           data-ignore-success-toast="已关闭词条下划线提示"          />         <action shareModelTitle="" showOut="" type="home" text="前往词典首页" url="https://baikeredirect.feishu.cn/drive/lingo?locale&#x3D;zh-CN&amp;open_source&#x3D;card_web_tab" tooltip=""           className="" subscribed=""           text-unsubscribe="取消订阅"           data-tooltip-subscribed-text="订阅后，将会通过订阅号推送词条下的新增文档"           data-tooltip-not-subscribed-text="取消订阅后，将不会再收到相关推送"           data-toast-subscribe="订阅成功，将会通过订阅号推送词条下的新增文档"           data-toast-unsubscribe="取消订阅后，将不会再收到相关推送"           data-ignore-success-toast="已关闭词条下划线提示"          />     </abbr-action-v2>   </view>   <view     className="larkw-aslCard-layout-block baike_navbar_scrollbar_trigger larkw-abbreviation-content larkw-aslCard-scrollbar larkw-aslCard-scrollbar-hover"     style="max-height: inherit; max-width: inherit; overflow: hidden overlay;word-break: normal;"     canUseContributors="true">     <view className="larkw-aslCard-util-bg-ultra" id="larkw-aslCard-body-enterprise_7233732879589572628">       <view className="larkw-aslCard-layout-block larkw-aslCard-baike-header"         style='padding:24px 20px 0; position: relative;'>         <view className="aslcard-baike-nav-placeloader" />            <view              className="larkw-aslCard-layout-block main-key-content"              style="position: relative;width: 100%;"            >             <view className="larkw-aslCard-layout-inlineBlock" style='position: absolute; top: 0; right: 0;'>             </view>             <tooltip                title="进入词条详情页"                style="max-width:calc(100% - 64px);width:fit-content;"                className="main-key-tooltip"               bind='{"onClick":{                 "callbacks":[{"funcName":"openURL","params":{"url":"https://ai.feishu-boe.cn/lingo/detail/7233732879589572628?open_source&#x3D;card_entity_home"}}],                 "events":[{"eventName":"event_track_v2","params":{"click":"function","function_type":"entity_name"}}]               }}'             >                 <text-highlight locale="zh-CN" style="color: @text-title;font-size: 18px;font-weight: 500;line-height: 26px;margin-right: 8px;"  text="Ai"  highlightTerms='[]'/>             </tooltip>           </view>            <view className="larkw-aslCard-layout-flex" style="align-items: center;">             <user-list data-text-hint="贡献" version="v2" maxCountShow="2">                 <user userId="7215104701929357331" avatarKey="v2_98f36e28-20f7-4f32-889c-b926df7eb22j" tooltip="张晓阳"                   className="aslcard-barike-ultra-useritem" userName="张晓阳" size="24" style="">                 </user>               <user-rest                 style="margin-right: 8px;height: 24px;width: 24px;display: flex;align-items: center;justify-content: center;border-radius: 50%;background-color: #EFF0F1;color: @text-caption;cursor: pointer;margin-right: 0;margin-bottom: 0;">               </user-rest>             </user-list>             <image style="margin: 0px 2px 0px 6px">              <svg width="2" height="10" viewBox="0 0 2 10" fill="none" xmlns="http://www.w3.org/2000/svg">                 <path d="M1 0V10" stroke="#BBBFC4"/>               </svg>             </image>             <view               className="to_answer"               id="user-list-right-node"               bind='{"onClick":{               "callbacks":[{"funcName":"openURL","params":{"url":"https://ai.feishu-boe.cn/lingo/detail/7233732879589572628?anchor&#x3D;qaComment&amp;addQuestion&#x3D;true&amp;open_source&#x3D;ask_contributor"}}],               "events":[{"eventName":"event_track_v2","params":{"click":"function","function_type":"ask_contributor"}}]               }}'>               <text>提问</text>             </view>           </view>         </view>        <view className="larkw-aslCard-layout-block aslcard-baike-section-ultra" style="padding-top: 0px;">         <view className="larkw-aslCard-layout-block asl-section-description" style="padding:4px 20px;">             <text-highlight               bind='{                 "onUnFold": {"events":[{                   "eventName":"event_track_v2",                   "params":{"click":"function","function_type":"description_unfold"}                 }]}               }'               locale="zh-CN"                maxHeight="setMaxHeightVal folderSwitcher.canDescriptionFolder 66"                style="white-space: pre-wrap;word-break: break-word;"                text="人工智能是计算机科学的一个分支，它企图了解智能的实质，并生产出一种新的能以人类智能相似的方式做出反应的智能机器，该领域的研究包括机器人、语言识别、图像识别、自然语言处理和专家系统等。"                 highlightTerms='[&quot;&amp;#10&quot;]'             />         </view>       </view>         <async-template         hidden="false"         templateName="recommend_docs"         templateId="recommendRelatedDoc"         serviceName="getRelatedResource"         params='{"entryIds":["enterprise_7233732879589572628"],"resourceTypes":[1],"enterFrom":""}'       />          <view className="larkw-aslCard-layout-block larkw-aslCard-hideInLarkSearch larkw-aslCard-showInLark">          <view className="larkw-aslCard-layout-flex"           style='padding: 10px 20px;font-size: 12px;line-height: 20px;color: @text-caption;margin-bottom:14px;'>           <view style="display: flex;align-items: center;">             <text>找不到想要的信息？</text>             <view className="larkw-aslCard-layout-inlineBlock larkw-aslCard-text-link-button"               style="color: @text-link-normal;" bind='{"onClick":{         "callbacks":[{"funcName":"openLarkSearch","params":{"query":"Ai"}}],         "events":[{"eventName":"event_track_v2","params":{"click":"function","function_type":"search","abbr_id":"enterprise_7233732879589572628"}}]         }}'>               搜索更多             </view>           </view>         </view>       </view>          <view style="display: none;" role="for-debug"         data-canShowSuperAdminBanner=""         data-superAdminBannerHref=""         data-canShowNormalUserBanner="false"         data-normalUserBannerHref=""         data-IsUserSuperAdmin="nodata"         data-IsTenantActivated="nodata" />     </view>   </view>    <view className="aslcard-baike-footer">     <view className="aslcard-baike-divider" style="margin: 0 20px;">     </view>     <view       style="display: flex;align-items: center;justify-content: space-between;height: 46px;padding: 0 16px;flex-shrink: 0;">       <view className="aslcard-baike-logo-btn-container larkw-aslCard-layout-flex" style="max-width: calc(100% - 84px);">         <tooltip title="前往词典首页，探索更多词条" style="width: 100%">           <view className="aslcard-baike-btn aslcard-baike-btn-extra-small aslcard-baike-logo-btn"             url="https://baikeredirect.feishu.cn/drive/lingo?locale&#x3D;zh-CN&amp;from&#x3D;logo&amp;abbrId&#x3D;enterprise_7233732879589572628&amp;page&#x3D;category&amp;repo_id&#x3D;1&amp;open_source&#x3D;card_web_logo"             bind='{"onClick":{"events":[{"eventName":"event_track_v2","params":{"click":"function","function_type":"encyclopedia_logo","target":"asl_abbr_paltform_view","abbr_id":"enterprise_7233732879589572628"}}]}}'>             <view className="aslcard-baike-logo-btn-img" style="width: 21px; height: 17px;">               <image url="https://lf-cdn-tos.bytescm.com/obj/static/asl-card/baike-logo-gray-lm_zh-CN_v2.svg"                 className="aslcard-baike-logo-btn-img-placeholder"></image>             </view>             <text className="repo_name">企业词库</text>             <image>               <svg width="13" height="13" viewBox="0 0 13 13" fill="none" xmlns="http://www.w3.org/2000/svg">                 <path                   d="M4.65292 2.64645C4.45765 2.84171 4.45765 3.15829 4.65292 3.35355L7.79936 6.5L4.65292 9.64645C4.45765 9.84171 4.45765 10.1583 4.65292 10.3536C4.84818 10.5488 5.16476 10.5488 5.36002 10.3536L8.86002 6.85355C8.95379 6.75979 9.00647 6.63261 9.00647 6.5C9.00647 6.36739 8.95379 6.24021 8.86002 6.14645L5.36002 2.64645C5.16476 2.45118 4.84818 2.45118 4.65292 2.64645Z"                   fill="currentColor" />               </svg>             </image>           </view>         </tooltip>       </view>        <view className="like-kit">         <like-kit like-count='0' data-text-ignore-btn="关闭词条提示"           dislike-count='0' like="" dislike=""           data-text-feedback-title="反馈给贡献者"           data-text-feedback-success="反馈提交成功"           show-like="true"            show-dislike="false"         ></like-kit>         <tooltip title="我要反馈" className="aslcard-baike-fotter-icon">           <view  bind='{"onClick":{           "callbacks":[{"funcName":"openFeedback","params":{"title":"词条反馈"}}],           "events":[{"eventName":"event_track_v2","params":{"click":"function","function_type":"feedback_logo"}}]           }}' style="height: 16px;">             <image >               <svg width="14" height="16" viewBox="0 0 14 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg">                 <path d="M10.6667 1.99984H1.33333V13.9998H4.66667V15.3332H1.33333C0.596954 15.3332 0 14.7362 0 13.9998V1.99984C0 1.26346 0.596954 0.666504 1.33333 0.666504H10.6667C11.403 0.666504 12 1.26346 12 1.99984V7.33317H10.6667V1.99984Z" fill="currentColor"/>                 <path d="M3.33333 4.6665C2.96514 4.6665 2.66667 4.96498 2.66667 5.33317C2.66667 5.70136 2.96514 5.99984 3.33333 5.99984H8.66667C9.03486 5.99984 9.33333 5.70136 9.33333 5.33317C9.33333 4.96498 9.03486 4.6665 8.66667 4.6665H3.33333Z" fill="currentColor"/>                 <path d="M2.66667 8.33317C2.66667 7.96498 2.96514 7.6665 3.33333 7.6665H6C6.36819 7.6665 6.66667 7.96498 6.66667 8.33317C6.66667 8.70136 6.36819 8.99984 6 8.99984H3.33333C2.96514 8.99984 2.66667 8.70136 2.66667 8.33317Z" fill="currentColor"/>                 <path d="M11.5523 8.69999C11.9428 8.30946 12.576 8.30946 12.9665 8.69999C13.357 9.09051 13.357 9.72367 12.9665 10.1142L12.2594 10.8213L10.8452 9.40709L11.5523 8.69999Z" fill="currentColor"/>                 <path d="M10.1381 10.1142L11.5523 11.5284L8.23093 14.8498C8.09164 14.9891 7.91229 15.0813 7.71798 15.1136L6.45737 15.3233C6.42136 15.3292 6.38467 15.3175 6.35885 15.2917C6.33271 15.2655 6.32099 15.2282 6.32749 15.1918L6.55128 13.9372C6.58465 13.7501 6.6746 13.5777 6.80901 13.4433L10.1381 10.1142Z" fill="currentColor"/>               </svg>             </image>           </view>         </tooltip>           <tooltip title="相关讨论" className="aslcard-baike-fotter-icon">             <view  bind='{"onClick":{           "callbacks":[{"funcName":"openURL","params":{"url":"https://ai.feishu-boe.cn/lingo/detail/7233732879589572628?anchor&#x3D;qaComment&amp;open_source&#x3D;answers_logo"}}],           "events":[{"eventName":"event_track_v2","params":{"click":"function","function_type":"answers_logo"}}]           }}' style="height: 16px;">               <image >                 <svg width="16" height="16" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg">                 <path d="M3.66675 8.66634H2.00008V2.66634H10.6667V8.66634H6.33059L3.66675 10.8333V8.66634ZM6.66675 9.99968H10.6667C11.4031 9.99968 12.0001 9.40272 12.0001 8.66634V2.66634C12.0001 1.92996 11.4031 1.33301 10.6667 1.33301H2.00008C1.2637 1.33301 0.666748 1.92996 0.666748 2.66634V8.66634C0.666748 9.40272 1.2637 9.99968 2.00008 9.99968H2.33341V11.9495C2.33341 12.4539 2.87199 12.7756 3.31615 12.5365L6.66675 9.99968ZM8.99726 12.6667H5.34274L7.0094 11.3333H9.33341L12.0001 13.5V11.333H14.0001V5.99967H13.3334V4.66634H14.0001C14.7365 4.66634 15.3334 5.2633 15.3334 5.99967V11.333C15.3334 12.0694 14.7365 12.6663 14.0001 12.6663H13.3334V14.6162C13.3334 15.1206 12.7948 15.4423 12.3507 15.2031L8.99726 12.6667Z" fill="currentColor"/>                 </svg>               </image>             </view>           </tooltip>       </view>     </view>   </view>    <abbr-data-carrier id="abbr-data-carry-id" data-report-card-view='[{"result_type":"success"}]'></abbr-data-carrier>   <guide       data-options='{"key":"Lingo_card_share","style":{"zIndex":100,"width":"max-content"},"conf":[{"content":"词典支持分享词条啦！","target":".larkw-aslCard-moreactions-wrapper .abbr_share_icon","direction":"bottom","align":"center","distance":4,"clickBlankToDisappear":true,"autoFinishMs":5000}],"extraDaInfo":{"abbr_id":"enterprise_7233732879589572628","onboarding_type":"bubble","onboarding_sub_type":"entity_share"}}' >   </guide>   <guide        data-options='{"key":"Lingo_doc_homograph","style":{"zIndex":100,"width":"max-content"},"conf":[{"content":"点击置顶，在当前文档优先展示该释义","target":".abbrmultidescv2-item-pinItem .larkw-aslCard-icon-mask","direction":"top","align":"center","distance":4,"clickBlankToDisappear":true,"autoFinishMs":5000}],"extraDaInfo":{"abbr_id":"enterprise_7233732879589572628","onboarding_type":"bubble","onboarding_sub_type":"entity_pin"}}' >   </guide> </view>
     */
    @SerializedName("card")
    private String card;
    /**
     * 卡片对应词条的id
     * <p> 示例值：enterprise_7233732879589572628
     */
    @SerializedName("id")
    private String id;
    /**
     * 用户点击的高亮词条
     * <p> 示例值：Ai
     */
    @SerializedName("key")
    private String key;
    /**
     * 词条卡片类型
     * <p> 示例值：
     */
    @SerializedName("card_type")
    private Integer cardType;
    /**
     * 卡片模版名
     * <p> 示例值：abbreviation-ultra
     */
    @SerializedName("template_name")
    private String templateName;

    // builder 开始
    public EntityCardData() {
    }

    public EntityCardData(Builder builder) {
        /**
         * 根据请求的渲染类型进行渲染后的词条卡片数据
         * <p> 示例值：<view className="aslcard-baike-ultra-card larkw-aslCard-layout-flex aslcard-baike-container-outer without-copyperm-dom"   style='flex-direction: column; width: 100%; box-sizing: border-box; height: 100%; max-height: inherit; max-width: inherit;position: relative;'>   <style id="baike-card-external-ultra">     .aslcard-baike-container-outer {       min-width: 320px;     }      .abbreviation-cardItem_insearch .aslcard-baike-container-outer {       min-width: 100%;     }      .larkw-aslCard-card-container .larkw-aslCard-element-abbrnav-bar {       padding-top: 12px;     }      .larkw-aslCard-baikeCard .larkw-aslCard-showInLark {       display: none;     }      .larkw-aslCard-baikeCard-inLark .larkw-aslCard-showInLark {       display: block;     }      .larkw-aslCard-baikeCard-inLark .larkw-aslCard-footer-ignoreBtn {       display: none;     }      .list-item-avatar {       margin-right: 8px;       flex-shrink: 0;       overflow: hidden;       border-radius: 8px;     }      .list-item-avatar-bg {       background-color: @primary-pri-100;     }      .list-item-title {       overflow: hidden;       text-overflow: ellipsis;       white-space: nowrap;       color: @text-title;     }      .list-item-title.larkw-aslCard-text-link-button {       margin-left: -2px;     }      .larkw-aslCard-text-link-button {       padding: 0 4px;       transition: none;       border-radius: 6px;     }      .larkw-aslCard-text-link-button:hover {       color: @text-link-normal;     }      .larkw-aslCard-text-link-button:active {       color: @text-link-pressed;     }      .larkw-aslCard-baike-header {}      .larkw-aslCard-baikeCard-actions-icon .universe-icon {       font-size: 16px;     }      .baikeSectionHeader {       width: 100%;       box-sizing: border-box;       padding-left: 16px;     }      .baikeSectionHeaderInner {       padding: 8px 0;       flex-shrink: 0;       font-size: 12px;       margin-right: 4px;       line-height: 20px;       color: @text-caption;     }      .larkw-aslCard-ig .larkw-aslCard-element-abbrnav-bar {       padding: 18px 0 10px 0;       margin-left: -4px;     }      .abbreviation-cardItem_insearch .larkw-aslCard-showInLarkSearch {       display: block;     }      .abbreviation-cardItem_insearch .larkw-aslCard-hideInLarkSearch {       display: none;     }      .abbreviation-cardItem_insearch .larkw-aslCard-icon-mask.larkw-aslCard-baikeCard-actions-icon:not(:last-child),     .abbreviation-cardItem_insearch .larkw-aslCard-icon-mask:not(:last-child) {       display: none;     }      .baike-card-link-item .larkw-aslCard-element-image-fallback,     .baike-card-link-item .larkw-aslCard-element-plImage-placeholder {       background-color: @primary-pri-100;     }      .baike-card-link-item-default {       display: flex;       justify-content: center;       align-items: center;       background-color: @primary-pri-100;        color: @text-link-normal;     }      .larkw-aslCard-text-link-ig:hover {       color: @text-link-hover;     }      .larkw-aslCard-text-link-ig:active {       color: @text-link-pressed;     }      .larkw-aslCard-abbrClassify-tag .ud__tag__content {       max-width: 100px;       overflow: hidden;       text-overflow: ellipsis;       white-space: nowrap;     }      .larkw-aslCard-layout-block.larkw-abbreviation-content {       padding: 0;       box-sizing: inherit;     }      .larkw-abbreviation-content {       border-radius: 10px;     }      .list-item-avatar-user .ud__avatar {       height: 24px !important;       width: 24px !important;     }      .lux-ellipsis-line {       overflow: hidden;       text-overflow: ellipsis;       white-space: nowrap;       min-width: 50px;     }      .ud__menu-normal-item-title-content.ud__menu-normal-item-title-content-text-overflow {       white-space: nowrap;       overflow: hidden;       text-overflow: ellipsis;     }      .asl-section-description .larkw-aslCard-element-text {       white-space: pre-wrap;       word-break: break-word;     }      .abbreviation-cardItem_insearch .larkw-aslCard-element-image-set .image-cell {       width: 9.18vw;       height: 9.18vw;     }      .larkw-aslCard-element-rich-text .larkw-aslCard-element-link,      .larkw-aslCard-element-rich-text .larkw-aslCard-element-richlink {       margin: 0px !important;       padding: 3px 2px;       display: inline;     }      .larkw-aslCard-element-rich-text .larkw-aslCard-element-abbreviation {       display: inline;       cursor: pointer;       line-height: 20px;       position: relative;       border-bottom-style: solid;       border-width: 1px;       border-image-slice: 1;       border-image-source: repeating-linear-gradient(90deg, @N650 0, @N650 1px, transparent 0, transparent 3px);     }     .larkw-aslCard-element-rich-text .larkw-aslCard-element-abbreviation:hover,     .larkw-aslCard-element-rich-text .larkw-aslCard-element-abbreviation:active {       border-bottom-color: @B500;     }      .larkw-aslCard-element-rich-text .larkw-aslCard-element-abbreviation:hover {       color: @B500;       border-image-source: repeating-linear-gradient(90deg, @B500 0, @B500 1px, transparent 0, transparent 3px);     }      .larkw-aslCard-element-at {       color: @text-link-normal !important;     }      .main-key-content {       width: fit-content;       padding-bottom: 4px;     }      .main-key-tooltip {       cursor: pointer;     }      .main-key-tooltip:hover {       .larkw-aslCard-element-text {         color: @text-link-hover !important;       }     }      .larkw-aslCard-baikecard-feedback .panel {       display: flex;       flex-wrap: wrap;       grid-template-columns: unset;       grid-template-rows: unset;        .capsule {         min-width: 183px;          .capsule-text {           overflow: hidden;           text-overflow: ellipsis;         }       }     }   </style>    <style id="aslcard_theme_ultra">     .ai-popup-portal .ai-popup-wrapper {       border: none;       overflow: inherit;       box-shadow: @shadow-s4-down;     }      .larkw-aslCard-util-bg-ultra {       background-repeat: no-repeat;       background-position: 0 0;       background-size: 100% 143px;     }      .larkw-aslCard-card-theme-LIGHT .larkw-aslCard-util-bg-ultra {       background-image: url(https://lf-cdn-tos.bytescm.com/obj/static/asl-card/lm-min-ultra.png?time=202209222)     }      .larkw-aslCard-card-theme-DARK .larkw-aslCard-util-bg-ultra {       background-image: url(https://lf-cdn-tos.bytescm.com/obj/static/asl-card/dm-min-ultra.png?time=202209222)     }      .aslcard-ellipsis {       overflow: hidden;       text-overflow: ellipsis;       white-space: nowrap;     }      .aslcard-baike-section-ultra {       padding: 6px 0px;     }      .asl-baikeultra-section-title {       font-weight: 500;       font-size: 12px;        line-height: 22px;       display: flex;       align-items: center;       padding: 4px 20px;       color: @text-title;        .section-subTitle {         color: @text-caption;         font-weight: 400;         padding-left: 2px;       }     }      .asl-baikeultra-list-item {       padding: 6px 20px;       display: flex;       align-items: center;        .item-tag-md {         margin-left: 4px;       }     }      .aslcard-baike-btn {       display: flex;       align-items: center;       justify-content: center;       border-radius: 6px;       cursor: pointer;     }      .aslcard-baike-btn:hover {       background-color: @fill-hover;     }      .aslcard-baike-btn-extra-small {       height: 24px;       padding: 0 2px;     }      .aslcard-baike-btn-logo {}      .aslcard-baike-category-item {       margin: 4px 8px 4px 0px;       position: relative;       cursor: pointer;       line-height: 20px;       display: flex;        .category-tag-icon {         position: absolute;         right: 6px;         display: flex;         color: @udtoken-tag-text-blue;       }        .aslcard-baike-tag-md {         font-size: 12px;         font-weight: 400;         color: @udtoken-tag-text-blue;         background-color: @udtoken-tag-bg-blue;         cursor: pointer;         padding-right: 17px;       }     }      .aslcard-baike-category-item: hover {       .aslcard-baike-tag-md {         background-color: @udtoken-tag-bg-blue-hover;       }     }      .aslcard-baike-btn-bg-primary {       cursor: pointer;       background-color: @primary-pri-50;     }      .aslcard-baike-btn-bg-primary:hover {       background-color: @primary-pri-100;     }      .aslcard-baike-btn-bg-primary:active {       background-color: @primary-pri-200;     }      .aslcard-baike-divider {       height: 1px;       background-color: @line-divider-default;       transform: scaleY(0.5);     }      .aslcard-baike-navbar {       user-select: none;       box-sizing: border-box;       background-color: @bg-float;       border-radius: 10px 10px 0 0;       position: absolute;       width: 100%;       z-index: 3;       overflow: hidden;       height: 56px;       opacity: 0;       pointer-events: none;     }      .aslcard-baike-navbar-content {       width: 100%;       height: 22px;       display: flex;       align-items: center;       border-radius: 10px 10px 0 0;       overflow: hidden;     }      .aslcard-baike-navbar-noback {       box-sizing: border-box;       padding: 0px 20px;       height: 22px;     }      .aslcard-baike-navbar-withback {       justify-content: center;       display: none;     }      .larkw-aslCard-baikeCard-scrolled .aslcard-baike-navbar {       opacity: 1;       pointer-events: auto;       padding-top: 21px;       transition: opacity 0.15s;     }      .aslcard-baike-navbar-goback-btn {       display: none;       position: absolute;       top: 20px;       left: 16px;       z-index: 3;     }      .aslcard-baike-nav-placeloader {       display: none;       height: 28px;       width: 100%;     }      .larkw-aslCard-baikeCard-withgoback .aslcard-baike-navbar-goback-btn {       display: flex;     }      .larkw-aslCard-baikeCard-withgoback .aslcard-baike-navbar-noback {       display: none;     }      .larkw-aslCard-baikeCard-withgoback.larkw-aslCard-baikeCard-scrolled .aslcard-baike-navbar-withback {       display: flex;     }      .larkw-aslCard-baikeCard-withgoback .aslcard-baike-nav-placeloader {       display: block;     }      .larkw-aslCard-element-abbrmultidesc .abbrmultidesc-list {       max-height: 150px;       overflow: hidden auto;       margin-left: -8px;       margin-right: -8px;     }      .larkw-aslCard-element-abbrmultidesc .abbrmultidesc-item-content {       overflow: hidden;       text-overflow: ellipsis;       display: -webkit-box;       -webkit-line-clamp: 2;       -webkit-box-orient: vertical;     }      .abbreviation-cardItem_insearch {       border-radius: 8px;     }      .abbreviation-cardItem_insearch .larkw-aslCard-card-theme-LIGHT .larkw-aslCard-util-bg-ultra,     .abbreviation-cardItem_insearch .larkw-aslCard-card-theme-DARK .larkw-aslCard-util-bg-ultra {       background-image: none;     }      .larkw-aslCard-element-userlistV2 {       margin-left: -4px;     }      .aslcard-baike-logo-btn-img {       display: flex;       transition: background-image 0.15s;     }      .aslcard-baike-logo-btn-img-placeholder {       opacity: 0;     }      .aslcard-baike-logo-btn {       color: @icon-n3;              .repo_name {         color: @text-placeholder;         font-size: 12px;         padding-left: 0px;         overflow: hidden;         text-overflow: ellipsis;         white-space: nowrap;         font-weight: 600;       }     }      .aslcard-baike-logo-btn:hover {       color: @icon-n2;        .repo_name {         color: @text-title;       }     }      .aslcard-baike-logo-btn .aslcard-baike-logo-btn-img {       background-image: url(https://lf-cdn-tos.bytescm.com/obj/static/asl-card/baike-logo-gray-lm_zh-CN_v2.svg);     }      .aslcard-baike-logo-btn:hover .aslcard-baike-logo-btn-img {       background-image: url(https://lf-cdn-tos.bytescm.com/obj/static/asl-card/baike-logo-colorful-lm_zh-CN_v2.svg);     }      .larkw-aslCard-card-theme-DARK .aslcard-baike-logo-btn .aslcard-baike-logo-btn-img {       background-image: url(https://lf-cdn-tos.bytescm.com/obj/static/asl-card/baike-logo-gray-dm_zh-CN_v2.svg);     }      .larkw-aslCard-card-theme-DARK .aslcard-baike-logo-btn:hover .aslcard-baike-logo-btn-img {       background-image: url(https://lf-cdn-tos.bytescm.com/obj/static/asl-card/baike-logo-colorful-dm_zh-CN_v2.svg);     }      .larkw-aslCard-element-userlistV2-content .aslcard-barike-ultra-useritem:not(:last-child) {       margin-right: 4px;     }      .larkw-aslCard-element-userlistV2-hint .username {       overflow: hidden;       text-overflow: ellipsis;       white-space: nowrap;       max-width: 144px;     }      .aslcard-baike-ultra-card .larkw-aslCard-footer-dislike-button .universe-icon.larkw-aslCard-footer-like-icon {       color: @icon-n3;     }      .larkw-aslCard-element-abbrmultidesc .abbrmultidesc-list {       padding-bottom: 4px;       max-height: 144px;       overflow: hidden overlay;       margin-left: -5px;       margin-right: -5px;     }      .larkw-aslCard-element-abbrmultidesc .abbrmultidesc-item {       line-height: 18px;       padding: 7px 5px 7px 18px;     }      .larkw-aslCard-element-abbrmultidesc .abbrmultidesc-item-active {       color: @text-title;     }      .larkw-aslCard-element-abbrmultidesc .abbrmultidesc-item-visited {       color: @text-title;     }      .larkw-aslCard-element-abbrmultidesc .abbrmultidesc-item:before {       content: "";       position: absolute;       top: 13px;       border-radius: 50%;       left: 5px;       width: 6px;       height: 6px;       background-color: @icon-disabled;     }      .larkw-aslCard-element-abbrmultidesc .abbrmultidesc-item-active:before {       background-color: @B500;     }      .larkw-aslCard-element-abbrmultidesc div.abbrmultidesc-item {       padding: 7px 5px 7px 18px;     }      .larkw-aslCard-element-abbrmultidesc .abbrmultidesc-item .abbrmultidesc-item-content {       padding: 0;     }      .larkw-aslCard-element-abbrmultidesc .abbrmultidesc-item-pinItem {       margin-right: -5px;     }      .abbrmultidesc-list::-webkit-scrollbar-thumb:hover {       background-color: transparent !important;     }      .-container {       display: block;     }      .aslCard-baikeCard-alias-wrapper {       margin-top: 2px;       .aslCard-baikeCard-alias {         color: @text-caption;         font-size: 14px;         line-height: 22px;       }     }      .ellipsis-two-line {       overflow: hidden;       text-overflow: ellipsis;       display: -webkit-box;       -webkit-line-clamp: 2;       -webkit-box-orient: vertical;     }      .ellipsis-one-line {       overflow: hidden;       text-overflow: ellipsis;       display: -webkit-box;       -webkit-line-clamp: 1;       -webkit-box-orient: vertical;     }          .larkw-aslCard-element-abbrmultidescv2 .abbrmultidescv2-list-wrapper {       user-select: none;       max-height: 128px;     }      .larkw-aslCard-element-abbrmultidescv2 .abbrmultidescv2-list-unexpanded {       max-height: 0px !important;     }          .abbrmultidescv2-list.aslcard-baikecard-scrollarea::-webkit-scrollbar {       display: none;     }      .larkw-aslCard-section-title {       display: flex;       justify-content: space-between;       border-radius: 6px;       padding-right: -4px;        .title-right-btn {         margin-right: -4px;         display: flex;         flex-direction: row;         align-items: center;         cursor: pointer;         color: @text-caption;         font-size: 12px;         font-weight: 400;         height: 20px;         line-height: 20px;         padding: 0px 4px;         border-radius: 6px;       }        .title-right-btn.related-docs-title {           display: none;       }        .title-right-btn: hover{          background-color:  @fill-hover;       }     }      .larkw-aslCard-recommend-docs-entry-show {       .larkw-aslCard-section-title {         .title-right-btn.related-docs-title {           display: flex;         }       }     }       .larkw-aslCard-folder-container-normal-button {       padding: 4px 0px 4px 16px;        .folder-option {         padding: 0px 4px;       }     }      .larkw-aslCard-folder-container-link-button {       right: 0px;     }          .aslcard-baike-showEntry-section {       margin-left: 12px !important;       margin-right: 12px !important;        .aslcard-baike-relatedWords-showEntry:hover {         background-color: @bg-float-overlay;;         cursor: pointer;       }        .asl-baikeultra-section-title {         padding:4px 8px;       }        .larkw-aslCard-layout-block {         padding:0px 8px;          .larkw-aslCard-folder-container-normal-button {            padding-left: 0px;         }       }        .larkw-aslCard-folder-container-normal-button {         padding-left: 8px;       }     }      .larkw-aslCard-relatedWord-block {         width: 100%;         margin-bottom: 2px;                  .larkw-aslCard-relatedWord-block-title {           color: @text-caption;           font-size: 12px;           line-height: 20px;           display: flex;           align-items: center;           margin-bottom: 4px;         }          .larkw-aslCard-relatedWord-block-content{           display: flex;           flex-wrap: wrap;         }     }      .larkw-aslCard-relatedWord-block:last-child {         padding-bottom: 0px;     }      .like-kit {       display: flex;       flex-direction: row;     }      .larkw-aslCard-scrollbar::-webkit-scrollbar {       display: none;     }      .abbrmultidescv2-item-active .abbrmultidescv2-item-pinItem {       opacity: 1 !important;     }      .aslcard-baike-fotter-icon {       width: 24px;       height: 24px;       border-radius: 8px;       cursor: pointer;       align-items:center;        justify-content: center;       display: flex;       color: @icon-n3;       margin-left: 4px;     }      .aslcard-baike-fotter-icon:hover {       background-color: @udtoken-btn-text-bg-neutral-hover;;     }    </style>    <style id="aslcard_qa">     .aslcard-baike-relatedQASection {         .show-one-line {           height:          }          .relatedQA-page-entry: hover {            background-color:  @fill-hover;         }          .larkw-aslCard-QA-item {           display: flex;           flex-direction: row;           padding: 6px 8px;           border-radius: 6px;           cursor: pointer;            .QA_content {             width: 100%;                          .larkw-aslCard-element-rich-text {               white-space: nowrap;               overflow: hidden;               text-overflow: ellipsis;               display: inline-block;               width: calc(100% - 34px);               height: 22px;               pointer: cursor;                span {                 white-space: nowrap;               }             }              .Q_content,             .A_content {               height: 22px;               line-height:22px;               align-items: center;               display: flex;               flex-direction: row;               padding: 1px 0px;                .QA_icon {                 width: 20px;                 height: 20px;                 line-height: 20px;                 text-align: center;                 border-radius: 6px;                 margin-right:10px;                 font-size: 12px;               }                .Q_icon {                 background-color: @primary-pri-100;                 color: @primary-pri-500;               }                .A_icon {                 background-color: @function-warning-100;                 color: @function-warning-600;               }             }              .no_answer {               font-size: 14px;               line-height: 20px;               color: @text-caption;               display: flex;               align-items: center;                .to_answer {                 font-size: 14px;               }             }         }       }           .larkw-aslCard-QA-item: hover {           background-color:  @fill-hover;         }     }     .to_answer {       color: @text-link-normal;       border-radius: 6px;       padding: 0px 4px;       font-size: 12px;       line-height: 20px;       height: 20px;       cursor: pointer;     }      .to_answer:hover {       color: @text-link-normal;       background-color: @fill-active;     }      .to_answer:active {       color: @text-link-pressed;       background-color: @fill-active;     }      .to-answer-related-users,     .to-answer-contributors {       display: flex;       flex-direction: row;       font-size: 12px;       line-height: 20px;       color: @text-caption;       cursor: pointer;       width: fit-content;       flex-wrap: wrap;     }    </style>    <style id="aslcard-related-words">     .larkw-aslCard-relatedWords-wrapper {       padding: 0px 16px;       .larkw-aslCard-relatedWords-calssfication-item {         padding:4px 4px 0px 4px !important;         .title {           margin-bottom: 4px;           height: auto;            .title-text {             margin-bottom: 0px;             flex: 1;           }         }         .abbreviation-item {           margin: 0px 6px 6px 0px;         }       }        .larkw-aslCard-folder-container-normal-button {         padding-left: 0px !important;       }     }   </style>    <style id="abbrmulti-desc-v2">     .larkw-aslCard-element-abbrmultidescv2 {       .abbrmultidescv2-header-topline {         margin: 2px 0px;       }        .abbrmultidescv2-header {         padding: 4px 0px;       }        .abbrmultidescv2-item-content {          padding: 4px 0px;       }     }      .aslcard-baike-divider {       margin: 4px 0px;     }   </style>    <view className="aslcard-baike-navbar">     <view className="aslcard-baike-navbar-content aslcard-baike-navbar-noback" style="width: calc(100% - 64px);">       <text-highlight className="ellipsis-one-line" style="font-weight: 500;font-size: 14px;"  text="Ai"  highlightTerms='[]'/>     </view>     <view className="aslcard-baike-navbar-content aslcard-baike-navbar-withback">       <text style="font-weight: 500;font-size: 14px; max-width: 120px;" className="aslcard-ellipsis">Ai</text>     </view>     <view className="aslcard-baike-divider" style="position: absolute;bottom: 0;width: 100%;"></view>   </view>   <view className="aslcard-baike-navbar-goback-btn">     <tooltip title="返回">       <view className="larkw-aslCard-icon-mask" style="color: @icon-n1;" bind='{"onClick": {         "callbacks": [           {             "funcName": "back",             "params":{}           }         ]}       }'>         <image>           <svg width="16" height="16" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg">             <path               d="M12.2197 1.71967C12.5126 2.01256 12.5126 2.48744 12.2197 2.78033L6 9L12.2197 15.2197C12.5126 15.5126 12.5126 15.9874 12.2197 16.2803C11.9268 16.5732 11.4519 16.5732 11.159 16.2803L4.93934 10.0607C4.35355 9.47487 4.35355 8.52513 4.93934 7.93934L11.159 1.71967C11.4519 1.42678 11.9268 1.42678 12.2197 1.71967Z"               fill="currentColor" />           </svg>          </image>       </view>     </tooltip>   </view>   <view style="position: absolute;top: 20px;right: 16px;z-index: 3;">     <abbr-action-v2 data-tootip-more-title="更多">         <action shareModelTitle="分享到会话" showOut="true" type="share" text="分享" url="https://ai.feishu-boe.cn/lingo/detail/7233732879589572628?open_source&#x3D;im_share_card" tooltip=""           className="abbr_share_icon" subscribed=""           text-unsubscribe="取消订阅"           data-tooltip-subscribed-text="订阅后，将会通过订阅号推送词条下的新增文档"           data-tooltip-not-subscribed-text="取消订阅后，将不会再收到相关推送"           data-toast-subscribe="订阅成功，将会通过订阅号推送词条下的新增文档"           data-toast-unsubscribe="取消订阅后，将不会再收到相关推送"           data-ignore-success-toast="已关闭词条下划线提示"          />         <action shareModelTitle="" showOut="" type="abbr_home" text="查看词条详情" url="https://ai.feishu-boe.cn/lingo/detail/7233732879589572628?open_source&#x3D;card_entity_home" tooltip=""           className="abbr_detail_home_icon" subscribed=""           text-unsubscribe="取消订阅"           data-tooltip-subscribed-text="订阅后，将会通过订阅号推送词条下的新增文档"           data-tooltip-not-subscribed-text="取消订阅后，将不会再收到相关推送"           data-toast-subscribe="订阅成功，将会通过订阅号推送词条下的新增文档"           data-toast-unsubscribe="取消订阅后，将不会再收到相关推送"           data-ignore-success-toast="已关闭词条下划线提示"          />         <action shareModelTitle="" showOut="false" type="edit" text="编辑词条" url="https://ai.feishu-boe.cn/lingo/editor?locale&#x3D;zh-CN&amp;abbrId&#x3D;enterprise_7233732879589572628&amp;query&#x3D;Ai&amp;open_source&#x3D;card_entity_editor" tooltip=""           className="" subscribed=""           text-unsubscribe="取消订阅"           data-tooltip-subscribed-text="订阅后，将会通过订阅号推送词条下的新增文档"           data-tooltip-not-subscribed-text="取消订阅后，将不会再收到相关推送"           data-toast-subscribe="订阅成功，将会通过订阅号推送词条下的新增文档"           data-toast-unsubscribe="取消订阅后，将不会再收到相关推送"           data-ignore-success-toast="已关闭词条下划线提示"          />         <action shareModelTitle="" showOut="" type="ignore" text="关闭词条下划线" url="" tooltip=""           className="" subscribed=""           text-unsubscribe="取消订阅"           data-tooltip-subscribed-text="订阅后，将会通过订阅号推送词条下的新增文档"           data-tooltip-not-subscribed-text="取消订阅后，将不会再收到相关推送"           data-toast-subscribe="订阅成功，将会通过订阅号推送词条下的新增文档"           data-toast-unsubscribe="取消订阅后，将不会再收到相关推送"           data-ignore-success-toast="已关闭词条下划线提示"          />         <action shareModelTitle="" showOut="" type="divider" text="" url="" tooltip=""           className="" subscribed=""           text-unsubscribe="取消订阅"           data-tooltip-subscribed-text="订阅后，将会通过订阅号推送词条下的新增文档"           data-tooltip-not-subscribed-text="取消订阅后，将不会再收到相关推送"           data-toast-subscribe="订阅成功，将会通过订阅号推送词条下的新增文档"           data-toast-unsubscribe="取消订阅后，将不会再收到相关推送"           data-ignore-success-toast="已关闭词条下划线提示"          />         <action shareModelTitle="" showOut="" type="create" text="创建词条" url="https://ai.feishu-boe.cn/lingo/editor?action&#x3D;create&amp;abbrId&#x3D;enterprise_7233732879589572628&amp;locale&#x3D;zh-CN&amp;open_source&#x3D;card_entity_create" tooltip=""           className="" subscribed=""           text-unsubscribe="取消订阅"           data-tooltip-subscribed-text="订阅后，将会通过订阅号推送词条下的新增文档"           data-tooltip-not-subscribed-text="取消订阅后，将不会再收到相关推送"           data-toast-subscribe="订阅成功，将会通过订阅号推送词条下的新增文档"           data-toast-unsubscribe="取消订阅后，将不会再收到相关推送"           data-ignore-success-toast="已关闭词条下划线提示"          />         <action shareModelTitle="" showOut="" type="home" text="前往词典首页" url="https://baikeredirect.feishu.cn/drive/lingo?locale&#x3D;zh-CN&amp;open_source&#x3D;card_web_tab" tooltip=""           className="" subscribed=""           text-unsubscribe="取消订阅"           data-tooltip-subscribed-text="订阅后，将会通过订阅号推送词条下的新增文档"           data-tooltip-not-subscribed-text="取消订阅后，将不会再收到相关推送"           data-toast-subscribe="订阅成功，将会通过订阅号推送词条下的新增文档"           data-toast-unsubscribe="取消订阅后，将不会再收到相关推送"           data-ignore-success-toast="已关闭词条下划线提示"          />     </abbr-action-v2>   </view>   <view     className="larkw-aslCard-layout-block baike_navbar_scrollbar_trigger larkw-abbreviation-content larkw-aslCard-scrollbar larkw-aslCard-scrollbar-hover"     style="max-height: inherit; max-width: inherit; overflow: hidden overlay;word-break: normal;"     canUseContributors="true">     <view className="larkw-aslCard-util-bg-ultra" id="larkw-aslCard-body-enterprise_7233732879589572628">       <view className="larkw-aslCard-layout-block larkw-aslCard-baike-header"         style='padding:24px 20px 0; position: relative;'>         <view className="aslcard-baike-nav-placeloader" />            <view              className="larkw-aslCard-layout-block main-key-content"              style="position: relative;width: 100%;"            >             <view className="larkw-aslCard-layout-inlineBlock" style='position: absolute; top: 0; right: 0;'>             </view>             <tooltip                title="进入词条详情页"                style="max-width:calc(100% - 64px);width:fit-content;"                className="main-key-tooltip"               bind='{"onClick":{                 "callbacks":[{"funcName":"openURL","params":{"url":"https://ai.feishu-boe.cn/lingo/detail/7233732879589572628?open_source&#x3D;card_entity_home"}}],                 "events":[{"eventName":"event_track_v2","params":{"click":"function","function_type":"entity_name"}}]               }}'             >                 <text-highlight locale="zh-CN" style="color: @text-title;font-size: 18px;font-weight: 500;line-height: 26px;margin-right: 8px;"  text="Ai"  highlightTerms='[]'/>             </tooltip>           </view>            <view className="larkw-aslCard-layout-flex" style="align-items: center;">             <user-list data-text-hint="贡献" version="v2" maxCountShow="2">                 <user userId="7215104701929357331" avatarKey="v2_98f36e28-20f7-4f32-889c-b926df7eb22j" tooltip="张晓阳"                   className="aslcard-barike-ultra-useritem" userName="张晓阳" size="24" style="">                 </user>               <user-rest                 style="margin-right: 8px;height: 24px;width: 24px;display: flex;align-items: center;justify-content: center;border-radius: 50%;background-color: #EFF0F1;color: @text-caption;cursor: pointer;margin-right: 0;margin-bottom: 0;">               </user-rest>             </user-list>             <image style="margin: 0px 2px 0px 6px">              <svg width="2" height="10" viewBox="0 0 2 10" fill="none" xmlns="http://www.w3.org/2000/svg">                 <path d="M1 0V10" stroke="#BBBFC4"/>               </svg>             </image>             <view               className="to_answer"               id="user-list-right-node"               bind='{"onClick":{               "callbacks":[{"funcName":"openURL","params":{"url":"https://ai.feishu-boe.cn/lingo/detail/7233732879589572628?anchor&#x3D;qaComment&amp;addQuestion&#x3D;true&amp;open_source&#x3D;ask_contributor"}}],               "events":[{"eventName":"event_track_v2","params":{"click":"function","function_type":"ask_contributor"}}]               }}'>               <text>提问</text>             </view>           </view>         </view>        <view className="larkw-aslCard-layout-block aslcard-baike-section-ultra" style="padding-top: 0px;">         <view className="larkw-aslCard-layout-block asl-section-description" style="padding:4px 20px;">             <text-highlight               bind='{                 "onUnFold": {"events":[{                   "eventName":"event_track_v2",                   "params":{"click":"function","function_type":"description_unfold"}                 }]}               }'               locale="zh-CN"                maxHeight="setMaxHeightVal folderSwitcher.canDescriptionFolder 66"                style="white-space: pre-wrap;word-break: break-word;"                text="人工智能是计算机科学的一个分支，它企图了解智能的实质，并生产出一种新的能以人类智能相似的方式做出反应的智能机器，该领域的研究包括机器人、语言识别、图像识别、自然语言处理和专家系统等。"                 highlightTerms='[&quot;&amp;#10&quot;]'             />         </view>       </view>         <async-template         hidden="false"         templateName="recommend_docs"         templateId="recommendRelatedDoc"         serviceName="getRelatedResource"         params='{"entryIds":["enterprise_7233732879589572628"],"resourceTypes":[1],"enterFrom":""}'       />          <view className="larkw-aslCard-layout-block larkw-aslCard-hideInLarkSearch larkw-aslCard-showInLark">          <view className="larkw-aslCard-layout-flex"           style='padding: 10px 20px;font-size: 12px;line-height: 20px;color: @text-caption;margin-bottom:14px;'>           <view style="display: flex;align-items: center;">             <text>找不到想要的信息？</text>             <view className="larkw-aslCard-layout-inlineBlock larkw-aslCard-text-link-button"               style="color: @text-link-normal;" bind='{"onClick":{         "callbacks":[{"funcName":"openLarkSearch","params":{"query":"Ai"}}],         "events":[{"eventName":"event_track_v2","params":{"click":"function","function_type":"search","abbr_id":"enterprise_7233732879589572628"}}]         }}'>               搜索更多             </view>           </view>         </view>       </view>          <view style="display: none;" role="for-debug"         data-canShowSuperAdminBanner=""         data-superAdminBannerHref=""         data-canShowNormalUserBanner="false"         data-normalUserBannerHref=""         data-IsUserSuperAdmin="nodata"         data-IsTenantActivated="nodata" />     </view>   </view>    <view className="aslcard-baike-footer">     <view className="aslcard-baike-divider" style="margin: 0 20px;">     </view>     <view       style="display: flex;align-items: center;justify-content: space-between;height: 46px;padding: 0 16px;flex-shrink: 0;">       <view className="aslcard-baike-logo-btn-container larkw-aslCard-layout-flex" style="max-width: calc(100% - 84px);">         <tooltip title="前往词典首页，探索更多词条" style="width: 100%">           <view className="aslcard-baike-btn aslcard-baike-btn-extra-small aslcard-baike-logo-btn"             url="https://baikeredirect.feishu.cn/drive/lingo?locale&#x3D;zh-CN&amp;from&#x3D;logo&amp;abbrId&#x3D;enterprise_7233732879589572628&amp;page&#x3D;category&amp;repo_id&#x3D;1&amp;open_source&#x3D;card_web_logo"             bind='{"onClick":{"events":[{"eventName":"event_track_v2","params":{"click":"function","function_type":"encyclopedia_logo","target":"asl_abbr_paltform_view","abbr_id":"enterprise_7233732879589572628"}}]}}'>             <view className="aslcard-baike-logo-btn-img" style="width: 21px; height: 17px;">               <image url="https://lf-cdn-tos.bytescm.com/obj/static/asl-card/baike-logo-gray-lm_zh-CN_v2.svg"                 className="aslcard-baike-logo-btn-img-placeholder"></image>             </view>             <text className="repo_name">企业词库</text>             <image>               <svg width="13" height="13" viewBox="0 0 13 13" fill="none" xmlns="http://www.w3.org/2000/svg">                 <path                   d="M4.65292 2.64645C4.45765 2.84171 4.45765 3.15829 4.65292 3.35355L7.79936 6.5L4.65292 9.64645C4.45765 9.84171 4.45765 10.1583 4.65292 10.3536C4.84818 10.5488 5.16476 10.5488 5.36002 10.3536L8.86002 6.85355C8.95379 6.75979 9.00647 6.63261 9.00647 6.5C9.00647 6.36739 8.95379 6.24021 8.86002 6.14645L5.36002 2.64645C5.16476 2.45118 4.84818 2.45118 4.65292 2.64645Z"                   fill="currentColor" />               </svg>             </image>           </view>         </tooltip>       </view>        <view className="like-kit">         <like-kit like-count='0' data-text-ignore-btn="关闭词条提示"           dislike-count='0' like="" dislike=""           data-text-feedback-title="反馈给贡献者"           data-text-feedback-success="反馈提交成功"           show-like="true"            show-dislike="false"         ></like-kit>         <tooltip title="我要反馈" className="aslcard-baike-fotter-icon">           <view  bind='{"onClick":{           "callbacks":[{"funcName":"openFeedback","params":{"title":"词条反馈"}}],           "events":[{"eventName":"event_track_v2","params":{"click":"function","function_type":"feedback_logo"}}]           }}' style="height: 16px;">             <image >               <svg width="14" height="16" viewBox="0 0 14 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg">                 <path d="M10.6667 1.99984H1.33333V13.9998H4.66667V15.3332H1.33333C0.596954 15.3332 0 14.7362 0 13.9998V1.99984C0 1.26346 0.596954 0.666504 1.33333 0.666504H10.6667C11.403 0.666504 12 1.26346 12 1.99984V7.33317H10.6667V1.99984Z" fill="currentColor"/>                 <path d="M3.33333 4.6665C2.96514 4.6665 2.66667 4.96498 2.66667 5.33317C2.66667 5.70136 2.96514 5.99984 3.33333 5.99984H8.66667C9.03486 5.99984 9.33333 5.70136 9.33333 5.33317C9.33333 4.96498 9.03486 4.6665 8.66667 4.6665H3.33333Z" fill="currentColor"/>                 <path d="M2.66667 8.33317C2.66667 7.96498 2.96514 7.6665 3.33333 7.6665H6C6.36819 7.6665 6.66667 7.96498 6.66667 8.33317C6.66667 8.70136 6.36819 8.99984 6 8.99984H3.33333C2.96514 8.99984 2.66667 8.70136 2.66667 8.33317Z" fill="currentColor"/>                 <path d="M11.5523 8.69999C11.9428 8.30946 12.576 8.30946 12.9665 8.69999C13.357 9.09051 13.357 9.72367 12.9665 10.1142L12.2594 10.8213L10.8452 9.40709L11.5523 8.69999Z" fill="currentColor"/>                 <path d="M10.1381 10.1142L11.5523 11.5284L8.23093 14.8498C8.09164 14.9891 7.91229 15.0813 7.71798 15.1136L6.45737 15.3233C6.42136 15.3292 6.38467 15.3175 6.35885 15.2917C6.33271 15.2655 6.32099 15.2282 6.32749 15.1918L6.55128 13.9372C6.58465 13.7501 6.6746 13.5777 6.80901 13.4433L10.1381 10.1142Z" fill="currentColor"/>               </svg>             </image>           </view>         </tooltip>           <tooltip title="相关讨论" className="aslcard-baike-fotter-icon">             <view  bind='{"onClick":{           "callbacks":[{"funcName":"openURL","params":{"url":"https://ai.feishu-boe.cn/lingo/detail/7233732879589572628?anchor&#x3D;qaComment&amp;open_source&#x3D;answers_logo"}}],           "events":[{"eventName":"event_track_v2","params":{"click":"function","function_type":"answers_logo"}}]           }}' style="height: 16px;">               <image >                 <svg width="16" height="16" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg">                 <path d="M3.66675 8.66634H2.00008V2.66634H10.6667V8.66634H6.33059L3.66675 10.8333V8.66634ZM6.66675 9.99968H10.6667C11.4031 9.99968 12.0001 9.40272 12.0001 8.66634V2.66634C12.0001 1.92996 11.4031 1.33301 10.6667 1.33301H2.00008C1.2637 1.33301 0.666748 1.92996 0.666748 2.66634V8.66634C0.666748 9.40272 1.2637 9.99968 2.00008 9.99968H2.33341V11.9495C2.33341 12.4539 2.87199 12.7756 3.31615 12.5365L6.66675 9.99968ZM8.99726 12.6667H5.34274L7.0094 11.3333H9.33341L12.0001 13.5V11.333H14.0001V5.99967H13.3334V4.66634H14.0001C14.7365 4.66634 15.3334 5.2633 15.3334 5.99967V11.333C15.3334 12.0694 14.7365 12.6663 14.0001 12.6663H13.3334V14.6162C13.3334 15.1206 12.7948 15.4423 12.3507 15.2031L8.99726 12.6667Z" fill="currentColor"/>                 </svg>               </image>             </view>           </tooltip>       </view>     </view>   </view>    <abbr-data-carrier id="abbr-data-carry-id" data-report-card-view='[{"result_type":"success"}]'></abbr-data-carrier>   <guide       data-options='{"key":"Lingo_card_share","style":{"zIndex":100,"width":"max-content"},"conf":[{"content":"词典支持分享词条啦！","target":".larkw-aslCard-moreactions-wrapper .abbr_share_icon","direction":"bottom","align":"center","distance":4,"clickBlankToDisappear":true,"autoFinishMs":5000}],"extraDaInfo":{"abbr_id":"enterprise_7233732879589572628","onboarding_type":"bubble","onboarding_sub_type":"entity_share"}}' >   </guide>   <guide        data-options='{"key":"Lingo_doc_homograph","style":{"zIndex":100,"width":"max-content"},"conf":[{"content":"点击置顶，在当前文档优先展示该释义","target":".abbrmultidescv2-item-pinItem .larkw-aslCard-icon-mask","direction":"top","align":"center","distance":4,"clickBlankToDisappear":true,"autoFinishMs":5000}],"extraDaInfo":{"abbr_id":"enterprise_7233732879589572628","onboarding_type":"bubble","onboarding_sub_type":"entity_pin"}}' >   </guide> </view>
         */
        this.card = builder.card;
        /**
         * 卡片对应词条的id
         * <p> 示例值：enterprise_7233732879589572628
         */
        this.id = builder.id;
        /**
         * 用户点击的高亮词条
         * <p> 示例值：Ai
         */
        this.key = builder.key;
        /**
         * 词条卡片类型
         * <p> 示例值：
         */
        this.cardType = builder.cardType;
        /**
         * 卡片模版名
         * <p> 示例值：abbreviation-ultra
         */
        this.templateName = builder.templateName;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getCard() {
        return this.card;
    }

    public void setCard(String card) {
        this.card = card;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Integer getCardType() {
        return this.cardType;
    }

    public void setCardType(Integer cardType) {
        this.cardType = cardType;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public static class Builder {
        /**
         * 根据请求的渲染类型进行渲染后的词条卡片数据
         * <p> 示例值：<view className="aslcard-baike-ultra-card larkw-aslCard-layout-flex aslcard-baike-container-outer without-copyperm-dom"   style='flex-direction: column; width: 100%; box-sizing: border-box; height: 100%; max-height: inherit; max-width: inherit;position: relative;'>   <style id="baike-card-external-ultra">     .aslcard-baike-container-outer {       min-width: 320px;     }      .abbreviation-cardItem_insearch .aslcard-baike-container-outer {       min-width: 100%;     }      .larkw-aslCard-card-container .larkw-aslCard-element-abbrnav-bar {       padding-top: 12px;     }      .larkw-aslCard-baikeCard .larkw-aslCard-showInLark {       display: none;     }      .larkw-aslCard-baikeCard-inLark .larkw-aslCard-showInLark {       display: block;     }      .larkw-aslCard-baikeCard-inLark .larkw-aslCard-footer-ignoreBtn {       display: none;     }      .list-item-avatar {       margin-right: 8px;       flex-shrink: 0;       overflow: hidden;       border-radius: 8px;     }      .list-item-avatar-bg {       background-color: @primary-pri-100;     }      .list-item-title {       overflow: hidden;       text-overflow: ellipsis;       white-space: nowrap;       color: @text-title;     }      .list-item-title.larkw-aslCard-text-link-button {       margin-left: -2px;     }      .larkw-aslCard-text-link-button {       padding: 0 4px;       transition: none;       border-radius: 6px;     }      .larkw-aslCard-text-link-button:hover {       color: @text-link-normal;     }      .larkw-aslCard-text-link-button:active {       color: @text-link-pressed;     }      .larkw-aslCard-baike-header {}      .larkw-aslCard-baikeCard-actions-icon .universe-icon {       font-size: 16px;     }      .baikeSectionHeader {       width: 100%;       box-sizing: border-box;       padding-left: 16px;     }      .baikeSectionHeaderInner {       padding: 8px 0;       flex-shrink: 0;       font-size: 12px;       margin-right: 4px;       line-height: 20px;       color: @text-caption;     }      .larkw-aslCard-ig .larkw-aslCard-element-abbrnav-bar {       padding: 18px 0 10px 0;       margin-left: -4px;     }      .abbreviation-cardItem_insearch .larkw-aslCard-showInLarkSearch {       display: block;     }      .abbreviation-cardItem_insearch .larkw-aslCard-hideInLarkSearch {       display: none;     }      .abbreviation-cardItem_insearch .larkw-aslCard-icon-mask.larkw-aslCard-baikeCard-actions-icon:not(:last-child),     .abbreviation-cardItem_insearch .larkw-aslCard-icon-mask:not(:last-child) {       display: none;     }      .baike-card-link-item .larkw-aslCard-element-image-fallback,     .baike-card-link-item .larkw-aslCard-element-plImage-placeholder {       background-color: @primary-pri-100;     }      .baike-card-link-item-default {       display: flex;       justify-content: center;       align-items: center;       background-color: @primary-pri-100;        color: @text-link-normal;     }      .larkw-aslCard-text-link-ig:hover {       color: @text-link-hover;     }      .larkw-aslCard-text-link-ig:active {       color: @text-link-pressed;     }      .larkw-aslCard-abbrClassify-tag .ud__tag__content {       max-width: 100px;       overflow: hidden;       text-overflow: ellipsis;       white-space: nowrap;     }      .larkw-aslCard-layout-block.larkw-abbreviation-content {       padding: 0;       box-sizing: inherit;     }      .larkw-abbreviation-content {       border-radius: 10px;     }      .list-item-avatar-user .ud__avatar {       height: 24px !important;       width: 24px !important;     }      .lux-ellipsis-line {       overflow: hidden;       text-overflow: ellipsis;       white-space: nowrap;       min-width: 50px;     }      .ud__menu-normal-item-title-content.ud__menu-normal-item-title-content-text-overflow {       white-space: nowrap;       overflow: hidden;       text-overflow: ellipsis;     }      .asl-section-description .larkw-aslCard-element-text {       white-space: pre-wrap;       word-break: break-word;     }      .abbreviation-cardItem_insearch .larkw-aslCard-element-image-set .image-cell {       width: 9.18vw;       height: 9.18vw;     }      .larkw-aslCard-element-rich-text .larkw-aslCard-element-link,      .larkw-aslCard-element-rich-text .larkw-aslCard-element-richlink {       margin: 0px !important;       padding: 3px 2px;       display: inline;     }      .larkw-aslCard-element-rich-text .larkw-aslCard-element-abbreviation {       display: inline;       cursor: pointer;       line-height: 20px;       position: relative;       border-bottom-style: solid;       border-width: 1px;       border-image-slice: 1;       border-image-source: repeating-linear-gradient(90deg, @N650 0, @N650 1px, transparent 0, transparent 3px);     }     .larkw-aslCard-element-rich-text .larkw-aslCard-element-abbreviation:hover,     .larkw-aslCard-element-rich-text .larkw-aslCard-element-abbreviation:active {       border-bottom-color: @B500;     }      .larkw-aslCard-element-rich-text .larkw-aslCard-element-abbreviation:hover {       color: @B500;       border-image-source: repeating-linear-gradient(90deg, @B500 0, @B500 1px, transparent 0, transparent 3px);     }      .larkw-aslCard-element-at {       color: @text-link-normal !important;     }      .main-key-content {       width: fit-content;       padding-bottom: 4px;     }      .main-key-tooltip {       cursor: pointer;     }      .main-key-tooltip:hover {       .larkw-aslCard-element-text {         color: @text-link-hover !important;       }     }      .larkw-aslCard-baikecard-feedback .panel {       display: flex;       flex-wrap: wrap;       grid-template-columns: unset;       grid-template-rows: unset;        .capsule {         min-width: 183px;          .capsule-text {           overflow: hidden;           text-overflow: ellipsis;         }       }     }   </style>    <style id="aslcard_theme_ultra">     .ai-popup-portal .ai-popup-wrapper {       border: none;       overflow: inherit;       box-shadow: @shadow-s4-down;     }      .larkw-aslCard-util-bg-ultra {       background-repeat: no-repeat;       background-position: 0 0;       background-size: 100% 143px;     }      .larkw-aslCard-card-theme-LIGHT .larkw-aslCard-util-bg-ultra {       background-image: url(https://lf-cdn-tos.bytescm.com/obj/static/asl-card/lm-min-ultra.png?time=202209222)     }      .larkw-aslCard-card-theme-DARK .larkw-aslCard-util-bg-ultra {       background-image: url(https://lf-cdn-tos.bytescm.com/obj/static/asl-card/dm-min-ultra.png?time=202209222)     }      .aslcard-ellipsis {       overflow: hidden;       text-overflow: ellipsis;       white-space: nowrap;     }      .aslcard-baike-section-ultra {       padding: 6px 0px;     }      .asl-baikeultra-section-title {       font-weight: 500;       font-size: 12px;        line-height: 22px;       display: flex;       align-items: center;       padding: 4px 20px;       color: @text-title;        .section-subTitle {         color: @text-caption;         font-weight: 400;         padding-left: 2px;       }     }      .asl-baikeultra-list-item {       padding: 6px 20px;       display: flex;       align-items: center;        .item-tag-md {         margin-left: 4px;       }     }      .aslcard-baike-btn {       display: flex;       align-items: center;       justify-content: center;       border-radius: 6px;       cursor: pointer;     }      .aslcard-baike-btn:hover {       background-color: @fill-hover;     }      .aslcard-baike-btn-extra-small {       height: 24px;       padding: 0 2px;     }      .aslcard-baike-btn-logo {}      .aslcard-baike-category-item {       margin: 4px 8px 4px 0px;       position: relative;       cursor: pointer;       line-height: 20px;       display: flex;        .category-tag-icon {         position: absolute;         right: 6px;         display: flex;         color: @udtoken-tag-text-blue;       }        .aslcard-baike-tag-md {         font-size: 12px;         font-weight: 400;         color: @udtoken-tag-text-blue;         background-color: @udtoken-tag-bg-blue;         cursor: pointer;         padding-right: 17px;       }     }      .aslcard-baike-category-item: hover {       .aslcard-baike-tag-md {         background-color: @udtoken-tag-bg-blue-hover;       }     }      .aslcard-baike-btn-bg-primary {       cursor: pointer;       background-color: @primary-pri-50;     }      .aslcard-baike-btn-bg-primary:hover {       background-color: @primary-pri-100;     }      .aslcard-baike-btn-bg-primary:active {       background-color: @primary-pri-200;     }      .aslcard-baike-divider {       height: 1px;       background-color: @line-divider-default;       transform: scaleY(0.5);     }      .aslcard-baike-navbar {       user-select: none;       box-sizing: border-box;       background-color: @bg-float;       border-radius: 10px 10px 0 0;       position: absolute;       width: 100%;       z-index: 3;       overflow: hidden;       height: 56px;       opacity: 0;       pointer-events: none;     }      .aslcard-baike-navbar-content {       width: 100%;       height: 22px;       display: flex;       align-items: center;       border-radius: 10px 10px 0 0;       overflow: hidden;     }      .aslcard-baike-navbar-noback {       box-sizing: border-box;       padding: 0px 20px;       height: 22px;     }      .aslcard-baike-navbar-withback {       justify-content: center;       display: none;     }      .larkw-aslCard-baikeCard-scrolled .aslcard-baike-navbar {       opacity: 1;       pointer-events: auto;       padding-top: 21px;       transition: opacity 0.15s;     }      .aslcard-baike-navbar-goback-btn {       display: none;       position: absolute;       top: 20px;       left: 16px;       z-index: 3;     }      .aslcard-baike-nav-placeloader {       display: none;       height: 28px;       width: 100%;     }      .larkw-aslCard-baikeCard-withgoback .aslcard-baike-navbar-goback-btn {       display: flex;     }      .larkw-aslCard-baikeCard-withgoback .aslcard-baike-navbar-noback {       display: none;     }      .larkw-aslCard-baikeCard-withgoback.larkw-aslCard-baikeCard-scrolled .aslcard-baike-navbar-withback {       display: flex;     }      .larkw-aslCard-baikeCard-withgoback .aslcard-baike-nav-placeloader {       display: block;     }      .larkw-aslCard-element-abbrmultidesc .abbrmultidesc-list {       max-height: 150px;       overflow: hidden auto;       margin-left: -8px;       margin-right: -8px;     }      .larkw-aslCard-element-abbrmultidesc .abbrmultidesc-item-content {       overflow: hidden;       text-overflow: ellipsis;       display: -webkit-box;       -webkit-line-clamp: 2;       -webkit-box-orient: vertical;     }      .abbreviation-cardItem_insearch {       border-radius: 8px;     }      .abbreviation-cardItem_insearch .larkw-aslCard-card-theme-LIGHT .larkw-aslCard-util-bg-ultra,     .abbreviation-cardItem_insearch .larkw-aslCard-card-theme-DARK .larkw-aslCard-util-bg-ultra {       background-image: none;     }      .larkw-aslCard-element-userlistV2 {       margin-left: -4px;     }      .aslcard-baike-logo-btn-img {       display: flex;       transition: background-image 0.15s;     }      .aslcard-baike-logo-btn-img-placeholder {       opacity: 0;     }      .aslcard-baike-logo-btn {       color: @icon-n3;              .repo_name {         color: @text-placeholder;         font-size: 12px;         padding-left: 0px;         overflow: hidden;         text-overflow: ellipsis;         white-space: nowrap;         font-weight: 600;       }     }      .aslcard-baike-logo-btn:hover {       color: @icon-n2;        .repo_name {         color: @text-title;       }     }      .aslcard-baike-logo-btn .aslcard-baike-logo-btn-img {       background-image: url(https://lf-cdn-tos.bytescm.com/obj/static/asl-card/baike-logo-gray-lm_zh-CN_v2.svg);     }      .aslcard-baike-logo-btn:hover .aslcard-baike-logo-btn-img {       background-image: url(https://lf-cdn-tos.bytescm.com/obj/static/asl-card/baike-logo-colorful-lm_zh-CN_v2.svg);     }      .larkw-aslCard-card-theme-DARK .aslcard-baike-logo-btn .aslcard-baike-logo-btn-img {       background-image: url(https://lf-cdn-tos.bytescm.com/obj/static/asl-card/baike-logo-gray-dm_zh-CN_v2.svg);     }      .larkw-aslCard-card-theme-DARK .aslcard-baike-logo-btn:hover .aslcard-baike-logo-btn-img {       background-image: url(https://lf-cdn-tos.bytescm.com/obj/static/asl-card/baike-logo-colorful-dm_zh-CN_v2.svg);     }      .larkw-aslCard-element-userlistV2-content .aslcard-barike-ultra-useritem:not(:last-child) {       margin-right: 4px;     }      .larkw-aslCard-element-userlistV2-hint .username {       overflow: hidden;       text-overflow: ellipsis;       white-space: nowrap;       max-width: 144px;     }      .aslcard-baike-ultra-card .larkw-aslCard-footer-dislike-button .universe-icon.larkw-aslCard-footer-like-icon {       color: @icon-n3;     }      .larkw-aslCard-element-abbrmultidesc .abbrmultidesc-list {       padding-bottom: 4px;       max-height: 144px;       overflow: hidden overlay;       margin-left: -5px;       margin-right: -5px;     }      .larkw-aslCard-element-abbrmultidesc .abbrmultidesc-item {       line-height: 18px;       padding: 7px 5px 7px 18px;     }      .larkw-aslCard-element-abbrmultidesc .abbrmultidesc-item-active {       color: @text-title;     }      .larkw-aslCard-element-abbrmultidesc .abbrmultidesc-item-visited {       color: @text-title;     }      .larkw-aslCard-element-abbrmultidesc .abbrmultidesc-item:before {       content: "";       position: absolute;       top: 13px;       border-radius: 50%;       left: 5px;       width: 6px;       height: 6px;       background-color: @icon-disabled;     }      .larkw-aslCard-element-abbrmultidesc .abbrmultidesc-item-active:before {       background-color: @B500;     }      .larkw-aslCard-element-abbrmultidesc div.abbrmultidesc-item {       padding: 7px 5px 7px 18px;     }      .larkw-aslCard-element-abbrmultidesc .abbrmultidesc-item .abbrmultidesc-item-content {       padding: 0;     }      .larkw-aslCard-element-abbrmultidesc .abbrmultidesc-item-pinItem {       margin-right: -5px;     }      .abbrmultidesc-list::-webkit-scrollbar-thumb:hover {       background-color: transparent !important;     }      .-container {       display: block;     }      .aslCard-baikeCard-alias-wrapper {       margin-top: 2px;       .aslCard-baikeCard-alias {         color: @text-caption;         font-size: 14px;         line-height: 22px;       }     }      .ellipsis-two-line {       overflow: hidden;       text-overflow: ellipsis;       display: -webkit-box;       -webkit-line-clamp: 2;       -webkit-box-orient: vertical;     }      .ellipsis-one-line {       overflow: hidden;       text-overflow: ellipsis;       display: -webkit-box;       -webkit-line-clamp: 1;       -webkit-box-orient: vertical;     }          .larkw-aslCard-element-abbrmultidescv2 .abbrmultidescv2-list-wrapper {       user-select: none;       max-height: 128px;     }      .larkw-aslCard-element-abbrmultidescv2 .abbrmultidescv2-list-unexpanded {       max-height: 0px !important;     }          .abbrmultidescv2-list.aslcard-baikecard-scrollarea::-webkit-scrollbar {       display: none;     }      .larkw-aslCard-section-title {       display: flex;       justify-content: space-between;       border-radius: 6px;       padding-right: -4px;        .title-right-btn {         margin-right: -4px;         display: flex;         flex-direction: row;         align-items: center;         cursor: pointer;         color: @text-caption;         font-size: 12px;         font-weight: 400;         height: 20px;         line-height: 20px;         padding: 0px 4px;         border-radius: 6px;       }        .title-right-btn.related-docs-title {           display: none;       }        .title-right-btn: hover{          background-color:  @fill-hover;       }     }      .larkw-aslCard-recommend-docs-entry-show {       .larkw-aslCard-section-title {         .title-right-btn.related-docs-title {           display: flex;         }       }     }       .larkw-aslCard-folder-container-normal-button {       padding: 4px 0px 4px 16px;        .folder-option {         padding: 0px 4px;       }     }      .larkw-aslCard-folder-container-link-button {       right: 0px;     }          .aslcard-baike-showEntry-section {       margin-left: 12px !important;       margin-right: 12px !important;        .aslcard-baike-relatedWords-showEntry:hover {         background-color: @bg-float-overlay;;         cursor: pointer;       }        .asl-baikeultra-section-title {         padding:4px 8px;       }        .larkw-aslCard-layout-block {         padding:0px 8px;          .larkw-aslCard-folder-container-normal-button {            padding-left: 0px;         }       }        .larkw-aslCard-folder-container-normal-button {         padding-left: 8px;       }     }      .larkw-aslCard-relatedWord-block {         width: 100%;         margin-bottom: 2px;                  .larkw-aslCard-relatedWord-block-title {           color: @text-caption;           font-size: 12px;           line-height: 20px;           display: flex;           align-items: center;           margin-bottom: 4px;         }          .larkw-aslCard-relatedWord-block-content{           display: flex;           flex-wrap: wrap;         }     }      .larkw-aslCard-relatedWord-block:last-child {         padding-bottom: 0px;     }      .like-kit {       display: flex;       flex-direction: row;     }      .larkw-aslCard-scrollbar::-webkit-scrollbar {       display: none;     }      .abbrmultidescv2-item-active .abbrmultidescv2-item-pinItem {       opacity: 1 !important;     }      .aslcard-baike-fotter-icon {       width: 24px;       height: 24px;       border-radius: 8px;       cursor: pointer;       align-items:center;        justify-content: center;       display: flex;       color: @icon-n3;       margin-left: 4px;     }      .aslcard-baike-fotter-icon:hover {       background-color: @udtoken-btn-text-bg-neutral-hover;;     }    </style>    <style id="aslcard_qa">     .aslcard-baike-relatedQASection {         .show-one-line {           height:          }          .relatedQA-page-entry: hover {            background-color:  @fill-hover;         }          .larkw-aslCard-QA-item {           display: flex;           flex-direction: row;           padding: 6px 8px;           border-radius: 6px;           cursor: pointer;            .QA_content {             width: 100%;                          .larkw-aslCard-element-rich-text {               white-space: nowrap;               overflow: hidden;               text-overflow: ellipsis;               display: inline-block;               width: calc(100% - 34px);               height: 22px;               pointer: cursor;                span {                 white-space: nowrap;               }             }              .Q_content,             .A_content {               height: 22px;               line-height:22px;               align-items: center;               display: flex;               flex-direction: row;               padding: 1px 0px;                .QA_icon {                 width: 20px;                 height: 20px;                 line-height: 20px;                 text-align: center;                 border-radius: 6px;                 margin-right:10px;                 font-size: 12px;               }                .Q_icon {                 background-color: @primary-pri-100;                 color: @primary-pri-500;               }                .A_icon {                 background-color: @function-warning-100;                 color: @function-warning-600;               }             }              .no_answer {               font-size: 14px;               line-height: 20px;               color: @text-caption;               display: flex;               align-items: center;                .to_answer {                 font-size: 14px;               }             }         }       }           .larkw-aslCard-QA-item: hover {           background-color:  @fill-hover;         }     }     .to_answer {       color: @text-link-normal;       border-radius: 6px;       padding: 0px 4px;       font-size: 12px;       line-height: 20px;       height: 20px;       cursor: pointer;     }      .to_answer:hover {       color: @text-link-normal;       background-color: @fill-active;     }      .to_answer:active {       color: @text-link-pressed;       background-color: @fill-active;     }      .to-answer-related-users,     .to-answer-contributors {       display: flex;       flex-direction: row;       font-size: 12px;       line-height: 20px;       color: @text-caption;       cursor: pointer;       width: fit-content;       flex-wrap: wrap;     }    </style>    <style id="aslcard-related-words">     .larkw-aslCard-relatedWords-wrapper {       padding: 0px 16px;       .larkw-aslCard-relatedWords-calssfication-item {         padding:4px 4px 0px 4px !important;         .title {           margin-bottom: 4px;           height: auto;            .title-text {             margin-bottom: 0px;             flex: 1;           }         }         .abbreviation-item {           margin: 0px 6px 6px 0px;         }       }        .larkw-aslCard-folder-container-normal-button {         padding-left: 0px !important;       }     }   </style>    <style id="abbrmulti-desc-v2">     .larkw-aslCard-element-abbrmultidescv2 {       .abbrmultidescv2-header-topline {         margin: 2px 0px;       }        .abbrmultidescv2-header {         padding: 4px 0px;       }        .abbrmultidescv2-item-content {          padding: 4px 0px;       }     }      .aslcard-baike-divider {       margin: 4px 0px;     }   </style>    <view className="aslcard-baike-navbar">     <view className="aslcard-baike-navbar-content aslcard-baike-navbar-noback" style="width: calc(100% - 64px);">       <text-highlight className="ellipsis-one-line" style="font-weight: 500;font-size: 14px;"  text="Ai"  highlightTerms='[]'/>     </view>     <view className="aslcard-baike-navbar-content aslcard-baike-navbar-withback">       <text style="font-weight: 500;font-size: 14px; max-width: 120px;" className="aslcard-ellipsis">Ai</text>     </view>     <view className="aslcard-baike-divider" style="position: absolute;bottom: 0;width: 100%;"></view>   </view>   <view className="aslcard-baike-navbar-goback-btn">     <tooltip title="返回">       <view className="larkw-aslCard-icon-mask" style="color: @icon-n1;" bind='{"onClick": {         "callbacks": [           {             "funcName": "back",             "params":{}           }         ]}       }'>         <image>           <svg width="16" height="16" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg">             <path               d="M12.2197 1.71967C12.5126 2.01256 12.5126 2.48744 12.2197 2.78033L6 9L12.2197 15.2197C12.5126 15.5126 12.5126 15.9874 12.2197 16.2803C11.9268 16.5732 11.4519 16.5732 11.159 16.2803L4.93934 10.0607C4.35355 9.47487 4.35355 8.52513 4.93934 7.93934L11.159 1.71967C11.4519 1.42678 11.9268 1.42678 12.2197 1.71967Z"               fill="currentColor" />           </svg>          </image>       </view>     </tooltip>   </view>   <view style="position: absolute;top: 20px;right: 16px;z-index: 3;">     <abbr-action-v2 data-tootip-more-title="更多">         <action shareModelTitle="分享到会话" showOut="true" type="share" text="分享" url="https://ai.feishu-boe.cn/lingo/detail/7233732879589572628?open_source&#x3D;im_share_card" tooltip=""           className="abbr_share_icon" subscribed=""           text-unsubscribe="取消订阅"           data-tooltip-subscribed-text="订阅后，将会通过订阅号推送词条下的新增文档"           data-tooltip-not-subscribed-text="取消订阅后，将不会再收到相关推送"           data-toast-subscribe="订阅成功，将会通过订阅号推送词条下的新增文档"           data-toast-unsubscribe="取消订阅后，将不会再收到相关推送"           data-ignore-success-toast="已关闭词条下划线提示"          />         <action shareModelTitle="" showOut="" type="abbr_home" text="查看词条详情" url="https://ai.feishu-boe.cn/lingo/detail/7233732879589572628?open_source&#x3D;card_entity_home" tooltip=""           className="abbr_detail_home_icon" subscribed=""           text-unsubscribe="取消订阅"           data-tooltip-subscribed-text="订阅后，将会通过订阅号推送词条下的新增文档"           data-tooltip-not-subscribed-text="取消订阅后，将不会再收到相关推送"           data-toast-subscribe="订阅成功，将会通过订阅号推送词条下的新增文档"           data-toast-unsubscribe="取消订阅后，将不会再收到相关推送"           data-ignore-success-toast="已关闭词条下划线提示"          />         <action shareModelTitle="" showOut="false" type="edit" text="编辑词条" url="https://ai.feishu-boe.cn/lingo/editor?locale&#x3D;zh-CN&amp;abbrId&#x3D;enterprise_7233732879589572628&amp;query&#x3D;Ai&amp;open_source&#x3D;card_entity_editor" tooltip=""           className="" subscribed=""           text-unsubscribe="取消订阅"           data-tooltip-subscribed-text="订阅后，将会通过订阅号推送词条下的新增文档"           data-tooltip-not-subscribed-text="取消订阅后，将不会再收到相关推送"           data-toast-subscribe="订阅成功，将会通过订阅号推送词条下的新增文档"           data-toast-unsubscribe="取消订阅后，将不会再收到相关推送"           data-ignore-success-toast="已关闭词条下划线提示"          />         <action shareModelTitle="" showOut="" type="ignore" text="关闭词条下划线" url="" tooltip=""           className="" subscribed=""           text-unsubscribe="取消订阅"           data-tooltip-subscribed-text="订阅后，将会通过订阅号推送词条下的新增文档"           data-tooltip-not-subscribed-text="取消订阅后，将不会再收到相关推送"           data-toast-subscribe="订阅成功，将会通过订阅号推送词条下的新增文档"           data-toast-unsubscribe="取消订阅后，将不会再收到相关推送"           data-ignore-success-toast="已关闭词条下划线提示"          />         <action shareModelTitle="" showOut="" type="divider" text="" url="" tooltip=""           className="" subscribed=""           text-unsubscribe="取消订阅"           data-tooltip-subscribed-text="订阅后，将会通过订阅号推送词条下的新增文档"           data-tooltip-not-subscribed-text="取消订阅后，将不会再收到相关推送"           data-toast-subscribe="订阅成功，将会通过订阅号推送词条下的新增文档"           data-toast-unsubscribe="取消订阅后，将不会再收到相关推送"           data-ignore-success-toast="已关闭词条下划线提示"          />         <action shareModelTitle="" showOut="" type="create" text="创建词条" url="https://ai.feishu-boe.cn/lingo/editor?action&#x3D;create&amp;abbrId&#x3D;enterprise_7233732879589572628&amp;locale&#x3D;zh-CN&amp;open_source&#x3D;card_entity_create" tooltip=""           className="" subscribed=""           text-unsubscribe="取消订阅"           data-tooltip-subscribed-text="订阅后，将会通过订阅号推送词条下的新增文档"           data-tooltip-not-subscribed-text="取消订阅后，将不会再收到相关推送"           data-toast-subscribe="订阅成功，将会通过订阅号推送词条下的新增文档"           data-toast-unsubscribe="取消订阅后，将不会再收到相关推送"           data-ignore-success-toast="已关闭词条下划线提示"          />         <action shareModelTitle="" showOut="" type="home" text="前往词典首页" url="https://baikeredirect.feishu.cn/drive/lingo?locale&#x3D;zh-CN&amp;open_source&#x3D;card_web_tab" tooltip=""           className="" subscribed=""           text-unsubscribe="取消订阅"           data-tooltip-subscribed-text="订阅后，将会通过订阅号推送词条下的新增文档"           data-tooltip-not-subscribed-text="取消订阅后，将不会再收到相关推送"           data-toast-subscribe="订阅成功，将会通过订阅号推送词条下的新增文档"           data-toast-unsubscribe="取消订阅后，将不会再收到相关推送"           data-ignore-success-toast="已关闭词条下划线提示"          />     </abbr-action-v2>   </view>   <view     className="larkw-aslCard-layout-block baike_navbar_scrollbar_trigger larkw-abbreviation-content larkw-aslCard-scrollbar larkw-aslCard-scrollbar-hover"     style="max-height: inherit; max-width: inherit; overflow: hidden overlay;word-break: normal;"     canUseContributors="true">     <view className="larkw-aslCard-util-bg-ultra" id="larkw-aslCard-body-enterprise_7233732879589572628">       <view className="larkw-aslCard-layout-block larkw-aslCard-baike-header"         style='padding:24px 20px 0; position: relative;'>         <view className="aslcard-baike-nav-placeloader" />            <view              className="larkw-aslCard-layout-block main-key-content"              style="position: relative;width: 100%;"            >             <view className="larkw-aslCard-layout-inlineBlock" style='position: absolute; top: 0; right: 0;'>             </view>             <tooltip                title="进入词条详情页"                style="max-width:calc(100% - 64px);width:fit-content;"                className="main-key-tooltip"               bind='{"onClick":{                 "callbacks":[{"funcName":"openURL","params":{"url":"https://ai.feishu-boe.cn/lingo/detail/7233732879589572628?open_source&#x3D;card_entity_home"}}],                 "events":[{"eventName":"event_track_v2","params":{"click":"function","function_type":"entity_name"}}]               }}'             >                 <text-highlight locale="zh-CN" style="color: @text-title;font-size: 18px;font-weight: 500;line-height: 26px;margin-right: 8px;"  text="Ai"  highlightTerms='[]'/>             </tooltip>           </view>            <view className="larkw-aslCard-layout-flex" style="align-items: center;">             <user-list data-text-hint="贡献" version="v2" maxCountShow="2">                 <user userId="7215104701929357331" avatarKey="v2_98f36e28-20f7-4f32-889c-b926df7eb22j" tooltip="张晓阳"                   className="aslcard-barike-ultra-useritem" userName="张晓阳" size="24" style="">                 </user>               <user-rest                 style="margin-right: 8px;height: 24px;width: 24px;display: flex;align-items: center;justify-content: center;border-radius: 50%;background-color: #EFF0F1;color: @text-caption;cursor: pointer;margin-right: 0;margin-bottom: 0;">               </user-rest>             </user-list>             <image style="margin: 0px 2px 0px 6px">              <svg width="2" height="10" viewBox="0 0 2 10" fill="none" xmlns="http://www.w3.org/2000/svg">                 <path d="M1 0V10" stroke="#BBBFC4"/>               </svg>             </image>             <view               className="to_answer"               id="user-list-right-node"               bind='{"onClick":{               "callbacks":[{"funcName":"openURL","params":{"url":"https://ai.feishu-boe.cn/lingo/detail/7233732879589572628?anchor&#x3D;qaComment&amp;addQuestion&#x3D;true&amp;open_source&#x3D;ask_contributor"}}],               "events":[{"eventName":"event_track_v2","params":{"click":"function","function_type":"ask_contributor"}}]               }}'>               <text>提问</text>             </view>           </view>         </view>        <view className="larkw-aslCard-layout-block aslcard-baike-section-ultra" style="padding-top: 0px;">         <view className="larkw-aslCard-layout-block asl-section-description" style="padding:4px 20px;">             <text-highlight               bind='{                 "onUnFold": {"events":[{                   "eventName":"event_track_v2",                   "params":{"click":"function","function_type":"description_unfold"}                 }]}               }'               locale="zh-CN"                maxHeight="setMaxHeightVal folderSwitcher.canDescriptionFolder 66"                style="white-space: pre-wrap;word-break: break-word;"                text="人工智能是计算机科学的一个分支，它企图了解智能的实质，并生产出一种新的能以人类智能相似的方式做出反应的智能机器，该领域的研究包括机器人、语言识别、图像识别、自然语言处理和专家系统等。"                 highlightTerms='[&quot;&amp;#10&quot;]'             />         </view>       </view>         <async-template         hidden="false"         templateName="recommend_docs"         templateId="recommendRelatedDoc"         serviceName="getRelatedResource"         params='{"entryIds":["enterprise_7233732879589572628"],"resourceTypes":[1],"enterFrom":""}'       />          <view className="larkw-aslCard-layout-block larkw-aslCard-hideInLarkSearch larkw-aslCard-showInLark">          <view className="larkw-aslCard-layout-flex"           style='padding: 10px 20px;font-size: 12px;line-height: 20px;color: @text-caption;margin-bottom:14px;'>           <view style="display: flex;align-items: center;">             <text>找不到想要的信息？</text>             <view className="larkw-aslCard-layout-inlineBlock larkw-aslCard-text-link-button"               style="color: @text-link-normal;" bind='{"onClick":{         "callbacks":[{"funcName":"openLarkSearch","params":{"query":"Ai"}}],         "events":[{"eventName":"event_track_v2","params":{"click":"function","function_type":"search","abbr_id":"enterprise_7233732879589572628"}}]         }}'>               搜索更多             </view>           </view>         </view>       </view>          <view style="display: none;" role="for-debug"         data-canShowSuperAdminBanner=""         data-superAdminBannerHref=""         data-canShowNormalUserBanner="false"         data-normalUserBannerHref=""         data-IsUserSuperAdmin="nodata"         data-IsTenantActivated="nodata" />     </view>   </view>    <view className="aslcard-baike-footer">     <view className="aslcard-baike-divider" style="margin: 0 20px;">     </view>     <view       style="display: flex;align-items: center;justify-content: space-between;height: 46px;padding: 0 16px;flex-shrink: 0;">       <view className="aslcard-baike-logo-btn-container larkw-aslCard-layout-flex" style="max-width: calc(100% - 84px);">         <tooltip title="前往词典首页，探索更多词条" style="width: 100%">           <view className="aslcard-baike-btn aslcard-baike-btn-extra-small aslcard-baike-logo-btn"             url="https://baikeredirect.feishu.cn/drive/lingo?locale&#x3D;zh-CN&amp;from&#x3D;logo&amp;abbrId&#x3D;enterprise_7233732879589572628&amp;page&#x3D;category&amp;repo_id&#x3D;1&amp;open_source&#x3D;card_web_logo"             bind='{"onClick":{"events":[{"eventName":"event_track_v2","params":{"click":"function","function_type":"encyclopedia_logo","target":"asl_abbr_paltform_view","abbr_id":"enterprise_7233732879589572628"}}]}}'>             <view className="aslcard-baike-logo-btn-img" style="width: 21px; height: 17px;">               <image url="https://lf-cdn-tos.bytescm.com/obj/static/asl-card/baike-logo-gray-lm_zh-CN_v2.svg"                 className="aslcard-baike-logo-btn-img-placeholder"></image>             </view>             <text className="repo_name">企业词库</text>             <image>               <svg width="13" height="13" viewBox="0 0 13 13" fill="none" xmlns="http://www.w3.org/2000/svg">                 <path                   d="M4.65292 2.64645C4.45765 2.84171 4.45765 3.15829 4.65292 3.35355L7.79936 6.5L4.65292 9.64645C4.45765 9.84171 4.45765 10.1583 4.65292 10.3536C4.84818 10.5488 5.16476 10.5488 5.36002 10.3536L8.86002 6.85355C8.95379 6.75979 9.00647 6.63261 9.00647 6.5C9.00647 6.36739 8.95379 6.24021 8.86002 6.14645L5.36002 2.64645C5.16476 2.45118 4.84818 2.45118 4.65292 2.64645Z"                   fill="currentColor" />               </svg>             </image>           </view>         </tooltip>       </view>        <view className="like-kit">         <like-kit like-count='0' data-text-ignore-btn="关闭词条提示"           dislike-count='0' like="" dislike=""           data-text-feedback-title="反馈给贡献者"           data-text-feedback-success="反馈提交成功"           show-like="true"            show-dislike="false"         ></like-kit>         <tooltip title="我要反馈" className="aslcard-baike-fotter-icon">           <view  bind='{"onClick":{           "callbacks":[{"funcName":"openFeedback","params":{"title":"词条反馈"}}],           "events":[{"eventName":"event_track_v2","params":{"click":"function","function_type":"feedback_logo"}}]           }}' style="height: 16px;">             <image >               <svg width="14" height="16" viewBox="0 0 14 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg">                 <path d="M10.6667 1.99984H1.33333V13.9998H4.66667V15.3332H1.33333C0.596954 15.3332 0 14.7362 0 13.9998V1.99984C0 1.26346 0.596954 0.666504 1.33333 0.666504H10.6667C11.403 0.666504 12 1.26346 12 1.99984V7.33317H10.6667V1.99984Z" fill="currentColor"/>                 <path d="M3.33333 4.6665C2.96514 4.6665 2.66667 4.96498 2.66667 5.33317C2.66667 5.70136 2.96514 5.99984 3.33333 5.99984H8.66667C9.03486 5.99984 9.33333 5.70136 9.33333 5.33317C9.33333 4.96498 9.03486 4.6665 8.66667 4.6665H3.33333Z" fill="currentColor"/>                 <path d="M2.66667 8.33317C2.66667 7.96498 2.96514 7.6665 3.33333 7.6665H6C6.36819 7.6665 6.66667 7.96498 6.66667 8.33317C6.66667 8.70136 6.36819 8.99984 6 8.99984H3.33333C2.96514 8.99984 2.66667 8.70136 2.66667 8.33317Z" fill="currentColor"/>                 <path d="M11.5523 8.69999C11.9428 8.30946 12.576 8.30946 12.9665 8.69999C13.357 9.09051 13.357 9.72367 12.9665 10.1142L12.2594 10.8213L10.8452 9.40709L11.5523 8.69999Z" fill="currentColor"/>                 <path d="M10.1381 10.1142L11.5523 11.5284L8.23093 14.8498C8.09164 14.9891 7.91229 15.0813 7.71798 15.1136L6.45737 15.3233C6.42136 15.3292 6.38467 15.3175 6.35885 15.2917C6.33271 15.2655 6.32099 15.2282 6.32749 15.1918L6.55128 13.9372C6.58465 13.7501 6.6746 13.5777 6.80901 13.4433L10.1381 10.1142Z" fill="currentColor"/>               </svg>             </image>           </view>         </tooltip>           <tooltip title="相关讨论" className="aslcard-baike-fotter-icon">             <view  bind='{"onClick":{           "callbacks":[{"funcName":"openURL","params":{"url":"https://ai.feishu-boe.cn/lingo/detail/7233732879589572628?anchor&#x3D;qaComment&amp;open_source&#x3D;answers_logo"}}],           "events":[{"eventName":"event_track_v2","params":{"click":"function","function_type":"answers_logo"}}]           }}' style="height: 16px;">               <image >                 <svg width="16" height="16" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg">                 <path d="M3.66675 8.66634H2.00008V2.66634H10.6667V8.66634H6.33059L3.66675 10.8333V8.66634ZM6.66675 9.99968H10.6667C11.4031 9.99968 12.0001 9.40272 12.0001 8.66634V2.66634C12.0001 1.92996 11.4031 1.33301 10.6667 1.33301H2.00008C1.2637 1.33301 0.666748 1.92996 0.666748 2.66634V8.66634C0.666748 9.40272 1.2637 9.99968 2.00008 9.99968H2.33341V11.9495C2.33341 12.4539 2.87199 12.7756 3.31615 12.5365L6.66675 9.99968ZM8.99726 12.6667H5.34274L7.0094 11.3333H9.33341L12.0001 13.5V11.333H14.0001V5.99967H13.3334V4.66634H14.0001C14.7365 4.66634 15.3334 5.2633 15.3334 5.99967V11.333C15.3334 12.0694 14.7365 12.6663 14.0001 12.6663H13.3334V14.6162C13.3334 15.1206 12.7948 15.4423 12.3507 15.2031L8.99726 12.6667Z" fill="currentColor"/>                 </svg>               </image>             </view>           </tooltip>       </view>     </view>   </view>    <abbr-data-carrier id="abbr-data-carry-id" data-report-card-view='[{"result_type":"success"}]'></abbr-data-carrier>   <guide       data-options='{"key":"Lingo_card_share","style":{"zIndex":100,"width":"max-content"},"conf":[{"content":"词典支持分享词条啦！","target":".larkw-aslCard-moreactions-wrapper .abbr_share_icon","direction":"bottom","align":"center","distance":4,"clickBlankToDisappear":true,"autoFinishMs":5000}],"extraDaInfo":{"abbr_id":"enterprise_7233732879589572628","onboarding_type":"bubble","onboarding_sub_type":"entity_share"}}' >   </guide>   <guide        data-options='{"key":"Lingo_doc_homograph","style":{"zIndex":100,"width":"max-content"},"conf":[{"content":"点击置顶，在当前文档优先展示该释义","target":".abbrmultidescv2-item-pinItem .larkw-aslCard-icon-mask","direction":"top","align":"center","distance":4,"clickBlankToDisappear":true,"autoFinishMs":5000}],"extraDaInfo":{"abbr_id":"enterprise_7233732879589572628","onboarding_type":"bubble","onboarding_sub_type":"entity_pin"}}' >   </guide> </view>
         */
        private String card;
        /**
         * 卡片对应词条的id
         * <p> 示例值：enterprise_7233732879589572628
         */
        private String id;
        /**
         * 用户点击的高亮词条
         * <p> 示例值：Ai
         */
        private String key;
        /**
         * 词条卡片类型
         * <p> 示例值：
         */
        private Integer cardType;
        /**
         * 卡片模版名
         * <p> 示例值：abbreviation-ultra
         */
        private String templateName;

        /**
         * 根据请求的渲染类型进行渲染后的词条卡片数据
         * <p> 示例值：<view className="aslcard-baike-ultra-card larkw-aslCard-layout-flex aslcard-baike-container-outer without-copyperm-dom"   style='flex-direction: column; width: 100%; box-sizing: border-box; height: 100%; max-height: inherit; max-width: inherit;position: relative;'>   <style id="baike-card-external-ultra">     .aslcard-baike-container-outer {       min-width: 320px;     }      .abbreviation-cardItem_insearch .aslcard-baike-container-outer {       min-width: 100%;     }      .larkw-aslCard-card-container .larkw-aslCard-element-abbrnav-bar {       padding-top: 12px;     }      .larkw-aslCard-baikeCard .larkw-aslCard-showInLark {       display: none;     }      .larkw-aslCard-baikeCard-inLark .larkw-aslCard-showInLark {       display: block;     }      .larkw-aslCard-baikeCard-inLark .larkw-aslCard-footer-ignoreBtn {       display: none;     }      .list-item-avatar {       margin-right: 8px;       flex-shrink: 0;       overflow: hidden;       border-radius: 8px;     }      .list-item-avatar-bg {       background-color: @primary-pri-100;     }      .list-item-title {       overflow: hidden;       text-overflow: ellipsis;       white-space: nowrap;       color: @text-title;     }      .list-item-title.larkw-aslCard-text-link-button {       margin-left: -2px;     }      .larkw-aslCard-text-link-button {       padding: 0 4px;       transition: none;       border-radius: 6px;     }      .larkw-aslCard-text-link-button:hover {       color: @text-link-normal;     }      .larkw-aslCard-text-link-button:active {       color: @text-link-pressed;     }      .larkw-aslCard-baike-header {}      .larkw-aslCard-baikeCard-actions-icon .universe-icon {       font-size: 16px;     }      .baikeSectionHeader {       width: 100%;       box-sizing: border-box;       padding-left: 16px;     }      .baikeSectionHeaderInner {       padding: 8px 0;       flex-shrink: 0;       font-size: 12px;       margin-right: 4px;       line-height: 20px;       color: @text-caption;     }      .larkw-aslCard-ig .larkw-aslCard-element-abbrnav-bar {       padding: 18px 0 10px 0;       margin-left: -4px;     }      .abbreviation-cardItem_insearch .larkw-aslCard-showInLarkSearch {       display: block;     }      .abbreviation-cardItem_insearch .larkw-aslCard-hideInLarkSearch {       display: none;     }      .abbreviation-cardItem_insearch .larkw-aslCard-icon-mask.larkw-aslCard-baikeCard-actions-icon:not(:last-child),     .abbreviation-cardItem_insearch .larkw-aslCard-icon-mask:not(:last-child) {       display: none;     }      .baike-card-link-item .larkw-aslCard-element-image-fallback,     .baike-card-link-item .larkw-aslCard-element-plImage-placeholder {       background-color: @primary-pri-100;     }      .baike-card-link-item-default {       display: flex;       justify-content: center;       align-items: center;       background-color: @primary-pri-100;        color: @text-link-normal;     }      .larkw-aslCard-text-link-ig:hover {       color: @text-link-hover;     }      .larkw-aslCard-text-link-ig:active {       color: @text-link-pressed;     }      .larkw-aslCard-abbrClassify-tag .ud__tag__content {       max-width: 100px;       overflow: hidden;       text-overflow: ellipsis;       white-space: nowrap;     }      .larkw-aslCard-layout-block.larkw-abbreviation-content {       padding: 0;       box-sizing: inherit;     }      .larkw-abbreviation-content {       border-radius: 10px;     }      .list-item-avatar-user .ud__avatar {       height: 24px !important;       width: 24px !important;     }      .lux-ellipsis-line {       overflow: hidden;       text-overflow: ellipsis;       white-space: nowrap;       min-width: 50px;     }      .ud__menu-normal-item-title-content.ud__menu-normal-item-title-content-text-overflow {       white-space: nowrap;       overflow: hidden;       text-overflow: ellipsis;     }      .asl-section-description .larkw-aslCard-element-text {       white-space: pre-wrap;       word-break: break-word;     }      .abbreviation-cardItem_insearch .larkw-aslCard-element-image-set .image-cell {       width: 9.18vw;       height: 9.18vw;     }      .larkw-aslCard-element-rich-text .larkw-aslCard-element-link,      .larkw-aslCard-element-rich-text .larkw-aslCard-element-richlink {       margin: 0px !important;       padding: 3px 2px;       display: inline;     }      .larkw-aslCard-element-rich-text .larkw-aslCard-element-abbreviation {       display: inline;       cursor: pointer;       line-height: 20px;       position: relative;       border-bottom-style: solid;       border-width: 1px;       border-image-slice: 1;       border-image-source: repeating-linear-gradient(90deg, @N650 0, @N650 1px, transparent 0, transparent 3px);     }     .larkw-aslCard-element-rich-text .larkw-aslCard-element-abbreviation:hover,     .larkw-aslCard-element-rich-text .larkw-aslCard-element-abbreviation:active {       border-bottom-color: @B500;     }      .larkw-aslCard-element-rich-text .larkw-aslCard-element-abbreviation:hover {       color: @B500;       border-image-source: repeating-linear-gradient(90deg, @B500 0, @B500 1px, transparent 0, transparent 3px);     }      .larkw-aslCard-element-at {       color: @text-link-normal !important;     }      .main-key-content {       width: fit-content;       padding-bottom: 4px;     }      .main-key-tooltip {       cursor: pointer;     }      .main-key-tooltip:hover {       .larkw-aslCard-element-text {         color: @text-link-hover !important;       }     }      .larkw-aslCard-baikecard-feedback .panel {       display: flex;       flex-wrap: wrap;       grid-template-columns: unset;       grid-template-rows: unset;        .capsule {         min-width: 183px;          .capsule-text {           overflow: hidden;           text-overflow: ellipsis;         }       }     }   </style>    <style id="aslcard_theme_ultra">     .ai-popup-portal .ai-popup-wrapper {       border: none;       overflow: inherit;       box-shadow: @shadow-s4-down;     }      .larkw-aslCard-util-bg-ultra {       background-repeat: no-repeat;       background-position: 0 0;       background-size: 100% 143px;     }      .larkw-aslCard-card-theme-LIGHT .larkw-aslCard-util-bg-ultra {       background-image: url(https://lf-cdn-tos.bytescm.com/obj/static/asl-card/lm-min-ultra.png?time=202209222)     }      .larkw-aslCard-card-theme-DARK .larkw-aslCard-util-bg-ultra {       background-image: url(https://lf-cdn-tos.bytescm.com/obj/static/asl-card/dm-min-ultra.png?time=202209222)     }      .aslcard-ellipsis {       overflow: hidden;       text-overflow: ellipsis;       white-space: nowrap;     }      .aslcard-baike-section-ultra {       padding: 6px 0px;     }      .asl-baikeultra-section-title {       font-weight: 500;       font-size: 12px;        line-height: 22px;       display: flex;       align-items: center;       padding: 4px 20px;       color: @text-title;        .section-subTitle {         color: @text-caption;         font-weight: 400;         padding-left: 2px;       }     }      .asl-baikeultra-list-item {       padding: 6px 20px;       display: flex;       align-items: center;        .item-tag-md {         margin-left: 4px;       }     }      .aslcard-baike-btn {       display: flex;       align-items: center;       justify-content: center;       border-radius: 6px;       cursor: pointer;     }      .aslcard-baike-btn:hover {       background-color: @fill-hover;     }      .aslcard-baike-btn-extra-small {       height: 24px;       padding: 0 2px;     }      .aslcard-baike-btn-logo {}      .aslcard-baike-category-item {       margin: 4px 8px 4px 0px;       position: relative;       cursor: pointer;       line-height: 20px;       display: flex;        .category-tag-icon {         position: absolute;         right: 6px;         display: flex;         color: @udtoken-tag-text-blue;       }        .aslcard-baike-tag-md {         font-size: 12px;         font-weight: 400;         color: @udtoken-tag-text-blue;         background-color: @udtoken-tag-bg-blue;         cursor: pointer;         padding-right: 17px;       }     }      .aslcard-baike-category-item: hover {       .aslcard-baike-tag-md {         background-color: @udtoken-tag-bg-blue-hover;       }     }      .aslcard-baike-btn-bg-primary {       cursor: pointer;       background-color: @primary-pri-50;     }      .aslcard-baike-btn-bg-primary:hover {       background-color: @primary-pri-100;     }      .aslcard-baike-btn-bg-primary:active {       background-color: @primary-pri-200;     }      .aslcard-baike-divider {       height: 1px;       background-color: @line-divider-default;       transform: scaleY(0.5);     }      .aslcard-baike-navbar {       user-select: none;       box-sizing: border-box;       background-color: @bg-float;       border-radius: 10px 10px 0 0;       position: absolute;       width: 100%;       z-index: 3;       overflow: hidden;       height: 56px;       opacity: 0;       pointer-events: none;     }      .aslcard-baike-navbar-content {       width: 100%;       height: 22px;       display: flex;       align-items: center;       border-radius: 10px 10px 0 0;       overflow: hidden;     }      .aslcard-baike-navbar-noback {       box-sizing: border-box;       padding: 0px 20px;       height: 22px;     }      .aslcard-baike-navbar-withback {       justify-content: center;       display: none;     }      .larkw-aslCard-baikeCard-scrolled .aslcard-baike-navbar {       opacity: 1;       pointer-events: auto;       padding-top: 21px;       transition: opacity 0.15s;     }      .aslcard-baike-navbar-goback-btn {       display: none;       position: absolute;       top: 20px;       left: 16px;       z-index: 3;     }      .aslcard-baike-nav-placeloader {       display: none;       height: 28px;       width: 100%;     }      .larkw-aslCard-baikeCard-withgoback .aslcard-baike-navbar-goback-btn {       display: flex;     }      .larkw-aslCard-baikeCard-withgoback .aslcard-baike-navbar-noback {       display: none;     }      .larkw-aslCard-baikeCard-withgoback.larkw-aslCard-baikeCard-scrolled .aslcard-baike-navbar-withback {       display: flex;     }      .larkw-aslCard-baikeCard-withgoback .aslcard-baike-nav-placeloader {       display: block;     }      .larkw-aslCard-element-abbrmultidesc .abbrmultidesc-list {       max-height: 150px;       overflow: hidden auto;       margin-left: -8px;       margin-right: -8px;     }      .larkw-aslCard-element-abbrmultidesc .abbrmultidesc-item-content {       overflow: hidden;       text-overflow: ellipsis;       display: -webkit-box;       -webkit-line-clamp: 2;       -webkit-box-orient: vertical;     }      .abbreviation-cardItem_insearch {       border-radius: 8px;     }      .abbreviation-cardItem_insearch .larkw-aslCard-card-theme-LIGHT .larkw-aslCard-util-bg-ultra,     .abbreviation-cardItem_insearch .larkw-aslCard-card-theme-DARK .larkw-aslCard-util-bg-ultra {       background-image: none;     }      .larkw-aslCard-element-userlistV2 {       margin-left: -4px;     }      .aslcard-baike-logo-btn-img {       display: flex;       transition: background-image 0.15s;     }      .aslcard-baike-logo-btn-img-placeholder {       opacity: 0;     }      .aslcard-baike-logo-btn {       color: @icon-n3;              .repo_name {         color: @text-placeholder;         font-size: 12px;         padding-left: 0px;         overflow: hidden;         text-overflow: ellipsis;         white-space: nowrap;         font-weight: 600;       }     }      .aslcard-baike-logo-btn:hover {       color: @icon-n2;        .repo_name {         color: @text-title;       }     }      .aslcard-baike-logo-btn .aslcard-baike-logo-btn-img {       background-image: url(https://lf-cdn-tos.bytescm.com/obj/static/asl-card/baike-logo-gray-lm_zh-CN_v2.svg);     }      .aslcard-baike-logo-btn:hover .aslcard-baike-logo-btn-img {       background-image: url(https://lf-cdn-tos.bytescm.com/obj/static/asl-card/baike-logo-colorful-lm_zh-CN_v2.svg);     }      .larkw-aslCard-card-theme-DARK .aslcard-baike-logo-btn .aslcard-baike-logo-btn-img {       background-image: url(https://lf-cdn-tos.bytescm.com/obj/static/asl-card/baike-logo-gray-dm_zh-CN_v2.svg);     }      .larkw-aslCard-card-theme-DARK .aslcard-baike-logo-btn:hover .aslcard-baike-logo-btn-img {       background-image: url(https://lf-cdn-tos.bytescm.com/obj/static/asl-card/baike-logo-colorful-dm_zh-CN_v2.svg);     }      .larkw-aslCard-element-userlistV2-content .aslcard-barike-ultra-useritem:not(:last-child) {       margin-right: 4px;     }      .larkw-aslCard-element-userlistV2-hint .username {       overflow: hidden;       text-overflow: ellipsis;       white-space: nowrap;       max-width: 144px;     }      .aslcard-baike-ultra-card .larkw-aslCard-footer-dislike-button .universe-icon.larkw-aslCard-footer-like-icon {       color: @icon-n3;     }      .larkw-aslCard-element-abbrmultidesc .abbrmultidesc-list {       padding-bottom: 4px;       max-height: 144px;       overflow: hidden overlay;       margin-left: -5px;       margin-right: -5px;     }      .larkw-aslCard-element-abbrmultidesc .abbrmultidesc-item {       line-height: 18px;       padding: 7px 5px 7px 18px;     }      .larkw-aslCard-element-abbrmultidesc .abbrmultidesc-item-active {       color: @text-title;     }      .larkw-aslCard-element-abbrmultidesc .abbrmultidesc-item-visited {       color: @text-title;     }      .larkw-aslCard-element-abbrmultidesc .abbrmultidesc-item:before {       content: "";       position: absolute;       top: 13px;       border-radius: 50%;       left: 5px;       width: 6px;       height: 6px;       background-color: @icon-disabled;     }      .larkw-aslCard-element-abbrmultidesc .abbrmultidesc-item-active:before {       background-color: @B500;     }      .larkw-aslCard-element-abbrmultidesc div.abbrmultidesc-item {       padding: 7px 5px 7px 18px;     }      .larkw-aslCard-element-abbrmultidesc .abbrmultidesc-item .abbrmultidesc-item-content {       padding: 0;     }      .larkw-aslCard-element-abbrmultidesc .abbrmultidesc-item-pinItem {       margin-right: -5px;     }      .abbrmultidesc-list::-webkit-scrollbar-thumb:hover {       background-color: transparent !important;     }      .-container {       display: block;     }      .aslCard-baikeCard-alias-wrapper {       margin-top: 2px;       .aslCard-baikeCard-alias {         color: @text-caption;         font-size: 14px;         line-height: 22px;       }     }      .ellipsis-two-line {       overflow: hidden;       text-overflow: ellipsis;       display: -webkit-box;       -webkit-line-clamp: 2;       -webkit-box-orient: vertical;     }      .ellipsis-one-line {       overflow: hidden;       text-overflow: ellipsis;       display: -webkit-box;       -webkit-line-clamp: 1;       -webkit-box-orient: vertical;     }          .larkw-aslCard-element-abbrmultidescv2 .abbrmultidescv2-list-wrapper {       user-select: none;       max-height: 128px;     }      .larkw-aslCard-element-abbrmultidescv2 .abbrmultidescv2-list-unexpanded {       max-height: 0px !important;     }          .abbrmultidescv2-list.aslcard-baikecard-scrollarea::-webkit-scrollbar {       display: none;     }      .larkw-aslCard-section-title {       display: flex;       justify-content: space-between;       border-radius: 6px;       padding-right: -4px;        .title-right-btn {         margin-right: -4px;         display: flex;         flex-direction: row;         align-items: center;         cursor: pointer;         color: @text-caption;         font-size: 12px;         font-weight: 400;         height: 20px;         line-height: 20px;         padding: 0px 4px;         border-radius: 6px;       }        .title-right-btn.related-docs-title {           display: none;       }        .title-right-btn: hover{          background-color:  @fill-hover;       }     }      .larkw-aslCard-recommend-docs-entry-show {       .larkw-aslCard-section-title {         .title-right-btn.related-docs-title {           display: flex;         }       }     }       .larkw-aslCard-folder-container-normal-button {       padding: 4px 0px 4px 16px;        .folder-option {         padding: 0px 4px;       }     }      .larkw-aslCard-folder-container-link-button {       right: 0px;     }          .aslcard-baike-showEntry-section {       margin-left: 12px !important;       margin-right: 12px !important;        .aslcard-baike-relatedWords-showEntry:hover {         background-color: @bg-float-overlay;;         cursor: pointer;       }        .asl-baikeultra-section-title {         padding:4px 8px;       }        .larkw-aslCard-layout-block {         padding:0px 8px;          .larkw-aslCard-folder-container-normal-button {            padding-left: 0px;         }       }        .larkw-aslCard-folder-container-normal-button {         padding-left: 8px;       }     }      .larkw-aslCard-relatedWord-block {         width: 100%;         margin-bottom: 2px;                  .larkw-aslCard-relatedWord-block-title {           color: @text-caption;           font-size: 12px;           line-height: 20px;           display: flex;           align-items: center;           margin-bottom: 4px;         }          .larkw-aslCard-relatedWord-block-content{           display: flex;           flex-wrap: wrap;         }     }      .larkw-aslCard-relatedWord-block:last-child {         padding-bottom: 0px;     }      .like-kit {       display: flex;       flex-direction: row;     }      .larkw-aslCard-scrollbar::-webkit-scrollbar {       display: none;     }      .abbrmultidescv2-item-active .abbrmultidescv2-item-pinItem {       opacity: 1 !important;     }      .aslcard-baike-fotter-icon {       width: 24px;       height: 24px;       border-radius: 8px;       cursor: pointer;       align-items:center;        justify-content: center;       display: flex;       color: @icon-n3;       margin-left: 4px;     }      .aslcard-baike-fotter-icon:hover {       background-color: @udtoken-btn-text-bg-neutral-hover;;     }    </style>    <style id="aslcard_qa">     .aslcard-baike-relatedQASection {         .show-one-line {           height:          }          .relatedQA-page-entry: hover {            background-color:  @fill-hover;         }          .larkw-aslCard-QA-item {           display: flex;           flex-direction: row;           padding: 6px 8px;           border-radius: 6px;           cursor: pointer;            .QA_content {             width: 100%;                          .larkw-aslCard-element-rich-text {               white-space: nowrap;               overflow: hidden;               text-overflow: ellipsis;               display: inline-block;               width: calc(100% - 34px);               height: 22px;               pointer: cursor;                span {                 white-space: nowrap;               }             }              .Q_content,             .A_content {               height: 22px;               line-height:22px;               align-items: center;               display: flex;               flex-direction: row;               padding: 1px 0px;                .QA_icon {                 width: 20px;                 height: 20px;                 line-height: 20px;                 text-align: center;                 border-radius: 6px;                 margin-right:10px;                 font-size: 12px;               }                .Q_icon {                 background-color: @primary-pri-100;                 color: @primary-pri-500;               }                .A_icon {                 background-color: @function-warning-100;                 color: @function-warning-600;               }             }              .no_answer {               font-size: 14px;               line-height: 20px;               color: @text-caption;               display: flex;               align-items: center;                .to_answer {                 font-size: 14px;               }             }         }       }           .larkw-aslCard-QA-item: hover {           background-color:  @fill-hover;         }     }     .to_answer {       color: @text-link-normal;       border-radius: 6px;       padding: 0px 4px;       font-size: 12px;       line-height: 20px;       height: 20px;       cursor: pointer;     }      .to_answer:hover {       color: @text-link-normal;       background-color: @fill-active;     }      .to_answer:active {       color: @text-link-pressed;       background-color: @fill-active;     }      .to-answer-related-users,     .to-answer-contributors {       display: flex;       flex-direction: row;       font-size: 12px;       line-height: 20px;       color: @text-caption;       cursor: pointer;       width: fit-content;       flex-wrap: wrap;     }    </style>    <style id="aslcard-related-words">     .larkw-aslCard-relatedWords-wrapper {       padding: 0px 16px;       .larkw-aslCard-relatedWords-calssfication-item {         padding:4px 4px 0px 4px !important;         .title {           margin-bottom: 4px;           height: auto;            .title-text {             margin-bottom: 0px;             flex: 1;           }         }         .abbreviation-item {           margin: 0px 6px 6px 0px;         }       }        .larkw-aslCard-folder-container-normal-button {         padding-left: 0px !important;       }     }   </style>    <style id="abbrmulti-desc-v2">     .larkw-aslCard-element-abbrmultidescv2 {       .abbrmultidescv2-header-topline {         margin: 2px 0px;       }        .abbrmultidescv2-header {         padding: 4px 0px;       }        .abbrmultidescv2-item-content {          padding: 4px 0px;       }     }      .aslcard-baike-divider {       margin: 4px 0px;     }   </style>    <view className="aslcard-baike-navbar">     <view className="aslcard-baike-navbar-content aslcard-baike-navbar-noback" style="width: calc(100% - 64px);">       <text-highlight className="ellipsis-one-line" style="font-weight: 500;font-size: 14px;"  text="Ai"  highlightTerms='[]'/>     </view>     <view className="aslcard-baike-navbar-content aslcard-baike-navbar-withback">       <text style="font-weight: 500;font-size: 14px; max-width: 120px;" className="aslcard-ellipsis">Ai</text>     </view>     <view className="aslcard-baike-divider" style="position: absolute;bottom: 0;width: 100%;"></view>   </view>   <view className="aslcard-baike-navbar-goback-btn">     <tooltip title="返回">       <view className="larkw-aslCard-icon-mask" style="color: @icon-n1;" bind='{"onClick": {         "callbacks": [           {             "funcName": "back",             "params":{}           }         ]}       }'>         <image>           <svg width="16" height="16" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg">             <path               d="M12.2197 1.71967C12.5126 2.01256 12.5126 2.48744 12.2197 2.78033L6 9L12.2197 15.2197C12.5126 15.5126 12.5126 15.9874 12.2197 16.2803C11.9268 16.5732 11.4519 16.5732 11.159 16.2803L4.93934 10.0607C4.35355 9.47487 4.35355 8.52513 4.93934 7.93934L11.159 1.71967C11.4519 1.42678 11.9268 1.42678 12.2197 1.71967Z"               fill="currentColor" />           </svg>          </image>       </view>     </tooltip>   </view>   <view style="position: absolute;top: 20px;right: 16px;z-index: 3;">     <abbr-action-v2 data-tootip-more-title="更多">         <action shareModelTitle="分享到会话" showOut="true" type="share" text="分享" url="https://ai.feishu-boe.cn/lingo/detail/7233732879589572628?open_source&#x3D;im_share_card" tooltip=""           className="abbr_share_icon" subscribed=""           text-unsubscribe="取消订阅"           data-tooltip-subscribed-text="订阅后，将会通过订阅号推送词条下的新增文档"           data-tooltip-not-subscribed-text="取消订阅后，将不会再收到相关推送"           data-toast-subscribe="订阅成功，将会通过订阅号推送词条下的新增文档"           data-toast-unsubscribe="取消订阅后，将不会再收到相关推送"           data-ignore-success-toast="已关闭词条下划线提示"          />         <action shareModelTitle="" showOut="" type="abbr_home" text="查看词条详情" url="https://ai.feishu-boe.cn/lingo/detail/7233732879589572628?open_source&#x3D;card_entity_home" tooltip=""           className="abbr_detail_home_icon" subscribed=""           text-unsubscribe="取消订阅"           data-tooltip-subscribed-text="订阅后，将会通过订阅号推送词条下的新增文档"           data-tooltip-not-subscribed-text="取消订阅后，将不会再收到相关推送"           data-toast-subscribe="订阅成功，将会通过订阅号推送词条下的新增文档"           data-toast-unsubscribe="取消订阅后，将不会再收到相关推送"           data-ignore-success-toast="已关闭词条下划线提示"          />         <action shareModelTitle="" showOut="false" type="edit" text="编辑词条" url="https://ai.feishu-boe.cn/lingo/editor?locale&#x3D;zh-CN&amp;abbrId&#x3D;enterprise_7233732879589572628&amp;query&#x3D;Ai&amp;open_source&#x3D;card_entity_editor" tooltip=""           className="" subscribed=""           text-unsubscribe="取消订阅"           data-tooltip-subscribed-text="订阅后，将会通过订阅号推送词条下的新增文档"           data-tooltip-not-subscribed-text="取消订阅后，将不会再收到相关推送"           data-toast-subscribe="订阅成功，将会通过订阅号推送词条下的新增文档"           data-toast-unsubscribe="取消订阅后，将不会再收到相关推送"           data-ignore-success-toast="已关闭词条下划线提示"          />         <action shareModelTitle="" showOut="" type="ignore" text="关闭词条下划线" url="" tooltip=""           className="" subscribed=""           text-unsubscribe="取消订阅"           data-tooltip-subscribed-text="订阅后，将会通过订阅号推送词条下的新增文档"           data-tooltip-not-subscribed-text="取消订阅后，将不会再收到相关推送"           data-toast-subscribe="订阅成功，将会通过订阅号推送词条下的新增文档"           data-toast-unsubscribe="取消订阅后，将不会再收到相关推送"           data-ignore-success-toast="已关闭词条下划线提示"          />         <action shareModelTitle="" showOut="" type="divider" text="" url="" tooltip=""           className="" subscribed=""           text-unsubscribe="取消订阅"           data-tooltip-subscribed-text="订阅后，将会通过订阅号推送词条下的新增文档"           data-tooltip-not-subscribed-text="取消订阅后，将不会再收到相关推送"           data-toast-subscribe="订阅成功，将会通过订阅号推送词条下的新增文档"           data-toast-unsubscribe="取消订阅后，将不会再收到相关推送"           data-ignore-success-toast="已关闭词条下划线提示"          />         <action shareModelTitle="" showOut="" type="create" text="创建词条" url="https://ai.feishu-boe.cn/lingo/editor?action&#x3D;create&amp;abbrId&#x3D;enterprise_7233732879589572628&amp;locale&#x3D;zh-CN&amp;open_source&#x3D;card_entity_create" tooltip=""           className="" subscribed=""           text-unsubscribe="取消订阅"           data-tooltip-subscribed-text="订阅后，将会通过订阅号推送词条下的新增文档"           data-tooltip-not-subscribed-text="取消订阅后，将不会再收到相关推送"           data-toast-subscribe="订阅成功，将会通过订阅号推送词条下的新增文档"           data-toast-unsubscribe="取消订阅后，将不会再收到相关推送"           data-ignore-success-toast="已关闭词条下划线提示"          />         <action shareModelTitle="" showOut="" type="home" text="前往词典首页" url="https://baikeredirect.feishu.cn/drive/lingo?locale&#x3D;zh-CN&amp;open_source&#x3D;card_web_tab" tooltip=""           className="" subscribed=""           text-unsubscribe="取消订阅"           data-tooltip-subscribed-text="订阅后，将会通过订阅号推送词条下的新增文档"           data-tooltip-not-subscribed-text="取消订阅后，将不会再收到相关推送"           data-toast-subscribe="订阅成功，将会通过订阅号推送词条下的新增文档"           data-toast-unsubscribe="取消订阅后，将不会再收到相关推送"           data-ignore-success-toast="已关闭词条下划线提示"          />     </abbr-action-v2>   </view>   <view     className="larkw-aslCard-layout-block baike_navbar_scrollbar_trigger larkw-abbreviation-content larkw-aslCard-scrollbar larkw-aslCard-scrollbar-hover"     style="max-height: inherit; max-width: inherit; overflow: hidden overlay;word-break: normal;"     canUseContributors="true">     <view className="larkw-aslCard-util-bg-ultra" id="larkw-aslCard-body-enterprise_7233732879589572628">       <view className="larkw-aslCard-layout-block larkw-aslCard-baike-header"         style='padding:24px 20px 0; position: relative;'>         <view className="aslcard-baike-nav-placeloader" />            <view              className="larkw-aslCard-layout-block main-key-content"              style="position: relative;width: 100%;"            >             <view className="larkw-aslCard-layout-inlineBlock" style='position: absolute; top: 0; right: 0;'>             </view>             <tooltip                title="进入词条详情页"                style="max-width:calc(100% - 64px);width:fit-content;"                className="main-key-tooltip"               bind='{"onClick":{                 "callbacks":[{"funcName":"openURL","params":{"url":"https://ai.feishu-boe.cn/lingo/detail/7233732879589572628?open_source&#x3D;card_entity_home"}}],                 "events":[{"eventName":"event_track_v2","params":{"click":"function","function_type":"entity_name"}}]               }}'             >                 <text-highlight locale="zh-CN" style="color: @text-title;font-size: 18px;font-weight: 500;line-height: 26px;margin-right: 8px;"  text="Ai"  highlightTerms='[]'/>             </tooltip>           </view>            <view className="larkw-aslCard-layout-flex" style="align-items: center;">             <user-list data-text-hint="贡献" version="v2" maxCountShow="2">                 <user userId="7215104701929357331" avatarKey="v2_98f36e28-20f7-4f32-889c-b926df7eb22j" tooltip="张晓阳"                   className="aslcard-barike-ultra-useritem" userName="张晓阳" size="24" style="">                 </user>               <user-rest                 style="margin-right: 8px;height: 24px;width: 24px;display: flex;align-items: center;justify-content: center;border-radius: 50%;background-color: #EFF0F1;color: @text-caption;cursor: pointer;margin-right: 0;margin-bottom: 0;">               </user-rest>             </user-list>             <image style="margin: 0px 2px 0px 6px">              <svg width="2" height="10" viewBox="0 0 2 10" fill="none" xmlns="http://www.w3.org/2000/svg">                 <path d="M1 0V10" stroke="#BBBFC4"/>               </svg>             </image>             <view               className="to_answer"               id="user-list-right-node"               bind='{"onClick":{               "callbacks":[{"funcName":"openURL","params":{"url":"https://ai.feishu-boe.cn/lingo/detail/7233732879589572628?anchor&#x3D;qaComment&amp;addQuestion&#x3D;true&amp;open_source&#x3D;ask_contributor"}}],               "events":[{"eventName":"event_track_v2","params":{"click":"function","function_type":"ask_contributor"}}]               }}'>               <text>提问</text>             </view>           </view>         </view>        <view className="larkw-aslCard-layout-block aslcard-baike-section-ultra" style="padding-top: 0px;">         <view className="larkw-aslCard-layout-block asl-section-description" style="padding:4px 20px;">             <text-highlight               bind='{                 "onUnFold": {"events":[{                   "eventName":"event_track_v2",                   "params":{"click":"function","function_type":"description_unfold"}                 }]}               }'               locale="zh-CN"                maxHeight="setMaxHeightVal folderSwitcher.canDescriptionFolder 66"                style="white-space: pre-wrap;word-break: break-word;"                text="人工智能是计算机科学的一个分支，它企图了解智能的实质，并生产出一种新的能以人类智能相似的方式做出反应的智能机器，该领域的研究包括机器人、语言识别、图像识别、自然语言处理和专家系统等。"                 highlightTerms='[&quot;&amp;#10&quot;]'             />         </view>       </view>         <async-template         hidden="false"         templateName="recommend_docs"         templateId="recommendRelatedDoc"         serviceName="getRelatedResource"         params='{"entryIds":["enterprise_7233732879589572628"],"resourceTypes":[1],"enterFrom":""}'       />          <view className="larkw-aslCard-layout-block larkw-aslCard-hideInLarkSearch larkw-aslCard-showInLark">          <view className="larkw-aslCard-layout-flex"           style='padding: 10px 20px;font-size: 12px;line-height: 20px;color: @text-caption;margin-bottom:14px;'>           <view style="display: flex;align-items: center;">             <text>找不到想要的信息？</text>             <view className="larkw-aslCard-layout-inlineBlock larkw-aslCard-text-link-button"               style="color: @text-link-normal;" bind='{"onClick":{         "callbacks":[{"funcName":"openLarkSearch","params":{"query":"Ai"}}],         "events":[{"eventName":"event_track_v2","params":{"click":"function","function_type":"search","abbr_id":"enterprise_7233732879589572628"}}]         }}'>               搜索更多             </view>           </view>         </view>       </view>          <view style="display: none;" role="for-debug"         data-canShowSuperAdminBanner=""         data-superAdminBannerHref=""         data-canShowNormalUserBanner="false"         data-normalUserBannerHref=""         data-IsUserSuperAdmin="nodata"         data-IsTenantActivated="nodata" />     </view>   </view>    <view className="aslcard-baike-footer">     <view className="aslcard-baike-divider" style="margin: 0 20px;">     </view>     <view       style="display: flex;align-items: center;justify-content: space-between;height: 46px;padding: 0 16px;flex-shrink: 0;">       <view className="aslcard-baike-logo-btn-container larkw-aslCard-layout-flex" style="max-width: calc(100% - 84px);">         <tooltip title="前往词典首页，探索更多词条" style="width: 100%">           <view className="aslcard-baike-btn aslcard-baike-btn-extra-small aslcard-baike-logo-btn"             url="https://baikeredirect.feishu.cn/drive/lingo?locale&#x3D;zh-CN&amp;from&#x3D;logo&amp;abbrId&#x3D;enterprise_7233732879589572628&amp;page&#x3D;category&amp;repo_id&#x3D;1&amp;open_source&#x3D;card_web_logo"             bind='{"onClick":{"events":[{"eventName":"event_track_v2","params":{"click":"function","function_type":"encyclopedia_logo","target":"asl_abbr_paltform_view","abbr_id":"enterprise_7233732879589572628"}}]}}'>             <view className="aslcard-baike-logo-btn-img" style="width: 21px; height: 17px;">               <image url="https://lf-cdn-tos.bytescm.com/obj/static/asl-card/baike-logo-gray-lm_zh-CN_v2.svg"                 className="aslcard-baike-logo-btn-img-placeholder"></image>             </view>             <text className="repo_name">企业词库</text>             <image>               <svg width="13" height="13" viewBox="0 0 13 13" fill="none" xmlns="http://www.w3.org/2000/svg">                 <path                   d="M4.65292 2.64645C4.45765 2.84171 4.45765 3.15829 4.65292 3.35355L7.79936 6.5L4.65292 9.64645C4.45765 9.84171 4.45765 10.1583 4.65292 10.3536C4.84818 10.5488 5.16476 10.5488 5.36002 10.3536L8.86002 6.85355C8.95379 6.75979 9.00647 6.63261 9.00647 6.5C9.00647 6.36739 8.95379 6.24021 8.86002 6.14645L5.36002 2.64645C5.16476 2.45118 4.84818 2.45118 4.65292 2.64645Z"                   fill="currentColor" />               </svg>             </image>           </view>         </tooltip>       </view>        <view className="like-kit">         <like-kit like-count='0' data-text-ignore-btn="关闭词条提示"           dislike-count='0' like="" dislike=""           data-text-feedback-title="反馈给贡献者"           data-text-feedback-success="反馈提交成功"           show-like="true"            show-dislike="false"         ></like-kit>         <tooltip title="我要反馈" className="aslcard-baike-fotter-icon">           <view  bind='{"onClick":{           "callbacks":[{"funcName":"openFeedback","params":{"title":"词条反馈"}}],           "events":[{"eventName":"event_track_v2","params":{"click":"function","function_type":"feedback_logo"}}]           }}' style="height: 16px;">             <image >               <svg width="14" height="16" viewBox="0 0 14 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg">                 <path d="M10.6667 1.99984H1.33333V13.9998H4.66667V15.3332H1.33333C0.596954 15.3332 0 14.7362 0 13.9998V1.99984C0 1.26346 0.596954 0.666504 1.33333 0.666504H10.6667C11.403 0.666504 12 1.26346 12 1.99984V7.33317H10.6667V1.99984Z" fill="currentColor"/>                 <path d="M3.33333 4.6665C2.96514 4.6665 2.66667 4.96498 2.66667 5.33317C2.66667 5.70136 2.96514 5.99984 3.33333 5.99984H8.66667C9.03486 5.99984 9.33333 5.70136 9.33333 5.33317C9.33333 4.96498 9.03486 4.6665 8.66667 4.6665H3.33333Z" fill="currentColor"/>                 <path d="M2.66667 8.33317C2.66667 7.96498 2.96514 7.6665 3.33333 7.6665H6C6.36819 7.6665 6.66667 7.96498 6.66667 8.33317C6.66667 8.70136 6.36819 8.99984 6 8.99984H3.33333C2.96514 8.99984 2.66667 8.70136 2.66667 8.33317Z" fill="currentColor"/>                 <path d="M11.5523 8.69999C11.9428 8.30946 12.576 8.30946 12.9665 8.69999C13.357 9.09051 13.357 9.72367 12.9665 10.1142L12.2594 10.8213L10.8452 9.40709L11.5523 8.69999Z" fill="currentColor"/>                 <path d="M10.1381 10.1142L11.5523 11.5284L8.23093 14.8498C8.09164 14.9891 7.91229 15.0813 7.71798 15.1136L6.45737 15.3233C6.42136 15.3292 6.38467 15.3175 6.35885 15.2917C6.33271 15.2655 6.32099 15.2282 6.32749 15.1918L6.55128 13.9372C6.58465 13.7501 6.6746 13.5777 6.80901 13.4433L10.1381 10.1142Z" fill="currentColor"/>               </svg>             </image>           </view>         </tooltip>           <tooltip title="相关讨论" className="aslcard-baike-fotter-icon">             <view  bind='{"onClick":{           "callbacks":[{"funcName":"openURL","params":{"url":"https://ai.feishu-boe.cn/lingo/detail/7233732879589572628?anchor&#x3D;qaComment&amp;open_source&#x3D;answers_logo"}}],           "events":[{"eventName":"event_track_v2","params":{"click":"function","function_type":"answers_logo"}}]           }}' style="height: 16px;">               <image >                 <svg width="16" height="16" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg">                 <path d="M3.66675 8.66634H2.00008V2.66634H10.6667V8.66634H6.33059L3.66675 10.8333V8.66634ZM6.66675 9.99968H10.6667C11.4031 9.99968 12.0001 9.40272 12.0001 8.66634V2.66634C12.0001 1.92996 11.4031 1.33301 10.6667 1.33301H2.00008C1.2637 1.33301 0.666748 1.92996 0.666748 2.66634V8.66634C0.666748 9.40272 1.2637 9.99968 2.00008 9.99968H2.33341V11.9495C2.33341 12.4539 2.87199 12.7756 3.31615 12.5365L6.66675 9.99968ZM8.99726 12.6667H5.34274L7.0094 11.3333H9.33341L12.0001 13.5V11.333H14.0001V5.99967H13.3334V4.66634H14.0001C14.7365 4.66634 15.3334 5.2633 15.3334 5.99967V11.333C15.3334 12.0694 14.7365 12.6663 14.0001 12.6663H13.3334V14.6162C13.3334 15.1206 12.7948 15.4423 12.3507 15.2031L8.99726 12.6667Z" fill="currentColor"/>                 </svg>               </image>             </view>           </tooltip>       </view>     </view>   </view>    <abbr-data-carrier id="abbr-data-carry-id" data-report-card-view='[{"result_type":"success"}]'></abbr-data-carrier>   <guide       data-options='{"key":"Lingo_card_share","style":{"zIndex":100,"width":"max-content"},"conf":[{"content":"词典支持分享词条啦！","target":".larkw-aslCard-moreactions-wrapper .abbr_share_icon","direction":"bottom","align":"center","distance":4,"clickBlankToDisappear":true,"autoFinishMs":5000}],"extraDaInfo":{"abbr_id":"enterprise_7233732879589572628","onboarding_type":"bubble","onboarding_sub_type":"entity_share"}}' >   </guide>   <guide        data-options='{"key":"Lingo_doc_homograph","style":{"zIndex":100,"width":"max-content"},"conf":[{"content":"点击置顶，在当前文档优先展示该释义","target":".abbrmultidescv2-item-pinItem .larkw-aslCard-icon-mask","direction":"top","align":"center","distance":4,"clickBlankToDisappear":true,"autoFinishMs":5000}],"extraDaInfo":{"abbr_id":"enterprise_7233732879589572628","onboarding_type":"bubble","onboarding_sub_type":"entity_pin"}}' >   </guide> </view>
         *
         * @param card
         * @return
         */
        public Builder card(String card) {
            this.card = card;
            return this;
        }


        /**
         * 卡片对应词条的id
         * <p> 示例值：enterprise_7233732879589572628
         *
         * @param id
         * @return
         */
        public Builder id(String id) {
            this.id = id;
            return this;
        }


        /**
         * 用户点击的高亮词条
         * <p> 示例值：Ai
         *
         * @param key
         * @return
         */
        public Builder key(String key) {
            this.key = key;
            return this;
        }


        /**
         * 词条卡片类型
         * <p> 示例值：
         *
         * @param cardType
         * @return
         */
        public Builder cardType(Integer cardType) {
            this.cardType = cardType;
            return this;
        }

        /**
         * 词条卡片类型
         * <p> 示例值：
         *
         * @param cardType {@link com.lark.oapi.service.lingo.v1.enums.EntityCardDataCardTypeEnum}
         * @return
         */
        public Builder cardType(com.lark.oapi.service.lingo.v1.enums.EntityCardDataCardTypeEnum cardType) {
            this.cardType = cardType.getValue();
            return this;
        }


        /**
         * 卡片模版名
         * <p> 示例值：abbreviation-ultra
         *
         * @param templateName
         * @return
         */
        public Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }


        public EntityCardData build() {
            return new EntityCardData(this);
        }
    }
}
