// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.mail.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.mail.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class PublicMailbox {
    /**
     * 公共邮箱唯一标识
     * <p> 示例值：xxxxxxxxxxxxxxx
     */
    @SerializedName("public_mailbox_id")
    private String publicMailboxId;
    /**
     * 公共邮箱地址
     * <p> 示例值：test_public_mailbox@xxx.xx
     */
    @SerializedName("email")
    private String email;
    /**
     * 公共邮箱名称
     * <p> 示例值：test public mailbox
     */
    @SerializedName("name")
    private String name;
    /**
     * 数据驻留地
     * <p> 示例值：cn
     */
    @SerializedName("geo")
    private String geo;

    // builder 开始
    public PublicMailbox() {
    }

    public PublicMailbox(Builder builder) {
        /**
         * 公共邮箱唯一标识
         * <p> 示例值：xxxxxxxxxxxxxxx
         */
        this.publicMailboxId = builder.publicMailboxId;
        /**
         * 公共邮箱地址
         * <p> 示例值：test_public_mailbox@xxx.xx
         */
        this.email = builder.email;
        /**
         * 公共邮箱名称
         * <p> 示例值：test public mailbox
         */
        this.name = builder.name;
        /**
         * 数据驻留地
         * <p> 示例值：cn
         */
        this.geo = builder.geo;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getPublicMailboxId() {
        return this.publicMailboxId;
    }

    public void setPublicMailboxId(String publicMailboxId) {
        this.publicMailboxId = publicMailboxId;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getGeo() {
        return this.geo;
    }

    public void setGeo(String geo) {
        this.geo = geo;
    }

    public static class Builder {
        /**
         * 公共邮箱唯一标识
         * <p> 示例值：xxxxxxxxxxxxxxx
         */
        private String publicMailboxId;
        /**
         * 公共邮箱地址
         * <p> 示例值：test_public_mailbox@xxx.xx
         */
        private String email;
        /**
         * 公共邮箱名称
         * <p> 示例值：test public mailbox
         */
        private String name;
        /**
         * 数据驻留地
         * <p> 示例值：cn
         */
        private String geo;

        /**
         * 公共邮箱唯一标识
         * <p> 示例值：xxxxxxxxxxxxxxx
         *
         * @param publicMailboxId
         * @return
         */
        public Builder publicMailboxId(String publicMailboxId) {
            this.publicMailboxId = publicMailboxId;
            return this;
        }


        /**
         * 公共邮箱地址
         * <p> 示例值：test_public_mailbox@xxx.xx
         *
         * @param email
         * @return
         */
        public Builder email(String email) {
            this.email = email;
            return this;
        }


        /**
         * 公共邮箱名称
         * <p> 示例值：test public mailbox
         *
         * @param name
         * @return
         */
        public Builder name(String name) {
            this.name = name;
            return this;
        }


        /**
         * 数据驻留地
         * <p> 示例值：cn
         *
         * @param geo
         * @return
         */
        public Builder geo(String geo) {
            this.geo = geo;
            return this;
        }


        public PublicMailbox build() {
            return new PublicMailbox(this);
        }
    }
}
