// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.mdm.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.mdm.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class Project {
    /**
     * 项目唯一id
     * <p> 示例值：U00000000000001
     */
    @SerializedName("project_uid")
    private String projectUid;
    /**
     * 项目编码
     * <p> 示例值：P000001
     */
    @SerializedName("code")
    private String code;
    /**
     * 项目名称
     * <p> 示例值：项目123
     */
    @SerializedName("name")
    private String name;
    /**
     * 项目类型名称
     * <p> 示例值：项目类型3
     */
    @SerializedName("type")
    private String type;
    /**
     * 负责人id
     * <p> 示例值：U000012300001
     */
    @SerializedName("responsible_user_union_id")
    private String responsibleUserUnionId;
    /**
     * 项目开始日期(yyyy-MM-dd)
     * <p> 示例值：9999-01-01
     */
    @SerializedName("start_day")
    private String startDay;
    /**
     * 项目截止日期(yyyy-MM-dd)
     * <p> 示例值：9999-01-01
     */
    @SerializedName("end_day")
    private String endDay;
    /**
     * 父项目节点
     * <p> 示例值：123123123
     */
    @SerializedName("parent_code")
    private String parentCode;
    /**
     * 项目层级
     * <p> 示例值：1
     */
    @SerializedName("level")
    private Integer level;
    /**
     * 项目层级详情
     * <p> 示例值：2021-XJ001-02-02
     */
    @SerializedName("level_info")
    private String levelInfo;
    /**
     * 项目状态
     * <p> 示例值：1
     */
    @SerializedName("status")
    private Integer status;
    /**
     * 扩展字段值信息
     * <p> 示例值：
     */
    @SerializedName("extend_info")
    private ExtendField[] extendInfo;
    /**
     * 是否全部公司
     * <p> 示例值：true
     */
    @SerializedName("is_all_company")
    private Boolean isAllCompany;
    /**
     * 项目公司部门关系列表
     * <p> 示例值：
     */
    @SerializedName("project_company_dept_mappings")
    private ProjectCompanyDeptMapping[] projectCompanyDeptMappings;
    /**
     * 名称多语言
     * <p> 示例值：
     */
    @SerializedName("multi_language_name")
    private MultiLanguage[] multiLanguageName;

    // builder 开始
    public Project() {
    }

    public Project(Builder builder) {
        /**
         * 项目唯一id
         * <p> 示例值：U00000000000001
         */
        this.projectUid = builder.projectUid;
        /**
         * 项目编码
         * <p> 示例值：P000001
         */
        this.code = builder.code;
        /**
         * 项目名称
         * <p> 示例值：项目123
         */
        this.name = builder.name;
        /**
         * 项目类型名称
         * <p> 示例值：项目类型3
         */
        this.type = builder.type;
        /**
         * 负责人id
         * <p> 示例值：U000012300001
         */
        this.responsibleUserUnionId = builder.responsibleUserUnionId;
        /**
         * 项目开始日期(yyyy-MM-dd)
         * <p> 示例值：9999-01-01
         */
        this.startDay = builder.startDay;
        /**
         * 项目截止日期(yyyy-MM-dd)
         * <p> 示例值：9999-01-01
         */
        this.endDay = builder.endDay;
        /**
         * 父项目节点
         * <p> 示例值：123123123
         */
        this.parentCode = builder.parentCode;
        /**
         * 项目层级
         * <p> 示例值：1
         */
        this.level = builder.level;
        /**
         * 项目层级详情
         * <p> 示例值：2021-XJ001-02-02
         */
        this.levelInfo = builder.levelInfo;
        /**
         * 项目状态
         * <p> 示例值：1
         */
        this.status = builder.status;
        /**
         * 扩展字段值信息
         * <p> 示例值：
         */
        this.extendInfo = builder.extendInfo;
        /**
         * 是否全部公司
         * <p> 示例值：true
         */
        this.isAllCompany = builder.isAllCompany;
        /**
         * 项目公司部门关系列表
         * <p> 示例值：
         */
        this.projectCompanyDeptMappings = builder.projectCompanyDeptMappings;
        /**
         * 名称多语言
         * <p> 示例值：
         */
        this.multiLanguageName = builder.multiLanguageName;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getProjectUid() {
        return this.projectUid;
    }

    public void setProjectUid(String projectUid) {
        this.projectUid = projectUid;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getResponsibleUserUnionId() {
        return this.responsibleUserUnionId;
    }

    public void setResponsibleUserUnionId(String responsibleUserUnionId) {
        this.responsibleUserUnionId = responsibleUserUnionId;
    }

    public String getStartDay() {
        return this.startDay;
    }

    public void setStartDay(String startDay) {
        this.startDay = startDay;
    }

    public String getEndDay() {
        return this.endDay;
    }

    public void setEndDay(String endDay) {
        this.endDay = endDay;
    }

    public String getParentCode() {
        return this.parentCode;
    }

    public void setParentCode(String parentCode) {
        this.parentCode = parentCode;
    }

    public Integer getLevel() {
        return this.level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public String getLevelInfo() {
        return this.levelInfo;
    }

    public void setLevelInfo(String levelInfo) {
        this.levelInfo = levelInfo;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public ExtendField[] getExtendInfo() {
        return this.extendInfo;
    }

    public void setExtendInfo(ExtendField[] extendInfo) {
        this.extendInfo = extendInfo;
    }

    public Boolean getIsAllCompany() {
        return this.isAllCompany;
    }

    public void setIsAllCompany(Boolean isAllCompany) {
        this.isAllCompany = isAllCompany;
    }

    public ProjectCompanyDeptMapping[] getProjectCompanyDeptMappings() {
        return this.projectCompanyDeptMappings;
    }

    public void setProjectCompanyDeptMappings(ProjectCompanyDeptMapping[] projectCompanyDeptMappings) {
        this.projectCompanyDeptMappings = projectCompanyDeptMappings;
    }

    public MultiLanguage[] getMultiLanguageName() {
        return this.multiLanguageName;
    }

    public void setMultiLanguageName(MultiLanguage[] multiLanguageName) {
        this.multiLanguageName = multiLanguageName;
    }

    public static class Builder {
        /**
         * 项目唯一id
         * <p> 示例值：U00000000000001
         */
        private String projectUid;
        /**
         * 项目编码
         * <p> 示例值：P000001
         */
        private String code;
        /**
         * 项目名称
         * <p> 示例值：项目123
         */
        private String name;
        /**
         * 项目类型名称
         * <p> 示例值：项目类型3
         */
        private String type;
        /**
         * 负责人id
         * <p> 示例值：U000012300001
         */
        private String responsibleUserUnionId;
        /**
         * 项目开始日期(yyyy-MM-dd)
         * <p> 示例值：9999-01-01
         */
        private String startDay;
        /**
         * 项目截止日期(yyyy-MM-dd)
         * <p> 示例值：9999-01-01
         */
        private String endDay;
        /**
         * 父项目节点
         * <p> 示例值：123123123
         */
        private String parentCode;
        /**
         * 项目层级
         * <p> 示例值：1
         */
        private Integer level;
        /**
         * 项目层级详情
         * <p> 示例值：2021-XJ001-02-02
         */
        private String levelInfo;
        /**
         * 项目状态
         * <p> 示例值：1
         */
        private Integer status;
        /**
         * 扩展字段值信息
         * <p> 示例值：
         */
        private ExtendField[] extendInfo;
        /**
         * 是否全部公司
         * <p> 示例值：true
         */
        private Boolean isAllCompany;
        /**
         * 项目公司部门关系列表
         * <p> 示例值：
         */
        private ProjectCompanyDeptMapping[] projectCompanyDeptMappings;
        /**
         * 名称多语言
         * <p> 示例值：
         */
        private MultiLanguage[] multiLanguageName;

        /**
         * 项目唯一id
         * <p> 示例值：U00000000000001
         *
         * @param projectUid
         * @return
         */
        public Builder projectUid(String projectUid) {
            this.projectUid = projectUid;
            return this;
        }


        /**
         * 项目编码
         * <p> 示例值：P000001
         *
         * @param code
         * @return
         */
        public Builder code(String code) {
            this.code = code;
            return this;
        }


        /**
         * 项目名称
         * <p> 示例值：项目123
         *
         * @param name
         * @return
         */
        public Builder name(String name) {
            this.name = name;
            return this;
        }


        /**
         * 项目类型名称
         * <p> 示例值：项目类型3
         *
         * @param type
         * @return
         */
        public Builder type(String type) {
            this.type = type;
            return this;
        }


        /**
         * 负责人id
         * <p> 示例值：U000012300001
         *
         * @param responsibleUserUnionId
         * @return
         */
        public Builder responsibleUserUnionId(String responsibleUserUnionId) {
            this.responsibleUserUnionId = responsibleUserUnionId;
            return this;
        }


        /**
         * 项目开始日期(yyyy-MM-dd)
         * <p> 示例值：9999-01-01
         *
         * @param startDay
         * @return
         */
        public Builder startDay(String startDay) {
            this.startDay = startDay;
            return this;
        }


        /**
         * 项目截止日期(yyyy-MM-dd)
         * <p> 示例值：9999-01-01
         *
         * @param endDay
         * @return
         */
        public Builder endDay(String endDay) {
            this.endDay = endDay;
            return this;
        }


        /**
         * 父项目节点
         * <p> 示例值：123123123
         *
         * @param parentCode
         * @return
         */
        public Builder parentCode(String parentCode) {
            this.parentCode = parentCode;
            return this;
        }


        /**
         * 项目层级
         * <p> 示例值：1
         *
         * @param level
         * @return
         */
        public Builder level(Integer level) {
            this.level = level;
            return this;
        }


        /**
         * 项目层级详情
         * <p> 示例值：2021-XJ001-02-02
         *
         * @param levelInfo
         * @return
         */
        public Builder levelInfo(String levelInfo) {
            this.levelInfo = levelInfo;
            return this;
        }


        /**
         * 项目状态
         * <p> 示例值：1
         *
         * @param status
         * @return
         */
        public Builder status(Integer status) {
            this.status = status;
            return this;
        }

        /**
         * 项目状态
         * <p> 示例值：1
         *
         * @param status {@link com.lark.oapi.service.mdm.v1.enums.ProjectStatusEnum}
         * @return
         */
        public Builder status(com.lark.oapi.service.mdm.v1.enums.ProjectStatusEnum status) {
            this.status = status.getValue();
            return this;
        }


        /**
         * 扩展字段值信息
         * <p> 示例值：
         *
         * @param extendInfo
         * @return
         */
        public Builder extendInfo(ExtendField[] extendInfo) {
            this.extendInfo = extendInfo;
            return this;
        }


        /**
         * 是否全部公司
         * <p> 示例值：true
         *
         * @param isAllCompany
         * @return
         */
        public Builder isAllCompany(Boolean isAllCompany) {
            this.isAllCompany = isAllCompany;
            return this;
        }


        /**
         * 项目公司部门关系列表
         * <p> 示例值：
         *
         * @param projectCompanyDeptMappings
         * @return
         */
        public Builder projectCompanyDeptMappings(ProjectCompanyDeptMapping[] projectCompanyDeptMappings) {
            this.projectCompanyDeptMappings = projectCompanyDeptMappings;
            return this;
        }


        /**
         * 名称多语言
         * <p> 示例值：
         *
         * @param multiLanguageName
         * @return
         */
        public Builder multiLanguageName(MultiLanguage[] multiLanguageName) {
            this.multiLanguageName = multiLanguageName;
            return this;
        }


        public Project build() {
            return new Project(this);
        }
    }
}
