// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.okr.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.okr.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class ContentTextStyle {
    /**
     * 是否加粗
     * <p> 示例值：true
     */
    @SerializedName("bold")
    private Boolean bold;
    /**
     * 是否删除
     * <p> 示例值：true
     */
    @SerializedName("strikeThrough")
    private Boolean strikeThrough;
    /**
     * 背景颜色
     * <p> 示例值：
     */
    @SerializedName("backColor")
    private ContentColor backColor;
    /**
     * 字体颜色
     * <p> 示例值：
     */
    @SerializedName("textColor")
    private ContentColor textColor;
    /**
     * 链接地址
     * <p> 示例值：
     */
    @SerializedName("link")
    private ContentLink link;

    // builder 开始
    public ContentTextStyle() {
    }

    public ContentTextStyle(Builder builder) {
        /**
         * 是否加粗
         * <p> 示例值：true
         */
        this.bold = builder.bold;
        /**
         * 是否删除
         * <p> 示例值：true
         */
        this.strikeThrough = builder.strikeThrough;
        /**
         * 背景颜色
         * <p> 示例值：
         */
        this.backColor = builder.backColor;
        /**
         * 字体颜色
         * <p> 示例值：
         */
        this.textColor = builder.textColor;
        /**
         * 链接地址
         * <p> 示例值：
         */
        this.link = builder.link;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Boolean getBold() {
        return this.bold;
    }

    public void setBold(Boolean bold) {
        this.bold = bold;
    }

    public Boolean getStrikeThrough() {
        return this.strikeThrough;
    }

    public void setStrikeThrough(Boolean strikeThrough) {
        this.strikeThrough = strikeThrough;
    }

    public ContentColor getBackColor() {
        return this.backColor;
    }

    public void setBackColor(ContentColor backColor) {
        this.backColor = backColor;
    }

    public ContentColor getTextColor() {
        return this.textColor;
    }

    public void setTextColor(ContentColor textColor) {
        this.textColor = textColor;
    }

    public ContentLink getLink() {
        return this.link;
    }

    public void setLink(ContentLink link) {
        this.link = link;
    }

    public static class Builder {
        /**
         * 是否加粗
         * <p> 示例值：true
         */
        private Boolean bold;
        /**
         * 是否删除
         * <p> 示例值：true
         */
        private Boolean strikeThrough;
        /**
         * 背景颜色
         * <p> 示例值：
         */
        private ContentColor backColor;
        /**
         * 字体颜色
         * <p> 示例值：
         */
        private ContentColor textColor;
        /**
         * 链接地址
         * <p> 示例值：
         */
        private ContentLink link;

        /**
         * 是否加粗
         * <p> 示例值：true
         *
         * @param bold
         * @return
         */
        public Builder bold(Boolean bold) {
            this.bold = bold;
            return this;
        }


        /**
         * 是否删除
         * <p> 示例值：true
         *
         * @param strikeThrough
         * @return
         */
        public Builder strikeThrough(Boolean strikeThrough) {
            this.strikeThrough = strikeThrough;
            return this;
        }


        /**
         * 背景颜色
         * <p> 示例值：
         *
         * @param backColor
         * @return
         */
        public Builder backColor(ContentColor backColor) {
            this.backColor = backColor;
            return this;
        }


        /**
         * 字体颜色
         * <p> 示例值：
         *
         * @param textColor
         * @return
         */
        public Builder textColor(ContentColor textColor) {
            this.textColor = textColor;
            return this;
        }


        /**
         * 链接地址
         * <p> 示例值：
         *
         * @param link
         * @return
         */
        public Builder link(ContentLink link) {
            this.link = link;
            return this;
        }


        public ContentTextStyle build() {
            return new ContentTextStyle(this);
        }
    }
}
